/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.VolGroupAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespVolGroup;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolGroupGrapher
extends Grapher {
    String title;
    public static final byte CHART_SIZE = 101;
    public static final byte CHART_SIZE_X = 102;
    public static final String CHART_SELECTED = "STG5556T";
    public static final String CHART_ALL = "STG1294T";
    public static final String FREE_HIST = "STG5105L";
    public static final String FREE_PERCENT_HIST = "STG5106L";
    public static final String CAPACITY_HIST = "STG5109L";
    public static final String NUM_LVFS_HIST = "STG6207L";
    public static final String FREE_HISTORY = "STG7530L";
    public static final String FREE_PCT_HISTORY = "STG7531L";
    public static final String CAPACITY_HISTORY = "STG7539L";
    static final String USED_SPACE = MessageLog.getMessageNoID("STG1237L");
    static final String FREE_SPACE = MessageLog.getMessageNoID("STG1184L");

    public String getChartType(GuiReportReq grr, ReportDataAdjuster pAdjuster) {
        if (grr.chartSubtype > 0) {
            return null;
        }
        this.title = grr.histSubtype == 1 ? FREE_HIST : (grr.histSubtype == 2 ? FREE_PERCENT_HIST : (grr.histSubtype == 5 ? CAPACITY_HIST : NUM_LVFS_HIST));
        return MessageLog.getMessageNoID(this.title);
    }

    public int graphsPerPage(GuiReportReq grr) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, GuiChartSettingsReq gcsr) {
        VolGroupAdjuster adjuster = (VolGroupAdjuster)pAdjuster;
        AperiChart chart = null;
        if (grr.chartSubtype > 0) {
            chart = this.createChart(grr, pData, rows, pAdjuster, null, gcsr);
        } else {
            GuiReportReq newGrr = this.createHistory(grr, pData, rows, this.title, adjuster);
            chart = (AperiChart)new SpaceHistChart().batch(newGrr, gcsr);
        }
        return chart;
    }

    public AperiCustomizableChart createChart(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, ReportingDDI ddi, GuiChartSettingsReq gcsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(VolGroupGrapher.class.getName(), "createChart", "grr, pData, rows, pAdjuster, ddi, gcsr");
        }
        RespVolGroup[] data = (RespVolGroup[])pData;
        VolGroupAdjuster adjuster = (VolGroupAdjuster)pAdjuster;
        int rowCount = rows.length;
        Number[][] chartY = new Number[2][rowCount];
        String[] pointL = new String[rowCount];
        String[] seriesL = new String[]{USED_SPACE, FREE_SPACE};
        for (int i = rowCount - 1; i >= 0; --i) {
            RespVolGroup dataRow = data[rows[i]];
            chartY[0][i] = new Long(dataRow.vgTotalSpace - dataRow.vgFreeSpace);
            chartY[1][i] = new Long(dataRow.vgFreeSpace);
            pointL[i] = dataRow.rvgComputerName + "." + dataRow.vgName;
        }
        AperiCustomizableChart chart = new AperiCustomizableChart(1, 7, chartY, seriesL, pointL, new ChartOptions(), grr);
        if (ddi != null) {
            ddi.addChart(grr, chart, "");
        }
        AperiCustomizableChart traceResult = chart;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(VolGroupGrapher.class.getName(), "createChart", traceResult);
        }
        return traceResult;
    }

    public GuiReportReq createHistory(GuiReportReq grr, Object[] pData, int[] rows, String actionCommand, VolGroupAdjuster adjuster) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(VolGroupGrapher.class.getName(), "createHistory", "grr, pData, rows, actionCommand, adjuster");
        }
        RespVolGroup[] data = (RespVolGroup[])pData;
        GuiReportReq newGrr = grr.explode(-1);
        newGrr.reportSubtype = grr.reportSubtype;
        newGrr.idSubtype = -1;
        SpaceHistChart.initLegend(newGrr);
        newGrr.selectedResources = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            RespVolGroup dataRow = data[rows[i]];
            newGrr.selectedResources[i] = dataRow.vgID;
            SpaceHistChart.addLegend(newGrr, dataRow.rvgComputerName, dataRow.vgName, dataRow.vgID);
        }
        if (actionCommand == FREE_HIST) {
            newGrr.chartLabelType = 1;
            newGrr.histSubtype = 1;
            newGrr.historyTitle = "STG6203L";
        } else if (actionCommand == FREE_PERCENT_HIST) {
            newGrr.chartLabelType = (byte)8;
            newGrr.histSubtype = (byte)2;
            newGrr.historyTitle = "STG6204L";
        } else if (actionCommand == CAPACITY_HIST) {
            newGrr.chartLabelType = 1;
            newGrr.histSubtype = (byte)5;
            newGrr.historyTitle = "STG6205L";
        } else {
            newGrr.chartLabelType = (byte)6;
            newGrr.histSubtype = 0;
            newGrr.historyTitle = "STG6206L";
        }
        newGrr.reportSubtypeOrig = grr.reportSubtype;
        newGrr.reportSubtype = 28;
        GuiReportReq traceResult = newGrr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(VolGroupGrapher.class.getName(), "createHistory", traceResult);
        }
        return traceResult;
    }
}

