/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.TStorm.gui.DiscoveryAlertEditor;
import org.eclipse.aperi.TStorm.gui.IPListEditor;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AbstractAlertEditor;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class CimomDiscoveryCreateOrEdit
implements CreateOrEdit,
GuiRequestor,
ChangeListener {
    private static final int SCHEDULE_TAB = 0;
    private static final int ALERT_TAB = 1;
    private static final int OPTIONS_TAB = 2;
    private CreateOrEditDDI DDI;
    private CreateHeaderPanel createHeaderPanel;
    private JTabbedPane tabs;
    private JSgcScheduleCreateWhenData scheduleEditor;
    private AbstractAlertEditor alertEditor;
    private IPListEditor manualSlpDAs;
    private JCheckBox scanLocalCheckbox;
    private boolean msgShown = false;

    public CimomDiscoveryCreateOrEdit(CreateOrEditDDI pDDI) {
        this.DDI = pDDI;
        this.DDI.showEnabled = true;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr";
    }

    public CreateHeader getData() {
        this.scheduleEditor.getData();
        ProbePing schedule = (ProbePing)this.createHeaderPanel.getData();
        schedule.pbAlert = this.alertEditor.getData();
        schedule.pbManualSlpDAs = this.manualSlpDAs.getData();
        schedule.arguments = this.scanLocalCheckbox.isSelected() ? " " : "0";
        return schedule;
    }

    public void validate(CreateHeader newHeader) throws GeneralException {
        ScheduleHeader schedule = (ScheduleHeader)newHeader;
        this.DDI.exceptionTabIndex = 0;
        this.scheduleEditor.validate(schedule);
        this.DDI.exceptionTabIndex = 1;
        this.alertEditor.validateData();
        ProbePing pingSched = (ProbePing)schedule;
        if (!this.msgShown && schedule.arguments != null && schedule.arguments.equals("0") && pingSched.pbManualSlpDAs == null) {
            boolean hasCimoms = false;
            hasCimoms = GuiClient.doesCimomTableHaveCimoms();
            if (!hasCimoms) {
                String s = Util.getString("GUI8214M");
                JOptionPane.showMessageDialog(guiMain.getFrame(), s, Util.getString("GUI8215T"), 2);
                this.msgShown = true;
            }
        }
    }

    public void showNoCimomMessage() {
        String s = Util.getString("GUI8214M");
        JOptionPane.showMessageDialog(guiMain.getFrame(), s, Util.getString("GUI8215T"), 2);
        this.msgShown = true;
    }

    public void showTab(int tabIndex) {
        this.tabs.setSelectedIndex(tabIndex);
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
        guiMain.setSaveAsActionEnabled(false, false);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void replace(CreateHeader newHeader) {
        this.DDI.setDescription("");
        this.createHeaderPanel.replace(newHeader);
        this.scheduleEditor.replace((ScheduleHeader)newHeader);
    }

    private void create(ProbePing schedule) {
        this.createHeaderPanel = new CreateHeaderPanel(schedule, this, this.DDI);
        this.scheduleEditor = new JSgcScheduleCreateWhenData(104, this.DDI);
        JPanel whenPanel = this.scheduleEditor.build(schedule);
        this.alertEditor = schedule.pbAlert == null ? new DiscoveryAlertEditor(26) : new DiscoveryAlertEditor(schedule.pbAlert);
        this.tabs = new JTabbedPane();
        this.tabs.setFont(BaseTree.boldFont);
        String s = MessageLog.getMessageNoID("GUI8222L");
        this.tabs.addTab(s, whenPanel);
        s = MessageLog.getMessageNoID("STG4036L");
        this.tabs.addTab(s, this.alertEditor.getComponent());
        JPanel subPanel = new JPanel(new BorderLayout());
        s = Util.getString("CIMOM_DA_LIST_TEXT");
        this.manualSlpDAs = new IPListEditor(schedule.pbManualSlpDAs, s);
        subPanel.add((Component)this.manualSlpDAs.getComponent(), "Center");
        JPanel checkboxPanel = new JPanel(new FlowLayout(0, 6, 10));
        s = Util.getString("SCAN_LOCAL_SUBNET");
        this.scanLocalCheckbox = new JCheckBox(s);
        GuiUtil.setAccessibleDescription(this.scanLocalCheckbox, s);
        checkboxPanel.add(this.scanLocalCheckbox);
        subPanel.add((Component)checkboxPanel, "South");
        if (schedule.arguments != null && schedule.arguments.equals("0")) {
            this.scanLocalCheckbox.setSelected(false);
        } else {
            this.scanLocalCheckbox.setSelected(true);
        }
        s = Util.getString("CIMOM_DA_LIST_BORDER");
        subPanel.setBorder(GuiUtil.getBorder(s));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)subPanel, c);
        panel.add(Box.createVerticalStrut(1), c);
        s = MessageLog.getMessageNoID("STG3175L");
        this.tabs.addTab(s, panel);
        this.tabs.setSelectedIndex(this.DDI.tabIndex);
        this.tabs.addChangeListener(this);
        this.createHeaderPanel.add((Component)this.tabs, "Center");
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.gettingFocus();
    }

    private void submitRetrieve() {
        ProbePing schedule = new ProbePing(104);
        schedule.validateIPs = true;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr", schedule);
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    public void build(int ID2) {
        this.submitRetrieve();
    }

    public void build(CreateHeader createHeader) {
        this.create((ProbePing)createHeader);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        ProbePing schedule = (ProbePing)response.responseData;
        this.DDI.oldCreateHeader = (CreateHeader)schedule.clone();
        this.create(schedule);
    }

    public void stateChanged(ChangeEvent event) {
        this.DDI.tabIndex = this.tabs.getSelectedIndex();
    }

    public String getHelpID(int tab) {
        switch (tab) {
            case 0: {
                return "adm_dsc_whentorun";
            }
            case 1: {
                return "adm_dsc_alert";
            }
            case 2: {
                return "adm_dsc_cimomoptions";
            }
        }
        return null;
    }
}

