/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.JTabbedPane;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.gui.AlertCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.ComputerAlertEditor;
import org.eclipse.aperi.TStorm.gui.ComputerGroupSelector;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.xmsg.MessageLog;

public class CompAlertCreateOrEdit
extends AlertCreateOrEdit {
    private ComputerGroupSelector compSelector;
    private static final int ALERT_TAB = 0;
    private static final int COMPUTER_TAB = 1;

    public CompAlertCreateOrEdit(CreateOrEditDDI pDdi) {
        super(pDdi);
    }

    protected void makeTabbedPane(AlertHeader compAlert) {
        this.compSelector = new ComputerGroupSelector(1, compAlert.alertElements, compAlert.alertGroups, compAlert.alertClusters, compAlert.allObjects);
        this.alertEditor = compAlert.alert == null ? new ComputerAlertEditor() : new ComputerAlertEditor(compAlert.alert);
        this.tabbedPane = new JTabbedPane();
        String title = MessageLog.getMessageNoID("STG4036L");
        this.tabbedPane.addTab(title, this.alertEditor.getComponent());
        title = MessageLog.getMessageNoID("STG4041L");
        this.tabbedPane.addTab(title, this.compSelector.getComponent());
    }

    public CreateHeader getData() {
        AlertHeader compAlert = (AlertHeader)super.getData();
        NameList[] compLists = this.compSelector.getData();
        compAlert.alertElements = compLists[0];
        compAlert.alertGroups = compLists[1];
        compAlert.alertClusters = compLists[2];
        compAlert.allObjects = this.compSelector.allMembersSelected;
        return compAlert;
    }

    public void replace(CreateHeader newHeader) {
        super.replace(newHeader);
        AlertHeader compAlert = (AlertHeader)newHeader;
        this.compSelector.replace(compAlert.alertElements, compAlert.alertGroups, compAlert.alertClusters, compAlert.allObjects);
    }

    public void changeOccurred(int changeType, NameList name) {
        if (changeType == 100) {
            this.compSelector.invalidateGroups(name.nlInfo);
        }
        if (changeType != 1) {
            return;
        }
        if (name.nlInfo == 0) {
            this.compSelector.addGroup(name);
        }
    }

    public String getHelpID(int tab) {
        switch (tab) {
            case 0: {
                return "alcom5";
            }
            case 1: {
                return "alcom10";
            }
        }
        return null;
    }
}

