/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.TStorm.gui.ComputerTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputerTreeLabel
extends BaseTreeNode
implements GuiRequestor,
ActionListener {
    protected NameList[] computerList;
    private int osType;
    private int clusterID = 0;

    public ComputerTreeLabel(String labelID, int osType) {
        super(MessageLog.getMessageNoID(labelID));
        this.osType = osType;
    }

    public ComputerTreeLabel(String labelID, int osType, int clusterID) {
        super(MessageLog.getMessageNoID(labelID));
        this.osType = osType;
        this.clusterID = clusterID;
    }

    public void showPopupMenu(MouseEvent event) {
        JPopupMenu popup = super.getPopupMenu();
        JMenuItem refresh = new JMenuItem(MessageLog.getMessageNoID("STG0003L"));
        refresh.setToolTipText(MessageLog.getMessageNoID("STG0004L"));
        refresh.addActionListener(this);
        popup.add(refresh);
        super.showPopupMenu(popup, event);
    }

    public void actionPerformed(ActionEvent event) {
        this.computerList = null;
        this.removeAllChildren();
        this.makeRequest();
    }

    public void expand(TreeExpansionEvent event) {
        if (this.computerList == null || this.computerList.length == 0) {
            this.makeRequest();
        }
    }

    private void makeRequest() {
        Request request = new Request();
        GuiRequest.computerList(request);
        GuiListReq requestData = (GuiListReq)request.requestData;
        if (this.clusterID < 1) {
            if (this.osType == 22) {
                requestData.computerID = this.clusterID;
                requestData.listRequested = 10099;
            } else {
                requestData.listRequested = 10001;
            }
        } else {
            requestData.listRequested = Constants.isVirtualServer(this.osType) ? (this.getUserObject().toString().equals(MessageLog.getMessageNoID("STG1032L")) ? 100 : 10001) : 101;
            requestData.computerID = this.clusterID;
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            NameList computer = (NameList)response.responseData;
            int count = 0;
            while (computer != null) {
                ++count;
                computer = computer.nlNext;
            }
            this.computerList = new NameList[count];
            int i = 0;
            computer = (NameList)response.responseData;
            while (computer != null) {
                NameList next = computer.nlNext;
                computer.nlNext = null;
                this.computerList[i++] = computer;
                computer = next;
            }
            this.createNodes();
        }
    }

    public void createNodes() {
        for (int i = 0; i < this.computerList.length; ++i) {
            if (this.osType != -2 && this.osType != this.computerList[i].nlID2 && this.osType != -1) continue;
            this.addSorted(new ComputerTreeNode(this.computerList[i]));
        }
        BaseTree.MyTree.nodeStructureChanged(this);
        guiMain.getBaseTree().repaint();
    }
}

