/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.MouseEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.TStorm.gui.ClusterDDI;
import org.eclipse.aperi.TStorm.gui.ComputerDDI;
import org.eclipse.aperi.TStorm.gui.ComputerTreeLabel;
import org.eclipse.aperi.TStorm.gui.ControllerTreeLabel;
import org.eclipse.aperi.TStorm.gui.DiskTreeLabel;
import org.eclipse.aperi.TStorm.gui.ExportsTreeLabel;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeTreeLabel;
import org.eclipse.aperi.TStorm.gui.VolumeGroupTreeLabel;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AlertableTreeNode;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.IconFactory;

public class ComputerTreeNode
extends AlertableTreeNode {
    NameList computer;

    public ComputerTreeNode(NameList pComputer) {
        super(pComputer.nlID);
        this.computer = pComputer;
        this.setUserObject(this.computer);
        this.reset();
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.render(renderer, tree, sel, expanded, leaf, row, hasFocus);
        if (Constants.isVirtualServer(this.computer.nlID2) && this.computer.nlInfo != 99) {
            renderer.setIcon(IconFactory.getVirtualServerIcon());
        } else if (this.computer.nlInfo == 99) {
            renderer.setIcon(IconFactory.getClusterIcon());
        } else {
            renderer.setIcon(IconFactory.getComputerIcon());
        }
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() == 0) {
            if ((!Constants.isNasBox((short)this.computer.nlID2) || Constants.supportsFullProbe((short)this.computer.nlID2)) && this.computer.nlID2 != 22) {
                this.add(new ControllerTreeLabel(this.computer));
                this.add(new DiskTreeLabel(this.computer, -1));
            }
            if (this.computer.nlID2 == 22) {
                this.add(new ComputerTreeLabel("STG1033L", -1, this.computer.nlClusterID));
                this.add(new ComputerTreeLabel("STG1032L", 20, this.computer.nlClusterID));
            }
            if (this.computer.nlID2 == 2 || this.computer.nlID2 == 6 || this.computer.nlID2 == 3 || this.computer.nlID2 == 7 || this.computer.nlID2 == 8) {
                this.add(new VolumeGroupTreeLabel(this.computer));
            }
            if (this.computer.nlID2 != 22) {
                this.add(new LogicalVolumeTreeLabel(this.computer, -1));
            }
            if (this.computer.nlID2 != 8 && this.computer.nlID2 != 22 && this.computer.nlID2 != 23) {
                this.add(new ExportsTreeLabel(this.computer.nlID));
            }
        }
    }

    public void select(TreeSelectionEvent event) {
        if (this.computer.nlID2 == 22) {
            new ClusterDDI(this, this.computer.nlClusterID, this.computer.nlName);
        } else {
            new ComputerDDI(this, this.computer.nlID, this.computer.nlName);
        }
    }

    protected NameList getNameList() {
        return this.computer;
    }

    public void showPopupMenu(MouseEvent event) {
        if (this.computer.nlID2 == 22 && event != null) {
            this.menu = this.getPopupMenu();
            this.showPopupMenu(this.menu, event);
        } else {
            super.showPopupMenu(event);
        }
    }
}

