/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.DiskAdjuster;
import org.eclipse.aperi.TStorm.common.DiskGrapher;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.gui.DiskDDI;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskTable
extends JPanel
implements ActionListener,
DisplaysChartPopupInterface,
GuiRequestor,
HistoryChoiceInterface,
TJCTableMouseInterface {
    private MegaTable dskTable = new MegaTable();
    private Share[] shArray;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private DiskAdjuster adjuster;
    private DiskGrapher grapher;
    private DiskModel diskModel;
    int dataCount;
    int[] rows;

    public DiskTable(GuiReportReq grr, ReportingDDI ddi) {
        this.grr = grr;
        this.ddi = ddi;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.adjuster = new DiskAdjuster(grr);
        this.grapher = new DiskGrapher();
    }

    public void handleResponse(short status, Response response) {
        this.setLayout(new BorderLayout());
        this.shArray = status <= 4 ? (Share[])response.responseData : null;
        int cnt = this.shArray != null ? this.shArray.length : 0;
        if (cnt == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.shArray, false);
        this.shArray = (Share[])this.adjuster.getArray();
        this.diskModel = new DiskModel();
        this.dskTable.setFrozenColumns(this.adjuster.frozenColumns);
        this.dskTable.setMouseListener(this);
        this.dskTable.iconChanger = this.diskModel;
        if (this.adjuster.frozenRows > 0) {
            this.dskTable.setFrozenRows(this.adjuster.frozenRows);
            this.dskTable.setFrozenRowBackground(Color.yellow);
        }
        this.dskTable.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.dskTable.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.dskTable.setCellRenderer(Date.class, TableCellRenderers.date);
        this.dskTable.setRowIcon(13, true);
        this.dskTable.alternateRowIcon = IconFactory.getBlankIcon(38, 16);
        this.dskTable.setBaseTableModel(this.diskModel);
        if (this.adjuster.firstColumn > 0) {
            this.dskTable.setAsFirstColumn(this.adjuster.firstColumn);
        }
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.dskTable, "Center");
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        if (this.grr.reportSubtype != 18 && this.grr.reportSubtype != 37) {
            return this;
        }
        return null;
    }

    public boolean select(int viewRow, int viewCol) {
        return !this.adjuster.hasTotalsRow() || viewRow != 0;
    }

    public void selectionChanged(boolean state) {
    }

    public void doubleClick(int row, int col) {
        if (!this.adjuster.hasTotalsRow() || row != 0) {
            new DiskDDI(null, this.shArray[row].shResourceID, this.adjuster.daArray[row].daPath, this.shArray[row].shComputerID);
        }
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
        if (this.grr.reportSubtype != 18 && this.grr.reportSubtype != 37) {
            String allMessage;
            String selectedMessage;
            boolean enablePopup;
            boolean bl = enablePopup = this.shArray != null && this.shArray.length > 0;
            if (this.grr.reportSubtype == 39) {
                selectedMessage = "STG5557T";
                allMessage = "STG5558T";
            } else if (this.grr.reportSubtype == 24) {
                selectedMessage = "STG5559T";
                allMessage = "STG5560T";
            } else if (this.grr.reportSubtype == 23) {
                selectedMessage = "STG5561T";
                allMessage = "STG5562T";
            } else if (this.grr.reportSubtype == 25) {
                selectedMessage = "STG5563T";
                allMessage = "STG5564T";
            } else {
                selectedMessage = "STG5565T";
                allMessage = "STG5566T";
            }
            JPopupMenu menu = new JPopupMenu();
            JMenuItem mi = menu.add(MessageLog.getMessageNoID(selectedMessage));
            mi.setActionCommand("STG3207L");
            mi.setEnabled(this.dskTable.rowsSelected());
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID(allMessage));
            mi.setEnabled(enablePopup);
            mi.setActionCommand("STG7556L");
            mi.addActionListener(this);
            menu.show(c, x, y);
            menu.requestFocus();
        }
    }

    public void showJumpChart() {
        if (this.grr.reportSubtype != 18 && this.grr.reportSubtype != 37) {
            this.dataCount = this.shArray.length;
            this.rows = new int[this.dataCount];
            for (int i = 0; i < this.dataCount; ++i) {
                this.rows[i] = this.dskTable.getDataRow(i);
            }
            this.createHistory("STG7556L");
        }
    }

    public void showDefaultChart(int dataRow) {
        if (this.isDataValid(dataRow)) {
            this.rows = new int[1];
            this.rows[0] = dataRow;
            this.dataCount = 1;
            this.createHistory("STG7556L");
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand == "STG3207L") {
            this.rows = this.dskTable.getSelectedRows();
            this.dataCount = this.rows.length;
        } else {
            this.dataCount = this.shArray.length;
            this.rows = new int[this.dataCount];
            for (int i = 0; i < this.dataCount; ++i) {
                this.rows[i] = this.dskTable.getDataRow(i);
            }
        }
        this.createHistory(actionCommand);
    }

    private void createHistory(String actionCommand) {
        if (this.dataCount > 0) {
            GuiReportReq newGrr = this.grapher.createHistory(this.grr, this.shArray, this.rows, this.adjuster, actionCommand);
            this.ddi.addObject(this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", newGrr, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(newGrr.historyTitle), this);
        }
    }

    public boolean isDataValid(int dataRow) {
        boolean isValid = false;
        switch (this.grr.reportSubtype) {
            case 24: {
                if (this.adjuster.dkhArray[dataRow].dkhGrownDefects < 0) break;
                isValid = true;
                break;
            }
            case 25: {
                if (this.adjuster.dkhArray[dataRow].dkhRecoveredReadErrors + this.adjuster.dkhArray[dataRow].dkhRecoveredWriteErrors + this.adjuster.dkhArray[dataRow].dkhRecoveredVerifyErrors < 0) break;
                isValid = true;
                break;
            }
            case 26: {
                if (this.adjuster.dkhArray[dataRow].dkhUnrecoveredReadErrors + this.adjuster.dkhArray[dataRow].dkhUnrecoveredWriteErrors + this.adjuster.dkhArray[dataRow].dkhUnrecoveredVerifyErrors < 0) break;
                isValid = true;
                break;
            }
            case 39: {
                if (this.adjuster.dkhArray[dataRow].dkhFreeSpace < 0L) break;
                isValid = true;
                break;
            }
            case 23: {
                if (this.adjuster.dkhArray[dataRow].dkhPrimaryDefects < 0) break;
                isValid = true;
                break;
            }
        }
        return isValid;
    }

    public DiskTable(String a, String b, String c, String d) {
    }

    public Object[] getChoices(int reportType, int reportSubtype) {
        Object[] array = null;
        if (reportSubtype != 18 && reportSubtype != 37) {
            array = new Object[3];
            String[] messageArray = new String[]{"STG7556L"};
            byte[] labelArray = new byte[]{reportSubtype == 39 ? (byte)1 : 6};
            byte[] reportArray = new byte[]{3};
            array[0] = messageArray;
            array[1] = labelArray;
            array[2] = reportArray;
        }
        return array;
    }

    public Object[] getCharts(int reportType, int reportSubtype) {
        return null;
    }

    public int[] getGraphID(String selectedCommand) {
        int[] array = new int[2];
        array[0] = selectedCommand == "STG3207L" ? 3 : 1;
        return array;
    }

    private class DiskModel
    extends BaseTableModel
    implements AskForRowIconInterface {
        DiskModel() {
            this.columnNames = ((DiskTable)DiskTable.this).adjuster.colNames;
            this.rowCount = DiskTable.this.shArray.length;
            this.commonAdjuster = DiskTable.this.adjuster;
        }

        public Object getTableDataItem(int row, int col) {
            return DiskTable.this.adjuster.getCellData(row, DiskTable.this.adjuster.translateColumn(col));
        }

        public boolean changeIcon(int dataRow) {
            return !DiskTable.this.isDataValid(dataRow);
        }
    }
}

