/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryJobDDI;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class EditableObjectHistoryNode
extends BaseTreeNode
implements ActionListener,
GuiRequestor {
    private static final Color WARNING_COLOR = new Color(248, 104, 0);
    private static final Color RUNNING_COLOR = new Color(8, 26, 158);
    private static final Color SUCCESS_COLOR = new Color(64, 136, 96);
    private static final Color FAILED_COLOR = new Color(248, 0, 0);
    public NameList element;
    private String scheduleDescription;
    private short resourceType = (short)-1;
    private JPopupMenu popupMenu;
    private static final String COMMAND_STOP_NOW = "STOP_NOW";

    public EditableObjectHistoryNode(NameList element, String pScheduleDescription) {
        this.element = element;
        this.scheduleDescription = pScheduleDescription;
        this.setUserObject(element);
        this.setAllowsChildren(false);
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean selected, boolean expanded, boolean isLeaf, int row, boolean hasFocus) {
        switch (this.element.nlState) {
            case 1: {
                this.nodeColor = SUCCESS_COLOR;
                this.element.nlInfo = (short)84;
                break;
            }
            case 2: {
                this.nodeColor = RUNNING_COLOR;
                this.element.nlInfo = (short)86;
                break;
            }
            case 3: {
                this.nodeColor = WARNING_COLOR;
                this.element.nlInfo = (short)85;
                break;
            }
            default: {
                this.nodeColor = FAILED_COLOR;
                this.element.nlInfo = (short)87;
            }
        }
        if (!selected) {
            renderer.setForeground(this.nodeColor);
        }
        renderer.setIcon(NameListTreeCellRenderer.iconForObject(this.element));
        renderer.setFont(BaseTree.plainFont);
    }

    public void select(TreeSelectionEvent ignored) {
        Object[] args = new Object[]{this.scheduleDescription, new Integer(this.element.nlID2)};
        String description = MessageLog.getMessageNoID("JSS1001L", args);
        EditableObjectHistoryJobDDI historyDDI = new EditableObjectHistoryJobDDI(this.element, this, description, null);
    }

    public void showPopupMenu(MouseEvent event) {
        this.popupMenu = this.getPopupMenu();
        if (event != null) {
            this.showPopupMenu(this.popupMenu, event);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        guiMain.getBaseTree().requestFocus();
    }

    private void addMenuItem(JPopupMenu menu, String msgID, String cmd, boolean enabled, String resourceID) {
        String s = resourceID == null ? Util.getString(msgID) : Util.getString(resourceID);
        JMenuItem item = new JMenuItem(s);
        item.setName(s);
        item.setActionCommand(cmd);
        item.addActionListener(this);
        item.setEnabled(enabled);
        menu.add(item);
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            // empty if block
        }
    }

    public void setResourceType(short paResourceType) {
        this.resourceType = paResourceType;
    }
}

