/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.JTabbedPane;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.gui.AlertCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.EndpointAlertEditor;
import org.eclipse.aperi.TStorm.gui.GroupSelector;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class EndpointAlertCreateOrEdit
extends AlertCreateOrEdit {
    private GroupSelector endpointSelector;
    private static final int ALERT_TAB = 0;
    private static final int FABRIC_TAB = 1;

    public EndpointAlertCreateOrEdit(CreateOrEditDDI pDdi) {
        super(pDdi);
    }

    protected void makeTabbedPane(AlertHeader endpointAlert) {
        this.endpointSelector = new GroupSelector(129, endpointAlert.alertElements, endpointAlert.alertGroups, endpointAlert.allObjects);
        this.alertEditor = endpointAlert.alert == null ? new EndpointAlertEditor(this) : new EndpointAlertEditor(this, endpointAlert.alert);
        this.tabbedPane = new JTabbedPane();
        String title = MessageLog.getMessageNoID("STG4036L");
        this.tabbedPane.addTab(title, this.alertEditor.getComponent());
        title = Util.getString("FabricAlert_EndpointTabTitle");
        this.tabbedPane.addTab(title, this.endpointSelector.getComponent());
        if (((EndpointAlertEditor)this.alertEditor).getConditionValue() == 106) {
            this.tabbedPane.setEnabledAt(1, false);
        }
    }

    public CreateHeader getData() {
        AlertHeader endpointAlert = (AlertHeader)super.getData();
        NameList[] compLists = this.endpointSelector.getData();
        endpointAlert.alertElements = compLists[0];
        endpointAlert.alertGroups = compLists[1];
        endpointAlert.alertClusters = compLists[2];
        endpointAlert.allObjects = this.endpointSelector.allMembersSelected;
        return endpointAlert;
    }

    public void replace(CreateHeader newHeader) {
        super.replace(newHeader);
        AlertHeader endpointAlert = (AlertHeader)newHeader;
        this.endpointSelector.replace(endpointAlert.alertElements, endpointAlert.alertGroups, endpointAlert.alertClusters, endpointAlert.allObjects);
    }

    public void changeOccurred(int changeType, NameList name) {
        if (changeType == 100) {
            this.endpointSelector.invalidateGroups(name.nlInfo);
        }
        if (changeType != 1) {
            return;
        }
        if (name.nlInfo == 122) {
            this.endpointSelector.addGroup(name);
        }
    }

    public String getHelpID(int tab) {
        switch (tab) {
            case 0: {
                return FabricGuiUtil.FHELP_ALERT_ENDPOINT;
            }
            case 1: {
                return FabricGuiUtil.FHELP_ALERT_SELECT;
            }
        }
        return null;
    }
}

