/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.ExportsAdjuster;
import org.eclipse.aperi.TStorm.gui.ExportsDDI;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;

public class ExportsTable
extends JPanel
implements GuiRequestor {
    private MegaTable eTable = new MegaTable();
    private Export[] exports;
    private GuiReportReq grr;
    private ExportsAdjuster adjuster;

    public ExportsTable(GuiReportReq grr) {
        this.grr = grr;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.adjuster = new ExportsAdjuster(grr);
    }

    public void handleResponse(short status, Response response) {
        this.setLayout(new BorderLayout());
        this.exports = status <= 4 ? (Export[])response.responseData : null;
        int cnt = this.exports != null ? this.exports.length : 0;
        if (cnt == 0) {
            this.add((Component)ReportingDDI.getNoDataMessage(this.grr), "Center");
            return;
        }
        this.adjuster.adjust(this.exports, false);
        this.eTable.setMouseListener(new selectListener());
        this.eTable.setRowIcon(10, true);
        this.eTable.setCellRenderer(Date.class, TableCellRenderers.date);
        this.eTable.setBaseTableModel(new ExportsTableModel());
        this.add((Component)this.eTable, "Center");
    }

    public class selectListener
    extends TJCTableMouseAdapter {
        public boolean select(int viewRow, int viewCol) {
            return true;
        }

        public void doubleClick(int dataRow, int dataCol) {
            new ExportsDDI(null, ExportsTable.this.exports[dataRow]);
        }
    }

    private class ExportsTableModel
    extends BaseTableModel {
        ExportsTableModel() {
            this.rowCount = ExportsTable.this.exports.length;
            this.columnNames = ((ExportsTable)ExportsTable.this).adjuster.columnNameList;
            this.commonAdjuster = ExportsTable.this.adjuster;
        }

        public Object getTableDataItem(int row, int col) {
            return ExportsTable.this.adjuster.getCellData(row, ExportsTable.this.adjuster.translateColumn(col));
        }
    }
}

