/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Date;
import org.eclipse.aperi.TStorm.gui.BaseAlertLogTableData;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertLogDetailPanel;
import org.eclipse.aperi.gui.AlertLogTable;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.server.guireq.AlertLogReq;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.xmsg.MessageLog;

public class FabricAlertLogTableData
extends BaseAlertLogTableData {
    private static final int ACTIVE_COLUMN = 0;
    private static final int FABRIC_COLUMN = 1;
    private static final int OBJ_TYPE_COLUMN = 2;
    private static final int OBJ_NAME_COLUMN = 3;
    private static final int CONDITION_COLUMN = 4;
    private static final int FIRST_LOGGED_COLUMN = 5;
    private static final int LAST_LOGGED_COLUMN = 6;
    private static final int N_VIOLATIONS_COLUMN = 7;
    private static final int CREATOR_COLUMN = 8;
    private static final int NAME_COLUMN = 9;
    private static final int SCRIPT_NAME_COLUMN = 10;
    private static final int N_COLUMNS = 11;
    private static final String[] msgIDs = new String[]{null, "STG1102L", "GUI2021L", "GUI2022L", "GUI2023L", "GUI2024L", "GUI2025L", "GUI2026L", "GUI2027L", "GUI2028L", "GUI2069L"};
    private boolean hasObjectNameColumn = true;
    private boolean hasObjectTypeColumn = true;
    private int[] hiddenColumns;

    public FabricAlertLogTableData(AlertLogTable logTable, ExtAlertLog[] array, AlertLogReq logRequest) {
        super(logTable, array);
        this.columnNames = new String[11];
        this.columnNames[0] = " ";
        for (int i = 1; i < 11; ++i) {
            this.columnNames[i] = i != 3 || this.hasObjectTypeColumn || !this.hasObjectNameColumn ? MessageLog.getMessageNoID(msgIDs[i]) : CreateOrEditDDI.getObjectTypeName(logRequest.objectType);
        }
    }

    public Object getTableDataItem(int row, int column) {
        ExtAlertLog record = this.array[row];
        Object result = null;
        switch (column) {
            case 0: {
                result = this.byteToObject(row, record.alState);
                break;
            }
            case 1: {
                result = record.alComputer;
                break;
            }
            case 2: {
                if (record.getAlObjectName() == null) break;
                result = CreateOrEditDDI.getObjectTypeName(record.alResourceType);
                break;
            }
            case 3: {
                result = record.getAlObjectName();
                break;
            }
            case 4: {
                result = MessageLog.getMessageNoID(AlertConditionManager.getConditionMessageId(record.alAlertCondition));
                break;
            }
            case 5: {
                result = new Date(record.alFirstAlertTime);
                break;
            }
            case 6: {
                result = new Date(record.alLastAlertTime);
                break;
            }
            case 7: {
                result = this.intToObject(row, record.alAlertCount);
                break;
            }
            case 8: {
                result = record.alCreator;
                break;
            }
            case 9: {
                result = record.getAlName();
                break;
            }
            case 10: {
                if (Util.isEmpty(record.alScriptLogFile)) break;
                result = record.alScriptName;
            }
        }
        if (result == null) {
            result = AlertLogDDI.notApplicableText;
        }
        return result;
    }

    public static void addResourceDescription(ExtAlertLog record, AlertLogDetailPanel detailPanel) {
        String s;
        if (record.alResourceType >= 0 && (s = CreateOrEditDDI.getObjectTypeName(record.alResourceType)) != null) {
            detailPanel.addPair(s, record.getAlObjectName());
        }
    }

    public void hideColumns(MegaTable table) {
        int[] tempArray = new int[3];
        int ix = 0;
        this.hiddenColumns = null;
        if (!this.hasObjectTypeColumn) {
            table.setColumnHidden(2, true);
            tempArray[ix] = 2;
            ++ix;
            if (!this.hasObjectNameColumn) {
                table.setColumnHidden(3, true);
                tempArray[ix] = 3;
                ++ix;
            }
        }
        if (ix > 0) {
            this.hiddenColumns = new int[ix];
            for (int j = 0; j < ix; ++j) {
                this.hiddenColumns[j] = tempArray[j];
            }
        }
    }

    public int getNumberColumns() {
        return 11;
    }

    public int[] getRenderers() {
        int[] rendererArray = new int[11];
        rendererArray[5] = 1;
        rendererArray[6] = 1;
        rendererArray[7] = 5;
        return rendererArray;
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }
}

