/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.EditableList;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IPScanElementEditor;
import org.eclipse.aperi.xmsg.MessageLog;

class IPScanListEditor
extends EditableList
implements DocumentListener {
    private JComponent panel;
    private NameList ips;
    private String desc;
    private static IPScanElementEditor ipEditor = new IPScanElementEditor();
    private static String invalidFormatTitle = MessageLog.getMessageNoID("GUI8214T");
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public IPScanListEditor(NameList plist, String descStr) {
        super(" ", ipEditor, null, 5);
        this.ips = plist;
        this.desc = descStr;
        Document oneDoc = ipEditor.getIpDocumentOne();
        Document twoDoc = ipEditor.getIpDocumentTwo();
        Document threeDoc = ipEditor.getIpDocumentThree();
        if (oneDoc != null) {
            oneDoc.addDocumentListener(this);
        }
        if (twoDoc != null) {
            twoDoc.addDocumentListener(this);
        }
        if (threeDoc != null) {
            threeDoc.addDocumentListener(this);
        }
    }

    public JComponent getComponent() {
        while (this.ips != null) {
            this.addObject(this.ips.nlName);
            this.ips = this.ips.nlNext;
        }
        if (ipEditor != null && ipEditor.allIpFieldsFull()) {
            this.setAddEnabled(true);
        }
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JLabel label = new JLabel(this.desc);
        c.insets.top = 10;
        c.insets.left = 10;
        c.insets.bottom = 6;
        c.gridwidth = 0;
        c.anchor = 18;
        this.panel.add((Component)label, c);
        c.insets.top = 0;
        c.insets.left = 0;
        c.insets.bottom = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.panel.add(Box.createHorizontalStrut(100), c);
        c.insets.left = 10;
        c.gridheight = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.panel.add((Component)this, c);
        return this.panel;
    }

    public void addObject(Object o) {
        String s = o.toString().trim();
        int n = this.listModel.size();
        boolean going = true;
        while (going && n > 0) {
            String p;
            if (!(p = this.listModel.get(--n).toString()).equals(s)) continue;
            going = false;
        }
        if (going) {
            super.addObject(s);
        }
    }

    private static NameList makeNameList(Object o) {
        NameList result = new NameList();
        result.nlName = o.toString();
        return result;
    }

    public NameList getData() {
        NameList head = null;
        Object[] array = this.getElements();
        if (array != null && array.length > 0) {
            NameList last = head = IPScanListEditor.makeNameList(array[0]);
            for (int i = 1; i < array.length; ++i) {
                NameList element;
                last.nlNext = element = IPScanListEditor.makeNameList(array[i]);
                last = element;
            }
        }
        return head;
    }

    public void changedUpdate(DocumentEvent de) {
        if (ipEditor != null && ipEditor.allIpFieldsFull()) {
            this.setAddEnabled(true);
        }
    }

    public void insertUpdate(DocumentEvent de) {
        if (ipEditor != null && ipEditor.allIpFieldsFull()) {
            this.setAddEnabled(true);
        }
    }

    public void removeUpdate(DocumentEvent de) {
        if (ipEditor != null && ipEditor.allIpFieldsEmpty()) {
            this.setAddEnabled(false);
        }
    }

    protected void actionAdd() {
        String ip = String.valueOf(ipEditor.getObject());
        if (this.simpleNumericIPValidator(ip)) {
            this.addObject(ip);
            ipEditor.emptyAllIpFields();
        }
    }

    private boolean simpleNumericIPValidator(String ip) {
        String pattern = "^[\\d]+\\.[\\d]+\\.[\\d]+\\.[\\d]";
        if (!ip.matches(pattern)) {
            String msg = MessageLog.getMessageNoID("GUI8215E", ip);
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), msg, invalidFormatTitle, 0);
            return false;
        }
        return true;
    }
}

