/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.LogicalVolumeAdjuster;
import org.eclipse.aperi.TStorm.common.LogicalVolumeGrapher;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeDDI;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalVolumeTable
extends JPanel
implements ActionListener,
AskForRowIconInterface,
DisplaysChartPopupInterface,
GuiRequestor,
HistoryChoiceInterface,
TJCTableMouseInterface {
    private MegaTable lvTable = new MegaTable();
    private Share[] shArray;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private LogicalVolumeAdjuster adjuster;
    private LogicalVolumeGrapher grapher;

    public LogicalVolumeTable(GuiReportReq grr, ReportingDDI ddi) {
        this.grr = grr;
        this.ddi = ddi;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.adjuster = new LogicalVolumeAdjuster(grr);
        this.grapher = new LogicalVolumeGrapher();
    }

    public void handleResponse(short status, Response response) {
        this.setLayout(new BorderLayout());
        this.shArray = status <= 4 ? (Share[])response.responseData : null;
        int cnt = this.shArray != null ? this.shArray.length : 0;
        if (cnt == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.shArray, false);
        this.shArray = (Share[])this.adjuster.getArray();
        this.lvTable.setFrozenColumns(this.adjuster.frozenColumns);
        this.lvTable.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.lvTable.setCellRenderer(Date.class, TableCellRenderers.date);
        this.lvTable.setRowIcon(this.grr.reportSubtype == 21 ? 10 : 11, true);
        this.lvTable.setMouseListener(this);
        if (this.adjuster.frozenRows > 0) {
            this.lvTable.setFrozenRows(this.adjuster.frozenRows);
        }
        this.lvTable.setBaseTableModel(new LogicalDiskTableModel());
        this.lvTable.setAsFirstColumn(this.adjuster.getFirstColumn());
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.lvTable, "Center");
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public boolean changeIcon(int dataRow) {
        return this.shArray[dataRow].shFilesystem.fsID < 0;
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this;
    }

    public void showJumpChart() {
        int[] rows = new int[this.shArray.length];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = this.lvTable.getDataRow(i);
        }
        int[] ix = this.getGraphID("STG1276T");
        this.grr.chartSubtype = (byte)ix[0];
        this.grapher.createChart(this.grr, this.shArray, rows, this.adjuster, this.ddi, null);
    }

    public boolean select(int viewRow, int viewCol) {
        return this.shArray[this.lvTable.getDataRow((int)viewRow)].shFilesystem.fsID > 0;
    }

    public void doubleClick(int dataRow, int dataCol) {
        if (!this.adjuster.hasTotalsRow() || dataRow != 0) {
            String path = this.shArray[dataRow].shFilesystem.fsMountPoint != " " ? this.shArray[dataRow].shFilesystem.fsMountPoint : this.shArray[dataRow].shPath;
            NameList computer = new NameList();
            computer.nlID = this.shArray[dataRow].shComputerID;
            computer.nlName = GuiUtil.getComputer((int)computer.nlID).gcTSName;
            computer.nlInfo = 1;
            new LogicalVolumeDDI(null, this.shArray[dataRow].shLogicalDisk.ldID, this.shArray[dataRow].shFilesystem.fsID, computer, path);
        }
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
        if (this.grr.reportSubtype != 21) {
            JPopupMenu menu = new JPopupMenu();
            boolean rowsSelected = this.lvTable.rowsSelected();
            boolean popupEnabled = this.shArray != null && this.shArray.length > 0;
            JMenuItem mi = menu.add(MessageLog.getMessageNoID("STG1251T"));
            mi.setActionCommand("STG1251T");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG1276T"));
            mi.setEnabled(popupEnabled);
            mi.setActionCommand("STG1276T");
            mi.addActionListener(this);
            menu.addSeparator();
            mi = menu.add(MessageLog.getMessageNoID("STG5105L"));
            mi.setActionCommand("STG5105L");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5106L"));
            mi.setActionCommand("STG5106L");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5107L"));
            mi.setActionCommand("STG5107L");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5108L"));
            mi.setActionCommand("STG5108L");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            menu.show(c, x, y);
            menu.requestFocus();
        }
    }

    public void selectionChanged(boolean state) {
    }

    public void showDefaultChart(int dataRow) {
        int[] rows = new int[]{dataRow};
        int[] ix = this.getGraphID("STG1251T");
        this.grr.chartSubtype = (byte)ix[0];
        this.grapher.createChart(this.grr, this.shArray, rows, this.adjuster, this.ddi, null);
    }

    public void actionPerformed(ActionEvent e) {
        int[] rows;
        String actionCommand = e.getActionCommand();
        if (actionCommand == "STG1276T") {
            rows = new int[this.shArray.length];
            for (int i = 0; i < this.shArray.length; ++i) {
                rows[i] = this.lvTable.getDataRow(i);
            }
        } else {
            rows = this.lvTable.getSelectedRows();
        }
        if (rows != null && rows.length > 0) {
            if (actionCommand == "STG1251T" || actionCommand == "STG1276T") {
                int[] ix = this.getGraphID(actionCommand);
                this.grr.chartSubtype = (byte)ix[0];
                this.grapher.createChart(this.grr, this.shArray, rows, this.adjuster, this.ddi, null);
            } else {
                GuiReportReq newGrr = this.grapher.createHistory(this.grr, this.shArray, rows, actionCommand);
                this.ddi.addObject(this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", newGrr, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(newGrr.historyTitle), this);
            }
        }
    }

    public LogicalVolumeTable(String a, String b, String c, String d) {
    }

    public Object[] getChoices(int reportType, int reportSubtype) {
        Object[] array = null;
        if (reportSubtype != 21) {
            array = new Object[3];
            String[] messageArray = new String[]{"STG7530L", "STG7531L", "STG7537L", "STG7538L"};
            byte[] labelArray = new byte[]{1, 8, 1, 8};
            byte[] reportArray = new byte[]{1, 2, 3, 4};
            array[0] = messageArray;
            array[1] = labelArray;
            array[2] = reportArray;
        }
        return array;
    }

    public Object[] getCharts(int reportType, int reportSubtype) {
        Object[] array = null;
        if (reportSubtype != 21) {
            array = new Object[2];
            String[] messageArray = new String[]{"STG7528L"};
            byte[] reportArray = new byte[]{101};
            array[0] = messageArray;
            array[1] = reportArray;
        }
        return array;
    }

    public int[] getGraphID(String selectedCommand) {
        int[] array = new int[2];
        array[0] = selectedCommand == "STG1251T" ? 101 : (selectedCommand == "STG1276T" ? 102 : (selectedCommand == "STG5105L" ? 1 : (selectedCommand == "STG5106L" ? 2 : (selectedCommand == "STG5107L" ? 3 : 4))));
        return array;
    }

    private class LogicalDiskTableModel
    extends BaseTableModel {
        LogicalDiskTableModel() {
            this.columnNames = ((LogicalVolumeTable)LogicalVolumeTable.this).adjuster.colNames;
            this.rowCount = LogicalVolumeTable.this.shArray.length;
            this.commonAdjuster = LogicalVolumeTable.this.adjuster;
        }

        public Object getTableDataItem(int row, int col) {
            return LogicalVolumeTable.this.adjuster.getCellData(row, LogicalVolumeTable.this.adjuster.translateColumn(col));
        }
    }
}

