/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.PingAdjuster;
import org.eclipse.aperi.TStorm.common.PingGrapher;
import org.eclipse.aperi.TStorm.common.PingReport;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class PingTable
extends JPanel
implements ActionListener,
DisplaysChartPopupInterface,
GuiRequestor,
HistoryChoiceInterface,
TJCTableMouseInterface {
    private MegaTable table = new MegaTable();
    private PingReport[] tableData;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private PingAdjuster adjuster;
    private PingGrapher grapher;

    public PingTable(GuiReportReq grr, ReportingDDI ddi) {
        this.grr = grr;
        this.ddi = ddi;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.adjuster = new PingAdjuster(grr);
        this.grapher = new PingGrapher();
    }

    public void handleResponse(short status, Response response) {
        this.setLayout(new BorderLayout());
        this.tableData = status <= 4 ? (PingReport[])response.responseData : null;
        int rows = this.tableData != null ? this.tableData.length : 0;
        if (rows == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.tableData, false);
        this.table.setMouseListener(this);
        this.table.setCellRenderer(MutableShort.class, TableCellRenderers.percent);
        this.table.setCellRenderer(Date.class, TableCellRenderers.date);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setCellRenderer(MutableLong.class, new TableCellRenderers.DecimalRenderer(1, MessageLog.getMessageNoID("STG7558L")));
        int rowChartIcon = this.grr.reportSubtype == 28 ? 10 : 11;
        this.table.setRowIcon(rowChartIcon, this.grr.reportSubtype != 28);
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setBaseTableModel(new PingModel());
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this.grr.reportSubtype == 28 ? null : this;
    }

    public boolean select(int viewRow, int viewCol) {
        return true;
    }

    public void selectionChanged(boolean state) {
    }

    public void doubleClick(int dataRow, int dataCol) {
        if (this.grr.reportSubtype != 28) {
            GuiReportReq newGrr = this.grr.explode(this.tableData[dataRow].prID);
            this.ddi.addReport(this.grr, newGrr, this.grapher.getRowName(this.tableData, dataRow, this.adjuster));
        }
    }

    public void showDefaultChart(int dataRow) {
        int[] rows = new int[]{dataRow};
        int[] ix = this.getGraphID("STG4121L");
        this.grr.chartSubtype = (byte)ix[0];
        this.grapher.createChart(this.grr, this.tableData, rows, this.adjuster, this.ddi, null);
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
        if (this.grr.reportSubtype != 28) {
            int[] rows = this.table.getSelectedRows();
            boolean haveSelections = rows != null && rows.length > 0;
            boolean enablePopup = this.tableData != null && this.tableData.length > 0;
            JPopupMenu menu = new JPopupMenu();
            JMenuItem mi = menu.add(MessageLog.getMessageNoID("STG4121L"));
            mi.setEnabled(haveSelections);
            mi.setActionCommand("STG4121L");
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG4122L"));
            mi.setEnabled(enablePopup && this.grr.reportSubtype != 28);
            mi.setActionCommand("STG4122L");
            mi.addActionListener(this);
            if (this.grr.reportSubtype == 12) {
                menu.addSeparator();
                mi = menu.add(MessageLog.getMessageNoID("STG4123L"));
                mi.setEnabled(haveSelections);
                mi.setActionCommand("STG4123L");
                mi.addActionListener(this);
                mi = menu.add(MessageLog.getMessageNoID("STG4124L"));
                mi.setEnabled(haveSelections);
                mi.setActionCommand("STG4124L");
                mi.addActionListener(this);
            }
            menu.show(c, x, y);
            menu.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent e) {
        int[] rows;
        String actionCommand = e.getActionCommand();
        if (actionCommand == "STG4122L") {
            rows = new int[this.tableData.length];
            for (int i = rows.length - 1; i >= 0; --i) {
                rows[i] = this.table.getDataRow(i);
            }
        } else {
            rows = this.table.getSelectedRows();
        }
        if (actionCommand == "STG4124L" || actionCommand == "STG4123L") {
            GuiReportReq newGrr = this.grapher.createHistory(this.grr, this.tableData, rows, actionCommand);
            this.ddi.addObject(this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", newGrr, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(newGrr.historyTitle), this);
        } else {
            int[] ix = this.getGraphID(actionCommand);
            this.grr.chartSubtype = (byte)ix[0];
            this.grapher.createChart(this.grr, this.tableData, rows, this.adjuster, this.ddi, null);
        }
    }

    public void showJumpChart() {
        int[] rows = new int[this.tableData.length];
        for (int i = rows.length - 1; i >= 0; --i) {
            rows[i] = this.table.getDataRow(i);
        }
        int[] ix = this.getGraphID("STG4122L");
        this.grr.chartSubtype = (byte)ix[0];
        this.grapher.createChart(this.grr, this.tableData, rows, this.adjuster, this.ddi, null);
    }

    public PingTable(String a, String b, String c, String d) {
    }

    public Object[] getChoices(int reportType, int reportSubtype) {
        Object[] array = null;
        if (reportSubtype == 12) {
            array = new Object[3];
            String[] messageArray = new String[]{"STG4123L", "STG4124L"};
            byte[] labelArray = new byte[]{8, 3};
            byte[] reportArray = new byte[]{6, 7};
            array[0] = messageArray;
            array[1] = labelArray;
            array[2] = reportArray;
        }
        return array;
    }

    public Object[] getCharts(int reportType, int reportSubtype) {
        Object[] array = new Object[2];
        String[] messageArray = new String[]{"STG7554L"};
        byte[] reportArray = new byte[]{101};
        array[0] = messageArray;
        array[1] = reportArray;
        return array;
    }

    public int[] getGraphID(String selectedCommand) {
        int[] array = new int[2];
        array[0] = selectedCommand == "STG4121L" ? 101 : (selectedCommand == "STG4122L" ? 102 : (selectedCommand == "STG4123L" ? 6 : 7));
        return array;
    }

    private class PingModel
    extends BaseTableModel {
        PingModel() {
            this.columnNames = ((PingTable)PingTable.this).adjuster.colNames;
            this.rowCount = PingTable.this.tableData.length;
            this.commonAdjuster = PingTable.this.adjuster;
        }

        public Object getTableDataItem(int row, int col) {
            return PingTable.this.adjuster.getCellData(row, PingTable.this.adjuster.translateColumn(col));
        }
    }
}

