/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.common.Report;
import org.eclipse.aperi.TStorm.gui.FileMaskEditor;
import org.eclipse.aperi.TStorm.gui.ReportCreateOrEdit;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.ChartInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationDialog;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationDialogCallbackInterface;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationKey;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationManager;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportOptions
extends JPanel
implements GuiRequestor,
ItemListener,
ActionListener,
AperiChartCustomizationDialogCallbackInterface {
    GridBagConstraints gbcRegular = new GridBagConstraints();
    Insets insetA = new Insets(0, 5, 0, 0);
    JPanel reportTypePanel;
    JCheckBox runScript;
    JLabel scriptLabel;
    JTextField scriptName;
    JCheckBox includeHeaders;
    JCheckBox includeTotals;
    JCheckBox includeHistHeaders;
    JComboBox computerBox;
    JComboBox historyReportBox;
    JComboBox historyTypeBox;
    JComboBox chartReportBox;
    FileMaskEditor fileMaskEditor;
    JRadioButton csvButton;
    JRadioButton formattedButton;
    JRadioButton htmlButton;
    JRadioButton historyButton;
    JRadioButton pdfChartButton;
    JRadioButton htmlChartButton;
    Report report;
    NameList computerList;
    NameList computerNode;
    NameList resetAgent = null;
    byte[] histLabelArray;
    byte[] histReportArray;
    byte[] histRangeArray;
    byte[] chartReportArray;
    boolean fieldsSet;
    boolean computersAre21;
    static final String COMPUTER_TITLE = MessageLog.getMessageNoID("STG5147L");
    static final String SCRIPT_TITLE = MessageLog.getMessageNoID("GUI2069L");
    static final String FILE_MASK_TITLE = MessageLog.getMessageNoID("STG5148L");
    static final String REPORT_TYPE_TITLE = MessageLog.getMessageNoID("STG5149L");
    static final String COMPUTER_BOX_LABEL = MessageLog.getMessageNoID("STG5154L");
    static final String COMPUTER_BOX_LABEL2 = MessageLog.getMessageNoID("STG5157L");
    static final String REPORT_TYPE_LABEL = MessageLog.getMessageNoID("STG5155L");
    static final String CSV_BUTTON = MessageLog.getMessageNoID("STG5150L");
    static final String FORMATTED_BUTTON = MessageLog.getMessageNoID("STG5151L");
    static final String HTML_BUTTON = MessageLog.getMessageNoID("STG5256L");
    static final String HISTORY_BUTTON = MessageLog.getMessageNoID("STG5257L");
    static final String PDF_CHART_BUTTON = MessageLog.getMessageNoID("STG5267L");
    static final String HTML_CHART_BUTTON = MessageLog.getMessageNoID("STG5268L");
    static final String INCLUDE_HEADERS = MessageLog.getMessageNoID("GUI5084L");
    static final String INCLUDE_TOTALS = MessageLog.getMessageNoID("GUI5085L");
    static final String[] HISTORY_TYPES = new String[]{MessageLog.getMessageNoID("STG1193T"), MessageLog.getMessageNoID("STG1194T"), MessageLog.getMessageNoID("STG1195T")};
    static final String CHART_CUST_BUTTON = Util.getString("CUSTOMIZE_THIS_CHART");
    private JButton chartCustButton;
    private ChartOptions defaultSettings = null;
    private ChartOptions currentSettings = null;
    private int reportSubtype;
    private int chartId;
    private int chartSubtype = 0;
    private ReportCreateOrEdit rcoe;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ReportOptions(Report report) {
        this(report, null);
    }

    public ReportOptions(Report report, ReportCreateOrEdit rcoe) {
        this.report = report;
        this.rcoe = rcoe;
        this.getAgents();
        this.gbcRegular.anchor = 17;
        this.gbcRegular.gridwidth = 0;
        this.gbcRegular.insets = this.insetA;
        this.reportTypePanel = this.makeReportTypePanel();
    }

    private void getAgents() {
        GuiListReq requestData = new GuiListReq();
        requestData.listRequested = 12;
        requestData.excludeNAS = true;
        requestData.excludeVS = true;
        if (this.report.batchReport.reportType == 8 || this.report.batchReport.reportType == 9) {
            requestData.excludeUnder21 = true;
            this.computersAre21 = true;
        } else {
            this.computersAre21 = false;
        }
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", requestData);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            this.computerList = (NameList)response.responseData;
            if (this.fieldsSet) {
                this.computerBox.removeAllItems();
                this.replaceComputers();
            } else {
                this.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.gridwidth = 0;
                c.weightx = 1.0;
                c.fill = 1;
                this.add((Component)this.makeComputerPanel(), c);
                this.buildPanel(c);
                if (this.rcoe != null && this.rcoe.ddi.oldCreateHeader == null) {
                    this.rcoe.getData();
                    this.rcoe.ddi.oldCreateHeader = (Report)this.rcoe.report.clone();
                }
            }
        }
    }

    private void buildPanel(GridBagConstraints c) {
        this.add((Component)this.reportTypePanel, c);
        this.add(this.makeScriptPanel(), c);
        this.fileMaskEditor = new FileMaskEditor(128);
        c.weightx = 0.0;
        this.add((Component)this.fileMaskEditor.build(), c);
        c.gridheight = 0;
        c.weighty = 1.0;
        this.add(Box.createVerticalStrut(1), c);
        this.setFields();
        this.addListeners();
    }

    private JPanel makeComputerPanel() {
        this.computerBox = new TComboBox();
        this.replaceComputers();
        JPanel panel = GuiUtil.getTitledBorderedPanel(COMPUTER_TITLE);
        JPanel subPanel = new JPanel(new BorderLayout());
        JLabel computerBoxLabel = new JLabel(COMPUTER_BOX_LABEL);
        JLabel computerBoxLabel2 = new JLabel(COMPUTER_BOX_LABEL2);
        subPanel.add((Component)computerBoxLabel, "North");
        subPanel.add((Component)computerBoxLabel2, "South");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = this.gbcRegular.anchor;
        c.insets.left = this.insetA.left;
        c.insets.bottom = 6;
        c.gridheight = 0;
        panel.add((Component)subPanel, c);
        c.gridwidth = 0;
        c.insets.left = 12;
        panel.add((Component)this.computerBox, c);
        GuiUtil.completePanel(panel);
        return panel;
    }

    private void replaceComputers() {
        NameList dummyComputer = new NameList();
        dummyComputer.nlName = " ";
        this.computerBox.addItem(dummyComputer);
        this.computerNode = this.computerList;
        while (this.computerNode != null) {
            this.computerBox.addItem(this.computerNode);
            this.computerNode = this.computerNode.nlNext;
        }
        if (this.resetAgent != null) {
            this.computerBox.setSelectedIndex(0);
            int index = 1;
            this.computerNode = this.computerList;
            while (this.computerNode != null) {
                if (this.computerNode.nlID == this.resetAgent.nlID) {
                    this.computerBox.setSelectedIndex(index);
                    break;
                }
                ++index;
                this.computerNode = this.computerNode.nlNext;
            }
            this.resetAgent = null;
        }
    }

    private Component makeScriptPanel() {
        String s = MessageLog.getMessageNoID("GUI2071L");
        this.runScript = new JCheckBox(s);
        s = MessageLog.getMessageNoID("GUI2077L");
        this.scriptLabel = new JLabel(s);
        this.scriptLabel.setEnabled(false);
        GuiUtil.setAccessible(this.runScript, this.runScript.getText(), this.runScript.getText());
        this.scriptName = TTextField.newTTextField(10, 64, false);
        this.scriptName.setEnabled(false);
        GuiUtil.setAccessibleLabel(this.scriptLabel, this.scriptName, "MNEMONIC_SCRIPTNAME", s, "DESCRIPTION_SCRIPTNAME");
        JPanel panel = GuiUtil.getTitledBorderedPanel(SCRIPT_TITLE);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 0;
        c.insets.left = this.insetA.left;
        c.insets.bottom = 6;
        c.anchor = 17;
        panel.add((Component)this.runScript, c);
        c.insets.left = 15;
        panel.add((Component)this.scriptLabel, c);
        c.insets.left = 3;
        c.gridwidth = 0;
        c.weightx = 1.0;
        panel.add((Component)this.scriptName, c);
        return panel;
    }

    private JPanel makeReportTypePanel() {
        JPanel panel = GuiUtil.getTitledBorderedPanel(REPORT_TYPE_TITLE);
        JLabel reportTypeLabel = new JLabel(REPORT_TYPE_LABEL);
        this.csvButton = new JRadioButton(CSV_BUTTON);
        this.formattedButton = new JRadioButton(FORMATTED_BUTTON);
        this.htmlButton = new JRadioButton(HTML_BUTTON);
        this.historyButton = new JRadioButton(HISTORY_BUTTON);
        this.pdfChartButton = new JRadioButton(PDF_CHART_BUTTON);
        this.htmlChartButton = new JRadioButton(HTML_CHART_BUTTON);
        this.chartCustButton = new JButton(CHART_CUST_BUTTON);
        GuiUtil.setAccessible(this.csvButton, CSV_BUTTON, CSV_BUTTON);
        GuiUtil.setAccessible(this.formattedButton, FORMATTED_BUTTON, FORMATTED_BUTTON);
        GuiUtil.setAccessible(this.htmlButton, HTML_BUTTON, HTML_BUTTON);
        GuiUtil.setAccessible(this.historyButton, HISTORY_BUTTON, HISTORY_BUTTON);
        GuiUtil.setAccessible(this.htmlChartButton, HISTORY_BUTTON, HISTORY_BUTTON);
        GuiUtil.setAccessible(this.htmlChartButton, CHART_CUST_BUTTON, CHART_CUST_BUTTON);
        ButtonGroup typeGroup = new ButtonGroup();
        typeGroup.add(this.csvButton);
        typeGroup.add(this.formattedButton);
        typeGroup.add(this.htmlButton);
        typeGroup.add(this.historyButton);
        typeGroup.add(this.htmlChartButton);
        this.includeHeaders = new JCheckBox(INCLUDE_HEADERS);
        this.includeHeaders.setEnabled(false);
        GuiUtil.setAccessible(this.includeHeaders, INCLUDE_HEADERS, INCLUDE_HEADERS);
        this.includeTotals = new JCheckBox(INCLUDE_TOTALS);
        this.includeTotals.setEnabled(false);
        GuiUtil.setAccessible(this.includeTotals, INCLUDE_TOTALS, INCLUDE_TOTALS);
        this.includeHistHeaders = new JCheckBox(INCLUDE_HEADERS);
        this.includeHistHeaders.setEnabled(false);
        GuiUtil.setAccessible(this.includeHistHeaders, INCLUDE_HEADERS, INCLUDE_HEADERS);
        this.historyReportBox = new TComboBox();
        this.historyReportBox.setEnabled(false);
        this.historyTypeBox = new TComboBox(HISTORY_TYPES);
        this.historyTypeBox.setEnabled(false);
        this.chartReportBox = new TComboBox();
        this.chartReportBox.setEnabled(false);
        panel.add((Component)reportTypeLabel, this.gbcRegular);
        GridBagConstraints gbcFirst = new GridBagConstraints();
        GridBagConstraints gbcPlop = new GridBagConstraints();
        GridBagConstraints gbcLast = new GridBagConstraints();
        Insets insetX = new Insets(0, 0, 0, 5);
        Insets insetY = new Insets(0, 0, 0, 4);
        Insets insetZ = new Insets(0, 0, 0, 0);
        gbcFirst.anchor = 17;
        gbcFirst.insets = insetX;
        gbcPlop.gridwidth = 17;
        gbcPlop.insets = insetY;
        gbcLast.gridwidth = 0;
        gbcLast.insets = insetZ;
        JPanel subPanel = GuiUtil.getPanel();
        JPanel subPanel2 = GuiUtil.getPanel();
        JPanel subPanel3 = GuiUtil.getPanel();
        JPanel subPanel4 = GuiUtil.getPanel();
        subPanel.add((Component)this.csvButton, gbcFirst);
        subPanel.add((Component)this.includeHeaders, gbcPlop);
        subPanel.add((Component)this.includeTotals, gbcPlop);
        subPanel.add((Component)new JLabel(" "), gbcPlop);
        subPanel.add((Component)new JLabel(" "), gbcLast);
        subPanel.add((Component)this.formattedButton, gbcFirst);
        subPanel.add((Component)new JLabel(" "), gbcPlop);
        subPanel.add((Component)new JLabel(" "), gbcPlop);
        subPanel.add((Component)new JLabel(" "), gbcPlop);
        subPanel.add((Component)new JLabel(" "), gbcLast);
        subPanel.add((Component)this.htmlButton, gbcFirst);
        subPanel.add((Component)new JLabel(" "), gbcPlop);
        subPanel.add((Component)new JLabel(" "), gbcPlop);
        subPanel.add((Component)new JLabel(" "), gbcPlop);
        subPanel.add((Component)new JLabel(" "), gbcLast);
        subPanel.add((Component)this.historyButton, gbcFirst);
        subPanel.add((Component)this.includeHistHeaders, gbcPlop);
        subPanel.add((Component)this.historyReportBox, gbcPlop);
        subPanel.add((Component)this.historyTypeBox, gbcPlop);
        subPanel.add((Component)new JLabel(" "), gbcLast);
        subPanel3.add((Component)new JLabel(" "), gbcLast);
        subPanel3.add((Component)this.htmlChartButton, gbcFirst);
        subPanel3.add((Component)new JLabel(" "), gbcLast);
        subPanel4.add((Component)this.chartReportBox, gbcPlop);
        subPanel4.add((Component)this.chartCustButton, gbcPlop);
        subPanel4.add((Component)new JLabel(" "), gbcLast);
        GuiUtil.completePanel(subPanel3);
        GuiUtil.completePanel(subPanel4);
        subPanel2.add((Component)subPanel3, gbcFirst);
        subPanel2.add((Component)subPanel4, gbcLast);
        GuiUtil.completePanel(subPanel);
        GuiUtil.completePanel(subPanel2);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = this.gbcRegular.anchor;
        c.insets.left = 5;
        c.insets.bottom = 0;
        c.gridwidth = 0;
        panel.add((Component)subPanel, c);
        c.insets.left = 0;
        panel.add((Component)subPanel2, c);
        GuiUtil.completePanel(panel);
        return panel;
    }

    private void setFields() {
        boolean empty;
        this.fieldsSet = true;
        this.computerBox.setSelectedIndex(0);
        if (this.report.computerID > 0) {
            int index = 1;
            this.computerNode = this.computerList;
            while (this.computerNode != null) {
                if (this.computerNode.nlID == this.report.computerID) {
                    this.computerBox.setSelectedIndex(index);
                    break;
                }
                ++index;
                this.computerNode = this.computerNode.nlNext;
            }
        }
        if (empty = Util.isEmpty(this.report.batchReport.scriptName)) {
            this.report.batchReport.scriptName = "";
        }
        this.scriptName.setText(this.report.batchReport.scriptName);
        this.runScript.setSelected(!empty);
        this.scriptName.setEnabled(!empty);
        this.scriptLabel.setEnabled(!empty);
        String mask = null;
        if (this.report.batchReport.fileMask != null) {
            mask = this.report.batchReport.maskToText(null, null);
        }
        this.fileMaskEditor.setData(mask);
        if (this.report.batchReport.reportType == 2) {
            this.formattedButton.setSelected(true);
        } else if (this.report.batchReport.reportType == 6) {
            this.htmlButton.setSelected(true);
        } else if (this.report.batchReport.reportType == 7) {
            this.historyButton.setSelected(true);
            this.includeHistHeaders.setSelected(this.report.batchReport.includeHeaders);
            this.includeHistHeaders.setEnabled(true);
            this.historyReportBox.setEnabled(true);
            this.historyTypeBox.setEnabled(true);
        } else if (this.report.batchReport.reportType == 1) {
            this.csvButton.setSelected(true);
            this.includeHeaders.setSelected(this.report.batchReport.includeHeaders);
            this.includeTotals.setSelected(this.report.batchReport.includeTotals);
            this.includeHeaders.setEnabled(true);
            this.includeTotals.setEnabled(true);
        } else if (this.report.batchReport.reportType != 8) {
            this.htmlChartButton.setSelected(true);
            this.chartReportBox.setEnabled(true);
            this.chartCustButton.setEnabled(true);
        }
    }

    private void addListeners() {
        this.runScript.addItemListener(this);
        this.csvButton.addItemListener(this);
        this.historyButton.addItemListener(this);
        this.htmlChartButton.addItemListener(this);
        this.chartCustButton.addActionListener(this);
        this.historyReportBox.addItemListener(this);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.chartCustButton) {
            boolean isHistory = false;
            this.getData();
            if (this.report.batchReport.grr.chartSubtype <= 0) {
                isHistory = true;
                this.chartId = this.report.batchReport.grr.histSubtype;
                this.chartSubtype = this.report.batchReport.grr.histSubtypeRange;
            } else {
                this.chartId = this.report.batchReport.grr.chartSubtype;
            }
            this.reportSubtype = this.report.batchReport.grr.reportSubtype;
            ChartInfo ci = new ChartInfo();
            this.defaultSettings = ci.getChartDefaults(this.report.batchReport.grr.reportType, this.reportSubtype, isHistory, this.chartId, this.chartSubtype);
            if (this.report.batchReport.saveChartSettingsReq != null && this.chartId == ((GuiChartSettingsReq)this.report.batchReport.saveChartSettingsReq.requestData).chartId && this.chartSubtype == ((GuiChartSettingsReq)this.report.batchReport.saveChartSettingsReq.requestData).chartSubtype) {
                this.currentSettings = ((GuiChartSettingsReq)this.report.batchReport.saveChartSettingsReq.requestData).options;
            } else {
                GuiChartSettingsReq gcsr = new GuiChartSettingsReq();
                gcsr.reportId = this.report.batchReport.grr.reportType;
                gcsr.chartId = this.chartId;
                gcsr.chartSubtype = this.chartSubtype;
                gcsr.reportSubtype = this.reportSubtype;
                gcsr.creator = GuiUtil.getUserName();
                gcsr.batchId = this.report.batchReport.reportID;
                gcsr.reqType = 4;
                gcsr.options = null;
                ChartOptions cs = AperiChartCustomizationManager.getManager().getChartCustomization(new AperiChartCustomizationKey(gcsr));
                this.currentSettings = cs != null ? (ChartOptions)cs.clone() : (ChartOptions)this.defaultSettings.clone();
            }
            AperiChartCustomizationDialog cd = new AperiChartCustomizationDialog(this.guiMain.getFrame(), this, Util.getString("CHART_CUSTOMIZATION"), null, this.currentSettings, this.defaultSettings, true, true, this.report.batchReport.grr.chartSubtype > 0, true, this.report.batchReport.grr.chartSubtype <= 0);
            GuiUtil.centerDialog(cd);
            cd.show();
        }
    }

    public void getData() {
        GuiReportReq grr = this.report.batchReport.grr;
        this.report.batchReport.includeTotals = false;
        this.report.batchReport.includeHeaders = false;
        grr.histType = 0;
        grr.histSubtype = 0;
        grr.histSubtypeRange = 0;
        grr.chartSubtype = 0;
        grr.chartLabelType = 0;
        NameList item = (NameList)this.computerBox.getSelectedItem();
        this.report.computerID = item.nlID;
        this.report.batchReport.scriptName = this.runScript.isSelected() ? this.scriptName.getText() : "";
        this.report.batchReport.fileMask = this.fileMaskEditor.getData();
        this.report.batchReport.fileMask = this.report.batchReport.maskToIDs(null);
        if (this.csvButton.isSelected()) {
            this.report.batchReport.reportType = 1;
            this.report.batchReport.includeHeaders = this.includeHeaders.isSelected();
            this.report.batchReport.includeTotals = this.includeTotals.isSelected();
        } else if (this.formattedButton.isSelected()) {
            this.report.batchReport.reportType = (byte)2;
        } else if (this.htmlButton.isSelected()) {
            this.report.batchReport.reportType = (byte)6;
        } else if (this.historyButton.isSelected()) {
            this.report.batchReport.reportType = (byte)7;
            if (!this.historyButton.isEnabled()) {
                grr.histType = (byte)-1;
            } else {
                grr.histType = (byte)this.historyTypeBox.getSelectedIndex();
                int selection = this.historyReportBox.getSelectedIndex();
                if (this.histRangeArray == null) {
                    grr.histSubtype = this.histReportArray[selection];
                    grr.chartLabelType = this.histLabelArray[selection];
                } else {
                    int numRanges = this.histRangeArray.length;
                    grr.chartLabelType = this.histLabelArray[selection / numRanges];
                    grr.histSubtype = this.histReportArray[selection / numRanges];
                    grr.histSubtypeRange = this.histRangeArray[selection % numRanges];
                }
                this.report.batchReport.includeHeaders = this.includeHistHeaders.isSelected();
                this.report.batchReport.historyHeader = (String)this.historyReportBox.getSelectedItem();
            }
        } else if (!this.pdfChartButton.isSelected() && this.htmlChartButton.isSelected()) {
            this.report.batchReport.reportType = (byte)9;
            this.getChartStuff(grr, this.htmlChartButton);
        }
    }

    private void getChartStuff(GuiReportReq grr, JRadioButton button) {
        if (!button.isEnabled()) {
            grr.histType = (byte)-1;
        } else {
            int selection = this.chartReportBox.getSelectedIndex();
            boolean isHistoryChart = false;
            if (this.chartReportArray != null && selection < this.chartReportArray.length) {
                grr.chartSubtype = this.chartReportArray[selection];
            } else {
                isHistoryChart = true;
                if (this.chartReportArray != null) {
                    selection -= this.chartReportArray.length;
                }
                if (this.histRangeArray == null) {
                    grr.histSubtype = this.histReportArray[selection];
                    grr.chartLabelType = this.histLabelArray[selection];
                } else {
                    int numRanges = this.histRangeArray.length;
                    grr.histSubtype = this.histReportArray[selection / numRanges];
                    grr.histSubtypeRange = this.histRangeArray[selection % numRanges];
                    grr.chartLabelType = this.histLabelArray[selection / numRanges];
                }
            }
        }
        this.report.batchReport.historyHeader = (String)this.chartReportBox.getSelectedItem();
    }

    public void validateData(boolean reportHasChanged) throws GeneralException {
        if (this.report.computerID < 1) {
            throw new GeneralException(MessageLog.getMessageNoTS("STG5158E"));
        }
        if (this.runScript.isSelected() && Util.isEmpty(this.report.batchReport.scriptName)) {
            throw new GeneralException(MessageLog.getMessageNoTS("STG3253E"));
        }
        if (this.report.batchReport.grr.histType == -1) {
            throw new GeneralException(MessageLog.getMessageNoTS("STG5261L"));
        }
        if (reportHasChanged && (this.report.batchReport.reportType == 7 || this.report.batchReport.reportType == 8 || this.report.batchReport.reportType == 9)) {
            throw new GeneralException(MessageLog.getMessageNoTS("STG5261L"));
        }
        String mask = null;
        if (this.report.batchReport.fileMask != null) {
            mask = this.report.batchReport.maskToText(null, null);
        }
        this.fileMaskEditor.validateData(mask);
    }

    public void replace(Report report) {
        this.report = report;
    }

    public void itemStateChanged(ItemEvent event) {
        boolean selected = event.getStateChange() == 1;
        GuiReportReq grr = this.report.batchReport.grr;
        if (event.getSource() == this.runScript) {
            this.scriptLabel.setEnabled(selected);
            this.scriptName.setEnabled(selected);
            this.resetAgents(selected);
        } else if (event.getSource() == this.csvButton) {
            this.includeHeaders.setEnabled(selected);
            this.includeTotals.setEnabled(selected);
            this.resetAgents(selected);
        } else if (event.getSource() == this.historyButton) {
            this.includeHistHeaders.setEnabled(selected);
            this.historyReportBox.setEnabled(selected);
            this.historyTypeBox.setEnabled(selected);
            this.resetAgents(selected);
        } else {
            this.chartReportBox.setEnabled(selected);
            this.chartCustButton.setEnabled(selected);
            if (selected && !this.computersAre21) {
                this.resetAgent = (NameList)this.computerBox.getSelectedItem();
                if (this.resetAgent.nlID > 0 && this.resetAgent.nlID2 < SoftwareVersion.VERSION_2_1_0) {
                    String msg = MessageLog.getMessageNoID("STG5567E", this.resetAgent.nlName);
                    JOptionPane.showMessageDialog(this.guiMain.getFrame(), msg, "STG5567E", 0);
                }
                if (this.resetAgent.nlID < 1) {
                    this.resetAgent = null;
                }
                this.report.batchReport.reportType = (byte)8;
                this.getAgents();
            }
        }
    }

    private void resetAgents(boolean selected) {
        if (selected && this.computersAre21) {
            this.resetAgent = (NameList)this.computerBox.getSelectedItem();
            if (this.resetAgent.nlID < 1) {
                this.resetAgent = null;
            }
            this.report.batchReport.reportType = 0;
            this.getAgents();
        }
    }

    public void disableHistory() {
        this.historyButton.setEnabled(false);
        this.includeHistHeaders.setEnabled(false);
        this.historyReportBox.setEnabled(false);
        this.historyTypeBox.setEnabled(false);
        this.historyReportBox.removeAllItems();
        this.pdfChartButton.setEnabled(false);
        this.htmlChartButton.setEnabled(false);
        this.chartReportBox.setEnabled(false);
        this.chartCustButton.setEnabled(false);
        this.chartReportBox.removeAllItems();
    }

    public void replaceHistoryArrays(String[] messageArray, byte[] labelArray, byte[] byteArray, String[] rangeMsgArray, byte[] rangeByteArray, boolean setBoxIndex, String[] chartMsgArray, byte[] chartNumberArray) {
        int index;
        int j;
        int i;
        int i2;
        this.histLabelArray = labelArray;
        this.histReportArray = byteArray;
        this.histRangeArray = rangeByteArray;
        this.chartReportArray = chartNumberArray;
        GuiReportReq grr = this.report.batchReport.grr;
        byte reportType = this.report.batchReport.reportType;
        this.disableHistory();
        if (messageArray != null) {
            if (rangeByteArray == null) {
                for (i2 = 0; i2 < messageArray.length; ++i2) {
                    this.historyReportBox.addItem(messageArray[i2]);
                }
            } else {
                for (i = 0; i < messageArray.length; ++i) {
                    for (j = 0; j < rangeMsgArray.length; ++j) {
                        String message = messageArray[i].endsWith("%") ? messageArray[i] + "  " + rangeMsgArray[j] : messageArray[i] + " " + rangeMsgArray[j];
                        this.historyReportBox.addItem(message);
                    }
                }
            }
            this.historyButton.setEnabled(true);
            index = 0;
            int type = 0;
            boolean thisReport = false;
            if (this.fieldsSet) {
                if (this.historyButton.isSelected()) {
                    thisReport = true;
                }
            } else if (reportType == 7) {
                thisReport = true;
            }
            if (thisReport) {
                this.includeHistHeaders.setEnabled(true);
                this.historyReportBox.setEnabled(true);
                this.historyTypeBox.setEnabled(true);
                if (setBoxIndex) {
                    for (int n = 0; n < byteArray.length; ++n) {
                        if (byteArray[n] != grr.histSubtype) continue;
                        index = n;
                        break;
                    }
                    if (rangeByteArray != null) {
                        index *= rangeByteArray.length;
                        for (int r = 0; r < rangeByteArray.length; ++r) {
                            if (rangeByteArray[r] != grr.histSubtypeRange) continue;
                            index += r;
                            break;
                        }
                    }
                    type = grr.histType;
                }
            }
            this.historyReportBox.setSelectedIndex(index);
            this.historyTypeBox.setSelectedIndex(type);
        }
        if (messageArray != null || chartMsgArray != null) {
            if (chartMsgArray != null) {
                for (i2 = 0; i2 < chartMsgArray.length; ++i2) {
                    this.chartReportBox.addItem(chartMsgArray[i2]);
                }
            }
            if (messageArray != null) {
                if (rangeByteArray == null) {
                    for (i2 = 0; i2 < messageArray.length; ++i2) {
                        this.chartReportBox.addItem(messageArray[i2]);
                    }
                } else {
                    for (i = 0; i < messageArray.length; ++i) {
                        for (j = 0; j < rangeMsgArray.length; ++j) {
                            String message = messageArray[i].endsWith("%") ? messageArray[i] + "  " + rangeMsgArray[j] : messageArray[i] + " " + rangeMsgArray[j];
                            this.chartReportBox.addItem(message);
                        }
                    }
                }
            }
            this.htmlChartButton.setEnabled(true);
            index = 0;
            boolean thisReport = false;
            if (this.fieldsSet) {
                if (this.htmlChartButton.isSelected()) {
                    thisReport = true;
                }
            } else if (reportType == 8 || reportType == 9) {
                thisReport = true;
            }
            if (thisReport) {
                this.chartReportBox.setEnabled(true);
                this.chartCustButton.setEnabled(true);
                if (setBoxIndex) {
                    int n;
                    if (grr.chartSubtype > 0) {
                        for (n = 0; n < chartNumberArray.length; ++n) {
                            if (chartNumberArray[n] != grr.chartSubtype) continue;
                            index = n;
                            break;
                        }
                    } else {
                        for (n = 0; n < byteArray.length; ++n) {
                            if (byteArray[n] != grr.histSubtype) continue;
                            index = n;
                            break;
                        }
                        if (rangeByteArray != null) {
                            index *= rangeByteArray.length;
                            for (int r = 0; r < rangeByteArray.length; ++r) {
                                if (rangeByteArray[r] != grr.histSubtypeRange) continue;
                                index += r;
                                break;
                            }
                        }
                        if (chartMsgArray != null) {
                            index += chartMsgArray.length;
                        }
                    }
                }
            }
            this.chartReportBox.setSelectedIndex(index);
        }
    }

    public void storeChartSaveRequest(Request r) {
        this.report.batchReport.saveChartSettingsReq = r;
    }

    public void setCustomOptions(ChartOptions customOptions) {
    }

    public void saveCustomOptions(ChartOptions customOptions) {
        ((GuiChartSettingsReq)this.report.batchReport.saveChartSettingsReq.requestData).options = (ChartOptions)customOptions.clone();
    }
}

