/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.ReportingFSGroupSelector;
import org.eclipse.aperi.TStorm.gui.ReportingGroupResourceData;
import org.eclipse.aperi.TStorm.gui.ShowResource;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.FilterPanel;
import org.eclipse.aperi.gui.FilterResultsViewer;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingFSGroupCreateOrEdit
implements CreateOrEdit,
GuiRequestor,
ActionListener {
    private CreateHeaderPanel createHeaderPanel;
    private CreateOrEditDDI DDI;
    private ReportingFSGroupSelector fsSelector;
    private Vector filterVec;
    private GridBagPanel filterPanel;
    private JButton selectResourcesButton;
    private JButton showAllButton;
    private boolean showAllRequest = false;

    public ReportingFSGroupCreateOrEdit(CreateOrEditDDI pDDI) {
        this.DDI = pDDI;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
    }

    public CreateHeader getData() {
        GroupDefinition def = (GroupDefinition)this.createHeaderPanel.getData();
        TreeSelector pSelector = (TreeSelector)this.fsSelector.getComponent();
        def.members = pSelector.getNameList();
        def.maskList = null;
        if (!this.filterVec.isEmpty()) {
            int type;
            int sz = this.filterVec.size();
            switch (this.DDI.nlInfo) {
                case 89: {
                    type = 95;
                    break;
                }
                case 90: {
                    type = 96;
                    break;
                }
                default: {
                    throw new RuntimeException("Uknown Filter Type");
                }
            }
            NameList finalMaskList = null;
            for (int i = 0; i < sz; ++i) {
                NameList nameList = new NameList();
                nameList.nlName = this.filterVec.get(i).toString();
                nameList.nlInfo = (short)type;
                nameList.nlNext = finalMaskList;
                finalMaskList = nameList;
            }
            def.maskList = finalMaskList;
        }
        return def;
    }

    public void validate(CreateHeader header) throws GeneralException {
        GroupDefinition def = (GroupDefinition)header;
        if (def.members == null && def.maskList == null) {
            String s = MessageLog.getMessageNoTS("STG3156E", null);
            throw new GeneralException(s);
        }
    }

    private void create(GroupDefinition def) {
        this.createHeaderPanel = new CreateHeaderPanel(def, this, this.DDI);
        NameList[] initiallySelected = new NameList[]{def.members};
        NameList nameList = def.members;
        String[] strings = new String[5];
        strings[1] = "STG4029L";
        strings[4] = "STG4030L";
        NameList filesystemGroups = null;
        NameList filesystems = null;
        NameList reportingGroups = null;
        NameList filesystemGroupElement = null;
        NameList filesystemElement = null;
        NameList reportingGroupElement = null;
        switch (this.DDI.nlInfo) {
            case 90: {
                while (nameList != null) {
                    if (nameList.nlInfo == 2) {
                        filesystemGroupElement = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlID2, nameList.nlInfo);
                        filesystemGroupElement.nlNext = filesystemGroups;
                        filesystemGroups = filesystemGroupElement;
                    } else if (nameList.nlInfo == 3) {
                        filesystemElement = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlID2, nameList.nlInfo);
                        filesystemElement.nlNext = filesystems;
                        filesystems = filesystemElement;
                    } else if (nameList.nlInfo == 90) {
                        reportingGroupElement = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlID2, nameList.nlInfo);
                        reportingGroupElement.nlNext = reportingGroups;
                        reportingGroups = reportingGroupElement;
                    }
                    nameList = nameList.nlNext;
                }
                NameList[] array = new NameList[5];
                array[2] = filesystemGroups;
                array[3] = filesystems;
                array[4] = reportingGroups;
                this.fsSelector = new ReportingFSGroupSelector(array, this.DDI.ID, false, false);
            }
        }
        this.filterVec = new Vector();
        NameList maskList = def.maskList;
        while (maskList != null) {
            this.filterVec.add(maskList.nlName);
            maskList = maskList.nlNext;
        }
        GridBagPanel container = new GridBagPanel(new Insets(0, 0, 0, 0));
        this.filterPanel = new FilterPanel(this.filterVec, new Insets(0, 0, 0, 0), this.DDI.nlInfo);
        container.add((JComponent)this.filterPanel, 1, new Insets(0, 4, 0, 4));
        container.newRow();
        container.add((JComponent)this.fsSelector.getComponent(), 25, 1);
        GridBagPanel buttonPanel = new GridBagPanel();
        this.selectResourcesButton = new JButton(Util.getString("LABEL_SELECT_RESOURCES"));
        this.selectResourcesButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_SELECT_RESOURCES"));
        this.selectResourcesButton.addActionListener(this);
        this.showAllButton = new JButton(Util.getString("LABEL_SHOW_ALL_RESOURCES"));
        this.showAllButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_SHOW_ALL_RESOURCES"));
        this.showAllButton.addActionListener(this);
        buttonPanel.add((JComponent)this.selectResourcesButton, 21, new Insets(0, 4, 0, 4));
        buttonPanel.add((JComponent)new JPanel(), 10, new Insets(0, 125, 0, 55));
        buttonPanel.add((JComponent)this.showAllButton, 22, new Insets(0, 4, 0, 4));
        container.newRow();
        container.add((JComponent)buttonPanel, 21);
        this.createHeaderPanel.add(container);
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.createHeaderPanel.gettingFocus();
    }

    public void replace(CreateHeader newHeader) {
        this.createHeaderPanel.replace(newHeader);
        NameList dummy = new NameList();
        dummy.nlInfo = this.DDI.nlInfo;
        ChangeManager.signalChange(100, dummy);
        this.fsSelector.hideSavedID(newHeader.ID);
    }

    private void submitRetrieve(int ID2) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
        request.userName = GuiUtil.getUserName();
        GroupDefinition def = new GroupDefinition();
        def.ID = ID2;
        def.groupType = this.DDI.nlInfo;
        def.members = null;
        request.requestData = def;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        GroupDefinition def = new GroupDefinition();
        def.groupType = this.DDI.nlInfo;
        this.create(def);
        this.DDI.oldCreateHeader = (CreateHeader)def.clone();
    }

    public void build(int ID2) {
        if (ID2 > 0) {
            this.submitRetrieve(ID2);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        this.create((GroupDefinition)createHeader);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int tabIndex) {
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        if (!this.showAllRequest) {
            GroupDefinition def = (GroupDefinition)response.responseData;
            this.DDI.oldCreateHeader = (CreateHeader)def.clone();
            this.create(def);
        } else {
            NameList res = (NameList)response.responseData;
            this.showAllRequest = false;
            this.showDialog(res);
        }
    }

    public String getHelpID(int tab) {
        return "repgrp10";
    }

    private NameList newNameList(String name, int id, int id2, int type) {
        NameList nameList = new NameList();
        nameList.nlName = name;
        nameList.nlID = id;
        nameList.nlID2 = id2;
        nameList.nlInfo = (short)type;
        return nameList;
    }

    public void actionPerformed(ActionEvent ae) {
        Object action = ae.getSource();
        if (action == this.selectResourcesButton) {
            FilterResultsViewer frv = new FilterResultsViewer(guiMain.getFrame(), FilterResultsViewer.PICK, this, 0, null, this.DDI.nlInfo, Util.getString("TITLE_SELECT_RESOURCES"));
            GuiUtil.centerDialog(frv);
            frv.displayDialog();
        } else {
            this.sendShowAllRequest();
        }
    }

    private NameList getNameList() {
        GroupDefinition def = (GroupDefinition)this.createHeaderPanel.getData();
        TreeSelector pSelector = (TreeSelector)this.fsSelector.getComponent();
        def.members = pSelector.getNameList();
        if (!this.filterVec.isEmpty()) {
            int sz = this.filterVec.size();
            int type = 0;
            switch (this.DDI.nlInfo) {
                case 90: {
                    type = 96;
                }
            }
            Object finalMaskList = null;
            for (int i = 0; i < sz; ++i) {
                NameList nameList = new NameList();
                nameList.nlName = this.filterVec.get(i).toString();
                nameList.nlInfo = (short)type;
                nameList.nlNext = def.members;
                def.members = nameList;
            }
        }
        return def.members;
    }

    private void sendShowAllRequest() {
        GuiListReq requestData = new GuiListReq();
        requestData.listRequested = 11;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", requestData);
        request.flags = (byte)4;
        requestData.qualifierObject = this.getNameList();
        if (requestData.qualifierObject != null) {
            this.showAllRequest = true;
            GuiClient.doRequest(this, request);
        } else {
            JOptionPane.showMessageDialog(guiMain.getFrame(), Util.getString("LABEL_ALL_RESOURCES_EMPTY"), "GUI1621I", 1);
        }
    }

    private void showDialog(NameList nameList) {
        if (nameList == null) {
            return;
        }
        Vector<ReportingGroupResourceData> v = new Vector<ReportingGroupResourceData>();
        while (nameList != null) {
            GComputer computer = GuiUtil.getComputer(nameList.nlID2);
            ReportingGroupResourceData data = new ReportingGroupResourceData();
            data.setComputerName(computer.gcTSName);
            data.setOsType(computer.gcOsType);
            data.setFsName(nameList.nlName);
            v.addElement(data);
            nameList = nameList.nlNext;
        }
        Vector<String> titleVect = new Vector<String>();
        titleVect.add(Util.getString("STG1216T"));
        titleVect.add(Util.getString("STG1102L"));
        ShowResource list = new ShowResource(v, titleVect, 3);
    }

    public void addSelectedResources(NameList[] resources) {
        JTree sourceTree = this.fsSelector.getSourceTree();
        sourceTree.expandRow(2);
        sourceTree.clearSelection();
        TreeSelector selector = this.fsSelector.getTreeSelector();
        while (!this.fsSelector.getResourcesAvailable()) {
            System.out.println("Waiting for computer resources");
        }
        TreeSelectionModel tmod = sourceTree.getSelectionModel();
        TreeSelectorNode root = (TreeSelectorNode)sourceTree.getModel().getRoot();
        TreeSelectorNode compNode = (TreeSelectorNode)root.getChildAt(2);
        for (int i = 0; i < resources.length; ++i) {
            System.out.println("Selected resources are:  " + resources[i].toString());
            int resId = resources[i].nlID2;
            for (int j = 0; j < compNode.getChildCount(); ++j) {
                TreeSelectorNode comp = (TreeSelectorNode)compNode.getChildAt(j);
                int compId = ((NameList)comp.getUserObject()).nlID;
                if (compId != resId) continue;
                for (int k = 0; k < comp.getChildCount(); ++k) {
                    TreeSelectorNode fs = (TreeSelectorNode)comp.getChildAt(k);
                    if (((NameList)fs.getUserObject()).nlID != resources[i].nlID) continue;
                    TreePath newTP = new TreePath(fs.getPath());
                    sourceTree.addSelectionPath(newTP);
                }
            }
        }
        if (sourceTree.getSelectionPaths() != null) {
            selector.processSelections(sourceTree, this.fsSelector.getSelectedTree());
        }
        selector.disableAddButton();
        sourceTree.setSelectionRow(0);
        sourceTree.requestFocus();
    }
}

