/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Enumeration;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingFSGroupSelector
implements TreeExpansionListener,
GuiRequestor,
TreeSelector.Reparenter {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList[] selections;
    private NameList rootName;
    private TreeSelectorNode sourceFSGroupLabel;
    private TreeSelectorNode sourceCompGroupLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    private boolean expandedComputer;
    private TreeSet fsSet = new TreeSet();
    private TreeSet excludeSet = new TreeSet();
    private JTree expansionTree;
    private boolean compsOnly;
    private String allObjectsLabel;
    public boolean allFSSelected;
    private boolean resourcesAvailable;
    private static final int ROOT_ID = -4;
    private static final int REPORTING_GROUP_ID = -2;
    private static final int FS_GROUP_ID = -3;
    private static final int FS_ID = -1;
    private static final int ALL_FS_ID = Integer.MAX_VALUE;
    private static final int N_INDICES = 4;
    private int excludeMe;
    private int returnedObjectType;
    private int parentId;
    private NameList computer;
    private boolean disbledFSObjects;
    private boolean initialLoad;
    private int savedID;
    private boolean showLeafFS = false;

    public ReportingFSGroupSelector() {
    }

    public ReportingFSGroupSelector(NameList[] pSelections, int ID2, boolean pAllFSSelected, boolean pCompsOnly) {
        this.selections = pSelections;
        this.excludeMe = ID2;
        this.allFSSelected = pAllFSSelected;
        this.compsOnly = pCompsOnly;
        this.initialLoad = true;
    }

    public ReportingFSGroupSelector(NameList[] pSelections, int ID2, boolean pAllFSSelected) {
        this(pSelections, ID2, pAllFSSelected, false);
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree, this);
        return this.selector;
    }

    public NameList[] getData() {
        this.allFSSelected = false;
        NameList[] listHead = new NameList[4];
        NameList[] listTail = new NameList[4];
        short index = 0;
        NameList selectedList = this.selector.getNameList();
        while (selectedList != null) {
            index = selectedList.nlInfo;
            if (index > 3) {
                if (index == 13) {
                    this.allFSSelected = true;
                }
                selectedList = selectedList.nlNext;
                continue;
            }
            NameList element = selectedList;
            selectedList = element.nlNext;
            element.nlNext = null;
            if (listTail[index] == null) {
                listHead[index] = element;
            } else {
                listTail[index].nlNext = element;
            }
            listTail[index] = element;
        }
        return listHead;
    }

    private void buildSourceTree() {
        TreeSelectorNode root = this.newRoot();
        if (!this.compsOnly) {
            this.sourceFSGroupLabel = this.addFSGroupLabel(root);
            this.addReportingGroupLabel(root);
            this.addFSLabel(root);
        }
        this.sourceTree = new JTree(root, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode groupLabel = null;
        TreeSelectorNode fsLabel = null;
        Object excludeLabel = null;
        TreeSelectorNode reportingGroupLabel = null;
        Object excludedComputers = null;
        Object tail = null;
        TreeSelectorNode root = this.newRoot();
        NameList name = this.selections[2];
        while (name != null) {
            if (groupLabel == null) {
                groupLabel = this.addFSGroupLabel(root);
            }
            groupLabel.add(new TreeSelectorNode(name, true, false, true, true, null));
            name = name.nlNext;
        }
        name = this.selections[4];
        while (name != null) {
            if (reportingGroupLabel == null) {
                reportingGroupLabel = this.addReportingGroupLabel(root);
            }
            reportingGroupLabel.add(new TreeSelectorNode(name, true, false, true, true, null, true, true));
            name = name.nlNext;
        }
        this.fillSets(this.selections[3], true, false);
        if (this.allFSSelected && !this.compsOnly || !this.fsSet.isEmpty()) {
            fsLabel = this.addFSLabel(root);
            this.addTreeSet(fsLabel, this.fsSet);
        }
        this.fillSetsForReporting(this.selections[4], true, false);
        return root;
    }

    private void buildSelectedTree() {
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(root, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList[] pSelections, boolean pAllFSSelected) {
        this.selections = pSelections;
        this.allFSSelected = pAllFSSelected;
        this.fsSet.clear();
        this.excludeSet.clear();
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        DefaultTreeModel model = (DefaultTreeModel)this.selectedTree.getModel();
        model.setRoot(root);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList fsList, boolean fsSelectable, boolean fsExcludeable) {
        int lastFSComputerID = -1;
        int lastExcludeComputerID = -1;
        DefaultMutableTreeNode fsComputer = null;
        DefaultMutableTreeNode excludedComputer = null;
        DefaultMutableTreeNode computer = null;
        while (fsList != null) {
            boolean excludeable;
            boolean selectable;
            TreeSet set;
            int lastComputerID;
            if ((fsList.nlState & 1) != 0) {
                lastComputerID = lastExcludeComputerID;
                set = this.excludeSet;
                selectable = false;
                excludeable = true;
                computer = excludedComputer;
            } else {
                lastComputerID = lastFSComputerID;
                set = this.fsSet;
                selectable = fsSelectable;
                excludeable = fsExcludeable;
                computer = fsComputer;
            }
            if (fsList.nlID2 != lastComputerID) {
                GComputer gc = GuiUtil.getComputer(fsList.nlID2);
                short id2 = 1;
                if (Constants.isVirtualServer(gc.gcOsType)) {
                    id2 = gc.gcOsType;
                }
                NameList n = this.newNameList(gc.gcTSName, fsList.nlID2, id2, 1, gc.gcClusterName, gc.gcHostedNodeName, gc.gcClusterID);
                computer = new TreeSelectorNode(n, false, false, true, false, null, true, true);
                ((TreeSelectorNode)computer).setButtonFlag(false);
                set.add(computer);
                if ((fsList.nlState & 1) != 0) {
                    lastExcludeComputerID = fsList.nlID2;
                    excludedComputer = computer;
                } else {
                    lastFSComputerID = fsList.nlID2;
                    fsComputer = computer;
                }
            }
            TreeSelectorNode fs = new TreeSelectorNode(fsList, fsSelectable, false, false, false, null, true, true);
            if (this.disbledFSObjects) {
                fs.setButtonFlag(false);
            }
            if (this.initialLoad) {
                fs.setButtonFlag(true);
            }
            computer.add(fs);
            fsList = fsList.nlNext;
        }
    }

    private void fillSetsForReporting(NameList memberList, boolean memberSelectable, boolean memberExcludeable) {
        TreeSelectorNode member = null;
        while (memberList != null) {
            boolean excludeable;
            boolean selectable;
            TreeSet set;
            if ((memberList.nlState & 1) != 0) {
                set = this.excludeSet;
                selectable = false;
                excludeable = true;
            } else {
                set = this.fsSet;
                selectable = memberSelectable;
                excludeable = memberExcludeable;
            }
            member = new TreeSelectorNode(memberList, selectable, excludeable, false, false, null, true, true);
            set.add(member);
            memberList = memberList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode parent, TreeSet set) {
        for (TreeSelectorNode child : set) {
            parent.add(child);
        }
    }

    public static void invalidateGroups(TreeSelector selector, JTree selectedTree, short groupType) {
        DefaultTreeModel model = (DefaultTreeModel)selectedTree.getModel();
        TreeSelectorNode node = (TreeSelectorNode)model.getRoot();
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        boolean going = true;
        while (going && e.hasMoreElements()) {
            node = (TreeSelectorNode)e.nextElement();
            int level = node.getLevel();
            if (level != 2) {
                if (level <= 2) continue;
                going = false;
                continue;
            }
            NameList object = node.getNameList();
            if (object.nlInfo != groupType) continue;
            selector.nodeUnselected(node);
            MutableTreeNode parent = (MutableTreeNode)node.getParent();
            int index = parent.getIndex(node);
            model.removeNodeFromParent(node);
            node = new TreeSelectorNode(object, true, false, true, true, null, true, true);
            model.insertNodeInto(node, parent, index);
        }
    }

    public void invalidateGroups(short groupType) {
        ReportingFSGroupSelector.invalidateGroups(this.selector, this.selectedTree, groupType);
    }

    private void addGroup(TreeSelectorNode groupLabel, NameList name) {
        if (!groupLabel.childrenFetched) {
            return;
        }
        NameList toAdd = (NameList)name.clone();
        TreeSelectorNode newNode = new TreeSelectorNode(toAdd, true, false, true, true, null, true, true);
        DefaultTreeModel model = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(model, groupLabel, newNode);
    }

    public void addFSGroup(NameList name) {
        this.addGroup(this.sourceFSGroupLabel, name);
    }

    public void addComputerGroup(NameList name) {
        this.addGroup(this.sourceCompGroupLabel, name);
    }

    public void treeExpanded(TreeExpansionEvent e) {
        this.initialLoad = false;
        TreePath path = e.getPath();
        this.expansionNode = (TreeSelectorNode)path.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList name = this.expansionNode.getNameList();
        this.expansionTree = (JTree)e.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        int type = -1;
        int groupID = -1;
        int computerID = -1;
        this.expandedComputer = false;
        if (this.expansionTree == this.sourceTree) {
            switch (name.nlID) {
                case -3: {
                    this.showLeafFS = false;
                    type = 2;
                    break;
                }
                case -1: {
                    this.showLeafFS = true;
                    type = 3;
                    this.disbledFSObjects = false;
                    break;
                }
                case -2: {
                    this.showLeafFS = false;
                    type = 90;
                    break;
                }
                default: {
                    if (name.nlInfo == 90) {
                        type = 90;
                        this.returnedObjectType = 1;
                        break;
                    }
                    if (name.nlInfo == 1 && name.nlID2 != 0) {
                        boolean temmp = name.nlInfo == 1 && name.nlID2 != 0;
                        type = 1;
                        this.returnedObjectType = 2;
                        this.computer = this.newNameList(name.nlName, name.nlID, 0, name.nlID2, name.nlClusterName, name.nlHostName, name.nlClusterID);
                        break;
                    }
                    if (name.nlInfo == 2 || name.nlInfo == 0) {
                        this.disbledFSObjects = true;
                        type = name.nlInfo + 1;
                        groupID = name.nlID;
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (name.nlInfo == 2 || name.nlInfo == 0) {
            this.disbledFSObjects = true;
            type = name.nlInfo + 1;
            groupID = name.nlID;
        } else if (name.nlInfo == 1 && this.expansionNode.selectable) {
            type = 3;
            computerID = name.nlID;
            this.expandedComputer = true;
        } else if (name.nlInfo == 90) {
            type = 90;
            this.returnedObjectType = 1;
        } else if (name.nlInfo == 1 && name.nlID2 != 0) {
            type = 1;
            this.returnedObjectType = 2;
            this.computer = this.newNameList(name.nlName, name.nlID, 0, name.nlID2, name.nlClusterName, name.nlHostName, name.nlClusterID);
        } else if (name.nlInfo == 1 && name.nlID2 != 0) {
            type = 98;
            this.returnedObjectType = 1;
        } else if (name.nlInfo == 13) {
            type = this.compsOnly ? 1 : 3;
        }
        if (type >= 0 && this.returnedObjectType == 0) {
            GuiListReq requestData = new GuiListReq();
            requestData.listRequested = 10000 + type;
            requestData.groupID = groupID;
            requestData.computerID = computerID;
            Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", requestData);
            request.flags = (byte)5;
            GuiClient.doRequest(this, request);
        } else if (type == 90 && this.returnedObjectType == 1) {
            this.sendGroupListRequest((short)98, name.nlID);
            this.parentId = name.nlID;
        }
    }

    private GroupDefinition makeGroupListRequestData(short resourceType, int groupID) {
        GroupDefinition requestData = new GroupDefinition();
        requestData.groupType = resourceType;
        requestData.ID = groupID;
        return requestData;
    }

    private void sendGroupListRequest(short resourceType, int groupID) {
        GroupDefinition requestData = this.makeGroupListRequestData(resourceType, groupID);
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", requestData);
        GuiClient.doRequest(this, request);
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        if (this.returnedObjectType == 1 || this.returnedObjectType == 2) {
            this.processGroupList(response);
            this.returnedObjectType = 0;
        } else {
            this.processNameList(response);
        }
    }

    private void processGroupList(Response response) {
        String name;
        if (response.responseData instanceof NameList) {
            this.processNameList(response);
            return;
        }
        Object set = null;
        GroupDefinition names = (GroupDefinition)response.responseData;
        if (names == null) {
            return;
        }
        NameList nameList = names.members;
        NameList maskList = names.maskList;
        if (nameList == null && maskList == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        TreeSelectorNode group = null;
        if (nameList != null) {
            while (nameList != null) {
                NameList n;
                if (nameList.nlInfo == 2) {
                    nameList.nlName = name = Util.getString("STG4227L", Util.getTranslatedName(nameList.nlName));
                    group = new TreeSelectorNode(nameList, false, false, true, false, null);
                    group.setButtonFlag(false);
                } else if (nameList.nlInfo == 3) {
                    n = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlID2, 3, nameList.nlClusterName, nameList.nlHostName, nameList.nlClusterID);
                    group = new TreeSelectorNode(n, false, false, false);
                    group.setButtonFlag(false);
                } else if (nameList.nlInfo == 1) {
                    n = this.newNameList(nameList.nlName, nameList.nlID, this.parentId, 1, nameList.nlClusterName, nameList.nlHostName, nameList.nlClusterID);
                    group = new TreeSelectorNode(n, false, false, true, false, null, true, true);
                    group.setButtonFlag(false);
                } else if (nameList.nlInfo == 90) {
                    nameList.nlName = name = Util.getString("STG4228L", Util.getTranslatedName(nameList.nlName));
                    group = new TreeSelectorNode(nameList, false, false, true, false, null);
                    group.setButtonFlag(false);
                }
                if (group != null) {
                    this.expansionNode.add(group);
                }
                nameList = nameList.nlNext;
            }
        }
        if (maskList != null) {
            while (maskList != null) {
                name = "";
                TreeSelectorNode node = null;
                maskList.nlName = name = Util.getString("STG4229L", Util.getTranslatedName(maskList.nlName));
                node = new TreeSelectorNode(maskList, false, false, false, false, null);
                node.setButtonFlag(false);
                if (node != null) {
                    this.expansionNode.add(node);
                }
                maskList = maskList.nlNext;
            }
        } else {
            boolean select = this.expansionTree == this.sourceTree;
            boolean exclude = !select;
            this.fsSet.clear();
            this.fillSets(nameList, select, exclude);
            this.addTreeSet(this.expansionNode, this.fsSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    public void processNameList(Response response) {
        if (response.responseData instanceof GroupDefinition) {
            this.processGroupList(response);
            return;
        }
        NameList nameList = (NameList)response.responseData;
        if (nameList == null) {
            this.resourcesAvailable = true;
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList.nlInfo == 2) {
            while (nameList != null) {
                TreeSelectorNode group = new TreeSelectorNode(nameList, true, false, true, true, null);
                this.expansionNode.add(group);
                nameList = nameList.nlNext;
            }
        } else if (nameList.nlInfo == 0) {
            while (nameList != null) {
                TreeSelectorNode group = new TreeSelectorNode(nameList, false, false, false, true, null);
                this.expansionNode.add(group);
                nameList = nameList.nlNext;
            }
        } else if (nameList.nlInfo == 90) {
            while (nameList != null) {
                TreeSelectorNode group = null;
                if (nameList.nlID != this.excludeMe && nameList.nlID != this.savedID) {
                    group = new TreeSelectorNode(nameList, true, false, true, true, null, true, true);
                    this.expansionNode.add(group);
                }
                nameList = nameList.nlNext;
            }
        } else {
            boolean excludable;
            boolean selectable = this.expansionTree == this.sourceTree;
            boolean bl = excludable = !selectable;
            if (nameList.nlInfo == 3) {
                if (this.expandedComputer) {
                    while (nameList != null) {
                        TreeSelectorNode node = new TreeSelectorNode(nameList, selectable, excludable, false, false, null, true, true);
                        this.expansionNode.add(node);
                        nameList = nameList.nlNext;
                    }
                } else {
                    this.fsSet.clear();
                    if (this.expansionNode.getUserObject().toString().equals(Util.getString("STG1006L"))) {
                        this.fillSets(nameList, true, excludable);
                    } else {
                        this.fillSets(nameList, false, excludable);
                    }
                    this.addTreeSet(this.expansionNode, this.fsSet);
                }
            } else {
                boolean expandable;
                boolean bl2 = expandable = selectable && nameList.nlInfo == 1;
                while (nameList != null) {
                    TreeSelectorNode node = new TreeSelectorNode(nameList, selectable, excludable, false, expandable, null, true, true);
                    this.expansionNode.add(node);
                    nameList = nameList.nlNext;
                }
            }
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
        this.resourcesAvailable = true;
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -4, -1, 0, null, null, 0);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addReportingGroupLabel(TreeSelectorNode root) {
        return this.addLabelNode("STG4226L", -2, root);
    }

    private TreeSelectorNode addFSGroupLabel(TreeSelectorNode root) {
        return this.addLabelNode("STG4032L", -3, root);
    }

    private TreeSelectorNode makeFSLabel() {
        return this.makeLabelNode("STG1006L", -1);
    }

    private TreeSelectorNode addFSLabel(TreeSelectorNode root) {
        TreeSelectorNode fsLabel = this.makeFSLabel();
        root.add(fsLabel);
        return fsLabel;
    }

    private TreeSelectorNode makeLabelNode(String labelMsgID, int id) {
        String label = MessageLog.getMessageNoID(labelMsgID);
        NameList name = this.newNameList(label, id, 0, -1, null, null, 0);
        TreeSelectorNode labelNode = new TreeSelectorNode(name, false, false, true);
        labelNode.setButtonFlag(false);
        labelNode.setSortKey(id);
        return labelNode;
    }

    private TreeSelectorNode addLabelNode(String labelMsgID, int id, TreeSelectorNode root) {
        TreeSelectorNode labelNode = this.makeLabelNode(labelMsgID, id);
        root.add(labelNode);
        return labelNode;
    }

    private void addAllFSNode(TreeSelectorNode addBelow, boolean expandable) {
        NameList name = this.newNameList(this.allObjectsLabel, Integer.MAX_VALUE, 0, 13, null, null, 0);
        TreeSelectorNode node = new TreeSelectorNode(name, true, false, expandable, true, null);
        node.setSortKey(-1);
        addBelow.insert(node, 0);
    }

    private NameList newNameList(String name, int id, int id2, int type, String clusterName, String clusterHostName, int clusterId) {
        NameList nameList = new NameList();
        nameList.nlName = name;
        nameList.nlID = id;
        nameList.nlID2 = id2;
        nameList.nlInfo = (short)type;
        nameList.nlClusterName = clusterName;
        nameList.nlHostName = clusterHostName;
        nameList.nlClusterID = clusterId;
        return nameList;
    }

    public TreeSelectorNode reparent(TreeSelectorNode excludeRoot, NameList name, MutableInteger levels) {
        TreeSelectorNode result = null;
        Enumeration<TreeNode> e = excludeRoot.children();
        boolean looking = true;
        int index = 0;
        while (looking && e.hasMoreElements()) {
            result = (TreeSelectorNode)e.nextElement();
        }
        if (looking) {
            DefaultTreeModel model = (DefaultTreeModel)this.selectedTree.getModel();
            model.insertNodeInto(result, excludeRoot, index);
        }
        return result;
    }

    public JTree getSourceTree() {
        return this.sourceTree;
    }

    public JTree getSelectedTree() {
        return this.selectedTree;
    }

    public TreeSelector getTreeSelector() {
        return this.selector;
    }

    public boolean getResourcesAvailable() {
        return this.resourcesAvailable;
    }

    public void hideSavedID(int ID2) {
        this.savedID = ID2;
    }
}

