/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.ReportingGroupResourceData;
import org.eclipse.aperi.TStorm.gui.ReportingGroupSelector;
import org.eclipse.aperi.TStorm.gui.ShowResource;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.FilterPanel;
import org.eclipse.aperi.gui.FilterResultsViewer;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingGroupCreateOrEdit
implements CreateOrEdit,
GuiRequestor,
ActionListener {
    private CreateHeaderPanel createHeaderPanel;
    private CreateOrEditDDI DDI;
    private ReportingGroupSelector grpSelector;
    private Vector filterVec;
    private GridBagPanel filterPanel;
    private JButton selectResourcesButton;
    private JButton showAllButton;
    private boolean showAllRequest;

    public ReportingGroupCreateOrEdit(CreateOrEditDDI pDDI) {
        this.DDI = pDDI;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
    }

    public CreateHeader getData() {
        GroupDefinition def = (GroupDefinition)this.createHeaderPanel.getData();
        TreeSelector pSelector = (TreeSelector)this.grpSelector.getComponent();
        def.members = pSelector.getReportingNameList();
        def.members = this.avoidDuplicates(def.members);
        def.maskList = null;
        if (!this.filterVec.isEmpty()) {
            int sz = this.filterVec.size();
            int type = 0;
            switch (this.DDI.nlInfo) {
                case 89: {
                    type = 95;
                }
            }
            NameList finalMaskList = null;
            for (int i = 0; i < sz; ++i) {
                NameList nameList = new NameList();
                nameList.nlName = this.filterVec.get(i).toString();
                nameList.nlInfo = (short)type;
                nameList.nlNext = finalMaskList;
                finalMaskList = nameList;
            }
            def.maskList = finalMaskList;
        }
        return def;
    }

    public void validate(CreateHeader header) throws GeneralException {
        GroupDefinition def = (GroupDefinition)header;
        if (def.members == null && def.maskList == null) {
            String s = MessageLog.getMessageNoTS("STG3156E", null);
            throw new GeneralException(s);
        }
    }

    private void create(GroupDefinition def) {
        this.createHeaderPanel = new CreateHeaderPanel(def, this, this.DDI);
        NameList[] initiallySelected = new NameList[]{def.members};
        NameList nameList = def.members;
        String[] strings = new String[5];
        strings[1] = "STG4029L";
        strings[4] = "STG4030L";
        NameList computerGroups = null;
        NameList groups = null;
        NameList reportingGroups = null;
        NameList computerElement = null;
        NameList groupElement = null;
        NameList reportingGroupElement = null;
        this.filterVec = new Vector();
        switch (this.DDI.nlInfo) {
            case 89: {
                while (nameList != null) {
                    if (nameList.nlInfo == 1) {
                        computerElement = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlInfo);
                        computerElement.nlNext = computerGroups;
                        computerGroups = computerElement;
                    } else if (nameList.nlInfo == 0) {
                        groupElement = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlInfo);
                        groupElement.nlNext = groups;
                        groups = groupElement;
                    } else if (nameList.nlInfo == 89) {
                        reportingGroupElement = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlInfo);
                        reportingGroupElement.nlNext = reportingGroups;
                        reportingGroups = reportingGroupElement;
                    }
                    nameList = nameList.nlNext;
                }
                this.grpSelector = new ReportingGroupSelector(1, computerGroups, groups, reportingGroups, false, false, true, this.DDI.ID);
            }
        }
        nameList = def.maskList;
        while (nameList != null) {
            this.filterVec.add(nameList.nlName);
            nameList = nameList.nlNext;
        }
        GridBagPanel container = new GridBagPanel(new Insets(0, 0, 0, 0));
        this.filterPanel = new FilterPanel(this.filterVec, new Insets(0, 0, 0, 0), this.DDI.nlInfo);
        container.add((JComponent)this.filterPanel, 1, new Insets(0, 4, 0, 4));
        container.newRow();
        container.add((JComponent)this.grpSelector.getComponent(), 25, 1);
        GridBagPanel buttonPanel = new GridBagPanel();
        this.selectResourcesButton = new JButton(Util.getString("LABEL_SELECT_RESOURCES"));
        this.selectResourcesButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_SELECT_RESOURCES"));
        this.selectResourcesButton.addActionListener(this);
        this.showAllButton = new JButton(Util.getString("LABEL_SHOW_ALL_RESOURCES"));
        this.showAllButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_SHOW_ALL_RESOURCES"));
        this.showAllButton.addActionListener(this);
        buttonPanel.add((JComponent)this.selectResourcesButton, 21, new Insets(0, 4, 0, 4));
        buttonPanel.add((JComponent)new JPanel(), 10, new Insets(0, 125, 0, 60));
        buttonPanel.add((JComponent)this.showAllButton, 22, new Insets(0, 4, 0, 4));
        container.newRow();
        container.add((JComponent)buttonPanel, 21);
        this.createHeaderPanel.add(container);
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.createHeaderPanel.gettingFocus();
    }

    public void replace(CreateHeader newHeader) {
        this.createHeaderPanel.replace(newHeader);
        NameList dummy = new NameList();
        dummy.nlInfo = this.DDI.nlInfo;
        ChangeManager.signalChange(100, dummy);
        this.grpSelector.hideSavedID(newHeader.ID);
    }

    private void submitRetrieve(int ID2) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
        request.flags = (byte)5;
        request.userName = GuiUtil.getUserName();
        GroupDefinition def = new GroupDefinition();
        def.ID = ID2;
        def.groupType = this.DDI.nlInfo;
        def.members = null;
        request.requestData = def;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        GroupDefinition def = new GroupDefinition();
        def.groupType = this.DDI.nlInfo;
        this.create(def);
        this.DDI.oldCreateHeader = (CreateHeader)def.clone();
    }

    public void build(int ID2) {
        if (ID2 > 0) {
            this.submitRetrieve(ID2);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        this.create((GroupDefinition)createHeader);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int tabIndex) {
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        if (!this.showAllRequest) {
            GroupDefinition def = (GroupDefinition)response.responseData;
            this.DDI.oldCreateHeader = (CreateHeader)def.clone();
            this.create(def);
        } else {
            NameList res = (NameList)response.responseData;
            this.showAllRequest = false;
            this.showDialog(res);
        }
    }

    private NameList avoidDuplicates(NameList nameList) {
        HashMap<Integer, NameList> map = new HashMap<Integer, NameList>();
        NameList newNameList = null;
        NameList newOne = null;
        NameList nl2 = null;
        while (nameList != null) {
            newOne = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlInfo);
            map.put(new Integer(newOne.nlID), newOne);
            nameList = nameList.nlNext;
        }
        Collection c = map.values();
        for (NameList nl2 : c) {
            newOne = this.newNameList(nl2.nlName, nl2.nlID, nl2.nlInfo);
            newOne.nlNext = newNameList;
            newNameList = newOne;
        }
        return newNameList;
    }

    public String getHelpID(int tab) {
        return "repgrp5";
    }

    private NameList newNameList(String name, int id, int type) {
        NameList nameList = new NameList();
        nameList.nlName = name;
        nameList.nlID = id;
        nameList.nlInfo = (short)type;
        return nameList;
    }

    public void actionPerformed(ActionEvent ae) {
        Object action = ae.getSource();
        if (action == this.selectResourcesButton) {
            FilterResultsViewer frv = new FilterResultsViewer(guiMain.getFrame(), FilterResultsViewer.PICK, this, 0, null, this.DDI.nlInfo, Util.getString("TITLE_SELECT_RESOURCES"));
            GuiUtil.centerDialog(frv);
            frv.displayDialog();
        } else {
            this.sendShowAllRequest();
        }
    }

    private NameList getNameList() {
        GroupDefinition def = (GroupDefinition)this.createHeaderPanel.getData();
        TreeSelector pSelector = (TreeSelector)this.grpSelector.getComponent();
        def.members = pSelector.getReportingNameList();
        if (!this.filterVec.isEmpty()) {
            int sz = this.filterVec.size();
            int type = 0;
            switch (this.DDI.nlInfo) {
                case 89: {
                    type = 95;
                }
            }
            Object finalMaskList = null;
            for (int i = 0; i < sz; ++i) {
                NameList nameList = new NameList();
                nameList.nlName = this.filterVec.get(i).toString();
                nameList.nlInfo = (short)type;
                nameList.nlNext = def.members;
                def.members = nameList;
            }
        }
        return def.members;
    }

    private void sendShowAllRequest() {
        GuiListReq requestData = new GuiListReq();
        requestData.listRequested = 11;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", requestData);
        request.flags = (byte)4;
        requestData.qualifierObject = this.getNameList();
        if (requestData.qualifierObject != null) {
            this.showAllRequest = true;
            GuiClient.doRequest(this, request);
        } else {
            JOptionPane.showMessageDialog(guiMain.getFrame(), Util.getString("LABEL_ALL_RESOURCES_EMPTY"), "GUI1621I", 1);
        }
    }

    private void showDialog(NameList nameList) {
        if (nameList == null) {
            return;
        }
        Vector<ReportingGroupResourceData> v = new Vector<ReportingGroupResourceData>();
        while (nameList != null) {
            ReportingGroupResourceData data = new ReportingGroupResourceData();
            data.setComputerName(nameList.nlName);
            data.setOsType(GuiUtil.getComputer((int)nameList.nlID).gcOsType);
            v.add(data);
            nameList = nameList.nlNext;
        }
        Vector<String> titleVect = new Vector<String>();
        titleVect.add(Util.getString("STG1102L"));
        ShowResource list = new ShowResource(v, titleVect, 1);
    }

    public void addSelectedResources(NameList[] resources) {
        JTree sourceTree = this.grpSelector.getSourceTree();
        sourceTree.expandRow(2);
        sourceTree.clearSelection();
        TreeSelector selector = this.grpSelector.getTreeSelector();
        while (!this.grpSelector.getResourcesAvailable()) {
            System.out.println("Waiting for computer resources");
        }
        TreeSelectionModel tmod = sourceTree.getSelectionModel();
        TreeSelectorNode root = (TreeSelectorNode)sourceTree.getModel().getRoot();
        TreeSelectorNode compNode = (TreeSelectorNode)root.getChildAt(2);
        block1: for (int i = 0; i < resources.length; ++i) {
            System.out.println("Selected resources are:  " + resources[i].toString());
            for (int j = 0; j < compNode.getChildCount(); ++j) {
                TreeSelectorNode comp = (TreeSelectorNode)compNode.getChildAt(j);
                if (((NameList)comp.getUserObject()).nlID != resources[i].nlID) continue;
                TreePath newTP = new TreePath(comp.getPath());
                sourceTree.addSelectionPath(newTP);
                continue block1;
            }
        }
        if (sourceTree.getSelectionPaths() != null) {
            selector.processSelections(sourceTree, this.grpSelector.getSelectedTree());
        }
        selector.disableAddButton();
        sourceTree.setSelectionRow(0);
        sourceTree.requestFocus();
    }
}

