/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingGroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList memberSelections;
    private NameList groupSelections;
    private NameList reportingSelections;
    private NameList rootName;
    private short memberType;
    private short groupType;
    private TreeSet memberSet = new TreeSet();
    private TreeSet excludeSet = new TreeSet();
    private JTree expansionTree;
    private String groupRootLabel;
    private String memberRootLabel;
    private String allMembersLabel;
    private TreeSelectorNode sourceGroupLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    public boolean allMembersSelected;
    private boolean excludeNAS;
    private static final int ROOT_ID = -4;
    private static final int GROUP_ID = -3;
    private static final int REPORTING_GROUP_ID = -2;
    private static final int MEMBER_ID = -1;
    private static final int ALL_MEMBER_ID = Integer.MAX_VALUE;
    private String reportingGroupsLabel;
    private short repGroupType;
    private boolean useReportingGroups;
    private boolean resourcesAvailable;
    private short fsGroupType;
    private boolean isFS = false;
    private static final int FS_ID = -6;
    private static final int FS_GROUP_ID = -7;
    private TreeSelectorNode root;
    private int returnedObjectType;
    private int excludeMe;
    private boolean memType;
    private int savedID;

    public ReportingGroupSelector(short pMemberType, NameList pMemberSelections, NameList pGroupSelections, NameList pReportingSelections, boolean pAllMembersSelected, boolean pExcludeNAS, boolean pUseReportingGroups, int ID2) {
        this.memberType = pMemberType;
        this.memberSelections = pMemberSelections;
        this.groupSelections = pGroupSelections;
        this.reportingSelections = pReportingSelections;
        this.allMembersSelected = pAllMembersSelected;
        this.excludeNAS = pExcludeNAS;
        this.useReportingGroups = pUseReportingGroups;
        this.excludeMe = ID2;
        switch (this.memberType) {
            case 1: {
                this.groupType = 0;
                this.repGroupType = (short)89;
                this.memberRootLabel = "STG4041L";
                this.groupRootLabel = "STG3012L";
                this.allMembersLabel = "STG3100L";
                this.reportingGroupsLabel = "STG4226L";
                break;
            }
            case 78: {
                this.groupType = (short)77;
                this.repGroupType = (short)93;
                this.memberRootLabel = "STG4191L";
                this.groupRootLabel = "STG5500L";
                this.allMembersLabel = "STG5501L";
                this.reportingGroupsLabel = "STG4226L";
                break;
            }
            case 3: {
                this.groupType = (short)2;
                this.repGroupType = (short)90;
                this.memberRootLabel = "STG1006L";
                this.groupRootLabel = "STG4032L";
                this.allMembersLabel = "STG4033L";
                this.reportingGroupsLabel = "STG4226L";
            }
        }
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList prevRepGroup = null;
        NameList prevGroup = null;
        NameList prevMember = null;
        NameList[] returnLists = new NameList[]{null, null, null};
        this.allMembersSelected = false;
        NameList selectedList = this.selector.getNameList();
        while (selectedList != null) {
            NameList cloan = (NameList)selectedList.clone();
            cloan.nlNext = null;
            if (cloan.nlInfo == this.groupType) {
                if (prevGroup == null) {
                    returnLists[1] = cloan;
                } else {
                    prevGroup.nlNext = cloan;
                }
                prevGroup = cloan;
            } else if (cloan.nlInfo == 13) {
                this.allMembersSelected = true;
            } else if (cloan.nlInfo == this.repGroupType) {
                if (prevRepGroup == null) {
                    returnLists[2] = cloan;
                } else {
                    prevRepGroup.nlNext = cloan;
                }
                prevRepGroup = cloan;
            } else {
                if (prevMember == null) {
                    returnLists[0] = cloan;
                } else {
                    prevMember.nlNext = cloan;
                }
                prevMember = cloan;
            }
            selectedList = selectedList.nlNext;
        }
        return returnLists;
    }

    private void buildSourceTree() {
        TreeSelectorNode root = this.newRoot();
        this.sourceGroupLabel = this.addGroupLabel(root);
        if (this.useReportingGroups) {
            this.addReportingGroupLabel(root);
        }
        if (this.isFS) {
            this.addFSLabel(root);
        } else {
            this.addMemberLabel(root);
        }
        this.sourceTree = new JTree(root, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode groupLabel = null;
        TreeSelectorNode memberLabel = null;
        TreeSelectorNode excludeLabel = null;
        TreeSelectorNode reportingGroupLabel = null;
        TreeSelectorNode root = this.newRoot();
        NameList name = this.groupSelections;
        while (name != null) {
            if (groupLabel == null) {
                groupLabel = this.addGroupLabel(root);
            }
            groupLabel.add(new TreeSelectorNode(name, true, false, true, true, null));
            name = name.nlNext;
        }
        name = this.reportingSelections;
        while (name != null) {
            if (reportingGroupLabel == null) {
                reportingGroupLabel = this.addReportingGroupLabel(root);
            }
            reportingGroupLabel.add(new TreeSelectorNode(name, true, false, true, true, null));
            name = name.nlNext;
        }
        this.fillSets(this.memberSelections, true, false);
        if (this.allMembersSelected || !this.memberSet.isEmpty()) {
            memberLabel = this.addMemberLabel(root);
            if (this.allMembersSelected) {
                this.addAllMembersNode(memberLabel, true);
            }
            this.addTreeSet(memberLabel, this.memberSet);
        }
        if (!this.excludeSet.isEmpty()) {
            excludeLabel = TreeSelector.makeExcludeRoot();
            root.add(excludeLabel);
            this.addTreeSet(excludeLabel, this.excludeSet);
        }
        this.fillSetsForReporting(this.reportingSelections, true, false);
        return root;
    }

    private void buildSelectedTree() {
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(root, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList pMemberSelections, NameList pGroupSelections, boolean pAllMembersSelected) {
        this.memberSelections = pMemberSelections;
        this.groupSelections = pGroupSelections;
        this.allMembersSelected = pAllMembersSelected;
        this.memberSet.clear();
        this.excludeSet.clear();
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        DefaultTreeModel model = new DefaultTreeModel(root, true);
        this.selectedTree.setModel(model);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList memberList, boolean memberSelectable, boolean memberExcludeable) {
        TreeSelectorNode member = null;
        while (memberList != null) {
            boolean excludeable;
            boolean selectable;
            TreeSet set;
            if ((memberList.nlState & 1) != 0) {
                set = this.excludeSet;
                selectable = false;
                excludeable = true;
            } else {
                set = this.memberSet;
                selectable = memberSelectable;
                excludeable = memberExcludeable;
            }
            member = new TreeSelectorNode(memberList, selectable, excludeable, false, false, null, true, true);
            set.add(member);
            memberList = memberList.nlNext;
        }
    }

    private void fillSetsForReporting(NameList memberList, boolean memberSelectable, boolean memberExcludeable) {
        TreeSelectorNode member = null;
        while (memberList != null) {
            boolean excludeable;
            boolean selectable;
            TreeSet set;
            if ((memberList.nlState & 1) != 0) {
                set = this.excludeSet;
                selectable = false;
                excludeable = true;
            } else {
                set = this.memberSet;
                selectable = memberSelectable;
                excludeable = memberExcludeable;
            }
            member = new TreeSelectorNode(memberList, selectable, excludeable, false, false, null, true, true);
            set.add(member);
            memberList = memberList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode parent, TreeSet set) {
        for (TreeSelectorNode child : set) {
            parent.add(child);
        }
    }

    public void invalidateGroups(short groupType) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, groupType);
    }

    public void addGroup(NameList name) {
        if (!this.sourceGroupLabel.childrenFetched) {
            return;
        }
        NameList toAdd = (NameList)name.clone();
        TreeSelectorNode newNode = new TreeSelectorNode(toAdd, true, false, true, true, null, true, true);
        DefaultTreeModel model = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(model, this.sourceGroupLabel, newNode);
    }

    public void treeExpanded(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        this.expansionNode = (TreeSelectorNode)path.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList name = this.expansionNode.getNameList();
        this.expansionTree = (JTree)e.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (name.nlID == -3) {
                this.sendRequest(this.groupType, -1);
            } else if (name.nlID == -1) {
                this.sendRequest(this.memberType, -1);
            } else if (name.nlID == -2) {
                this.sendRequest(this.repGroupType, -1);
            } else if (name.nlID == -6) {
                this.sendRequest(this.fsGroupType, -1);
            } else if (name.nlInfo == this.groupType) {
                this.memType = true;
                this.sendRequest(this.memberType, name.nlID);
            } else if (name.nlInfo == 89) {
                this.returnedObjectType = 1;
                this.sendGroupListRequest((short)89, name.nlID);
            } else if (name.nlInfo == 93) {
                this.returnedObjectType = 1;
                this.sendGroupListRequest((short)93, name.nlID);
            }
        } else if (name.nlInfo == 89) {
            this.returnedObjectType = 1;
            this.sendGroupListRequest((short)89, name.nlID);
        } else if (name.nlInfo == this.groupType) {
            this.memType = true;
            this.sendRequest(this.memberType, name.nlID);
        } else if (name.nlInfo == 13) {
            this.sendRequest(this.memberType, -1);
        } else if (name.nlInfo == 89) {
            this.returnedObjectType = 1;
            this.sendGroupListRequest((short)89, name.nlID);
        } else if (name.nlInfo == 93) {
            this.returnedObjectType = 1;
            this.sendGroupListRequest((short)93, name.nlID);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }

    protected GuiListReq makeRequestData(short resourceType, int groupID) {
        GuiListReq requestData = new GuiListReq();
        requestData.listRequested = 10000 + resourceType;
        requestData.groupID = groupID;
        if (this.excludeNAS) {
            requestData.excludeNAS = true;
        }
        if (resourceType == 1) {
            requestData.includeUnmanaged = true;
        }
        return requestData;
    }

    private void sendRequest(short resourceType, int groupID) {
        GuiListReq requestData = this.makeRequestData(resourceType, groupID);
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", requestData);
        GuiClient.doRequest(this, request);
    }

    protected GroupDefinition makeGroupListRequestData(short resourceType, int groupID) {
        GroupDefinition requestData = new GroupDefinition();
        requestData.groupType = resourceType;
        requestData.ID = groupID;
        return requestData;
    }

    private void sendGroupListRequest(short resourceType, int groupID) {
        GroupDefinition requestData = this.makeGroupListRequestData(resourceType, groupID);
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", requestData);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        if (this.returnedObjectType == 1) {
            this.processGroupList(response);
            this.returnedObjectType = 0;
        } else {
            this.processNameList(response);
        }
    }

    private void processGroupList(Response response) {
        GroupDefinition names = (GroupDefinition)response.responseData;
        if (names == null) {
            return;
        }
        NameList nameList = names.members;
        NameList maskList = names.maskList;
        if (nameList == null && maskList == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList != null) {
            TreeSelectorNode group;
            String name;
            if (nameList.nlInfo == this.groupType) {
                while (nameList != null) {
                    if (nameList.nlInfo == 89) {
                        nameList.nlName = name = Util.getString("STG4228L", Util.getTranslatedName(nameList.nlName));
                        group = new TreeSelectorNode(nameList, false, false, true, false, null);
                        group.setButtonFlag(false);
                    } else if (nameList.nlInfo == 0) {
                        nameList.nlName = name = Util.getString("STG4227L", Util.getTranslatedName(nameList.nlName));
                        group = new TreeSelectorNode(nameList, false, false, true, false, null);
                        group.setButtonFlag(false);
                    } else {
                        group = new TreeSelectorNode(nameList, false, false, false, false, null, true, true);
                        group.setButtonFlag(false);
                    }
                    if (group != null) {
                        this.expansionNode.add(group);
                    }
                    nameList = nameList.nlNext;
                }
            } else if (nameList.nlInfo == this.repGroupType) {
                while (nameList != null) {
                    group = null;
                    name = "";
                    boolean isEndResource = false;
                    if (nameList.nlInfo == 89 || nameList.nlInfo == 93) {
                        name = Util.getString("STG4228L", Util.getTranslatedName(nameList.nlName));
                    } else if (nameList.nlInfo == 0 || nameList.nlInfo == 77) {
                        name = Util.getString("STG4227L", Util.getTranslatedName(nameList.nlName));
                    } else {
                        isEndResource = true;
                    }
                    if (!isEndResource) {
                        nameList.nlName = name;
                        group = new TreeSelectorNode(nameList, false, false, true, false, null, true, true);
                        group.setButtonFlag(false);
                    } else {
                        group = new TreeSelectorNode(nameList, false, false, false, false, null);
                        group.setButtonFlag(false);
                    }
                    if (group != null) {
                        this.expansionNode.add(group);
                    }
                    nameList = nameList.nlNext;
                }
            } else if (nameList.nlInfo == 1) {
                while (nameList != null) {
                    group = null;
                    if (nameList.nlInfo == 89) {
                        nameList.nlName = name = Util.getString("STG4228L", Util.getTranslatedName(nameList.nlName));
                        group = new TreeSelectorNode(nameList, false, false, true, false, null);
                        group.setButtonFlag(false);
                    } else if (nameList.nlInfo == 0) {
                        nameList.nlName = name = Util.getString("STG4227L", Util.getTranslatedName(nameList.nlName));
                        group = new TreeSelectorNode(nameList, false, false, true, false, null);
                    } else {
                        group = new TreeSelectorNode(nameList, false, false, false, false, null, true, true);
                        group.setButtonFlag(false);
                    }
                    if (group != null) {
                        this.expansionNode.add(group);
                    }
                    nameList = nameList.nlNext;
                }
            }
        }
        if (maskList != null) {
            while (maskList != null) {
                String name = "";
                TreeSelectorNode group = null;
                maskList.nlName = name = Util.getString("STG4229L", Util.getTranslatedName(maskList.nlName));
                group = new TreeSelectorNode(maskList, false, false, false, false, null);
                group.setButtonFlag(false);
                if (group != null) {
                    this.expansionNode.add(group);
                }
                maskList = maskList.nlNext;
            }
        } else {
            boolean select = this.expansionTree == this.sourceTree;
            boolean exclude = !select;
            this.memberSet.clear();
            this.fillSets(nameList, select, exclude);
            this.addTreeSet(this.expansionNode, this.memberSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private void processNameList(Response response) {
        NameList nameList = (NameList)response.responseData;
        if (nameList == null) {
            this.resourcesAvailable = true;
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList.nlInfo == this.groupType) {
            while (nameList != null) {
                TreeSelectorNode group = new TreeSelectorNode(nameList, true, false, true, true, null);
                if (group != null) {
                    this.expansionNode.add(group);
                }
                nameList = nameList.nlNext;
            }
        } else if (nameList.nlInfo == this.repGroupType) {
            while (nameList != null) {
                TreeSelectorNode group = null;
                boolean isEndResource = false;
                if (nameList.nlInfo != 89 && nameList.nlInfo != 93) {
                    isEndResource = true;
                }
                if (!isEndResource) {
                    if (nameList.nlID != this.excludeMe && nameList.nlID != this.savedID) {
                        group = new TreeSelectorNode(nameList, true, false, true, true, null, true, true);
                    }
                } else {
                    group = new TreeSelectorNode(nameList, true, false, false, false, null, true, true);
                }
                if (group != null) {
                    this.expansionNode.add(group);
                }
                nameList = nameList.nlNext;
            }
        } else if (nameList.nlInfo == 78) {
            while (nameList != null) {
                TreeSelectorNode group;
                if (this.groupType == 77) {
                    group = new TreeSelectorNode(nameList, false, false, true, true, null);
                    group.setButtonFlag(false);
                } else {
                    group = new TreeSelectorNode(nameList, false, false, true, false, null);
                }
                if (group != null) {
                    this.expansionNode.add(group);
                }
                nameList = nameList.nlNext;
            }
        } else if (nameList.nlInfo == 1) {
            while (nameList != null) {
                TreeSelectorNode group;
                if (this.memType) {
                    group = new TreeSelectorNode(nameList, false, false, false, false, null, true, true);
                    group.setButtonFlag(false);
                } else {
                    boolean selectable = false;
                    if (this.repGroupType == 89) {
                        selectable = true;
                    }
                    group = new TreeSelectorNode(nameList, selectable, false, false, false, null, true, true);
                }
                if (group != null) {
                    this.expansionNode.add(group);
                }
                nameList = nameList.nlNext;
            }
            this.memType = false;
        } else {
            boolean select = this.expansionTree == this.sourceTree;
            boolean exclude = !select;
            this.memberSet.clear();
            this.fillSets(nameList, select, exclude);
            this.addTreeSet(this.expansionNode, this.memberSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
        this.resourcesAvailable = true;
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -4, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addGroupLabel(TreeSelectorNode root) {
        return this.addLabelNode(this.groupRootLabel, -3, root);
    }

    private TreeSelectorNode addMemberLabel(TreeSelectorNode root) {
        return this.addLabelNode(this.memberRootLabel, -1, root);
    }

    private TreeSelectorNode addReportingGroupLabel(TreeSelectorNode root) {
        return this.addLabelNode(this.reportingGroupsLabel, -2, root);
    }

    private TreeSelectorNode addFSLabel(TreeSelectorNode root) {
        return this.addLabelNode("STG1006L", -6, root);
    }

    private TreeSelectorNode addFSGroupLabel(TreeSelectorNode root) {
        return this.addLabelNode("STG4032L", -7, root);
    }

    private TreeSelectorNode addLabelNode(String labelMsgID, int id, TreeSelectorNode root) {
        String label = MessageLog.getMessageNoID(labelMsgID);
        NameList name = this.newNameList(label, id, -1);
        TreeSelectorNode labelNode = new TreeSelectorNode(name, false, false, true);
        labelNode.setButtonFlag(false);
        labelNode.setSortKey(id);
        root.add(labelNode);
        return labelNode;
    }

    private void addAllMembersNode(TreeSelectorNode root, boolean expandable) {
        String label = MessageLog.getMessageNoID(this.allMembersLabel);
        NameList name = this.newNameList(label, Integer.MAX_VALUE, 13);
        TreeSelectorNode node = new TreeSelectorNode(name, true, false, expandable, true, null);
        node.setSortKey(-1);
        root.add(node);
    }

    private NameList newNameList(String name, int id, int type) {
        NameList nameList = new NameList();
        nameList.nlName = name;
        nameList.nlID = id;
        nameList.nlInfo = (short)type;
        return nameList;
    }

    public JTree getSourceTree() {
        return this.sourceTree;
    }

    public JTree getSelectedTree() {
        return this.selectedTree;
    }

    public TreeSelector getTreeSelector() {
        return this.selector;
    }

    public boolean getResourcesAvailable() {
        return this.resourcesAvailable;
    }

    public void hideSavedID(int ID2) {
        this.savedID = ID2;
    }
}

