/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.gui.SettingsDDI;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class ResourceSettingsEditor
implements ChangeListener {
    protected SettingsDDI ddi;
    protected JCheckBox[] checkBoxes;
    protected JTextField[] fields;
    protected JLabel[] leadingLabels;
    protected JLabel[] trailingLabels;
    protected short[] values;

    protected abstract void fillSettingsFromValues(Settings var1);

    protected abstract void fillValuesFromSettings(Settings var1);

    protected void pullValuesFromPanel() {
        for (int i = 0; i < this.values.length; ++i) {
            int value;
            if (!this.checkBoxes[i].isSelected()) {
                value = 0;
            } else {
                String text = this.fields[i].getText();
                if (text == null || text.trim().equals("")) {
                    value = -1;
                } else {
                    try {
                        value = Short.parseShort(text);
                    }
                    catch (NumberFormatException e) {
                        value = -2;
                    }
                }
            }
            this.values[i] = value;
        }
    }

    protected void pushValuesOntoPanel() {
        for (int i = 0; i < this.values.length; ++i) {
            short value = this.values[i];
            JCheckBox checkBox = this.checkBoxes[i];
            if (value == 0) {
                checkBox.setSelected(false);
                continue;
            }
            checkBox.setSelected(true);
            String text = value < 0 ? "" : Short.toString(value);
            this.fields[i].setText(text);
        }
    }

    protected void pushSettingsOntoPanel(Settings settings) {
        this.fillValuesFromSettings(settings);
        this.pushValuesOntoPanel();
    }

    public void getData(Settings settings) {
        this.pullValuesFromPanel();
        this.fillSettingsFromValues(settings);
    }

    public void selectField(boolean visible) {
        this.fields[this.ddi.badField].requestFocus();
    }

    public void validate(Settings ignored) throws GeneralException {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == -1) {
                this.ddi.badField = i;
                String s = MessageLog.getMessageNoTS("STG3128E", null);
                throw new GeneralException(s);
            }
            if (this.values[i] != -2) continue;
            this.ddi.badField = i;
            String s = MessageLog.getMessageNoTS("STG7740E", null);
            throw new GeneralException(s);
        }
    }

    public void stateChanged(ChangeEvent event) {
        int index;
        JCheckBox source = (JCheckBox)event.getSource();
        for (index = 0; index < this.checkBoxes.length && this.checkBoxes[index] != source; ++index) {
        }
        boolean enabled = source.isSelected();
        this.leadingLabels[index].setEnabled(enabled);
        this.fields[index].setEnabled(enabled);
    }
}

