/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.SpaceUsedAdjuster;
import org.eclipse.aperi.TStorm.common.SpaceUsedGrapher;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableLongExt;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class SpaceUsedTable
extends JPanel
implements GuiRequestor,
DisplaysChartPopupInterface,
HistoryChoiceInterface {
    private MegaTable table = new MegaTable();
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private RespFSspace[] data;
    private String actionCommand;
    private SpaceUsedAdjuster adjuster;
    private SpaceUsedGrapher grapher;
    SpaceUsedModel spaceUsedModel;
    private TJCTableMouseInterface myMouseListener = new selectListener();

    public SpaceUsedTable(GuiReportReq grr, ReportingDDI ddi) {
        this.grr = grr;
        this.ddi = ddi;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.setLayout(new BorderLayout());
        this.adjuster = new SpaceUsedAdjuster(grr);
        this.grapher = new SpaceUsedGrapher();
    }

    public void handleResponse(short status, Response response) {
        this.data = status <= 4 ? (RespFSspace[])response.responseData : null;
        int cnt = this.data != null ? this.data.length : 0;
        if (cnt == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.data, false);
        this.data = (RespFSspace[])this.adjuster.getArray();
        this.table.setMouseListener(this.myMouseListener);
        this.spaceUsedModel = new SpaceUsedModel();
        this.table.setCellRenderer(MutableLongExt.class, TableCellRenderers.number);
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.table.setCellRenderer(MutableShort.class, TableCellRenderers.percent);
        this.table.setRowIcon(11, this.grr.reportSubtype != 10);
        this.table.iconChanger = this.spaceUsedModel;
        this.table.setBaseTableModel(this.spaceUsedModel);
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setFrozenRows(this.adjuster.frozenRows);
        if (this.grr.selectedColumns == null) {
            switch (this.grr.reportSubtype) {
                case 12: {
                    this.table.setColumnHidden(0, true);
                    break;
                }
                case 14: {
                    this.table.setColumnHidden(0, true);
                    break;
                }
                case 15: {
                    this.table.setColumnHidden(0, true);
                    this.table.setColumnHidden(1, true);
                }
            }
            if (this.grr.reportType == 9) {
                this.table.setAsFirstColumn(3);
            } else if (this.grr.reportType == 10) {
                this.table.setAsFirstColumn(4);
            } else {
                this.table.setAsFirstColumn(5);
            }
        }
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this.myMouseListener;
    }

    public void showJumpChart() {
        ActionEvent event = new ActionEvent(this, 777, "STG1276T");
        ((ActionListener)((Object)this.myMouseListener)).actionPerformed(event);
    }

    public SpaceUsedTable(String a, String b, String c, String d) {
    }

    public Object[] getChoices(int reportType, int reportSubtype) {
        Object[] array = new Object[3];
        String[] messageArray = new String[]{"STG7536L", "STG7530L", "STG7531L", "STG7537L", "STG7538L", "STG7539L"};
        byte[] labelArray = new byte[]{6, 1, 8, 1, 8, 1};
        byte[] reportArray = new byte[]{0, 1, 2, 3, 4, 5};
        array[0] = messageArray;
        array[1] = labelArray;
        array[2] = reportArray;
        return array;
    }

    public Object[] getCharts(int reportType, int reportSubtype) {
        Object[] array = new Object[2];
        String[] messageArray = new String[]{"STG7528L"};
        byte[] reportArray = new byte[]{101};
        array[0] = messageArray;
        array[1] = reportArray;
        return array;
    }

    public int[] getGraphID(String selectedCommand) {
        int[] array = new int[2];
        array[0] = selectedCommand == "STG1251T" ? 101 : (selectedCommand == "STG1276T" ? 102 : (selectedCommand == "STG5104L" ? 0 : (selectedCommand == "STG5105L" ? 1 : (selectedCommand == "STG5106L" ? 2 : (selectedCommand == "STG5107L" ? 3 : (selectedCommand == "STG5108L" ? 4 : 5))))));
        return array;
    }

    public class selectListener
    extends TJCTableMouseAdapter
    implements ActionListener {
        public boolean select(int viewRow, int viewCol) {
            return viewRow >= ((SpaceUsedTable)SpaceUsedTable.this).adjuster.frozenRows;
        }

        public void doubleClick(int dataRow, int dataCol) {
            if (((SpaceUsedTable)SpaceUsedTable.this).grr.reportSubtype != 10) {
                GuiReportReq newGrr = SpaceUsedTable.this.grr.explode(((SpaceUsedTable)SpaceUsedTable.this).data[dataRow].id);
                if (((SpaceUsedTable)SpaceUsedTable.this).grr.reportSubtype == 82) {
                    SpaceUsedTable.this.ddi.addReport(SpaceUsedTable.this.grr, newGrr, SpaceUsedTable.this.data[dataRow].getName());
                } else {
                    SpaceUsedTable.this.ddi.addReport(SpaceUsedTable.this.grr, newGrr, (((SpaceUsedTable)SpaceUsedTable.this).data[dataRow].creator.equals(" ") ? "" : ((SpaceUsedTable)SpaceUsedTable.this).data[dataRow].creator + ".") + SpaceUsedTable.this.data[dataRow].getName());
                }
            }
        }

        public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
            JPopupMenu menu = new JPopupMenu();
            boolean enablePopup = SpaceUsedTable.this.data != null && SpaceUsedTable.this.data.length > 0;
            JMenuItem mi = menu.add(MessageLog.getMessageNoID("STG1251T"));
            mi.setActionCommand("STG1251T");
            mi.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG1276T"));
            mi.setEnabled(enablePopup);
            mi.setActionCommand("STG1276T");
            mi.addActionListener(this);
            menu.addSeparator();
            mi = menu.add(MessageLog.getMessageNoID("STG5104L"));
            mi.setActionCommand("STG5104L");
            mi.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5105L"));
            mi.setActionCommand("STG5105L");
            mi.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5106L"));
            mi.setActionCommand("STG5106L");
            mi.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5107L"));
            mi.setActionCommand("STG5107L");
            mi.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5108L"));
            mi.setActionCommand("STG5108L");
            mi.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5109L"));
            mi.setActionCommand("STG5109L");
            mi.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            mi.addActionListener(this);
            menu.show(c, x, y);
            menu.requestFocus();
        }

        public void showDefaultChart(int dataRow) {
            int[] rows = new int[]{dataRow};
            int[] ix = SpaceUsedTable.this.getGraphID("STG1251T");
            ((SpaceUsedTable)SpaceUsedTable.this).grr.chartSubtype = (byte)ix[0];
            SpaceUsedTable.this.grapher.createChart(SpaceUsedTable.this.grr, SpaceUsedTable.this.data, rows, SpaceUsedTable.this.adjuster, SpaceUsedTable.this.ddi, null);
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows;
            SpaceUsedTable.this.actionCommand = e.getActionCommand();
            if (SpaceUsedTable.this.actionCommand == "STG1276T") {
                rows = new int[SpaceUsedTable.this.data.length];
                for (int i = 0; i < SpaceUsedTable.this.data.length; ++i) {
                    rows[i] = SpaceUsedTable.this.table.getDataRow(i);
                }
            } else {
                rows = SpaceUsedTable.this.table.getSelectedRows();
            }
            if (SpaceUsedTable.this.actionCommand == "STG1276T" || SpaceUsedTable.this.actionCommand == "STG1251T") {
                int[] ix = SpaceUsedTable.this.getGraphID(SpaceUsedTable.this.actionCommand);
                ((SpaceUsedTable)SpaceUsedTable.this).grr.chartSubtype = (byte)ix[0];
                SpaceUsedTable.this.grapher.createChart(SpaceUsedTable.this.grr, SpaceUsedTable.this.data, rows, SpaceUsedTable.this.adjuster, SpaceUsedTable.this.ddi, null);
            } else {
                GuiReportReq newGrr = SpaceUsedTable.this.grapher.createHistory(SpaceUsedTable.this.grr, SpaceUsedTable.this.data, rows, SpaceUsedTable.this.actionCommand);
                SpaceUsedTable.this.ddi.addObject(SpaceUsedTable.this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", newGrr, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(newGrr.historyTitle), SpaceUsedTable.this);
            }
        }
    }

    private class SpaceUsedModel
    extends BaseTableModel
    implements AskForRowIconInterface {
        SpaceUsedModel() {
            this.columnNames = ((SpaceUsedTable)SpaceUsedTable.this).adjuster.colNames;
            this.rowCount = SpaceUsedTable.this.data.length;
            this.commonAdjuster = SpaceUsedTable.this.adjuster;
        }

        public boolean changeIcon(int rowNum) {
            return rowNum < ((SpaceUsedTable)SpaceUsedTable.this).adjuster.frozenRows;
        }

        public Object getTableDataItem(int row, int col) {
            col = SpaceUsedTable.this.adjuster.translateColumn(col);
            return SpaceUsedTable.this.adjuster.getCellData(row, col);
        }
    }
}

