/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.TStorm.common.UnmanagedRptAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;

public class UnmanagedRptTable
extends JPanel
implements GuiRequestor {
    private MegaTable table = new MegaTable();
    private FoundComputer[] data;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private UnmanagedRptAdjuster adjuster;

    public UnmanagedRptTable(GuiReportReq grr, DataDisplayInfo ddi) {
        this.grr = grr;
        this.ddi = (ReportingDDI)ddi;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.adjuster = new UnmanagedRptAdjuster(grr);
    }

    public void handleResponse(short status, Response response) {
        this.setLayout(new BorderLayout());
        this.data = status <= 4 ? (FoundComputer[])response.responseData : null;
        int count = 0;
        if (this.data != null) {
            count = this.data.length;
        }
        if (count == 0) {
            if (this.ddi != null) {
                this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            } else {
                this.add((Component)ReportingDDI.getNoDataMessage(this.grr), "Center");
            }
            return;
        }
        this.adjuster.adjust(this.data, false);
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setCellRenderer(Date.class, TableCellRenderers.date);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setBaseTableModel(new UnmanagedRptTableModel());
        this.add((Component)this.table, "Center");
    }

    private class UnmanagedRptTableModel
    extends BaseTableModel {
        UnmanagedRptTableModel() {
            this.rowCount = UnmanagedRptTable.this.data.length;
            this.columnNames = ((UnmanagedRptTable)UnmanagedRptTable.this).adjuster.colNames;
            this.commonAdjuster = UnmanagedRptTable.this.adjuster;
        }

        public Object getTableDataItem(int row, int col) {
            return UnmanagedRptTable.this.adjuster.getCellData(row, UnmanagedRptTable.this.adjuster.translateColumn(col));
        }
    }
}

