/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import org.eclipse.aperi.San.gui.LUNTreeLabel;
import org.eclipse.aperi.TStorm.gui.DiskTreeLabel;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeTreeLabel;
import org.eclipse.aperi.TStorm.gui.VolumeGroupDDI;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTreeNode;

public class VolumeGroupTreeNode
extends BaseTreeNode {
    public NameList computer;
    public NameList volgroup;

    public VolumeGroupTreeNode(NameList computer, NameList volgroup) {
        super(volgroup);
        this.computer = computer;
        this.volgroup = volgroup;
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() > 0) {
            return;
        }
        if (this.computer.nlID2 != 8) {
            this.add(new DiskTreeLabel(this.computer, -1, this.volgroup.nlID));
        }
        if (this.computer.nlID2 == 21) {
            this.add(this.getLUNNode(this.computer, -1, this.volgroup.nlID));
        } else {
            this.add(this.getLVNode(this.computer, -1, this.volgroup.nlID));
        }
    }

    public void select(TreeSelectionEvent event) {
        new VolumeGroupDDI(this, this.volgroup, this.computer);
    }

    protected BaseTreeNode getLVNode(NameList nl, int compID, int vgID) {
        return new LogicalVolumeTreeLabel(nl, compID, vgID);
    }

    protected BaseTreeNode getLUNNode(NameList nl, int compID, int vgID) {
        return new LUNTreeLabel(nl, compID, vgID);
    }
}

