/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.DateEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.DurationBetweenEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.TimestampWidget;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditorDialog;
import org.eclipse.aperi.TStorm.gui.rptfilter.WidgetListener;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class DateBetweenEditor
implements ValueEditor,
WidgetListener,
ChangeListener {
    private ColumnFilter filter;
    private ValueEditorDialog dialog;
    private TimestampWidget leftWidget;
    private TimestampWidget rightWidget;
    private JComponent panel;
    private JLabel[] labels;

    private Component makeLabeledPanel(Component content, int index, String titleMsgID) {
        int vgap = index < 2 ? 3 : 0;
        BorderLayout layout = new BorderLayout(0, vgap);
        JPanel result = new JPanel(layout);
        String title = MessageLog.getMessageNoID(titleMsgID);
        JLabel label = new JLabel(title);
        Font boldFont = label.getFont().deriveFont(1);
        label.setFont(boldFont);
        label.setForeground(Color.black);
        result.add((Component)label, "North");
        result.add(Box.createHorizontalStrut(15), "West");
        result.add(content, "Center");
        this.labels[index] = label;
        return result;
    }

    private void enableAppropriateLabels() {
        boolean relative = this.leftWidget.scale == 0;
        this.labels[0].setEnabled(!relative);
        this.labels[1].setEnabled(!relative);
        this.labels[2].setEnabled(relative);
        this.labels[3].setEnabled(relative);
    }

    public DateBetweenEditor(ColumnFilter pFilter, ValueEditorDialog pDialog) {
        int lilIndent;
        this.filter = pFilter;
        this.dialog = pDialog;
        ColumnFilterValue first = this.filter.clfValueList;
        ColumnFilterValue second = first != null ? first.fvNext : null;
        this.labels = new JLabel[4];
        this.leftWidget = DateEditor.makeTimestampWidget(this.filter, first, this);
        this.rightWidget = DateEditor.makeTimestampWidget(this.filter, second, this);
        Component topLeft = this.leftWidget.makeAbsolutePanel();
        topLeft = this.makeLabeledPanel(topLeft, 0, "STG3271L");
        Component topRight = this.rightWidget.makeAbsolutePanel();
        topRight = this.makeLabeledPanel(topRight, 1, "STG3272L");
        Component bottomLeft = this.leftWidget.makeRelativePanel();
        bottomLeft = this.makeLabeledPanel(bottomLeft, 2, "STG3271L");
        Component bottomRight = this.rightWidget.makeRelativePanel();
        bottomRight = this.makeLabeledPanel(bottomRight, 3, "STG3272L");
        this.enableAppropriateLabels();
        this.leftWidget.enableAppropriateControls();
        this.rightWidget.enableAppropriateControls();
        for (int i = 0; i < this.rightWidget.buttons.length; ++i) {
            this.leftWidget.buttons[i].removeChangeListener(this.leftWidget);
            this.leftWidget.buttons[i].addChangeListener(this);
        }
        this.rightWidget.buttons = this.leftWidget.buttons;
        this.panel = new JPanel(new GridBagLayout());
        String title = MessageLog.getMessageNoID("STG3063L");
        this.panel.setBorder(GuiUtil.getBorder(title));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        int bigIndent = 25;
        c.insets.left = lilIndent = 5;
        this.panel.add((Component)this.leftWidget.buttons[1], c);
        c.gridwidth = 0;
        this.panel.add(Box.createHorizontalStrut(1), c);
        c.gridwidth = 1;
        c.insets.left = bigIndent;
        c.insets.bottom = 17;
        c.fill = 1;
        this.panel.add(topLeft, c);
        c.gridwidth = 0;
        c.insets.left = lilIndent;
        this.panel.add(topRight, c);
        c.gridwidth = 1;
        c.insets.bottom = 0;
        this.panel.add((Component)this.leftWidget.buttons[0], c);
        c.gridwidth = 0;
        this.panel.add(Box.createHorizontalStrut(1), c);
        c.gridheight = 0;
        c.gridwidth = 1;
        c.insets.left = bigIndent;
        c.insets.bottom = 15;
        this.panel.add(bottomLeft, c);
        c.gridwidth = 0;
        c.insets.left = lilIndent;
        this.panel.add(bottomRight, c);
    }

    public Component getWholeComponent() {
        return this.panel;
    }

    public void getData() throws GeneralException {
        ColumnFilterValue left = DateEditor.makeValue(this.leftWidget, this.filter);
        ColumnFilterValue right = DateEditor.makeValue(this.rightWidget, this.filter);
        Comparable leftValue = (Comparable)left.fvValue;
        Comparable rightValue = (Comparable)right.fvValue;
        if (leftValue.compareTo(rightValue) > 0 && DurationBetweenEditor.userConfirmsValueSwap(this)) {
            this.filter.clfValueList = right;
            right.fvNext = left;
        } else {
            this.filter.clfValueList = left;
            left.fvNext = right;
        }
    }

    public void setFocus() {
        this.leftWidget.setFocus();
    }

    public void valueChanged(int delta) {
        if (delta != 0) {
            this.dialog.setOKEnabled(!this.leftWidget.isIncomplete() && !this.rightWidget.isIncomplete());
        }
    }

    public void notifyEnterStruck() {
    }

    public void stateChanged(ChangeEvent event) {
        this.leftWidget.stateChanged(event);
        this.rightWidget.stateChanged(event);
        this.enableAppropriateLabels();
    }
}

