/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageFreeForm;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class FreeForm {
    public static final int MINIMUM_WIDTH = 100;
    protected static final int DEFAULT_DISPLAY_COLUMNS = 20;
    protected JTextField textField;
    protected ColumnFilter filter;
    protected boolean onDialog;

    protected void createTextField() {
        this.textField = TTextField.newTTextField(20, Short.MAX_VALUE, false);
        Dimension size = this.textField.getPreferredSize();
        size.width = 100;
        this.textField.setMinimumSize(size);
    }

    public abstract void refresh();

    public abstract void getData() throws GeneralException;

    public FreeForm(ColumnFilter pFilter, boolean pOnDialog) {
        this.filter = pFilter;
        this.onDialog = pOnDialog;
        this.createTextField();
    }

    public FreeForm(ColumnFilter pFilter) {
        this(pFilter, false);
    }

    public Component getComponent() {
        return this.textField;
    }

    public ColumnFilter getFilter() {
        return this.filter;
    }

    protected void ensureNonEmpty() throws GeneralException {
        String s = this.textField.getText();
        if (Util.isEmpty(s)) {
            s = MessageLog.getMessageNoTS("STG3265E");
            throw new GeneralException(s);
        }
    }

    public MutableLong adjustForRounding(MutableLong obj) {
        short inputUnit = this.filter.clfValueList.fvInputUnit;
        if (inputUnit > 0) {
            double adjAmt = StorageFreeForm.addAmt;
            double value = obj.value;
            obj.value = (long)(value += adjAmt * (double)FreeForm.longFromUnit(inputUnit));
        }
        return obj;
    }

    protected static long longFromUnit(short inputUnit) {
        long result = 1L;
        return result <<= inputUnit * 10;
    }
}

