/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.xmsg.MessageLog;

public class StorageEditor
extends FreeForm
implements ValueEditor {
    private static final String[] UNITS = new String[]{MessageLog.getMessageNoID("STG6063L"), MessageLog.getMessageNoID("STG6064L"), MessageLog.getMessageNoID("STG6065L"), MessageLog.getMessageNoID("STG6066L"), MessageLog.getMessageNoID("STG6067L")};
    private JComboBox combo = new TComboBox(UNITS);
    private Container panel;

    protected void createTextField() {
        this.textField = TTextField.newTTextField("", 20, Short.MAX_VALUE, false, this.onDialog);
    }

    public StorageEditor(ColumnFilter pFilter, boolean pOnDialog) {
        super(pFilter, pOnDialog);
        this.combo.setSelectedIndex(1);
        this.panel = new JPanel();
        this.panel.add(this.textField);
        this.panel.add(this.combo);
        this.refresh();
    }

    public StorageEditor(ColumnFilter pFilter) {
        this(pFilter, true);
    }

    public Component getWholeComponent() {
        return this.panel;
    }

    public void setFocus() {
        this.textField.requestFocus();
    }

    public void refresh() {
        ColumnFilterValue value = this.filter.clfValueList;
        MutableLong obj = value == null ? null : (MutableLong)value.fvValue;
        if (obj == null) {
            this.textField.setText("");
        } else {
            String qualified = StorageFreeForm.format(obj, value.fvInputUnit);
            String unqualified = value.fvInputUnit == 0 ? qualified : qualified.substring(0, qualified.length() - 1);
            this.textField.setText(unqualified);
            this.textField.select(0, unqualified.length());
            this.combo.setSelectedIndex(value.fvInputUnit);
        }
    }

    public void getData() throws GeneralException {
        this.ensureNonEmpty();
        StringBuffer buf = new StringBuffer(40);
        buf.append(this.textField.getText());
        buf.append(this.combo.getSelectedItem());
        this.filter.clfValueList = StorageFreeForm.parse(buf.toString(), new MutableInteger(), false);
    }
}

