/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.eclipse.aperi.TStorm.gui.rptfilter.WidgetListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.SizeLimitedDocument;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.xmsg.MessageLog;

public class TimestampWidget
implements DocumentListener,
ItemListener,
ActionListener,
ChangeListener {
    public static final short RELATIVE = 0;
    public static final short ABSOLUTE = 1;
    private static final short N_SCALE = 2;
    public static final int BIG_INDENT = 25;
    public static final int LIL_INDENT = 5;
    private static final int REL_YEARS_FIELD = 0;
    private static final int REL_WEEKS_FIELD = 1;
    private static final int REL_DAYS_FIELD = 2;
    private static final int REL_HOURS_FIELD = 3;
    private static final int REL_MINS_FIELD = 4;
    private static final int N_REL_FIELDS = 5;
    private static final int[] relLengths = new int[]{2, 3, 3, 2, 2};
    private static final int REL_YEARS_LABEL = 5;
    private static final int REL_WEEKS_LABEL = 6;
    private static final int REL_DAYS_LABEL = 7;
    private static final int REL_HOURS_LABEL = 8;
    private static final int REL_MINS_LABEL = 9;
    private static final int N_REL_LABELS = 5;
    private static final String[] relIDs = new String[]{"STG3066L", "STG3070L", "STG3058T", "STG3071L", "STG3072L"};
    private static final int ABS_YEAR_FIELD = 0;
    private static final int ABS_HOUR_FIELD = 1;
    private static final int ABS_MIN_FIELD = 2;
    private static final int N_ABS_FIELDS = 3;
    private static final int[] absLengths = new int[]{4, 2, 2};
    private static final int ABS_MONTH_COMBO = 3;
    private static final int ABS_DAY_COMBO = 4;
    private static final int N_ABS_COMBOS = 2;
    private static final int YEAR_OFFSET = 0;
    private static final int HOUR_OFFSET = 1;
    private static final int MIN_OFFSET = 2;
    private static final int MONTH_OFFSET = 3;
    private static final int DAY_OFFSET = 4;
    private static final String[] monthNameIDs = new String[]{"GUI2001T", "GUI2002T", "GUI2003T", "GUI2004T", "GUI2005T", "GUI2006T", "GUI2007T", "GUI2008T", "GUI2009T", "GUI2010T", "GUI2011T", "GUI2012T"};
    public long number;
    public short scale;
    public transient JRadioButton[] buttons;
    private transient JTextField[] relFields;
    private transient Document[] relDocuments;
    private transient Component[] relComponents;
    private transient int[] relFieldValues;
    private transient JTextField[] absFields;
    private transient Document[] absDocuments;
    private transient int[] absFieldValues;
    private transient Component[] absComponents;
    private transient JComboBox monthList;
    private transient JComboBox dayList;
    private transient WidgetListener listener;
    private static int CANONICAL_YEAR = 31536000;
    private static int ONE_WEEK = 604800;
    private static final int[] monthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public boolean isGreaterThan(long otherNumber, short otherScale) {
        if (this.scale != otherScale) {
            return false;
        }
        return this.number > otherNumber;
    }

    public boolean isIncomplete() {
        if (this.scale == 0 || this.absFieldValues == null) {
            return false;
        }
        return this.absFieldValues[0] < 0 || this.absFieldValues[1] < 0 || this.absFieldValues[2] < 0;
    }

    public void enableAppropriateControls() {
        int i;
        Component[] disabled;
        Component[] enabled;
        if (this.scale == 0) {
            enabled = this.relComponents;
            disabled = this.absComponents;
        } else {
            enabled = this.absComponents;
            disabled = this.relComponents;
        }
        if (disabled != null) {
            for (i = 0; i < disabled.length; ++i) {
                disabled[i].setEnabled(false);
            }
        }
        for (i = 0; i < enabled.length; ++i) {
            enabled[i].setEnabled(true);
        }
    }

    private void fillFieldArray(JTextField[] array, int[] lengths, Document[] documents, int[] initialValues, boolean isAbsolute) {
        for (int i = 0; i < array.length; ++i) {
            documents[i] = new SizeLimitedDocument(lengths[i], true);
            int v = initialValues[i];
            String s = Integer.toString(v);
            if (isAbsolute && i >= array.length - 2 && v < 10) {
                s = '0' + s;
            }
            array[i] = new JTextField(documents[i], s, lengths[i]);
            array[i].addActionListener(this);
            documents[i].addDocumentListener(this);
            GuiUtil.setAccessible(array[i], s, s);
        }
    }

    private void fillLabelArray(Component[] array, int offset, String[] IDs) {
        for (int i = 0; i < IDs.length; ++i) {
            array[offset + i] = new JLabel(MessageLog.getMessageNoID(IDs[i]));
        }
    }

    private void decomposeRelative() {
        int x;
        if (this.scale == 1) {
            x = 0;
        } else {
            x = (int)this.number;
            if (x < 0) {
                x = -x;
            }
        }
        this.relFieldValues[0] = x / CANONICAL_YEAR;
        this.relFieldValues[1] = (x %= CANONICAL_YEAR) / ONE_WEEK;
        this.relFieldValues[2] = (x %= ONE_WEEK) / 86400;
        this.relFieldValues[3] = (x %= 86400) / 3600;
        this.relFieldValues[4] = (x %= 3600) / 60;
    }

    private void reconstructRelative() {
        this.number = this.relFieldValues[4] * 60;
        this.number += (long)(this.relFieldValues[3] * 3600);
        this.number += (long)(this.relFieldValues[2] * 86400);
        this.number += (long)(this.relFieldValues[1] * ONE_WEEK);
        this.number += (long)(this.relFieldValues[0] * CANONICAL_YEAR);
    }

    private void decomposeAbsolute() {
        Date date = this.scale == 0 ? new Date() : new Date(this.number * 1000L);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        this.absFieldValues[0] = cal.get(1);
        this.absFieldValues[1] = cal.get(11);
        this.absFieldValues[2] = cal.get(12);
        this.absFieldValues[3] = cal.get(2);
        this.absFieldValues[4] = cal.get(5);
    }

    private void reconstructAbsolute() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(this.absFieldValues[0], this.absFieldValues[3], this.absFieldValues[4], this.absFieldValues[1], this.absFieldValues[2], 0);
        Date date = cal.getTime();
        this.number = date.getTime() / 1000L;
    }

    private void reconstruct() {
        if (this.scale == 0) {
            this.reconstructRelative();
        } else {
            this.reconstructAbsolute();
        }
    }

    private boolean yearIsLeap(int year) {
        return (year & 3) == 0;
    }

    private int daysInMonth(int year, int month) {
        int result = monthDays[month];
        if (month == 1 && this.yearIsLeap(year)) {
            ++result;
        }
        return result;
    }

    public TimestampWidget(long pNumber, short pScale, WidgetListener pListener, String relativeMsgID) {
        this.number = pNumber;
        this.scale = pScale;
        this.listener = pListener;
        this.buttons = new JRadioButton[2];
        String s = MessageLog.getMessageNoID(relativeMsgID);
        this.buttons[0] = new JRadioButton(s);
        GuiUtil.setAccessible(this.buttons[0], s, s);
        s = MessageLog.getMessageNoID("STG3065L");
        this.buttons[1] = new JRadioButton(s);
        GuiUtil.setAccessible(this.buttons[1], s, s);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.buttons[0]);
        buttonGroup.add(this.buttons[1]);
        this.buttons[this.scale].setSelected(true);
    }

    public TimestampWidget(long pNumber, short pScale, WidgetListener pListener) {
        this(pNumber, pScale, pListener, "STG3270L");
    }

    public Component makeRelativePanel() {
        int i;
        this.relFields = new JTextField[5];
        this.relDocuments = new Document[5];
        this.relFieldValues = new int[5];
        this.decomposeRelative();
        this.fillFieldArray(this.relFields, relLengths, this.relDocuments, this.relFieldValues, false);
        this.relComponents = new JComponent[10];
        for (i = 0; i < 5; ++i) {
            this.relComponents[i] = this.relFields[i];
        }
        this.fillLabelArray(this.relComponents, 5, relIDs);
        this.buttons[0].addChangeListener(this);
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets.left = 3;
        c.insets.right = 3;
        c.anchor = 17;
        c.fill = 0;
        for (i = 5; i < this.relComponents.length - 1; ++i) {
            result.add(this.relComponents[i], c);
        }
        c.gridwidth = 0;
        result.add(this.relComponents[i], c);
        c.gridwidth = 1;
        for (i = 0; i < 4; ++i) {
            result.add((Component)this.relFields[i], c);
        }
        c.weightx = 1.0;
        result.add((Component)this.relFields[i], c);
        c.gridheight = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        result.add(Box.createVerticalStrut(30), c);
        return result;
    }

    public Component makeAbsolutePanel() {
        int i;
        this.absFields = new JTextField[3];
        this.absDocuments = new Document[3];
        this.absFieldValues = new int[5];
        this.decomposeAbsolute();
        this.fillFieldArray(this.absFields, absLengths, this.absDocuments, this.absFieldValues, true);
        this.absComponents = new JComponent[5];
        for (i = 0; i < 3; ++i) {
            this.absComponents[i] = this.absFields[i];
        }
        Object[] monthNames = new Object[monthNameIDs.length];
        for (i = 0; i < monthNameIDs.length; ++i) {
            monthNames[i] = MessageLog.getMessageNoID(monthNameIDs[i]);
        }
        this.monthList = new TComboBox(monthNames);
        this.monthList.setSelectedIndex(this.absFieldValues[3]);
        this.absComponents[3] = this.monthList;
        this.dayList = new TComboBox();
        int x = this.daysInMonth(this.absFieldValues[0], this.absFieldValues[3]);
        for (i = 1; i <= x; ++i) {
            this.dayList.addItem(Integer.toString(i));
        }
        this.dayList.setSelectedIndex(this.absFieldValues[4] - 1);
        this.absComponents[4] = this.dayList;
        this.dayList.addItemListener(this);
        this.monthList.addItemListener(this);
        GuiUtil.setAccessible(this.monthList, Util.getString("NAME_MONTHSLIST"), Util.getString("DESCRIPTION_MONTHSLIST"));
        GuiUtil.setAccessible(this.dayList, Util.getString("NAME_DAYSLIST"), Util.getString("DESCRIPTION_DAYSLIST"));
        this.buttons[1].addChangeListener(this);
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets.left = 3;
        c.insets.right = 3;
        c.gridheight = 0;
        c.weighty = 1.0;
        if (!GuiUtil.wrapAtWords()) {
            result.add((Component)this.absFields[0], c);
            result.add((Component)this.monthList, c);
            result.add((Component)this.dayList, c);
        } else if (Locale.getDefault().toString().equals("en_US")) {
            result.add((Component)this.monthList, c);
            result.add((Component)this.dayList, c);
            result.add((Component)this.absFields[0], c);
        } else {
            result.add((Component)this.dayList, c);
            result.add((Component)this.monthList, c);
            result.add((Component)this.absFields[0], c);
        }
        c.insets.right = 2;
        result.add((Component)this.absFields[1], c);
        c.insets.left = 0;
        c.insets.right = 0;
        JLabel colon = new JLabel(":");
        Font font = colon.getFont();
        colon.setFont(font.deriveFont(1));
        colon.setForeground(Color.black);
        result.add((Component)colon, c);
        c.insets.left = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets.right = 15;
        result.add((Component)this.absFields[2], c);
        return result;
    }

    public Component makeSwitchable(boolean relativeAbove) {
        Component componentBelow;
        Component componentAbove;
        int scaleBelow;
        int scaleAbove;
        Component relativePanel = this.makeRelativePanel();
        Component absolutePanel = this.makeAbsolutePanel();
        this.enableAppropriateControls();
        if (relativeAbove) {
            scaleAbove = 0;
            scaleBelow = 1;
            componentAbove = relativePanel;
            componentBelow = absolutePanel;
        } else {
            scaleAbove = 1;
            scaleBelow = 0;
            componentAbove = absolutePanel;
            componentBelow = relativePanel;
        }
        JPanel result = new JPanel(new GridBagLayout());
        String s = MessageLog.getMessageNoID("STG3063L");
        result.setBorder(GuiUtil.getBorder(s));
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 18;
        c.insets.left = 5;
        result.add((Component)this.buttons[scaleAbove], c);
        c.weighty = 0.0;
        c.gridheight = 1;
        c.anchor = 18;
        c.insets.left = 25;
        c.insets.right = 0;
        c.insets.bottom = 5;
        result.add(componentAbove, c);
        c.insets.left = 5;
        c.insets.bottom = 0;
        result.add((Component)this.buttons[scaleBelow], c);
        c.insets.left = 25;
        c.insets.right = 0;
        c.insets.bottom = 15;
        result.add(componentBelow, c);
        return result;
    }

    public void setFocus() {
        JTextField component = this.scale == 0 ? this.relFields[2] : this.absFields[0];
        component.requestFocus();
    }

    private int whichDocument(DocumentEvent event) {
        int i;
        Document doc = event.getDocument();
        for (i = 0; i < this.relDocuments.length && this.relDocuments[i] != doc; ++i) {
        }
        if (i < this.relDocuments.length) {
            if (this.scale == 0) {
                return i;
            }
            return Integer.MAX_VALUE;
        }
        for (i = 0; i < this.absDocuments.length && this.absDocuments[i] != doc; ++i) {
        }
        if (i < this.absDocuments.length && this.scale == 1) {
            return ~i;
        }
        return Integer.MAX_VALUE;
    }

    private void possiblyAdjustDays() {
        int current;
        int days = this.daysInMonth(this.absFieldValues[0], this.absFieldValues[3]);
        if (days != (current = this.dayList.getItemCount())) {
            if (days > current) {
                do {
                    this.dayList.addItem(Integer.toString(++current));
                } while (current < days);
            } else {
                do {
                    this.dayList.removeItemAt(--current);
                } while (current > days);
            }
        }
    }

    public void insertUpdate(DocumentEvent event) {
        boolean notifyValueChanged;
        int i = this.whichDocument(event);
        if (i == Integer.MAX_VALUE) {
            return;
        }
        boolean relative = i >= 0;
        String s = null;
        int delta = 0;
        if (relative) {
            Document doc = this.relDocuments[i];
            int length = doc.getLength();
            try {
                s = doc.getText(0, length);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            this.relFieldValues[i] = Integer.parseInt(s);
            this.reconstructRelative();
            notifyValueChanged = true;
        } else {
            if (this.absFieldValues[i ^= 0xFFFFFFFF] < 0) {
                delta = 1;
            }
            Document doc = this.absDocuments[i];
            int length = doc.getLength();
            try {
                s = doc.getText(0, length);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            this.absFieldValues[i] = Integer.parseInt(s);
            if (i == 0) {
                this.possiblyAdjustDays();
            }
            boolean bl = notifyValueChanged = !this.isIncomplete();
            if (notifyValueChanged) {
                this.reconstructAbsolute();
            }
        }
        if (notifyValueChanged && this.listener != null) {
            this.listener.valueChanged(delta);
        }
    }

    public void removeUpdate(DocumentEvent event) {
        boolean notifyValueChanged;
        int i = this.whichDocument(event);
        if (i == Integer.MAX_VALUE) {
            return;
        }
        boolean relative = i >= 0;
        String s = null;
        int delta = 0;
        if (relative) {
            Document doc = this.relDocuments[i];
            int length = doc.getLength();
            if (length == 0) {
                this.relFieldValues[i] = 0;
            } else {
                try {
                    s = doc.getText(0, length);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                this.relFieldValues[i] = Integer.parseInt(s);
            }
            this.reconstructRelative();
            notifyValueChanged = true;
        } else {
            notifyValueChanged = !this.isIncomplete();
            Document doc = this.absDocuments[i ^= 0xFFFFFFFF];
            int length = doc.getLength();
            if (length == 0) {
                this.absFieldValues[i] = -1;
                delta = -1;
            } else {
                try {
                    s = doc.getText(0, length);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                this.absFieldValues[i] = Integer.parseInt(s);
            }
            if (i == 0) {
                this.possiblyAdjustDays();
            }
            if (notifyValueChanged && delta == 0) {
                this.reconstructAbsolute();
            }
        }
        if (notifyValueChanged && this.listener != null) {
            this.listener.valueChanged(delta);
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void stateChanged(ChangeEvent event) {
        int i;
        Object source = event.getSource();
        AbstractButton button = null;
        for (i = 0; i < 2 && (button = this.buttons[i]) != source; i = (int)((short)(i + 1))) {
        }
        if (i >= 2 || !button.isSelected()) {
            return;
        }
        this.scale = (short)i;
        this.enableAppropriateControls();
        if (this.isIncomplete()) {
            i = -1;
        } else {
            this.reconstruct();
            i = 1;
        }
        if (this.listener != null) {
            this.listener.valueChanged(i);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.dayList) {
            this.absFieldValues[4] = this.dayList.getSelectedIndex() + 1;
        } else if (source == this.monthList) {
            this.absFieldValues[3] = this.monthList.getSelectedIndex();
            this.possiblyAdjustDays();
        } else {
            return;
        }
        this.reconstructAbsolute();
        if (!this.isIncomplete() && this.listener != null) {
            this.listener.valueChanged(0);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (this.isIncomplete()) {
            Toolkit.getDefaultToolkit().beep();
        } else if (this.listener != null) {
            this.listener.notifyEnterStruck();
        }
    }
}

