/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.gui.rptfilter.DateBetweenEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.DateEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.DurationBetweenEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.DurationEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.EnumeratedMultipleEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.IntegerMultipleEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageBetweenEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageMultipleEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.StringMultipleEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class ValueEditorDialog
implements ActionListener,
WindowListener {
    private static char OK = (char)75;
    private static char CANCEL = (char)88;
    private JDialog dialog;
    private ColumnFilter original;
    private ColumnFilter changed;
    private ValueEditor editor;
    private JButton okButton;
    private boolean okPressed;

    public ValueEditorDialog(Dialog parent, ColumnFilter filter) {
        this.original = filter;
        this.changed = (ColumnFilter)filter.clone();
        ColumnDescriptor descriptor = filter.clfColumn;
        this.dialog = new JDialog(parent, descriptor.cdReportName, true);
        Container pane = this.dialog.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add(Box.createHorizontalStrut(10), "West");
        pane.add(Box.createHorizontalStrut(10), "East");
        pane.add(Box.createVerticalStrut(10), "North");
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        String s = MessageLog.getMessageNoID("GUI0113L");
        this.okButton = new JButton(s);
        s = ReportingSelectionDriver.charToString(OK);
        this.okButton.setActionCommand(s);
        this.okButton.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 10;
        c.insets.bottom = 15;
        c.insets.right = 3;
        c.gridheight = 0;
        buttonPanel.add((Component)this.okButton, c);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        s = MessageLog.getMessageNoID("GUI0114L");
        JButton cancelButton = new JButton(s);
        s = ReportingSelectionDriver.charToString(CANCEL);
        cancelButton.setActionCommand(s);
        cancelButton.addActionListener(this);
        c.insets.right = 0;
        c.insets.left = 3;
        c.gridwidth = 0;
        buttonPanel.add((Component)cancelButton, c);
        pane.add((Component)buttonPanel, "South");
        if (filter.clfColumn.cdValidValue != null) {
            this.editor = new EnumeratedMultipleEditor(this.changed, this);
        } else {
            this.editor = null;
            block0 : switch (filter.clfDataType) {
                case 1: {
                    this.editor = new StringMultipleEditor(this.changed, this);
                    break;
                }
                case 2: {
                    this.editor = new IntegerMultipleEditor(this.changed, this);
                    break;
                }
                case 3: 
                case 6: {
                    if (filter.clfCondition == 11 || filter.clfCondition == 12) {
                        this.editor = new DateBetweenEditor(this.changed, this);
                        break;
                    }
                    this.editor = new DateEditor(this.changed, this);
                    break;
                }
                case 4: {
                    if (filter.clfCondition == 11 || filter.clfCondition == 12) {
                        this.editor = new DurationBetweenEditor(this.changed);
                        break;
                    }
                    this.editor = new DurationEditor(this.changed);
                    break;
                }
                case 5: {
                    switch (filter.clfCondition) {
                        case 7: {
                            this.editor = new StorageMultipleEditor(this.changed, this);
                            break block0;
                        }
                        case 11: 
                        case 12: {
                            this.editor = new StorageBetweenEditor(this.changed);
                            break block0;
                        }
                    }
                    this.editor = new StorageEditor(this.changed);
                }
            }
        }
        if (this.editor == null) {
            s = "Unknown data type: " + Integer.toString(filter.clfDataType);
            throw new RuntimeException(s);
        }
        pane.add(this.editor.getWholeComponent(), "Center");
        this.dialog.addWindowListener(this);
    }

    public boolean show() {
        this.okPressed = false;
        this.dialog.pack();
        GuiUtil.centerDialog(this.dialog);
        this.dialog.show();
        return this.okPressed;
    }

    public void setOKEnabled(boolean state) {
        this.okButton.setEnabled(state);
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.charAt(0) == OK) {
            try {
                this.editor.getData();
            }
            catch (GeneralException e) {
                Toolkit.getDefaultToolkit().beep();
                if (e.getMessage() != null) {
                    GuiUtil.displayException(e);
                }
                return;
            }
            this.original.clfDataType = this.changed.clfDataType;
            this.original.clfValueList = this.changed.clfValueList;
            this.okPressed = true;
        }
        this.dialog.dispose();
    }

    public void windowClosing(WindowEvent ignored) {
    }

    public void windowClosed(WindowEvent ignored) {
    }

    public void windowIconified(WindowEvent ignored) {
    }

    public void windowDeiconified(WindowEvent ignored) {
    }

    public void windowDeactivated(WindowEvent ignored) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent ignored) {
        this.editor.setFocus();
    }
}

