/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import org.eclipse.aperi.backend.LogFileReader;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.ReadLogRequest;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;

public class JobLogFileReader
extends LogFileReader {
    protected MutableInteger open(ReadLogRequest requestData, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(JobLogFileReader.class.getName(), "open", "requestData, response");
        }
        LogFilePos position = requestData.position;
        if (position.offset < 0L && requestData.direction == 1) {
            position.offset = 0L;
        }
        int fd = -1;
        try {
            fd = this.openFile(requestData.name, (int)position.offset);
            if (position.offset < 0L) {
                position.offset = this.getFilePosition(fd);
            }
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(JobLogFileReader.class.getName(), "open", e);
            }
            Object[] args = e.getParameters();
            args[args.length - 1] = requestData.name;
            response.errorMessage = e.getMessage();
            response.status = (short)12;
        }
        if (fd < 0) {
            MutableInteger traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(JobLogFileReader.class.getName(), "open", traceResult);
            }
            return traceResult;
        }
        MutableInteger traceResult = new MutableInteger(fd);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(JobLogFileReader.class.getName(), "open", traceResult);
        }
        return traceResult;
    }

    protected int read(MutableInteger handle, LogFilePos pos, ReadLogRequest rq, ReadLogResponse rd, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(JobLogFileReader.class.getName(), "read", "handle, pos, rq, rd, response");
        }
        int traceResult = this.basicRead(handle.value, pos, rq, rd.lineArray, 0, response);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(JobLogFileReader.class.getName(), "read", traceResult);
        }
        return traceResult;
    }

    protected boolean setPosition(MutableInteger handle, ReadLogRequest rq, LogFilePos newPos) {
        this.setFilePosition(handle.value, (int)newPos.offset);
        return true;
    }
}

