/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

public class Encrypt {
    public static String encrypt(String input) {
        int seed = (int)(System.currentTimeMillis() % 13L);
        return "1" + "0123456789abc".substring(seed, seed + 1) + Encrypt.stringToHex(Encrypt.transformString(input, seed));
    }

    public static String decrypt(String input) {
        int length = input.length();
        if (length <= 2 || (length & 1) == 1) {
            return input;
        }
        try {
            int seed = Integer.parseInt(input.substring(1, 2), 16);
            return Encrypt.transformString(Encrypt.hexToString(input.substring(2)), seed);
        }
        catch (NumberFormatException e) {
            return input;
        }
    }

    public static String transformString(String input, int seed) {
        StringBuffer output = new StringBuffer(input);
        Encrypt.applyPattern(Encrypt.getPattern(seed), output);
        return output.toString();
    }

    private static long getPattern(int seed) {
        long[] keys = new long[]{7941439903471721695L, -1565980515881497136L, 7189945237006800589L, 5351706867103124827L, 5275627958481534053L, -2285909626294025519L, 1842210727525208757L, 3186724457345664289L, -5655450591998329531L, -3442920811114841647L, 7122884046233420469L, 5284922206445392273L, 2638172332413323084L};
        return keys[seed];
    }

    private static void applyPattern(long patternIn, StringBuffer buffer) {
        long pattern = patternIn;
        for (int i = 0; i < buffer.length(); ++i) {
            if (pattern == 0L) {
                pattern = patternIn;
            }
            buffer.setCharAt(i, (char)((long)buffer.charAt(i) ^ pattern & 0xFFL));
            pattern >>= 8;
        }
    }

    private static String stringToHex(String charString) {
        StringBuffer output = new StringBuffer(32);
        for (int i = 0; i < charString.length(); ++i) {
            char c = charString.charAt(i);
            if (c < '\u0010') {
                output.append('0');
            }
            output.append(Integer.toHexString(c));
        }
        return output.toString();
    }

    private static String hexToString(String hexString) {
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < hexString.length(); i += 2) {
            char c = (char)Integer.parseInt(hexString.substring(i, i + 2), 16);
            output.append(c);
        }
        return output.toString();
    }

    public static void main(String[] args) {
        if (args[0].equals("-e")) {
            System.out.println(Encrypt.encrypt(args[1]));
        } else {
            System.out.println(Encrypt.decrypt(args[1]));
        }
    }
}

