/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.logging.TraceLogger;

public class LineBreaker {
    private static final int WHITESPACE = 0;
    private static final int UNQUOTED_WORD = 1;
    private static final int DOUBLE_QUOTE = 2;
    private static final int SINGLE_QUOTE = 3;
    public static String[] template = new String[0];

    private static void finishOff(List list, StringBuffer buf) {
        list.add(buf.toString());
        buf.setLength(0);
    }

    public static String[] parse(String cmdLine) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LineBreaker.class.getName(), "parse", "cmdLine");
        }
        LinkedList list = new LinkedList();
        boolean backslashed = false;
        int quoteState = 0;
        StringBuffer buf = new StringBuffer();
        int length = cmdLine != null ? cmdLine.length() : 0;
        block25: for (int pos = 0; pos < length; ++pos) {
            char c = cmdLine.charAt(pos);
            if (backslashed) {
                if (quoteState == 2) {
                    switch (c) {
                        case '\"': 
                        case '$': 
                        case '\\': 
                        case '`': {
                            break;
                        }
                        default: {
                            buf.append('\\');
                        }
                    }
                }
                buf.append(c);
                backslashed = false;
                continue;
            }
            int ctype = Character.isWhitespace(c) ? 32 : (int)c;
            switch (quoteState) {
                case 0: {
                    switch (ctype) {
                        case 32: {
                            continue block25;
                        }
                        case 34: {
                            quoteState = 2;
                            continue block25;
                        }
                        case 39: {
                            quoteState = 3;
                            continue block25;
                        }
                        case 92: {
                            backslashed = true;
                            quoteState = 1;
                            continue block25;
                        }
                    }
                    quoteState = 1;
                    buf.append(c);
                    continue block25;
                }
                case 1: {
                    switch (ctype) {
                        case 32: {
                            LineBreaker.finishOff(list, buf);
                            quoteState = 0;
                            continue block25;
                        }
                        case 34: {
                            quoteState = 2;
                            continue block25;
                        }
                        case 39: {
                            quoteState = 3;
                            continue block25;
                        }
                        case 92: {
                            backslashed = true;
                            continue block25;
                        }
                    }
                    buf.append(c);
                    continue block25;
                }
                case 2: {
                    switch (ctype) {
                        case 34: {
                            quoteState = 1;
                            continue block25;
                        }
                        case 92: {
                            backslashed = true;
                            continue block25;
                        }
                    }
                    buf.append(c);
                    continue block25;
                }
                case 3: {
                    if (ctype == 39) {
                        quoteState = 1;
                        continue block25;
                    }
                    buf.append(c);
                }
            }
        }
        if (quoteState != 0) {
            LineBreaker.finishOff(list, buf);
        }
        String[] traceResult = list.toArray(template);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LineBreaker.class.getName(), "parse", traceResult);
        }
        return traceResult;
    }
}

