/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.Serializable;
import java.util.HashMap;
import org.eclipse.aperi.common.HasID;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Util;

public class NameList
implements Serializable,
Cloneable,
HasID,
Comparable {
    static final long serialVersionUID = 8902880704585869433L;
    public NameList nlNext;
    public String nlName;
    public int nlID;
    public int nlID2;
    public int nlID3;
    public byte nlState;
    public short nlInfo;
    public int nlClusterID;
    public String nlClusterName;
    public String nlClusterDomain;
    public String nlHostName;
    public String nlName2;
    public String displayString = null;
    public Object ra = null;
    public static final byte EXCLUDED = 1;
    public static final byte SELECTED = 2;

    public String toString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        return Util.getTranslatedName(this.nlName);
    }

    public Object clone() {
        Object result = null;
        try {
            result = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
        return result;
    }

    public static boolean nameListsEqual(NameList left, NameList right) {
        MutableLong key;
        HashMap<MutableLong, NameList> map = new HashMap<MutableLong, NameList>();
        while (left != null) {
            key = new MutableLong(left.nlID);
            key.value = (key.value << 16) + (long)(left.nlState & 1);
            map.put(key, left);
            left = left.nlNext;
        }
        key = new MutableLong();
        boolean equal = true;
        while (equal && right != null) {
            key.value = right.nlID;
            key.value = (key.value << 16) + (long)(right.nlState & 1);
            left = (NameList)map.remove(key);
            equal = left != null;
            right = right.nlNext;
        }
        return equal && map.size() == 0;
    }

    public static boolean nameMasksListsEqual(NameList left, NameList right) {
        String key;
        HashMap<String, NameList> map = new HashMap<String, NameList>();
        while (left != null) {
            key = new String(left.nlName);
            map.put(key, left);
            left = left.nlNext;
        }
        key = new String();
        boolean equal = true;
        while (equal && right != null) {
            key = right.nlName;
            left = (NameList)map.remove(key);
            equal = left != null;
            right = right.nlNext;
        }
        return equal && map.size() == 0;
    }

    public static NameList cloneNameList(NameList template) {
        NameList head = null;
        NameList prev = null;
        while (template != null) {
            NameList element = (NameList)template.clone();
            element.nlNext = null;
            if (prev == null) {
                head = element;
            } else {
                prev.nlNext = element;
            }
            prev = element;
            template = template.nlNext;
        }
        return head;
    }

    public static NameList[] packList(NameList head) {
        int nElements = 0;
        NameList element = head;
        while (element != null) {
            ++nElements;
            element = element.nlNext;
        }
        NameList[] result = new NameList[nElements];
        nElements = 0;
        while (head != null) {
            element = head.nlNext;
            head.nlNext = null;
            result[nElements] = head;
            ++nElements;
            head = element;
        }
        return result;
    }

    public static NameList unpackList(NameList[] array) {
        NameList head;
        int count = array != null ? array.length : 0;
        if (count == 0) {
            head = null;
        } else {
            NameList prev = head = array[0];
            for (int i = 1; i < count; ++i) {
                prev = prev.nlNext = array[i];
            }
        }
        return head;
    }

    public Packable getNext() {
        return this.nlNext;
    }

    public void setNext(Packable next) {
        this.nlNext = (NameList)next;
    }

    public int getID() {
        return this.nlID;
    }

    public int compareTo(Object in) {
        NameList obj2 = (NameList)in;
        int result = 0;
        result = obj2.toString().compareTo(this.toString());
        if (result == 0) {
            result = obj2.nlID == this.nlID ? (obj2.nlID2 == this.nlID2 ? (obj2.nlID3 == this.nlID3 ? 0 : (obj2.nlID3 > this.nlID3 ? 1 : -1)) : (obj2.nlID2 > this.nlID2 ? 1 : -1)) : (obj2.nlID > this.nlID ? 1 : -1);
        }
        return result;
    }
}

