/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import org.eclipse.aperi.xmsg.MessageFormatter;

public class StorageException
extends Exception
implements Serializable {
    static final long serialVersionUID = 1090083897006496166L;
    public String messageID;
    public Object[] args;
    public String systemError;
    public Exception exception;
    public StorageException nextException;
    private static MessageFormatter defaultFormatter;

    public StorageException(String messageID, Object[] args) {
        this(messageID, args, null, null);
    }

    public StorageException(String messageID, Object[] args, String systemError) {
        this(messageID, args, systemError, null);
    }

    public StorageException(String messageID, Object[] args, String systemError, Exception exception) {
        this.messageID = messageID;
        this.args = args;
        this.systemError = systemError;
        this.exception = exception;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getSystemError() {
        return this.systemError;
    }

    public void addException(StorageException exception) {
        StorageException tail = this;
        while (tail.nextException != null) {
            tail = tail.nextException;
        }
        tail.nextException = exception;
    }

    public static void setDefaultFormatter(MessageFormatter formatter) {
        defaultFormatter = formatter;
    }

    public String getMessage(MessageFormatter formatter) {
        PrintWriter exceptionWriter = null;
        CharArrayWriter arrayWriter = null;
        StringBuffer buffer = new StringBuffer();
        StorageException e = this;
        while (e != null) {
            buffer.append(formatter.format(e.messageID, e.args));
            buffer.append('\n');
            if (e.systemError != null) {
                buffer.append(formatter.formatSystemError(e.systemError));
                buffer.append('\n');
            }
            if (e.exception != null) {
                if (exceptionWriter != null) {
                    arrayWriter.reset();
                } else {
                    arrayWriter = new CharArrayWriter();
                    exceptionWriter = new PrintWriter((Writer)arrayWriter, true);
                }
                e.exception.printStackTrace(exceptionWriter);
                buffer.append(arrayWriter.toCharArray());
            }
            e = e.nextException;
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    public Iterator getIterator() {
        return new ExceptionIterator(this);
    }

    public String getMessage() {
        if (defaultFormatter == null) {
            throw new RuntimeException("Illegal call to StorageException.getMessage()");
        }
        return this.getMessage(defaultFormatter);
    }

    public String toString() {
        String s = this.getClass().getName();
        return this.messageID != null ? s + ": " + this.messageID : s;
    }

    private class ExceptionIterator
    implements Iterator {
        private StorageException next;

        ExceptionIterator(StorageException head) {
            this.next = head;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            StorageException result = this.next;
            this.next = this.next.nextException;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

