/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.xmsg.MessageLog;

public class TableCellStrings {
    private static final int SEC_PER_DAY = 86400;
    private static final int SEC_PER_HR = 3600;
    private static final String DAY = MessageLog.getMessageNoID("STG4061L");
    private static final String HRS = MessageLog.getMessageNoID("STG4062L");
    private static final String MIN = MessageLog.getMessageNoID("STG4063L");
    private static final String SEC = MessageLog.getMessageNoID("STG4087L");
    private static final String KB = MessageLog.getMessageNoID("GEN0188T");
    private static final String MB = MessageLog.getMessageNoID("GEN0189T");
    private static final String GB = MessageLog.getMessageNoID("GEN0190T");
    private static final String TB = MessageLog.getMessageNoID("GEN0191T");
    private static final String NA = MessageLog.getMessageNoID("STG0019T");
    private static final DecimalFormat d0Fmt = new DecimalFormat();
    private static final DecimalFormat d2Fmt = new DecimalFormat("###,###,###,##0.00");
    private static final DecimalFormat dmFmt = new DecimalFormat();
    public static final int DATE_RENDERER = 1;
    public static final int DECIMAL_RENDERER = 2;
    public static final int DURATION_RENDERER = 3;
    public static final int MEGABYTE_RENDERER = 4;
    public static final int NUMBER_RENDERER = 5;
    public static final int PERCENT_RENDERER = 6;
    public static final int SPACE_RENDERER = 7;
    public static final int SPACEINT_RENDERER = 8;
    public static final int HERTZ_RENDERER = 9;
    public static final int METRIC_RENDERER = 10;

    public static String DecimalRenderer(int scale, String suffix, Object o, StringBuffer buffer) {
        String data;
        Number n = (Number)o;
        if (n == null) {
            data = "";
        } else if (n.intValue() < 0) {
            data = NA;
        } else {
            buffer.setLength(0);
            buffer.append(n.intValue() / scale);
            buffer.append('.');
            buffer.append(n.intValue() % scale);
            double value = Double.parseDouble(buffer.toString());
            buffer.delete(0, buffer.length());
            buffer.setLength(0);
            buffer.append(d0Fmt.format(value));
            if (suffix != null) {
                buffer.append(suffix);
            }
            data = buffer.toString();
        }
        return data;
    }

    public static String DateRenderer(Object o, DateFormat df) {
        String data = o instanceof Date ? (o == null || ((Date)o).compareTo(Constants.NULL_DATE_DATE) < 1 ? "" : df.format((Date)o)) : o.toString();
        return data;
    }

    public static String NumberRenderer(int num) {
        String data = num == -2 ? "" : (num < 0 ? NA : d0Fmt.format(num));
        return data;
    }

    public static String NumberRenderer(Object o, DecimalFormat d0Fmt) {
        String data = o == null || ((Number)o).longValue() == -2L ? "" : (((Number)o).longValue() < 0L ? NA : d0Fmt.format((Number)o));
        return data;
    }

    public static String NumberRenderer2(Object o, DecimalFormat d0Fmt) {
        String data = o == null || ((Number)o).longValue() < 0L ? "" : d0Fmt.format((Number)o);
        return data;
    }

    public static String MegabyteRenderer(Object o, DecimalFormat d0Fmt) {
        String data = o == null || ((Number)o).longValue() == -2L ? "" : (((Number)o).longValue() < 0L ? NA : d0Fmt.format((Number)o) + " " + MB);
        return data;
    }

    public static String SpaceRenderer(Object o) {
        long bytes;
        String data = "";
        if (o != null && (bytes = ((Number)o).longValue()) != -2L && bytes != -1024L) {
            data = bytes < 0L ? NA : (Variables.spaceUnits == 0 ? Util.formatBytes(((Number)o).longValue(), true) : (Variables.spaceUnits == 1 ? d2Fmt.format((double)bytes / 1024.0) + " " + KB : (Variables.spaceUnits == 2 ? d2Fmt.format((double)bytes / 1048576.0) + " " + MB : (Variables.spaceUnits == 3 ? d2Fmt.format((double)bytes / 1.073741824E9) + " " + GB : d2Fmt.format((double)(bytes /= 0x100000L) / 1048576.0) + " " + TB))));
        }
        return data;
    }

    public static String SpaceNoDecimalRenderer(Object o) {
        String data = o == null || ((Number)o).longValue() == -2L || ((Number)o).longValue() == -1024L ? "" : (((Number)o).longValue() < 0L ? NA : Util.formatBytes(((Number)o).longValue(), false));
        return data;
    }

    public static String PercentRenderer(Object o, DecimalFormat d0Fmt) {
        String data;
        if (o == null || ((Number)o).longValue() == -2L) {
            data = "";
        } else if (((Number)o).longValue() < 0L) {
            data = NA;
        } else {
            double d = ((Number)o).doubleValue() / 100.0;
            data = d0Fmt.getPercentInstance().format(d);
        }
        return data;
    }

    public static String DurationRenderer(Object o, StringBuffer buffer) {
        String data;
        if (o == null || ((Number)o).longValue() == -2L) {
            data = "";
        } else if (((Number)o).intValue() == -1) {
            data = NA;
        } else {
            int duration = ((Number)o).intValue();
            data = TableCellStrings.formatDuration(duration, buffer);
        }
        return data;
    }

    public static String formatDuration(int duration, StringBuffer buffer) {
        int days = duration / 86400;
        int hours = (duration %= 86400) / 3600;
        int minutes = (duration %= 3600) / 60;
        int seconds = duration % 60;
        buffer.setLength(0);
        boolean gotValue = TableCellStrings.appendValue(days, DAY, false, buffer);
        gotValue = TableCellStrings.appendValue(hours, HRS, gotValue, buffer);
        TableCellStrings.appendValue(minutes, MIN, gotValue, buffer);
        TableCellStrings.appendValue(seconds, SEC, true, buffer);
        return buffer.toString();
    }

    private static boolean appendValue(int value, String suffix, boolean gotValue, StringBuffer buffer) {
        if (value > 0 || gotValue) {
            buffer.append(' ');
            buffer.append(suffix);
            buffer.append(":");
            buffer.append(' ');
            buffer.append(value);
            gotValue = true;
        }
        return gotValue;
    }

    public static String NumberWithSuffixRenderer(Object o, DecimalFormat d0Fmt, String suffix) {
        String data;
        if (o == null || ((Number)o).longValue() == -2L) {
            data = "";
        } else if (((Number)o).longValue() < 0L) {
            data = NA;
        } else {
            data = d0Fmt.format((Number)o);
            StringBuffer buff = new StringBuffer(data);
            buff.append(suffix);
            data = buff.toString();
        }
        return data;
    }
}

