/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.File;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.xmsg.GuiResources;
import org.eclipse.aperi.xmsg.IntlMessageFormat;
import org.eclipse.aperi.xmsg.MessageBundleManager;
import org.eclipse.aperi.xmsg.MessageLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final DecimalFormat dFmt = new DecimalFormat();
    private static final DecimalFormat d0Fmt = new DecimalFormat("###0");
    private static final DecimalFormat d2Fmt = new DecimalFormat("###0.00");
    private static final String NA = MessageLog.getMessageNoID("STG0019T");
    private static final String MHZ = MessageLog.getMessageNoID("GEN0186T");
    private static final String KB = MessageLog.getMessageNoID("GEN0188T");
    private static final String MB = MessageLog.getMessageNoID("GEN0189T");
    private static final String GB = MessageLog.getMessageNoID("GEN0190T");
    private static final String TB = MessageLog.getMessageNoID("GEN0191T");
    public static final String BUNDLE_SRC_EXTENSION_POINT_ID = "org.eclipse.aperi.common.guiMessageSources";
    private static final ResourceBundle defaultBundle = ResourceBundle.getBundle(GuiResources.class.getName());
    private static final MessageBundleManager manager = new MessageBundleManager("org.eclipse.aperi.common.guiMessageSources");

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        int length = s.length();
        return length == 0 || length == 1 && s.charAt(0) == ' ';
    }

    public static boolean stringsEqual(String one, String another) {
        boolean oneEmpty = Util.isEmpty(one);
        boolean anotherEmpty = Util.isEmpty(another);
        if (oneEmpty || anotherEmpty) {
            return oneEmpty == anotherEmpty;
        }
        return one.equals(another);
    }

    public static boolean stringStartsWith(String one, String another) {
        boolean oneEmpty = Util.isEmpty(one);
        boolean anotherEmpty = Util.isEmpty(another);
        if (oneEmpty || anotherEmpty) {
            return false;
        }
        return one.startsWith(another);
    }

    public static int compareStrings(String one, String another) {
        boolean oneEmpty = Util.isEmpty(one);
        boolean anotherEmpty = Util.isEmpty(another);
        if (oneEmpty || anotherEmpty) {
            if (oneEmpty && anotherEmpty) {
                return 0;
            }
            if (oneEmpty) {
                return -1;
            }
            return 1;
        }
        return one.compareTo(another);
    }

    public static boolean stringsEqualIgnoreCase(String one, String another) {
        boolean oneEmpty = Util.isEmpty(one);
        boolean anotherEmpty = Util.isEmpty(another);
        if (oneEmpty || anotherEmpty) {
            return oneEmpty == anotherEmpty;
        }
        return one.equalsIgnoreCase(another);
    }

    public static String nextWord(String s, MutableInteger pPos) {
        int pos;
        int length = s.length();
        for (pos = pPos.value; pos < length && Character.isWhitespace(s.charAt(pos)); ++pos) {
        }
        if (pos >= length) {
            return null;
        }
        int start = pos;
        while (pos < length && !Character.isWhitespace(s.charAt(pos))) {
            ++pos;
        }
        pPos.value = pos;
        return s.substring(start, pos);
    }

    public static String convertTZ(String timeZone) {
        TimeZone tz = TimeZone.getTimeZone(timeZone);
        String[] tzIDs = TimeZone.getAvailableIDs(tz.getRawOffset());
        for (int i = 0; i < tzIDs.length; ++i) {
            if (tzIDs[i].length() != 3 || tz.useDaylightTime() != TimeZone.getTimeZone(tzIDs[i]).useDaylightTime()) continue;
            return tzIDs[i];
        }
        return "GMT";
    }

    public static String getDotName(String a, String b) {
        return Util.joinName(a, b, '.');
    }

    public static String joinName(String a, String b, String sep) {
        boolean bok;
        StringBuffer buf = new StringBuffer(80);
        boolean aok = a != null && !a.equals(" ");
        boolean bl = bok = b != null && !b.equals(" ");
        if (aok) {
            buf.append(a);
        }
        if (aok && bok) {
            buf.append(sep);
        }
        if (bok) {
            buf.append(b);
        }
        return buf.toString();
    }

    public static String joinName(String a, String b, char sep) {
        boolean bok;
        StringBuffer buf = new StringBuffer(80);
        boolean aok = a != null && !a.equals(" ");
        boolean bl = bok = b != null && !b.equals(" ");
        if (aok) {
            buf.append(a);
        }
        if (aok && bok) {
            buf.append(sep);
        }
        if (bok) {
            buf.append(b);
        }
        return buf.toString();
    }

    public static String formatBytes(long bytes) {
        return Util.formatBytes(bytes, true);
    }

    public static String formatBytes(long bytes, boolean wantDecimal) {
        DecimalFormat decFmt = wantDecimal ? d2Fmt : d0Fmt;
        String fmtBytes = new String();
        fmtBytes = bytes < 0L ? NA : (bytes < 1024L ? dFmt.format(bytes) + "      " : ((double)bytes < 1048576.0 ? decFmt.format((double)bytes / 1024.0) + " " + KB : ((double)bytes < 1.073741824E9 ? decFmt.format((double)bytes / 1048576.0) + " " + MB : ((double)bytes < 1.099511627776E12 ? decFmt.format((double)bytes / 1.073741824E9) + " " + GB : decFmt.format((double)(bytes /= 0x100000L) / 1048576.0) + " " + TB))));
        return fmtBytes;
    }

    public static String formatPrefBytes(long bytes, boolean wantDecimal) {
        DecimalFormat decFmt;
        DecimalFormat decimalFormat = decFmt = wantDecimal ? d2Fmt : d0Fmt;
        if (Variables.spaceUnits == 0) {
            return Util.formatBytes(bytes);
        }
        if (bytes < 0L) {
            return NA;
        }
        if (Variables.spaceUnits == 1) {
            return decFmt.format((double)bytes / 1024.0) + " " + KB;
        }
        if (Variables.spaceUnits == 2) {
            return decFmt.format((double)bytes / 1048576.0) + " " + MB;
        }
        if (Variables.spaceUnits == 3) {
            return decFmt.format((double)bytes / 1.073741824E9) + " " + GB;
        }
        return decFmt.format((double)(bytes /= 0x100000L) / 1048576.0) + " " + TB;
    }

    public static String formatPrefBytes(long bytes) {
        return Util.formatPrefBytes(bytes, true);
    }

    public static String formatHertz(int speed) {
        String hertz = speed <= 0 ? NA : Integer.toString(speed) + " " + MHZ;
        return hertz;
    }

    public static void formatLine(String line, StringBuffer buffer, Object[] parms) {
        for (int position = 0; position < line.length(); ++position) {
            int parmIndex;
            char c = line.charAt(position);
            if (c == '{') {
                parmIndex = 0;
                while (Character.isDigit(line.charAt(++position))) {
                    parmIndex *= 10;
                    parmIndex += line.charAt(position) - 48;
                }
                Object value = parms[parmIndex];
                if (value == null || value.equals("")) {
                    value = "<text unavailable>";
                }
                buffer.append(value.toString());
                continue;
            }
            if (c == '[') {
                parmIndex = 0;
                while (Character.isDigit(line.charAt(++position))) {
                    parmIndex *= 10;
                    parmIndex += line.charAt(position) - 48;
                }
                buffer.append(parms[parmIndex].toString());
                continue;
            }
            if (c == '\'') {
                char c2 = line.charAt(position + 1);
                if (c2 == '\'') {
                    buffer.append(c);
                    ++position;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
    }

    public static void formatLine(String line, StringBuffer buffer, Map<Integer, Object> parms) {
        for (int position = 0; position < line.length(); ++position) {
            int parmIndex;
            char c = line.charAt(position);
            if (c == '{') {
                parmIndex = 0;
                while (Character.isDigit(line.charAt(++position))) {
                    parmIndex *= 10;
                    parmIndex += line.charAt(position) - 48;
                }
                Object value = parms.get(parmIndex);
                if (value == null || value.equals("")) {
                    value = "<text unavailable>";
                }
                buffer.append(value.toString());
                continue;
            }
            if (c == '[') {
                parmIndex = 0;
                while (Character.isDigit(line.charAt(++position))) {
                    parmIndex *= 10;
                    parmIndex += line.charAt(position) - 48;
                }
                buffer.append(parms.get(parmIndex).toString());
                continue;
            }
            if (c == '\'') {
                char c2 = line.charAt(position + 1);
                if (c2 == '\'') {
                    buffer.append(c);
                    ++position;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
    }

    public static String formatDateTime(Date date) {
        return DateFormat.getDateTimeInstance(3, 3).format(date);
    }

    public static String formatTimeStamp(Date date) {
        return DateFormat.getDateTimeInstance(2, 0).format(date);
    }

    public static String formatTimeZone(String tz) {
        TimeZone tZone = TimeZone.getTimeZone(tz);
        int millisInHour = 3600000;
        int rawOffset = tZone.getRawOffset();
        Integer gmtOffset = new Integer(rawOffset / millisInHour);
        boolean useDST = tZone.useDaylightTime();
        String displayName = tZone.getDisplayName(useDST, 0);
        if (!useDST) {
            String gmtString = gmtOffset.toString();
            int gmtLength = gmtString.length();
            String[] zoneIDs = TimeZone.getAvailableIDs(gmtOffset * millisInHour);
            for (int i = 0; i < zoneIDs.length; ++i) {
                String tempDisplayName = TimeZone.getTimeZone(zoneIDs[i]).getDisplayName(useDST, 0);
                if (tempDisplayName.compareTo(displayName) == 0) {
                    i = zoneIDs.length;
                    continue;
                }
                if (!(gmtOffset > 0 ? displayName.indexOf(gmtString.substring(0, gmtLength)) != -1 : displayName.indexOf(gmtString.substring(1, gmtLength)) != -1)) continue;
                i = zoneIDs.length;
                displayName = tempDisplayName;
            }
        }
        if (displayName == null) {
            displayName = "";
        }
        return displayName;
    }

    public static void breakIntoThree(String input, String[] output) {
        Util.breakIntoTwo(input, output);
        if (output[1].length() == 1) {
            output[2] = " ";
        } else {
            String temp = output[0];
            Util.breakIntoTwo(output[1], output);
            output[2] = output[1];
            output[1] = output[0];
            output[0] = temp;
        }
    }

    public static void breakIntoTwo(String input, String[] output) {
        if (input == null || input.length() == 0) {
            output[0] = " ";
            output[1] = " ";
        } else if (input.charAt(0) == '\n') {
            output[0] = " ";
            output[1] = input.length() < 2 ? " " : input.substring(1);
        } else {
            output[0] = input;
            output[1] = " ";
            for (int i = 1; i < input.length(); ++i) {
                if (input.charAt(i) != '\n') continue;
                output[0] = input.substring(0, i);
                if (++i >= input.length()) break;
                output[1] = input.substring(i);
                break;
            }
        }
    }

    public static List splitLine(String line, int pos) {
        LinkedList<String> result = new LinkedList<String>();
        int length = line.length();
        boolean going = true;
        while (true) {
            if (pos < length && Character.isWhitespace(line.charAt(pos))) {
                ++pos;
                continue;
            }
            if (pos >= length) {
                going = false;
            } else {
                int i;
                for (i = pos + 1; i < length && !Character.isWhitespace(line.charAt(i)); ++i) {
                }
                result.add(line.substring(pos, i));
                pos = i;
            }
            if (!going) break;
        }
        return result;
    }

    public static String getString(String key) {
        String value = MessageLog.getMessageNoID(key);
        if (value.equals("<text unavailable>")) {
            value = key;
        }
        return value;
    }

    public static String getString(String key, String insert1) {
        String[] args = new String[]{insert1};
        String resourceString = Util.getString(key, args);
        return resourceString;
    }

    public static String getString(String key, String insert1, String insert2) {
        String[] args = new String[]{insert1, insert2};
        String resourceString = Util.getString(key, args);
        return resourceString;
    }

    public static String getString(String key, String[] inserts) {
        String resourceString = Util.getString(key);
        String message = IntlMessageFormat.format(resourceString, inserts);
        return message;
    }

    public static String getTranslatedName(String key) {
        if (key == null) {
            return "";
        }
        int keyLength = key.length();
        if (keyLength > 8 && key.startsWith("Default.")) {
            int n = "Default".length() + 1;
            String substring = key.substring(n, keyLength);
            StringBuffer fullString = new StringBuffer("Default.");
            return fullString.append(Util.getString(substring)).toString();
        }
        if (keyLength > 8 && key.startsWith("DiskDefault.")) {
            int n = "DiskDefault".length() + 1;
            String substring = key.substring(n, keyLength);
            StringBuffer fullString = new StringBuffer("DiskDefault.");
            return fullString.append(Util.getString(substring)).toString();
        }
        if (keyLength > 8 && key.startsWith("FabricDefault.")) {
            int n = "FabricDefault".length() + 1;
            String substring = key.substring(n, keyLength);
            StringBuffer fullString = new StringBuffer("FabricDefault.");
            return fullString.append(Util.getString(substring)).toString();
        }
        if (keyLength > 8 && key.startsWith("TapeDefault.")) {
            int n = "TapeDefault".length() + 1;
            String substring = key.substring(n, keyLength);
            StringBuffer fullString = new StringBuffer("TapeDefault.");
            return fullString.append(Util.getString(substring)).toString();
        }
        if (keyLength <= 4) {
            return key;
        }
        String substring = key.substring(0, 4);
        if (substring.equals("SQL_")) {
            return Util.getString(key);
        }
        return key;
    }

    public static void printKeyValuePair(PrintWriter writer, String key, String value) {
        Util.printKeyValuePair(writer, key, value, false);
    }

    public static void printKeyValuePair(PrintWriter writer, String key, String value, boolean quoteValue) {
        StringBuffer buffer = new StringBuffer(64);
        buffer.setLength(0);
        buffer.append(key);
        buffer.append('=');
        if (quoteValue) {
            buffer.append('\"');
            buffer.append(value);
            buffer.append('\"');
        } else {
            buffer.append(value);
        }
        writer.println(buffer.toString());
    }

    public static String charToHex(String strIN, int outLen) {
        String inHex;
        if (strIN == null) {
            return null;
        }
        char[] work = new char[outLen];
        try {
            inHex = Integer.toHexString(Integer.parseInt(strIN)).toUpperCase();
        }
        catch (NumberFormatException e) {
            return null;
        }
        int inLen = inHex.length();
        work = new char[outLen];
        int iDiff = outLen - inLen;
        if (iDiff < 0) {
            outLen = inLen;
            iDiff = 0;
        }
        int i = 0;
        int z = 0;
        if (iDiff > 0) {
            for (i = 0; i < iDiff; ++i) {
                work[i] = 48;
            }
        }
        while (i < outLen) {
            work[i] = inHex.charAt(z);
            ++z;
            ++i;
        }
        return String.valueOf(work);
    }

    public static String charHexToDecimal(String strIN) {
        if (strIN == null) {
            return null;
        }
        try {
            return Integer.toString(Integer.parseInt(strIN, 16));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean deleteTree(File dir) {
        return Util.deleteTree(dir, true);
    }

    private static boolean deleteTree(File file, boolean complete) {
        File[] files;
        boolean deleteStatus = complete;
        if (file.isDirectory() && (files = file.listFiles()) != null && files.length != 0) {
            for (int i = 0; i < files.length; ++i) {
                Util.deleteTree(files[i], complete);
            }
        }
        if (!file.delete() || !deleteStatus) {
            deleteStatus = false;
        }
        return deleteStatus;
    }

    static {
        manager.initialize();
    }
}

