/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.constants.metadata;

import org.eclipse.aperi.constants.metadata.MetadataManager;

public class AlertProductManager {
    public static final String EXTENSION_POINT_ID = "org.eclipse.aperi.common.alertProductSources";
    public static final String NAME = "org.eclipse.aperi.constants.metadata.AlertProduct.Name";
    public static final String SNMP_OID = "org.eclipse.aperi.constants.metadata.AlertProduct.SnmpOID";
    public static final String SUBPRODUCT_COUNT = "org.eclipse.aperi.constants.metadata.AlertProduct.SubproductCount";
    public static final String ALERT_LOG_USER_HELP = "org.eclipse.aperi.constants.metadata.AlertProduct.AlertLogUserHelp";
    public static final String ALERT_LOG_ACTIVE_HELP = "org.eclipse.aperi.constants.metadata.AlertProduct.AlertLogActiveHelp";
    private static final MetadataManager manager = new MetadataManager("org.eclipse.aperi.common.alertProductSources");

    public static MetadataManager getMetadataManager() {
        return manager;
    }

    public static String getName(short alertProduct) {
        return (String)AlertProductManager.get(alertProduct, NAME);
    }

    public static int[] getSnmpOid(short alertProduct) {
        return (int[])AlertProductManager.get(alertProduct, SNMP_OID);
    }

    public static short getSubproductCount(short alertProduct) {
        Short value = (Short)AlertProductManager.get(alertProduct, SUBPRODUCT_COUNT);
        if (value != null) {
            return value;
        }
        return 0;
    }

    public static boolean isValidSubproduct(byte subproduct) {
        return subproduct >= 0 && subproduct < 9;
    }

    public static String getAlertLogUserHelp(short alertProduct) {
        String value = (String)AlertProductManager.get(alertProduct, ALERT_LOG_USER_HELP);
        if (value != null) {
            return value;
        }
        return "welcome_gettingstarted";
    }

    public static String getAlertLogActiveHelp(short alertProduct) {
        String value = (String)AlertProductManager.get(alertProduct, ALERT_LOG_ACTIVE_HELP);
        if (value != null) {
            return value;
        }
        return "welcome_gettingstarted";
    }

    public static Object get(short alertProduct, String metadataKey) {
        return manager.get(alertProduct, metadataKey);
    }

    static {
        manager.initialize();
    }
}

