/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.constants.metadata;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.aperi.constants.metadata.IMetadataManagerListener;
import org.eclipse.aperi.constants.metadata.IMetadataSource;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataManager
implements IRegistryChangeListener,
IDisposable {
    public static final String ATTR_CLASS = "class";
    private String extensionPointId;
    private Set<IMetadataManagerListener> listenerSet;
    private Map<String, IMetadataSource> metadataSourceCache;
    private ReadWriteLock cacheLock;

    public MetadataManager(String extensionPointId) {
        this.extensionPointId = extensionPointId;
        this.listenerSet = new HashSet<IMetadataManagerListener>();
        this.metadataSourceCache = new HashMap<String, IMetadataSource>();
        this.cacheLock = new ReentrantReadWriteLock(true);
    }

    public void initialize() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(this.extensionPointId);
            for (int i = 0; i < elements.length; ++i) {
                try {
                    this.addSource(elements[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            throw new RuntimeException("Failed to obtain reference to extension registry.");
        }
        registry.addRegistryChangeListener((IRegistryChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.cacheLock.writeLock().lock();
        try {
            RegistryFactory.getRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
            for (IMetadataSource source : this.metadataSourceCache.values()) {
                try {
                    source.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.metadataSourceCache.clear();
            this.listenerSet.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        for (int i = 0; i < deltas.length; ++i) {
            int n;
            IExtension extension = deltas[i].getExtension();
            if (!extension.getExtensionPointUniqueIdentifier().equals(this.extensionPointId)) continue;
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (deltas[i].getKind() == 1) {
                for (n = 0; n < elements.length; ++n) {
                    try {
                        this.addSource(elements[n]);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            if (deltas[i].getKind() != 2) continue;
            for (n = 0; n < elements.length; ++n) {
                try {
                    this.removeSource(elements[n]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object constantValue, String metadataKey) {
        Object metadataValue = null;
        this.cacheLock.readLock().lock();
        try {
            Iterator<IMetadataSource> sourceIt = this.metadataSourceCache.values().iterator();
            while (sourceIt.hasNext() && (metadataValue = sourceIt.next().getValue(constantValue, metadataKey)) == null) {
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        return metadataValue;
    }

    public Lock getCacheReadLock() {
        return this.cacheLock.readLock();
    }

    public Set<?> getSupportedConstants() {
        return this.getSupportedConstants(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<?> getSupportedConstants(boolean sorted) {
        AbstractSet supportedConstants = sorted ? new TreeSet() : new HashSet();
        this.cacheLock.readLock().lock();
        try {
            Iterator<IMetadataSource> sourceIt = this.metadataSourceCache.values().iterator();
            while (sourceIt.hasNext()) {
                supportedConstants.addAll(sourceIt.next().getSupportedConstants());
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        return supportedConstants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IMetadataManagerListener listener) {
        Set<IMetadataManagerListener> set = this.listenerSet;
        synchronized (set) {
            this.listenerSet.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IMetadataManagerListener listener) {
        Set<IMetadataManagerListener> set = this.listenerSet;
        synchronized (set) {
            this.listenerSet.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSource(IConfigurationElement sourceElement) throws Exception {
        this.cacheLock.writeLock().lock();
        try {
            String sourceName = sourceElement.getAttribute(ATTR_CLASS);
            if (this.metadataSourceCache.containsKey(sourceName)) {
                throw new RuntimeException("Metadata source named " + sourceName + " is already registred.");
            }
            IMetadataSource source = (IMetadataSource)sourceElement.createExecutableExtension(ATTR_CLASS);
            this.metadataSourceCache.put(sourceName, source);
            Set<IMetadataManagerListener> set = this.listenerSet;
            synchronized (set) {
                Iterator<IMetadataManagerListener> listenerIt = this.listenerSet.iterator();
                while (listenerIt.hasNext()) {
                    try {
                        listenerIt.next().metadataSourceAdded(source);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSource(IConfigurationElement sourceElement) throws Exception {
        block9: {
            this.cacheLock.writeLock().lock();
            try {
                String sourceName = sourceElement.getAttribute(ATTR_CLASS);
                IMetadataSource source = this.metadataSourceCache.remove(sourceName);
                if (source == null) break block9;
                Set<IMetadataManagerListener> set = this.listenerSet;
                synchronized (set) {
                    Iterator<IMetadataManagerListener> listenerIt = this.listenerSet.iterator();
                    while (listenerIt.hasNext()) {
                        try {
                            listenerIt.next().metadataSourceRemoved(source);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                source.dispose();
            }
            finally {
                this.cacheLock.writeLock().unlock();
            }
        }
    }
}

