/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.discovery.RemoveMissingUtils;
import org.eclipse.aperi.discovery.interfaces.IRemoveMissingProcessor;
import org.eclipse.aperi.disk.api.IDiskManagementService;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.discovery.SubsystemDBHelper;
import org.eclipse.aperi.gui.tape.common.model.TapeLibraryDBHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.objects.Fabric2switch;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.Node2hba;
import org.eclipse.aperi.infrastructure.database.objects.Pe2node;
import org.eclipse.aperi.infrastructure.database.objects.PhyPe;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.Port2port;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2port;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBlade;
import org.eclipse.aperi.infrastructure.database.objects.Zone;
import org.eclipse.aperi.infrastructure.database.objects.Zone2member;
import org.eclipse.aperi.infrastructure.database.objects.ZoneMember;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.infrastructure.database.objects.Zset2zone;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class RemoveMissingProcessor
implements IRemoveMissingProcessor {
    private static final String className = RemoveMissingProcessor.class.getName();
    public static final String MESSAGE_NAME = "aperi.logger.message.RemoveMissing";
    public static final String TRACE_NAME = "aperi.logger.trace.RemoveMissing";
    public static String MSG_FILE = "org.eclipse.aperi.resources.RemoveMissingProcessorTMS";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    private static HashMap classMap = new HashMap();
    HashSet entityGroups = null;
    private IDiskManagementService cMgmtOps = null;
    private TapeLibraryDBHelper cTapeDBHelper = null;
    private boolean isHostRemovable = true;
    private static boolean TRACE = TraceLogger.enableTrace;

    public RemoveMissingProcessor() {
        this(null, -1);
    }

    public RemoveMissingProcessor(String pDeviceServerHost, int pDeviceServerPort) {
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
        this.cMgmtOps = (IDiskManagementService)ConnectorClient.getService((String)pDeviceServerHost, (int)pDeviceServerPort, IDiskManagerService.class, (String)"DiskManagerService");
        this.cTapeDBHelper = new TapeLibraryDBHelper();
        TRACE = TraceLogger.enableTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized short performDeletionForSelectedMissingEntities(String[] objectNames) {
        String msg;
        String methodName = "performDeletionForSelectedMissingEntities";
        boolean bool = false;
        DBConnection dbConn = null;
        this.isHostRemovable = true;
        if (TRACE) {
            TraceLogger.entry(className, methodName, objectNames.toString());
            msg = "";
            if (objectNames != null && objectNames.length > 0) {
                StringBuffer names = new StringBuffer();
                for (int i = 0; i < objectNames.length; ++i) {
                    names.append(objectNames[i]);
                    names.append("||");
                }
                msg = objectNames.length + " missing entities: " + names.toString() + " are selected.";
                TraceLogger.traceMessage(1, className, methodName, msg);
            } else {
                msg = "No missing entity selected.";
                TraceLogger.traceMessage(1, className, methodName, msg);
            }
        }
        try {
            dbConn = RemoveMissingUtils.getDBConnection();
            HashSet tmpEntityGroups = this.determineSelectedMissingList(objectNames, dbConn);
            bool = !tmpEntityGroups.isEmpty() ? this.processDeleteMissing(tmpEntityGroups, dbConn) : true;
        }
        catch (Exception e) {
            TraceLogger.exception(className, methodName, e);
        }
        finally {
            RemoveMissingUtils.closeConnection(dbConn);
        }
        if (!this.isHostRemovable) {
            if (bool) {
                if (TRACE) {
                    msg = "Remove success except selected host is not removable.";
                    TraceLogger.traceMessage(1, className, methodName, msg);
                    TraceLogger.exit(className, methodName);
                }
                return 100;
            }
            if (TRACE) {
                msg = "Remove failed and selected host is not removable.";
                TraceLogger.traceMessage(1, className, methodName, msg);
                TraceLogger.exit(className, methodName);
            }
            return 12;
        }
        if (bool) {
            if (TRACE) {
                msg = "Remove success.";
                TraceLogger.traceMessage(1, className, methodName, msg);
                TraceLogger.exit(className, methodName);
            }
            return 0;
        }
        if (TRACE) {
            msg = "Remove failed.";
            TraceLogger.traceMessage(1, className, methodName, msg);
            TraceLogger.exit(className, methodName);
        }
        return 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized short performScheduledDeletionForMissingEntity(String entityType, String entityId) {
        String methodName = "performScheduledDeletionForMissingEntity";
        short dbChangesMade = 0;
        String[] objectNames = null;
        HashSet<String> tmpDevices = new HashSet<String>();
        String timeStamp = null;
        DBResultSet tmpDeviceRS = null;
        DBConnection dbConn = null;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (entityId != null) {
            objectNames = new String[]{entityType + ':' + entityId};
        } else {
            try {
                dbConn = RemoveMissingUtils.getDBConnection();
                if (entityType.equals("switch")) {
                    tmpDeviceRS = RemoveMissingUtils.getAllMissingSwitches(timeStamp, dbConn);
                    while (tmpDeviceRS.next()) {
                        String switchId = "" + tmpDeviceRS.getInt("switchId");
                        tmpDevices.add("switch:" + switchId);
                    }
                } else if (entityType.equals("fabric")) {
                    tmpDeviceRS = RemoveMissingUtils.getAllMissingFabrics(timeStamp, dbConn);
                    while (tmpDeviceRS.next()) {
                        String fabricId = "" + tmpDeviceRS.getInt("fabricId");
                        tmpDevices.add("fabric:" + fabricId);
                    }
                } else if (entityType.equals("tapelibrary")) {
                    tmpDeviceRS = RemoveMissingUtils.getAllMissingTapeLibraries(timeStamp, dbConn);
                    while (tmpDeviceRS.next()) {
                        String libId = "" + tmpDeviceRS.getInt("libId");
                        tmpDevices.add("tapelibrary:" + libId);
                    }
                }
            }
            catch (Exception ep) {
                ep.printStackTrace();
            }
            finally {
                if (tmpDeviceRS != null) {
                    try {
                        tmpDeviceRS.getStatement().close();
                    }
                    catch (Exception ex) {}
                }
                RemoveMissingUtils.closeConnection(dbConn);
            }
        }
        try {
            if (tmpDevices.size() > 0) {
                objectNames = tmpDevices.toArray(new String[0]);
            }
            if (objectNames != null) {
                dbChangesMade = this.performDeletionForSelectedMissingEntities(objectNames);
            }
        }
        catch (Exception e) {
            traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return dbChangesMade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean performScheduledFabricDeletion() {
        String methodName = "performScheduledFabricDeletion";
        short rc = 12;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (TRACE) {
            TraceLogger.entry(className, methodName, "");
        }
        String[] objectNames = this.getExpiredFabricEntities();
        DBConnection dbConn = null;
        if (TRACE) {
            if (objectNames != null && objectNames.length > 0) {
                StringBuffer names = new StringBuffer();
                for (int i = 0; i < objectNames.length; ++i) {
                    names.append(objectNames[i]);
                    names.append("||");
                }
                String msg = "Deleting " + objectNames.length + " required missing obects...";
                TraceLogger.traceMessage(1, className, methodName, msg);
            } else {
                String msg = "No required missing entity found.";
                TraceLogger.traceMessage(1, className, methodName, msg);
            }
        }
        if (objectNames != null && objectNames.length > 0) {
            try {
                dbConn = RemoveMissingUtils.getDBConnection();
                dbConn.setAutoCommit(false);
                for (int i = 0; i < objectNames.length; ++i) {
                    int index = objectNames[i].indexOf(58);
                    String devClass = objectNames[i].substring(0, index);
                    String devKey = objectNames[i].substring(index + 1);
                    this.deleteEntityWithRetry(devClass, devKey, dbConn);
                }
                dbConn.commit();
                rc = 0;
            }
            catch (SQLException ep) {
                ep.printStackTrace();
                try {
                    dbConn.rollback();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            finally {
                RemoveMissingUtils.closeConnection(dbConn);
            }
        } else {
            rc = 0;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, rc);
        }
        if (rc == 0) {
            if (TRACE) {
                String msg = "Success";
                TraceLogger.traceMessage(1, className, methodName, msg);
            }
            return true;
        }
        if (TRACE) {
            String msg = "Failed.";
            TraceLogger.traceMessage(1, className, methodName, msg);
        }
        return false;
    }

    public synchronized boolean performScheduledTapeDeletion() {
        boolean isDeletedSubentities;
        String methodName = "performScheduledTapeDeletion";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        short rc = 12;
        if (TRACE) {
            TraceLogger.entry(className, methodName, "");
        }
        String[] objectNames = this.getExpiredTapeLibraries();
        if (TRACE) {
            if (objectNames != null && objectNames.length > 0) {
                StringBuffer names = new StringBuffer();
                for (int i = 0; i < objectNames.length; ++i) {
                    names.append(objectNames[i]);
                    names.append("||");
                }
                String msg = "Deleting " + objectNames.length + " required missing obects...";
                TraceLogger.traceMessage(1, className, methodName, msg);
            } else {
                String msg = "No required missing entity found.";
                TraceLogger.traceMessage(1, className, methodName, msg);
            }
        }
        if (objectNames != null && objectNames.length > 0) {
            try {
                for (int i = 0; i < objectNames.length; ++i) {
                    int index = objectNames[i].indexOf(58);
                    String devClass = objectNames[i].substring(0, index);
                    String devKey = objectNames[i].substring(index + 1);
                    this.handleTape(devClass, devKey);
                }
            }
            catch (Exception ep) {
                if (TRACE) {
                    TraceLogger.exception(className, methodName, ep);
                }
                rc = 12;
            }
        }
        rc = (isDeletedSubentities = this.handleExpiredTapeSubentities()) ? (short)0 : 12;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, rc);
        }
        if (rc == 0) {
            if (TRACE) {
                String msg = "Success";
                TraceLogger.traceMessage(1, className, methodName, msg);
            }
            return true;
        }
        if (TRACE) {
            String msg = "Failed.";
            TraceLogger.traceMessage(1, className, methodName, msg);
        }
        return false;
    }

    public synchronized boolean performScheduledSubsystemDeletion() {
        boolean isDeletedSubentities;
        String methodName = "performScheduledSubsystemDeletion";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        short rc = 12;
        if (TRACE) {
            TraceLogger.entry(className, methodName, "");
        }
        String[] objectNames = this.getExpiredSubsystems();
        if (TRACE) {
            if (objectNames != null && objectNames.length > 0) {
                StringBuffer names = new StringBuffer();
                for (int i = 0; i < objectNames.length; ++i) {
                    names.append(objectNames[i]);
                    names.append("||");
                }
                String msg = "Deleting " + objectNames.length + " required missing obects...";
                TraceLogger.traceMessage(1, className, methodName, msg);
            } else {
                String msg = "No required missing entity found.";
                TraceLogger.traceMessage(1, className, methodName, msg);
            }
        }
        if (objectNames != null && objectNames.length > 0) {
            try {
                for (int i = 0; i < objectNames.length; ++i) {
                    int index = objectNames[i].indexOf(58);
                    String devClass = objectNames[i].substring(0, index);
                    String devKey = objectNames[i].substring(index + 1);
                    this.handleSubsystem(devClass, devKey);
                }
            }
            catch (Exception ep) {
                ep.printStackTrace();
                rc = 12;
            }
        }
        rc = (isDeletedSubentities = this.handleExpiredSubsystemSubentities()) ? (short)0 : 12;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, rc);
        }
        if (rc == 0) {
            if (TRACE) {
                String msg = "Success";
                TraceLogger.traceMessage(1, className, methodName, msg);
            }
            return true;
        }
        if (TRACE) {
            String msg = "Failed.";
            TraceLogger.traceMessage(1, className, methodName, msg);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getExpiredFabricEntities() {
        String methodName = "getExpiredFabricEntities";
        ArrayList expiredEntities = new ArrayList();
        DBConnection dbConn = RemoveMissingUtils.getDBConnection();
        if (RemoveMissingUtils.isBadConnection(methodName, dbConn)) {
            return null;
        }
        try {
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("fabric", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("fabric2switch", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("switch", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("blade", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("switch2port", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("host", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("hba", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("node2hba", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("pe", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("pe2node", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("node", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("port", dbConn));
            expiredEntities.addAll(RemoveMissingUtils.getExpiredMissingEntities("port2port", dbConn));
            if (expiredEntities != null) {
                String[] expiredEntitiesStringArray;
                String[] stringArray = expiredEntitiesStringArray = expiredEntities.toArray(new String[expiredEntities.size()]);
                return stringArray;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            RemoveMissingUtils.closeConnection(dbConn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getExpiredTapeLibraries() {
        String methodName = "getExpiredFabricEntities";
        ArrayList expiredEntities = null;
        DBConnection dbConn = RemoveMissingUtils.getDBConnection();
        if (RemoveMissingUtils.isBadConnection(methodName, dbConn)) {
            return null;
        }
        try {
            expiredEntities = RemoveMissingUtils.getExpiredMissingEntities("tapelibrary", dbConn);
            if (expiredEntities != null) {
                String[] expiredEntitiesStringArray;
                String[] stringArray = expiredEntitiesStringArray = expiredEntities.toArray(new String[expiredEntities.size()]);
                return stringArray;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            RemoveMissingUtils.closeConnection(dbConn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getExpiredSubsystems() {
        String methodName = "getExpiredFabricEntities";
        ArrayList expiredEntities = null;
        DBConnection dbConn = RemoveMissingUtils.getDBConnection();
        if (RemoveMissingUtils.isBadConnection(methodName, dbConn)) {
            return null;
        }
        try {
            expiredEntities = RemoveMissingUtils.getExpiredMissingEntities("subsystem", dbConn);
            if (expiredEntities != null) {
                String[] expiredEntitiesStringArray;
                String[] stringArray = expiredEntitiesStringArray = expiredEntities.toArray(new String[expiredEntities.size()]);
                return stringArray;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            RemoveMissingUtils.closeConnection(dbConn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleExpiredTapeSubentities() {
        String methodName = "handleExpiredTapesubentities";
        if (TRACE) {
            TraceLogger.entry(className, methodName, "");
        }
        boolean rcTapeDrives = false;
        boolean rcTapeMediaChangers = false;
        ArrayList expiredSubentitiesIDs = null;
        Integer[] arrAutoIDs = null;
        int totExpired = 0;
        DBConnection dbConn = RemoveMissingUtils.getDBConnection();
        if (RemoveMissingUtils.isBadConnection(methodName, dbConn)) {
            return false;
        }
        try {
            int i;
            expiredSubentitiesIDs = RemoveMissingUtils.getExpiredMissingEntities("tapedrive", "tapelibrary", dbConn);
            if (expiredSubentitiesIDs != null && expiredSubentitiesIDs.size() != 0) {
                arrAutoIDs = expiredSubentitiesIDs.toArray(new Integer[expiredSubentitiesIDs.size()]);
                rcTapeDrives = this.cTapeDBHelper.deleteTapeDrivesByID(RemoveMissingProcessor.getPrimitiveIntArray(arrAutoIDs));
                if (TRACE) {
                    if (!rcTapeDrives) {
                        TraceLogger.traceMessage(1, className, methodName, "Error while deleting tape drives. some missing tape drives may not have been deleted.");
                    }
                    TraceLogger.traceMessage(1, className, methodName, "List of expired tape drives:");
                    totExpired += arrAutoIDs.length;
                    for (i = 0; i < arrAutoIDs.length; ++i) {
                        TraceLogger.traceMessage(1, className, methodName, "entity[" + i + "]=" + arrAutoIDs[i]);
                    }
                }
            }
            expiredSubentitiesIDs = null;
            arrAutoIDs = null;
            expiredSubentitiesIDs = RemoveMissingUtils.getExpiredMissingEntities("tapemediachanger", "tapelibrary", dbConn);
            if (expiredSubentitiesIDs != null && expiredSubentitiesIDs.size() != 0) {
                arrAutoIDs = expiredSubentitiesIDs.toArray(new Integer[expiredSubentitiesIDs.size()]);
                rcTapeMediaChangers = this.cTapeDBHelper.deleteTapeMediaChangersByID(RemoveMissingProcessor.getPrimitiveIntArray(arrAutoIDs));
                if (TRACE) {
                    if (!rcTapeMediaChangers) {
                        TraceLogger.traceMessage(1, className, methodName, "Error while deleting tape media changers. some expired missing media changers may not have been deleted.");
                    }
                    TraceLogger.traceMessage(1, className, methodName, "List of expired tape media changers:");
                    totExpired += arrAutoIDs.length;
                    for (i = 0; i < arrAutoIDs.length; ++i) {
                        TraceLogger.traceMessage(1, className, methodName, "entity[" + i + "]=" + arrAutoIDs[i]);
                    }
                }
            }
        }
        catch (Exception ee) {
            if (TRACE) {
                TraceLogger.exception(className, methodName, ee);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            RemoveMissingUtils.closeConnection(dbConn);
        }
        if (totExpired == 0 && TRACE) {
            TraceLogger.traceMessage(1, className, methodName, "No expired subsystem subentities found.");
            TraceLogger.exit(className, methodName);
        }
        return rcTapeMediaChangers && rcTapeDrives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleExpiredSubsystemSubentities() {
        String methodName = "handleExpiredSubsystemSubentities";
        if (TRACE) {
            TraceLogger.entry(className, methodName, "");
        }
        boolean rc = true;
        ArrayList expiredSubentitiesIDs = null;
        Integer[] arrAutoIDs = null;
        int totExpired = 0;
        DBConnection dbConn = RemoveMissingUtils.getDBConnection();
        if (RemoveMissingUtils.isBadConnection(methodName, dbConn)) {
            return false;
        }
        try {
            int i;
            expiredSubentitiesIDs = RemoveMissingUtils.getExpiredMissingEntities("storagevolume", "subsystem", dbConn);
            if (expiredSubentitiesIDs != null && expiredSubentitiesIDs.size() != 0) {
                arrAutoIDs = expiredSubentitiesIDs.toArray(new Integer[expiredSubentitiesIDs.size()]);
                rc = SubsystemDBHelper.deleteStorageVolumes(RemoveMissingProcessor.getPrimitiveIntArray(arrAutoIDs));
                if (TRACE) {
                    TraceLogger.traceMessage(1, className, methodName, "List of expired storage volumes:");
                }
                totExpired += arrAutoIDs.length;
                for (i = 0; i < arrAutoIDs.length; ++i) {
                    if (!TRACE) continue;
                    TraceLogger.traceMessage(1, className, methodName, "entity[" + i + "]=" + arrAutoIDs[i]);
                }
            }
            expiredSubentitiesIDs = null;
            arrAutoIDs = null;
            expiredSubentitiesIDs = RemoveMissingUtils.getExpiredMissingEntities("storagepool", "subsystem", dbConn);
            if (expiredSubentitiesIDs != null && expiredSubentitiesIDs.size() != 0) {
                arrAutoIDs = expiredSubentitiesIDs.toArray(new Integer[expiredSubentitiesIDs.size()]);
                boolean bl = rc = rc && SubsystemDBHelper.deleteStoragePools(RemoveMissingProcessor.getPrimitiveIntArray(arrAutoIDs));
                if (TRACE) {
                    TraceLogger.traceMessage(1, className, methodName, "List of expired storage pools:");
                }
                totExpired += arrAutoIDs.length;
                for (i = 0; i < arrAutoIDs.length; ++i) {
                    if (!TRACE) continue;
                    TraceLogger.traceMessage(1, className, methodName, "entity[" + i + "]=" + arrAutoIDs[i]);
                }
            }
            expiredSubentitiesIDs = null;
            arrAutoIDs = null;
            expiredSubentitiesIDs = RemoveMissingUtils.getExpiredMissingEntities("physicalvolume", "subsystem", dbConn);
            if (expiredSubentitiesIDs != null && expiredSubentitiesIDs.size() != 0) {
                arrAutoIDs = expiredSubentitiesIDs.toArray(new Integer[expiredSubentitiesIDs.size()]);
                boolean bl = rc = rc && SubsystemDBHelper.deletePhysicalVolumes(RemoveMissingProcessor.getPrimitiveIntArray(arrAutoIDs));
                if (TRACE) {
                    TraceLogger.traceMessage(1, className, methodName, "List of expired physical volumes:");
                }
                totExpired += arrAutoIDs.length;
                for (i = 0; i < arrAutoIDs.length; ++i) {
                    if (!TRACE) continue;
                    TraceLogger.traceMessage(1, className, methodName, "entity[" + i + "]=" + arrAutoIDs[i]);
                }
            }
            expiredSubentitiesIDs = null;
            arrAutoIDs = null;
            expiredSubentitiesIDs = RemoveMissingUtils.getExpiredMissingEntities("port", "subsystem", dbConn);
            if (expiredSubentitiesIDs != null && expiredSubentitiesIDs.size() != 0) {
                arrAutoIDs = expiredSubentitiesIDs.toArray(new Integer[expiredSubentitiesIDs.size()]);
                boolean bl = rc = rc && SubsystemDBHelper.deletePorts(RemoveMissingProcessor.getPrimitiveIntArray(arrAutoIDs));
                if (TRACE) {
                    TraceLogger.traceMessage(1, className, methodName, "List of expired subsystem ports:");
                }
                totExpired += arrAutoIDs.length;
                for (i = 0; i < arrAutoIDs.length; ++i) {
                    if (!TRACE) continue;
                    TraceLogger.traceMessage(1, className, methodName, "entity[" + i + "]=" + arrAutoIDs[i]);
                }
            }
        }
        catch (Exception ee) {
            if (TRACE) {
                TraceLogger.exception(className, methodName, ee);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            RemoveMissingUtils.closeConnection(dbConn);
        }
        if (totExpired == 0 && TRACE) {
            TraceLogger.traceMessage(1, className, methodName, "No expired subsystem subentities found.");
            TraceLogger.exit(className, methodName);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private HashSet determineMissingEntitiesByDeviceTypes(String[] deviceTypes, String timeStamp, DBConnection dbConn) {
        methodName = "detrmineMissingEntitiesByDeviceTypes";
        tmpDevices = new HashSet<String>();
        tmpEntityGroups = new HashSet();
        tmpDeviceRS = null;
        if (RemoveMissingProcessor.traceLogger.isLogging()) {
            RemoveMissingProcessor.traceLogger.entry(IRecordType.TYPE_API, (Object)RemoveMissingProcessor.className, methodName, deviceTypes);
        }
lbl7:
        // 5 sources

        try {
            for (i = 0; i < deviceTypes.length; ++i) {
                devClass = deviceTypes[i];
                try {
                    block31: {
                        if (!devClass.equals("switch")) break block31;
                        tmpDeviceRS = RemoveMissingUtils.getAllMissingSwitches(timeStamp, dbConn);
                        while (tmpDeviceRS.next()) {
                            switchId = "" + tmpDeviceRS.getInt("switchId");
                            tmpDevices.add("switch:" + switchId);
                        }
                        ** GOTO lbl7
                    }
                    if (!devClass.equals("fabric")) continue;
                    tmpDeviceRS = RemoveMissingUtils.getAllMissingFabrics(timeStamp, dbConn);
                    while (tmpDeviceRS.next()) {
                        fabricId = "" + tmpDeviceRS.getInt("fabricId");
                        tmpDevices.add("fabric:" + fabricId);
                    }
                    ** GOTO lbl7
                }
                catch (Exception ep) {
                    if (!RemoveMissingProcessor.traceLogger.isLogging()) continue;
                    RemoveMissingProcessor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, RemoveMissingProcessor.className, methodName, ep);
                    continue;
                }
                finally {
                    if (tmpDeviceRS != null) {
                        try {
                            tmpDeviceRS.getStatement().close();
                        }
                        catch (Exception ex) {}
                    }
                }
            }
            if (tmpDevices.size() > 0) {
                objectNames = (String[])tmpDevices.toArray();
                tmpEntityGroups = this.determineSelectedMissingList(objectNames, dbConn);
            }
        }
        catch (Exception e) {
            RemoveMissingProcessor.traceLogger.exception(IRecordType.TYPE_ERROR, RemoveMissingProcessor.className, methodName, e);
        }
        finally {
            if (tmpDeviceRS != null) {
                try {
                    tmpDeviceRS.getStatement().close();
                }
                catch (Exception ex) {}
            }
        }
        if (RemoveMissingProcessor.traceLogger.isLogging()) {
            RemoveMissingProcessor.traceLogger.exit(IRecordType.TYPE_EXIT, RemoveMissingProcessor.className, methodName);
        }
        return tmpEntityGroups;
    }

    private HashSet determineSelectedMissingList(String[] objectNames, DBConnection dbConn) {
        String methodName = "determineSelectedMissingList";
        HashSet outerArray = new HashSet();
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, objectNames);
        }
        if (objectNames == null) {
            String[] deviceTypes = new String[]{"fabric"};
            String timestamp = "currenttime";
            outerArray = this.determineMissingEntitiesByDeviceTypes(deviceTypes, timestamp, dbConn);
        } else {
            for (int i = 0; i < objectNames.length; ++i) {
                HashSet<String> tempList;
                int index = objectNames[i].indexOf(58);
                String devClass = objectNames[i].substring(0, index);
                String devKey = objectNames[i].substring(index + 1);
                if (devClass.equals("host")) {
                    if (RemoveMissingUtils.isHostRemovable(devKey)) {
                        tempList = new HashSet<String>();
                        tempList.add(objectNames[i]);
                        tempList.addAll(this.determineMissingSubEntityCollection(devClass, devKey, dbConn));
                        outerArray.add(tempList);
                        if (!TRACE) continue;
                        TraceLogger.traceMessage(1, className, methodName, objectNames[i] + " is removable");
                        continue;
                    }
                    traceLogger.text(IRecordType.TYPE_WARN, className, methodName, objectNames[i] + " is not removable");
                    if (TRACE) {
                        TraceLogger.traceMessage(1, className, methodName, objectNames[i] + " is not removable");
                    }
                    this.isHostRemovable = false;
                    continue;
                }
                if (devClass.equals("switch")) {
                    HashSet<String> tempList2;
                    String fabricId = this.getFabricIdOnlyHasThisSwitch(devKey);
                    if (fabricId != null && !fabricId.equals("")) {
                        devClass = "fabric";
                        devKey = fabricId;
                        tempList2 = new HashSet();
                        tempList2.add(devClass + ':' + devKey);
                        tempList2.addAll(this.determineMissingSubEntityCollection(devClass, devKey, dbConn));
                        outerArray.add(tempList2);
                        continue;
                    }
                    tempList2 = new HashSet<String>();
                    tempList2.add(objectNames[i]);
                    tempList2.addAll(this.determineMissingSubEntityCollection(devClass, devKey, dbConn));
                    outerArray.add(tempList2);
                    continue;
                }
                if (devClass.equals("fabric")) {
                    tempList = new HashSet();
                    tempList.add(objectNames[i]);
                    tempList.addAll(this.determineMissingSubEntityCollection(devClass, devKey, dbConn));
                    outerArray.add(tempList);
                    if (!RemoveMissingUtils.isPhysicalFabric(devKey)) continue;
                    ArrayList vsanIds = this.getMissingVsansForFabric(devKey, dbConn);
                    Iterator vsanIterator = vsanIds.iterator();
                    while (vsanIterator.hasNext()) {
                        tempList = new HashSet();
                        devClass = "fabric";
                        devKey = (String)vsanIterator.next();
                        tempList.add(devClass + ':' + devKey);
                        tempList.addAll(this.determineMissingSubEntityCollection(devClass, devKey, dbConn));
                        outerArray.add(tempList);
                    }
                    continue;
                }
                tempList = new HashSet();
                tempList.add(objectNames[i]);
                tempList.addAll(this.determineMissingSubEntityCollection(devClass, devKey, dbConn));
                outerArray.add(tempList);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return outerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HashSet getMissingSubEntitiesForSwitch(String switchId, DBConnection dbConn) {
        HashSet<String> missingSwitchSubEntities;
        String methodName;
        block44: {
            Exception ex222222;
            DBResultSet switch2portRS;
            DBResultSet bladeRS;
            DBResultSet fabric2switchRS;
            DBResultSet portRS;
            block38: {
                String portId;
                int state;
                methodName = "getMissingSubEntitiesForSwitch";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, className, methodName);
                }
                missingSwitchSubEntities = new HashSet<String>();
                portRS = null;
                fabric2switchRS = null;
                bladeRS = null;
                switch2portRS = null;
                fabric2switchRS = RemoveMissingUtils.getFabric2SwitchForSwitch(switchId, dbConn);
                while (fabric2switchRS.next()) {
                    String fabric2switchId = "" + fabric2switchRS.getInt("fabric2switchId");
                    state = fabric2switchRS.getInt("state");
                    if (state != 0) continue;
                    missingSwitchSubEntities.add("fabric2switch:" + fabric2switchId);
                }
                bladeRS = RemoveMissingUtils.getBladesForSwitch(switchId, dbConn);
                while (bladeRS.next()) {
                    String bladeId = "" + bladeRS.getInt("bladeId");
                    state = bladeRS.getInt("state");
                    if (state != 0) continue;
                    missingSwitchSubEntities.add("blade:" + bladeId);
                }
                switch2portRS = RemoveMissingUtils.getSwitch2PortForSwitch(switchId, dbConn);
                while (switch2portRS.next()) {
                    portId = "" + switch2portRS.getInt("switch2portId");
                    state = switch2portRS.getInt("state");
                    if (state != 0) continue;
                    missingSwitchSubEntities.add("switch2port:" + portId);
                }
                portRS = RemoveMissingUtils.getPortsForSwitch(switchId, dbConn);
                while (portRS.next()) {
                    portId = "" + portRS.getInt("portId");
                    state = portRS.getInt("state");
                    if (state != 0) continue;
                    missingSwitchSubEntities.add("port:" + portId);
                    missingSwitchSubEntities.addAll(this.getMissingSubEntitiesForPort(portId, dbConn));
                }
                Object var12_12 = null;
                if (portRS == null) break block38;
                try {
                    portRS.getStatement().close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (bladeRS != null) {
                try {
                    bladeRS.getStatement().close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (fabric2switchRS != null) {
                try {
                    fabric2switchRS.getStatement().close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (switch2portRS != null) {
                try {
                    switch2portRS.getStatement().close();
                }
                catch (Exception ex222222) {}
            }
            break block44;
            {
                catch (Exception ep) {
                    Exception ex222222;
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ep);
                    }
                    Object var12_13 = null;
                    if (portRS != null) {
                        try {
                            portRS.getStatement().close();
                        }
                        catch (Exception ex222222) {
                            // empty catch block
                        }
                    }
                    if (bladeRS != null) {
                        try {
                            bladeRS.getStatement().close();
                        }
                        catch (Exception ex222222) {
                            // empty catch block
                        }
                    }
                    if (fabric2switchRS != null) {
                        try {
                            fabric2switchRS.getStatement().close();
                        }
                        catch (Exception ex222222) {
                            // empty catch block
                        }
                    }
                    if (switch2portRS != null) {
                        try {
                            switch2portRS.getStatement().close();
                        }
                        catch (Exception ex222222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception ex222222;
                Object var12_14 = null;
                if (portRS != null) {
                    try {
                        portRS.getStatement().close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (bladeRS != null) {
                    try {
                        bladeRS.getStatement().close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (fabric2switchRS != null) {
                    try {
                        fabric2switchRS.getStatement().close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (switch2portRS != null) {
                    try {
                        switch2portRS.getStatement().close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return missingSwitchSubEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet getMissingSubEntitiesForPort(String portId, DBConnection dbConn) {
        String methodName = "getMissingSubEntitiesForPort";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, portId);
        }
        HashSet<String> missingPortSubEntities = new HashSet<String>();
        DBResultSet port2portRS = null;
        try {
            port2portRS = RemoveMissingUtils.getPort2portForPort(portId, dbConn);
            while (port2portRS.next()) {
                int state = port2portRS.getInt("state");
                String port2portId = "" + port2portRS.getInt("port2portId");
                if (state != 0) continue;
                missingPortSubEntities.add("port2port:" + port2portId);
            }
        }
        catch (Exception ep) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ep);
            }
        }
        finally {
            if (port2portRS != null) {
                try {
                    port2portRS.getStatement().close();
                }
                catch (Exception ex) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return missingPortSubEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet getMissingSubEntitiesForNode(String nodeId, DBConnection dbConn) {
        String methodName = "getMissingSubEntitiesForNode";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, nodeId);
        }
        HashSet<String> missingNodeSubEntities = new HashSet<String>();
        DBResultSet portRS = null;
        DBResultSet node2hbaRS = null;
        try {
            int state;
            portRS = RemoveMissingUtils.getPortsForNode(nodeId, dbConn);
            while (portRS.next()) {
                String portId = "" + portRS.getInt("portId");
                state = portRS.getInt("state");
                if (state != 0) continue;
                missingNodeSubEntities.add("port:" + portId);
                missingNodeSubEntities.addAll(this.getMissingSubEntitiesForPort(portId, dbConn));
            }
            node2hbaRS = RemoveMissingUtils.getNode2HBAForNode(nodeId, dbConn);
            while (node2hbaRS.next()) {
                String node2hbaId = "" + node2hbaRS.getInt("node2hbaId");
                state = node2hbaRS.getInt("state");
                if (state != 0) continue;
                missingNodeSubEntities.add("node2hba:" + node2hbaId);
            }
        }
        catch (Exception ep) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ep);
            }
        }
        finally {
            if (portRS != null) {
                try {
                    portRS.getStatement().close();
                }
                catch (Exception ex) {}
            }
            if (node2hbaRS != null) {
                try {
                    node2hbaRS.getStatement().close();
                }
                catch (Exception ex) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return missingNodeSubEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HashSet getMissingSubEntitiesForFabric(String fabricId, DBConnection dbConn) {
        HashSet<String> missingSanSubEntities;
        String methodName;
        block73: {
            Exception ex222222;
            DBResultSet zoneMemberRS;
            DBResultSet zoneSetRS;
            DBResultSet zoneRS;
            DBResultSet nodeRS;
            DBResultSet peRS;
            DBResultSet hostRS;
            DBResultSet switchRS;
            block61: {
                int state;
                methodName = "getMissingSubEntitiesForFabric";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, fabricId);
                }
                missingSanSubEntities = new HashSet<String>();
                switchRS = null;
                hostRS = null;
                peRS = null;
                nodeRS = null;
                zoneRS = null;
                zoneSetRS = null;
                zoneMemberRS = null;
                switchRS = RemoveMissingUtils.getSwitchesForFabric(fabricId, dbConn);
                while (switchRS.next()) {
                    String switchId = "" + switchRS.getInt("switchId");
                    int state1 = switchRS.getInt("state1");
                    int state2 = switchRS.getInt("state2");
                    String fabric2switchId = "" + switchRS.getInt("fabric2switchId");
                    if (state1 == 0) {
                        missingSanSubEntities.add("switch:" + switchId);
                        missingSanSubEntities.addAll(this.getMissingSubEntitiesForSwitch(switchId, dbConn));
                    }
                    if (state2 != 0) continue;
                    missingSanSubEntities.add("fabric2switch:" + fabric2switchId);
                }
                hostRS = RemoveMissingUtils.getHostsForFabric(fabricId, dbConn);
                while (hostRS.next()) {
                    String hostId = "" + hostRS.getInt("hostId");
                    state = hostRS.getInt("state");
                    if (state == 0 && RemoveMissingUtils.isHostRemovable(hostId)) {
                        missingSanSubEntities.add("host:" + hostId);
                    }
                    missingSanSubEntities.addAll(this.getMissingSubEntitiesForHost(hostId, dbConn));
                }
                peRS = RemoveMissingUtils.getPEsForFabric(fabricId, dbConn);
                while (peRS.next()) {
                    String peId = "" + peRS.getInt("peId");
                    state = peRS.getInt("state");
                    if (state != 0) continue;
                    missingSanSubEntities.add("pe:" + peId);
                    missingSanSubEntities.addAll(this.getMissingSubEntitiesForPE(peId, dbConn));
                }
                nodeRS = RemoveMissingUtils.getNodesForFabric(fabricId, dbConn);
                while (nodeRS.next()) {
                    String nodeId = "" + nodeRS.getInt("nodeId");
                    state = nodeRS.getInt("state");
                    if (state != 0) continue;
                    missingSanSubEntities.add("node:" + nodeId);
                    missingSanSubEntities.addAll(this.getMissingSubEntitiesForNode(nodeId, dbConn));
                }
                Object var17_17 = null;
                if (switchRS == null) break block61;
                try {
                    switchRS.getStatement().close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (hostRS != null) {
                try {
                    hostRS.getStatement().close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (peRS != null) {
                try {
                    peRS.getStatement().close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (nodeRS != null) {
                try {
                    nodeRS.getStatement().close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (zoneRS != null) {
                try {
                    zoneRS.getStatement().close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (zoneSetRS != null) {
                try {
                    zoneSetRS.getStatement().close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (zoneMemberRS != null) {
                try {
                    zoneMemberRS.getStatement().close();
                }
                catch (Exception ex222222) {}
            }
            break block73;
            {
                catch (Exception ep) {
                    Exception ex222222;
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ep);
                    }
                    Object var17_18 = null;
                    if (switchRS != null) {
                        try {
                            switchRS.getStatement().close();
                        }
                        catch (Exception ex222222) {
                            // empty catch block
                        }
                    }
                    if (hostRS != null) {
                        try {
                            hostRS.getStatement().close();
                        }
                        catch (Exception ex222222) {
                            // empty catch block
                        }
                    }
                    if (peRS != null) {
                        try {
                            peRS.getStatement().close();
                        }
                        catch (Exception ex222222) {
                            // empty catch block
                        }
                    }
                    if (nodeRS != null) {
                        try {
                            nodeRS.getStatement().close();
                        }
                        catch (Exception ex222222) {
                            // empty catch block
                        }
                    }
                    if (zoneRS != null) {
                        try {
                            zoneRS.getStatement().close();
                        }
                        catch (Exception ex222222) {
                            // empty catch block
                        }
                    }
                    if (zoneSetRS != null) {
                        try {
                            zoneSetRS.getStatement().close();
                        }
                        catch (Exception ex222222) {
                            // empty catch block
                        }
                    }
                    if (zoneMemberRS != null) {
                        try {
                            zoneMemberRS.getStatement().close();
                        }
                        catch (Exception ex222222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception ex222222;
                Object var17_19 = null;
                if (switchRS != null) {
                    try {
                        switchRS.getStatement().close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (hostRS != null) {
                    try {
                        hostRS.getStatement().close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (peRS != null) {
                    try {
                        peRS.getStatement().close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (nodeRS != null) {
                    try {
                        nodeRS.getStatement().close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (zoneRS != null) {
                    try {
                        zoneRS.getStatement().close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (zoneSetRS != null) {
                    try {
                        zoneSetRS.getStatement().close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (zoneMemberRS != null) {
                    try {
                        zoneMemberRS.getStatement().close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return missingSanSubEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet getMissingSubEntitiesForZone(String zoneId, DBConnection dbConn) {
        String methodName = "getMissingSubEntitiesForZone";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, zoneId);
        }
        HashSet<String> missingZoneSubEntities = new HashSet<String>();
        DBResultSet zoneSet2ZoneRS = null;
        DBResultSet zone2MemberRS = null;
        try {
            boolean state;
            zoneSet2ZoneRS = RemoveMissingUtils.getZoneSet2ZonesForZone(zoneId, dbConn);
            while (zoneSet2ZoneRS.next()) {
                state = false;
                String zset2zoneId = "" + zoneSet2ZoneRS.getInt("zset2zoneId");
                if (state) continue;
                missingZoneSubEntities.add("zset2zone:" + zset2zoneId);
            }
            zone2MemberRS = RemoveMissingUtils.getZone2MembersForZone(zoneId, dbConn);
            while (zone2MemberRS.next()) {
                state = false;
                String zone2memberId = "" + zone2MemberRS.getInt("zone2memberId");
                if (state) continue;
                missingZoneSubEntities.add("zone2member:" + zone2memberId);
            }
        }
        catch (Exception ep) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ep);
            }
        }
        finally {
            if (zoneSet2ZoneRS != null) {
                try {
                    zoneSet2ZoneRS.getStatement().close();
                }
                catch (Exception ex) {}
            }
            if (zone2MemberRS != null) {
                try {
                    zone2MemberRS.getStatement().close();
                }
                catch (Exception ex) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return missingZoneSubEntities;
    }

    private HashSet getMissingSubEntitiesForZoneSet(String zoneSetId, DBConnection dbConn) {
        String methodName = "getMissingSubEntitiesForZoneSet";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, zoneSetId);
        }
        HashSet missingZoneSetSubEntities = new HashSet();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return missingZoneSetSubEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet getMissingSubEntitiesForPE(String peId, DBConnection dbConn) {
        String methodName = "getMissingSubEntitiesForPE";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, peId);
        }
        HashSet<String> missingPESubEntities = new HashSet<String>();
        DBResultSet nodeRS = null;
        try {
            nodeRS = RemoveMissingUtils.getNodesForPE(peId, dbConn);
            while (nodeRS.next()) {
                String nodeId = "" + nodeRS.getInt("nodeId");
                String pe2nodeId = "" + nodeRS.getInt("pe2nodeId");
                int state = nodeRS.getInt("state1");
                int state2 = nodeRS.getInt("state2");
                if (state == 0) {
                    missingPESubEntities.add("node:" + nodeId);
                    missingPESubEntities.addAll(this.getMissingSubEntitiesForNode(nodeId, dbConn));
                }
                if (state2 != 0) continue;
                missingPESubEntities.add("pe2node:" + pe2nodeId);
            }
        }
        catch (Exception ep) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ep);
            }
        }
        finally {
            if (nodeRS != null) {
                try {
                    nodeRS.getStatement().close();
                }
                catch (Exception ex) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return missingPESubEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet getMissingSubEntitiesForHost(String hostId, DBConnection dbConn) {
        String methodName = "getMissingSubEntitiesForHost";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, hostId);
        }
        HashSet<String> missingHostSubEntities = new HashSet<String>();
        DBResultSet hbaRS = null;
        try {
            hbaRS = RemoveMissingUtils.getHBAsForHost(hostId, dbConn);
            while (hbaRS.next()) {
                String hbaId = "" + hbaRS.getInt("hbaId");
                int state = hbaRS.getInt("state");
                if (state != 0) continue;
                missingHostSubEntities.add("hba:" + hbaId);
                missingHostSubEntities.addAll(this.getMissingSubEntitiesForHBA(hbaId, dbConn));
            }
        }
        catch (Exception ep) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ep);
            }
        }
        finally {
            if (hbaRS != null) {
                try {
                    hbaRS.getStatement().close();
                }
                catch (Exception ex) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return missingHostSubEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet getMissingSubEntitiesForHBA(String hbaId, DBConnection dbConn) {
        String methodName = "getMissingSubEntitiesForHBA";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, hbaId);
        }
        HashSet<String> missingHBASubEntities = new HashSet<String>();
        DBResultSet nodeRS = null;
        try {
            nodeRS = RemoveMissingUtils.getNodesForHBA(hbaId, dbConn);
            while (nodeRS.next()) {
                String nodeId = "" + nodeRS.getInt("nodeId");
                String node2hbaId = "" + nodeRS.getInt("node2hbaId");
                int state1 = nodeRS.getInt("state1");
                int state2 = nodeRS.getInt("state2");
                if (state1 == 0) {
                    missingHBASubEntities.add("node:" + nodeId);
                    missingHBASubEntities.addAll(this.getMissingSubEntitiesForNode(nodeId, dbConn));
                }
                if (state2 != 0) continue;
                missingHBASubEntities.add("node2hba:" + node2hbaId);
            }
        }
        catch (Exception ep) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ep);
            }
        }
        finally {
            if (nodeRS != null) {
                try {
                    nodeRS.getStatement().close();
                }
                catch (Exception ex) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return missingHBASubEntities;
    }

    private HashSet determineDeletionTypes(HashSet entityGroups) {
        String methodName = "determineDeletionTypes";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        HashSet<String> nlsDeletionClasses = new HashSet<String>();
        for (HashSet entityGroup : entityGroups) {
            for (String entity : entityGroup) {
                String devClass = entity.substring(0, 2);
                String nlsDevClass = (String)classMap.get(devClass);
                if (nlsDevClass == null) continue;
                nlsDeletionClasses.add(nlsDevClass);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return nlsDeletionClasses;
    }

    private String convertHashSetToString(HashSet list) {
        String methodName = "convertHashSetToString";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        String classTypes = null;
        if (list.size() != 0) {
            Iterator it = list.iterator();
            int i = 0;
            String separator = " ";
            String tempClassType = null;
            while (it.hasNext()) {
                tempClassType = (String)it.next();
                classTypes = classTypes == null ? tempClassType + separator : classTypes + tempClassType + separator;
                ++i;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return classTypes;
    }

    private boolean processDeleteMissing(HashSet entityGroups, DBConnection dbConn) {
        String methodName = "processDeleteMissing";
        boolean dbChangesMade = false;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, entityGroups);
        }
        Iterator groups = entityGroups.iterator();
        ViewReportTablesUpdater vrtu = new ViewReportTablesUpdater();
        try {
            if (dbConn == null) {
                return dbChangesMade;
            }
            while (groups.hasNext()) {
                String entityClass = null;
                String entityKey = null;
                try {
                    dbConn.setAutoCommit(false);
                    HashSet group = (HashSet)groups.next();
                    for (String entity : group) {
                        int index = entity.indexOf(58);
                        entityClass = entity.substring(0, index);
                        entityKey = entity.substring(index + 1);
                        this.deleteEntity(dbConn, entityClass, entityKey);
                        vrtu.deleteDependentViews(entityClass, entityKey);
                    }
                    dbConn.commit();
                    dbChangesMade = true;
                }
                catch (Exception dbEx) {
                    traceLogger.text(IRecordType.TYPE_WARN, className, methodName, entityClass + entityKey + " is not deleted.");
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, dbEx);
                    if (dbConn != null) {
                        try {
                            dbConn.rollback();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    dbChangesMade = false;
                }
            }
        }
        catch (Exception ex) {
            traceLogger.exception(IRecordType.TYPE_EXIT, className, methodName, ex);
            dbChangesMade = false;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        vrtu = null;
        return dbChangesMade;
    }

    private void deleteEntity(DBConnection dbConn, String devClass, String devKey) throws SQLException {
        String methodName = "deleteMissingEntity";
        String msg = "Deleted missing entity: " + devClass + devKey;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{devClass, devKey});
        }
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        if (devClass.equals("port")) {
            htWhereClause.put(Port.getColumnInfo("PORT_ID"), devKey);
            htWhereClause.put(Port.getColumnInfo("DETECTABLE"), "0");
            Port.deletes(dbConn, htWhereClause);
            RemoveMissingUtils.deleteAttributeSnapshot(devClass, devKey, dbConn);
        } else if (devClass.equals("node")) {
            htWhereClause.put(Node.getColumnInfo("NODE_ID"), devKey);
            htWhereClause.put(Node.getColumnInfo("DETECTABLE"), "0");
            Node.deletes(dbConn, htWhereClause);
            RemoveMissingUtils.deleteAttributeSnapshot(devClass, devKey, dbConn);
        } else if (devClass.equals("hba")) {
            htWhereClause.put(Hba.getColumnInfo("HBA_ID"), devKey);
            htWhereClause.put(Hba.getColumnInfo("DETECTABLE"), "0");
            Hba.deletes(dbConn, htWhereClause);
            RemoveMissingUtils.markHBAPortAsNormalPort(devKey, dbConn);
            RemoveMissingUtils.deleteAttributeSnapshot(devClass, devKey, dbConn);
        } else if (devClass.equals("host")) {
            htWhereClause.put(Host.getColumnInfo("COMPUTER_ID"), devKey);
            htWhereClause.put(Host.getColumnInfo("DETECTABLE"), "0");
            Host.deletes(dbConn, htWhereClause);
            RemoveMissingUtils.deleteAttributeSnapshot(devClass, devKey, dbConn);
        } else if (devClass.equals("switch")) {
            String switchWWN = RemoveMissingUtils.getSwitchWWNById(devKey);
            if (switchWWN != null) {
                RemoveMissingUtils.deleteAttributeSnapshot(devClass, switchWWN, dbConn);
            }
            htWhereClause.put(Switch.getColumnInfo("SWITCH_ID"), devKey);
            htWhereClause.put(Switch.getColumnInfo("DETECTABLE"), "0");
            Switch.deletes(dbConn, htWhereClause);
        } else if (devClass.equals("blade")) {
            htWhereClause.put(SwitchBlade.getColumnInfo("SWITCH_BLADE_ID"), devKey);
            htWhereClause.put(SwitchBlade.getColumnInfo("DETECTABLE"), "0");
            SwitchBlade.deletes(dbConn, htWhereClause);
            RemoveMissingUtils.deleteAttributeSnapshot(devClass, devKey, dbConn);
        } else if (devClass.equals("fabric")) {
            String fabricWWN;
            if (RemoveMissingUtils.isPhysicalFabric(devKey)) {
                RemoveMissingUtils.markChildVsansAsRegular(devKey, dbConn);
            }
            if ((fabricWWN = RemoveMissingUtils.getFabricWWNById(devKey)) != null) {
                RemoveMissingUtils.deleteAttributeSnapshot(devClass, fabricWWN, dbConn);
            }
            htWhereClause.put(Fabric.getColumnInfo("FABRIC_ID"), devKey);
            htWhereClause.put(Fabric.getColumnInfo("DETECTABLE"), "0");
            Fabric.deletes(dbConn, htWhereClause);
        } else if (devClass.equals("pe")) {
            htWhereClause.put(PhyPe.getColumnInfo("PHY_PE_ID"), devKey);
            htWhereClause.put(PhyPe.getColumnInfo("DETECTABLE"), "0");
            PhyPe.deletes(dbConn, htWhereClause);
            RemoveMissingUtils.deleteAttributeSnapshot(devClass, devKey, dbConn);
        } else if (devClass.equals("pe2node")) {
            htWhereClause.put(Pe2node.getColumnInfo("PE2NODE_ID"), devKey);
            htWhereClause.put(Pe2node.getColumnInfo("DETECTABLE"), "0");
            Pe2node.deletes(dbConn, htWhereClause);
            RemoveMissingUtils.deleteAttributeSnapshot(devClass, devKey, dbConn);
        } else if (devClass.equals("port2port")) {
            htWhereClause.put(Port2port.getColumnInfo("PORT2PORT_ID"), devKey);
            htWhereClause.put(Port2port.getColumnInfo("DETECTABLE"), "0");
            Port2port.deletes(dbConn, htWhereClause);
            RemoveMissingUtils.deleteAttributeSnapshot(devClass, devKey, dbConn);
        } else if (devClass.equals("node2hba")) {
            htWhereClause.put(Node2hba.getColumnInfo("NODE2HBA_ID"), devKey);
            htWhereClause.put(Node2hba.getColumnInfo("DETECTABLE"), "0");
            Node2hba.deletes(dbConn, htWhereClause);
            RemoveMissingUtils.deleteAttributeSnapshot(devClass, devKey, dbConn);
        } else if (devClass.equals("fabric2switch")) {
            htWhereClause.put(Fabric2switch.getColumnInfo("FABRIC2SWITCH_ID"), devKey);
            htWhereClause.put(Fabric2switch.getColumnInfo("DETECTABLE"), "0");
            Fabric2switch.deletes(dbConn, htWhereClause);
            RemoveMissingUtils.deleteAttributeSnapshot(devClass, devKey, dbConn);
        } else if (devClass.equals("switch2port")) {
            htWhereClause.put(Switch2port.getColumnInfo("SWITCH2PORT_ID"), devKey);
            htWhereClause.put(Switch2port.getColumnInfo("DETECTABLE"), "0");
            Switch2port.deletes(dbConn, htWhereClause);
            RemoveMissingUtils.deleteAttributeSnapshot(devClass, devKey, dbConn);
        } else if (devClass.equals("zone")) {
            htWhereClause.put(Zone.getColumnInfo("ZONE_ID"), devKey);
            Zone.deletes(dbConn, htWhereClause);
        } else if (devClass.equals("zset")) {
            htWhereClause.put(Zset.getColumnInfo("ZSET_ID"), devKey);
            Zset.deletes(dbConn, htWhereClause);
        } else if (devClass.equals("zonemember")) {
            htWhereClause.put(ZoneMember.getColumnInfo("ZONE_MEMBER_ID"), devKey);
            ZoneMember.deletes(dbConn, htWhereClause);
        } else if (devClass.equals("zone2member")) {
            htWhereClause.put(Zone2member.getColumnInfo("ZONE2MEMBER_ID"), devKey);
            Zone2member.deletes(dbConn, htWhereClause);
        } else if (devClass.equals("zset2zone")) {
            htWhereClause.put(Zset2zone.getColumnInfo("ZSET2ZONE_ID"), devKey);
            Zset2zone.deletes(dbConn, htWhereClause);
        } else if (devClass.equals("subsystem")) {
            this.handleSubsystem(devClass, devKey);
        } else if (devClass.equals("tapelibrary")) {
            this.handleTape(devClass, devKey);
        } else {
            msg = devClass + devKey + "s not supported by RemovingMissing function.";
        }
        if (TRACE) {
            TraceLogger.traceMessage(1, className, methodName, msg);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubsystem(String devClass, String devKey) {
        DBConnection mConnection = null;
        String methodName = "handleSubsystem";
        try {
            mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            StorageSubsystem.StorageSubsystemCursor mSubsystemCursor = StorageSubsystem.getCursor(mConnection, null, null);
            while (mSubsystemCursor.next()) {
                StorageSubsystem mSubsystem = mSubsystemCursor.getObject();
                if (mSubsystem.getSubsystemId() != new Integer(devKey).intValue()) continue;
                String[] subsystemIDs = new String[]{(String)ExternalKeyConverter.getStorageSubsystemKey(mSubsystem)};
                this.cMgmtOps.deleteStorageSubsystems(subsystemIDs);
                break;
            }
        }
        catch (SQLException e1) {
            traceLogger.text(IRecordType.TYPE_ERROR_EXC, className, "handleSubsystem", devClass + devKey + e1.getStackTrace().toString());
        }
        finally {
            if (mConnection != null) {
                try {
                    mConnection.commit();
                    mConnection.close();
                }
                catch (SQLException e) {
                    traceLogger.text(IRecordType.TYPE_ERROR_EXC, className, "handleSubsystem", devClass + devKey + e.getStackTrace().toString());
                }
            }
        }
    }

    private void handleTape(String devClass, String devKey) {
        String methodName = "handleTape";
        this.cTapeDBHelper.deleteLibraryByID(Integer.parseInt(devKey));
    }

    private HashSet determineMissingSubEntityCollection(String devClass, String devKey, DBConnection dbConn) {
        String methodName = "determineMissingSubEntityCollection";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{devClass, devKey});
        }
        HashSet<String> underlyingObjects = new HashSet<String>();
        if (devClass.equals("port")) {
            underlyingObjects = this.getMissingSubEntitiesForPort(devKey, dbConn);
        } else if (devClass.equals("node")) {
            underlyingObjects = this.getMissingSubEntitiesForNode(devKey, dbConn);
        } else if (devClass.equals("switch")) {
            underlyingObjects = this.getMissingSubEntitiesForSwitch(devKey, dbConn);
        } else if (devClass.equals("fabric")) {
            underlyingObjects = this.getMissingSubEntitiesForFabric(devKey, dbConn);
        } else if (devClass.equals("pe")) {
            underlyingObjects = this.getMissingSubEntitiesForPE(devKey, dbConn);
        } else if (devClass.equals("hba")) {
            underlyingObjects = this.getMissingSubEntitiesForHBA(devKey, dbConn);
        } else if (devClass.equals("host")) {
            underlyingObjects = this.getMissingSubEntitiesForHost(devKey, dbConn);
        } else if (devClass.equals("port2port")) {
            underlyingObjects = new HashSet<String>();
            underlyingObjects.add(devClass + ':' + devKey);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, underlyingObjects);
        }
        return underlyingObjects;
    }

    private boolean deleteEntityWithRetry(String deviceType, String deviceId, DBConnection dbConn) throws SQLException {
        String methodName = "deleteEntityWithRetry";
        boolean bool = false;
        boolean toRetry = false;
        int numRetries = 3;
        do {
            try {
                this.deleteEntity(dbConn, deviceType, deviceId);
                toRetry = false;
                bool = true;
            }
            catch (SQLException e) {
                toRetry = true;
                if (--numRetries > 0) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    if (!TRACE) continue;
                    TraceLogger.traceMessage(1, className, methodName, "Unable to delete " + deviceType + deviceId + ". Retying...");
                    continue;
                }
                if (TRACE) {
                    TraceLogger.traceMessage(1, className, methodName, "Unable to delete " + deviceType + deviceId + ". " + numRetries + " retry attemped.");
                }
                throw e;
            }
        } while (toRetry && numRetries > 0);
        return bool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFabricIdOnlyHasThisSwitch(String switchId) {
        String myFabricId;
        block28: {
            String methodName = "getfabricIdOnlyHasThisSwitch";
            myFabricId = null;
            DBResultSet fabricRS = null;
            DBConnection dbConn = null;
            try {
                dbConn = RemoveMissingUtils.getDBConnection();
                fabricRS = RemoveMissingUtils.getFabricForSwitch(switchId, dbConn);
                if (!fabricRS.next()) break block28;
                String fabricId = "" + fabricRS.getInt("fabricId");
                int state = fabricRS.getInt("state");
                if (state != 0) break block28;
                boolean needToRemoveFabric = true;
                DBResultSet switchRS = null;
                try {
                    switchRS = RemoveMissingUtils.getSwitchesForFabric(fabricId, dbConn);
                    while (switchRS.next()) {
                        String tmpSwitchId = "" + switchRS.getInt("switchId");
                        if (tmpSwitchId.equals(switchId)) continue;
                        needToRemoveFabric = false;
                        break;
                    }
                    if (needToRemoveFabric) {
                        myFabricId = fabricId;
                    }
                }
                catch (Exception ep) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ep);
                    }
                }
                finally {
                    if (switchRS != null) {
                        try {
                            switchRS.getStatement().close();
                        }
                        catch (Exception ex) {}
                    }
                }
            }
            catch (Exception ep) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ep);
                }
            }
            finally {
                if (fabricRS != null) {
                    try {
                        fabricRS.getStatement().close();
                    }
                    catch (Exception ex) {}
                }
                RemoveMissingUtils.closeConnection(dbConn);
            }
        }
        return myFabricId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getMissingVsansForFabric(String fabricId, DBConnection dbConn) {
        String methodName = "getMissingVsansForFabric";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        HashSet missingVsansForFabric = new HashSet();
        DBResultSet vsanRS = null;
        ArrayList<String> vsanIds = new ArrayList<String>();
        try {
            vsanRS = RemoveMissingUtils.getVsansForFabric(fabricId, dbConn);
            while (vsanRS.next()) {
                String vsanId = "" + vsanRS.getInt("vsanId");
                int vsanState = vsanRS.getInt("vsanState");
                if (vsanState != 0) continue;
                vsanIds.add(vsanId);
            }
        }
        catch (Exception ep) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ep);
            }
        }
        finally {
            if (vsanRS != null) {
                try {
                    vsanRS.getStatement().close();
                }
                catch (Exception ex) {}
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return vsanIds;
    }

    public static int[] getPrimitiveIntArray(Integer[] arrAutoIDs) {
        int[] intArrayOfAutoIDs = new int[arrAutoIDs.length];
        for (int i = 0; i < arrAutoIDs.length; ++i) {
            intArrayOfAutoIDs[i] = arrAutoIDs[i];
        }
        return intArrayOfAutoIDs;
    }

    public static void main(String[] args) {
        if (args.length == 0 || args.length > 2) {
            return;
        }
        RemoveMissingProcessor rp = new RemoveMissingProcessor();
        if (args.length == 1) {
            String[] entity = new String[]{args[0]};
            rp.performDeletionForSelectedMissingEntities(entity);
        } else if (args.length == 2) {
            rp.performScheduledDeletionForMissingEntity(args[0], args[1]);
        }
    }
}

