/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.interfaces;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Observable;
import org.eclipse.aperi.sanmgmt.logging.ILogger;

public class Request
extends Observable
implements Serializable {
    public static final int WAITING = -2;
    public static final int SUBMITTED = -1;
    public static final int FAILED = 0;
    public static final int SUCCESSFUL = 1;
    public static final int RUNNING = 2;
    public static final int WARNING = 3;
    public static final int PARTIAL_FAILURE = 4;
    public static final int CANCELLED = 5;
    private String deviceServerRunNumber = "";
    private boolean running = true;
    private int status = 2;
    private boolean mainProcess = false;
    private HashSet requests = new HashSet();
    private Request parentRequest = null;
    private ILogger jobLogger = null;
    private boolean externalJobLogger = true;
    private boolean noJobManagement = false;
    private int id;
    private int rc = 0;
    private String scannerId = null;
    private int authoritativeReferenceType = -1;
    private int authoritativeReferenceId = -1;
    private String jobPrefix = null;

    public Request(int id, String deviceServerRunNumber, Request parentRequest, ILogger jobLogger, boolean externalJobLogger, boolean noJobManagement, boolean mainProcess, String scannerId, int authoritativeReferenceType, int authoritativeReferenceId, String jobPrefix) {
        this.id = id;
        this.mainProcess = mainProcess;
        this.deviceServerRunNumber = deviceServerRunNumber;
        this.parentRequest = parentRequest;
        this.noJobManagement = noJobManagement;
        this.jobLogger = jobLogger;
        this.externalJobLogger = externalJobLogger;
        if (parentRequest != null) {
            parentRequest.addChildRequest(this);
        }
        this.scannerId = scannerId;
        this.authoritativeReferenceType = authoritativeReferenceType;
        this.authoritativeReferenceId = authoritativeReferenceId;
        this.jobPrefix = jobPrefix;
    }

    public int getId() {
        return this.id;
    }

    public boolean isExternalJobLogger() {
        return this.externalJobLogger;
    }

    public boolean isNoJobManagement() {
        return this.noJobManagement;
    }

    public String getDeviceServerRunNumber() {
        return this.deviceServerRunNumber;
    }

    public void setDeviceServerRunNumber(String deviceServerRunNumber) {
        this.deviceServerRunNumber = deviceServerRunNumber;
    }

    public Request getParentRequest() {
        return this.parentRequest;
    }

    public void setParentRequest(Request parentRequest) {
        this.parentRequest = parentRequest;
    }

    public void addChildRequest(Request ID2) {
        this.requests.add(ID2);
    }

    public void removeChildRequest(Request ID2) {
        this.requests.remove(ID2);
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isMainProcess() {
        return this.mainProcess;
    }

    public boolean hasRunningChildRequests() {
        return !this.requests.isEmpty();
    }

    public Request[] getChildRequests() {
        return this.requests.toArray(new Request[0]);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public ILogger getJobLogger() {
        return this.jobLogger;
    }

    public void setReturnCode(int returnCode) {
        this.rc = returnCode;
    }

    public int getReturnCode() {
        return this.rc;
    }

    public String getScannerId() {
        return this.scannerId;
    }

    public int getAuthoritativeReferenceType() {
        return this.authoritativeReferenceType;
    }

    public int getAuthoritativeReferenceId() {
        return this.authoritativeReferenceId;
    }

    public String getJobPrefix() {
        return this.jobPrefix;
    }
}

