/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import com.ibm.log.Level;
import java.util.Properties;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.disk.DiskManagerConfiguration;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class DiskManagerConfigSvc {
    private static final String DM_CONFIG_GROUP = "DiskManager";
    private static DiskManagerConfigSvc stSingletongInstance = null;
    private IConfigService cConfigService = null;

    private DiskManagerConfigSvc() {
    }

    public static DiskManagerConfigSvc get() {
        return stSingletongInstance;
    }

    private void bindConfigService() {
        this.cConfigService = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
    }

    private String getConfValue(String pKey, String pDefault) {
        String mRetVal = null;
        try {
            mRetVal = this.cConfigService.getProperty(pKey, DM_CONFIG_GROUP);
        }
        catch (Exception mEx) {
            ILogger mTrcLogger = LogManagerFactory.getMessageLogger("aperi.logger.trace.DiskManager");
            mTrcLogger.exception(Level.ERROR, this, "getConfValue", mEx);
        }
        return mRetVal == null ? pDefault : mRetVal;
    }

    public static String getConfigValue(String pKey, String pDefault) {
        return DiskManagerConfigSvc.get().getConfValue(pKey, pDefault);
    }

    public static boolean getBooleanConfigValue(String pKey, boolean pDefault) {
        boolean mReturn = pDefault;
        String mVal = DiskManagerConfigSvc.get().getConfValue(pKey, null);
        if (mVal == null) {
            return mReturn;
        }
        mReturn = Boolean.valueOf(mVal);
        return mReturn;
    }

    public static int getIntConfigValue(String pKey, int pDefault) {
        int mReturn = pDefault;
        String mVal = DiskManagerConfigSvc.get().getConfValue(pKey, null);
        if (mVal == null) {
            return mReturn;
        }
        try {
            mReturn = Integer.parseInt(mVal);
        }
        catch (NumberFormatException pEx) {
            mReturn = pDefault;
        }
        return mReturn;
    }

    public static long getLongConfigValue(String pKey, long pDefault) {
        long mReturn = pDefault;
        String mVal = DiskManagerConfigSvc.get().getConfValue(pKey, null);
        if (mVal == null) {
            return mReturn;
        }
        try {
            mReturn = Long.parseLong(mVal);
        }
        catch (NumberFormatException pEx) {
            mReturn = pDefault;
        }
        return mReturn;
    }

    public void checkDefaultConfig() {
        try {
            Properties mProps = this.cConfigService.getProperties(DM_CONFIG_GROUP);
            String mKey = null;
            for (int bIndex = 0; bIndex < DiskManagerConfiguration.DM_DEFAULT_CONFIG.length; ++bIndex) {
                mKey = DiskManagerConfiguration.DM_DEFAULT_CONFIG[bIndex][0];
                if (mProps.getProperty(mKey) != null) continue;
                this.cConfigService.setProperty(mKey, DM_CONFIG_GROUP, DiskManagerConfiguration.DM_DEFAULT_CONFIG[bIndex][1]);
            }
        }
        catch (RuntimeException pEx) {
            ILogger mTrcLogger = LogManagerFactory.getMessageLogger("aperi.logger.trace.DiskManager");
            mTrcLogger.exception(Level.ERROR, this, "checkdefaultConfig", pEx);
        }
    }

    static {
        stSingletongInstance = new DiskManagerConfigSvc();
        stSingletongInstance.bindConfigService();
    }
}

