/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.MapableReusable;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerRTException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.BatchHandle;
import org.sblim.wbem.client.BatchResult;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;
import org.sblim.wbem.client.indications.CIMListener;
import org.sblim.wbem.util.SessionProperties;

public class CIMClientWrapper
implements MapableReusable {
    private static final String SVC_NAME = "External CIM request";
    private static final long SVC_TIMEOUT_DEFAULT = 600000L;
    private long cTimeout = 600000L;
    private Map cMethodTimeouts = null;
    public CIMClient cCIMClnt = null;
    private static Map stCIMOMLocks = Collections.synchronizedMap(new HashMap());
    private static Boolean stSynchronizationEnabled = null;
    private static Boolean stSaxParsingEnabled = null;
    private String cServiceURL = null;
    private Object cLock = new Object();
    private String cKey = null;
    private boolean cIsInPool = false;
    private boolean useCimPool = true;
    public static final String TRACE_NAME = "aperi.logger.trace.CIMScanner";
    public static ILogger traceLogger = null;
    public static String className = CIMClientWrapper.class.getName();

    public CIMClientWrapper(String pUserID, String pPassword, String pServiceURL, String pNameSpace) throws CIMException {
        this(pUserID, pPassword, pServiceURL, pNameSpace, false);
    }

    public CIMClientWrapper(CIMClient client) throws CIMException {
        this.cCIMClnt = client;
        this.cKey = client.toString();
        this.cMethodTimeouts = new HashMap();
        this.cTimeout = this.getCfgTimeout();
        this.getServiceURL();
        this.useCimPool = false;
    }

    protected CIMClientWrapper(String pUserID, String pPassword, String pServiceURL, String pNameSpace, boolean useCimPool) throws CIMException {
        UserPrincipal mUser = new UserPrincipal(pUserID);
        PasswordCredential mCreds = null;
        mCreds = pPassword != null ? new PasswordCredential(pPassword.toCharArray()) : new PasswordCredential();
        CIMNameSpace mNS = new CIMNameSpace(pServiceURL, pNameSpace);
        this.cCIMClnt = new CIMClient(mNS, (Principal)mUser, (Object)mCreds);
        this.cKey = CIMClientWrapper.generateKey(pUserID, pPassword, pServiceURL, pNameSpace);
        this.cMethodTimeouts = new HashMap();
        this.cTimeout = this.getCfgTimeout();
        this.cServiceURL = pServiceURL;
        this.useCimPool = useCimPool;
    }

    protected static String generateKey(String pUserID, String pPassword, String pServiceURL, String pNameSpace) {
        return pServiceURL + pUserID + pPassword + pNameSpace;
    }

    public Object getMappingKey() {
        return this.cKey;
    }

    public void initializeInstance(String pUserID, String pPassword, String pServiceURL, String pNameSpace) throws CIMException {
    }

    public void clearInstance() {
        this.cTimeout = this.getCfgTimeout();
    }

    public boolean isInPool() {
        return this.cIsInPool;
    }

    public void setIsInPool(boolean pInPool) {
        this.cIsInPool = pInPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInstance() {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "releaseInstance", null);
        try {
            mLTH.traceHigh("ObjectID: " + this.getAddress() + " ThreadName: " + Thread.currentThread().getName());
            if (!this.isInPool()) {
                this.clearInstance();
                this.cCIMClnt.close();
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object executeSvcCall(String pMethod, Class[] pParamClasses, Object[] pParams, LogTraceHelper pLTH) throws DiskManagerTimeoutException, CIMException {
        Object lock;
        Throwable mError;
        String methodName;
        block33: {
            methodName = "executeSvcCall";
            Object mReturn = null;
            mError = null;
            Long mTimeout = (Long)this.cMethodTimeouts.get(pMethod);
            try {
                try {
                    if (pLTH != null) {
                        pLTH.traceSvcEntry(SVC_NAME, pParams);
                        pLTH.traceHigh("ObjectID: " + this.getAddress() + " ThreadName: " + Thread.currentThread().getName());
                    } else {
                        if (traceLogger.isLogging()) {
                            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, pParams);
                        }
                        traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "ObjectID: " + this.getAddress() + " ThreadName: " + Thread.currentThread().getName());
                    }
                    if (this.isSaxParsingNeeded()) {
                        SessionProperties mSessionProps = (SessionProperties)SessionProperties.getGlobalProperties().clone();
                        mSessionProps.setXmlParser(1);
                        this.cCIMClnt.setSessionProperties(mSessionProps);
                        if (pLTH != null) {
                            pLTH.traceHigh("Using SAX parser for " + this.getServiceURL());
                        } else if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ALL, className, methodName, "Using SAX parser for " + this.getServiceURL() + " ThreadName: " + Thread.currentThread().getName());
                        }
                    }
                    if (this.isSynchronisationNeeded()) {
                        Object object = lock = this.getLock();
                        synchronized (object) {
                            mReturn = pParamClasses != null ? DiskThreadManager.executeWithTimeLimit(this.cCIMClnt, pMethod, pParamClasses, pParams, mTimeout == null ? this.cTimeout : mTimeout, pLTH) : DiskThreadManager.executeWithTimeLimit(this.cCIMClnt, pMethod, pParams, mTimeout == null ? this.cTimeout : mTimeout, pLTH);
                        }
                    } else {
                        mReturn = pParamClasses != null ? DiskThreadManager.executeWithTimeLimit(this.cCIMClnt, pMethod, pParamClasses, pParams, mTimeout == null ? this.cTimeout : mTimeout, pLTH) : DiskThreadManager.executeWithTimeLimit(this.cCIMClnt, pMethod, pParams, mTimeout == null ? this.cTimeout : mTimeout, pLTH);
                    }
                    lock = mReturn;
                    Object var14_14 = null;
                    if (mReturn == null) break block33;
                }
                catch (DiskManagerExecException pEx) {
                    mError = pEx.getCause();
                    Throwable bRootCause = null;
                    if (mError instanceof InvocationTargetException) {
                        bRootCause = ((InvocationTargetException)mError).getTargetException();
                    } else {
                        Throwable throwable = bRootCause = mError.getCause() != null ? mError.getCause() : mError;
                    }
                    if (bRootCause instanceof CIMException) {
                        StringBuffer bErrorTxt = new StringBuffer();
                        bErrorTxt.append("CIMException at ");
                        bErrorTxt.append(pMethod);
                        bErrorTxt.append("(");
                        for (int bPIndex = 0; bPIndex < pParams.length; ++bPIndex) {
                            bErrorTxt.append(DiskMessageHelper.toMsgString(pParams[bPIndex]));
                            bErrorTxt.append(",");
                        }
                        String bTxt = bErrorTxt.toString();
                        if (pLTH != null) {
                            pLTH.traceError(bTxt.substring(0, bTxt.length() - 1) + ")", bRootCause);
                            throw (CIMException)bRootCause;
                        }
                        if (!traceLogger.isLogging()) throw (CIMException)bRootCause;
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, bRootCause);
                        throw (CIMException)bRootCause;
                    }
                    if (pLTH != null) {
                        pLTH.traceError("Internal error: DiskManagerExecException", pEx);
                        throw new DiskManagerRTException(pEx);
                    }
                    if (!traceLogger.isLogging()) throw new DiskManagerRTException(pEx);
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, pEx);
                    throw new DiskManagerRTException(pEx);
                }
                catch (DiskManagerTimeoutException pEx) {
                    if (pLTH != null) {
                        pLTH.traceError("Timeout (" + pEx.getMessage() + ") during CIM call " + pMethod + "(" + DiskMessageHelper.toMsgString(pParams) + ") to CIMOM " + this.getServiceURL(), pEx);
                        throw pEx;
                    }
                    if (!traceLogger.isLogging()) throw pEx;
                    traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Timeout (" + pEx.getMessage() + ") during CIM call " + pMethod + "(" + DiskMessageHelper.toMsgString(pParams) + ") to CIMOM " + this.getServiceURL());
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, pEx);
                    throw pEx;
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (mReturn != null) {
                    if (mReturn instanceof Enumeration) {
                        if (pLTH != null) {
                            pLTH.traceSvcReturn(SVC_NAME, ((Enumeration)mReturn).hasMoreElements() ? "non-empty result" : "empty result");
                            throw throwable;
                        }
                        if (!traceLogger.isLogging()) throw throwable;
                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, ((Enumeration)mReturn).hasMoreElements() ? "non-empty result" : "empty result");
                        throw throwable;
                    }
                    if (pLTH != null) {
                        pLTH.traceSvcReturn(SVC_NAME, DiskMessageHelper.toMsgString(mReturn));
                        throw throwable;
                    }
                    if (!traceLogger.isLogging()) throw throwable;
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, DiskMessageHelper.toMsgString(mReturn));
                    throw throwable;
                }
                if (pLTH != null) {
                    pLTH.traceSvcReturn(SVC_NAME, mError != null ? mError.toString() : null);
                    throw throwable;
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, mError != null ? mError.toString() : null);
                throw throwable;
            }
            if (mReturn instanceof Enumeration) {
                if (pLTH != null) {
                    pLTH.traceSvcReturn(SVC_NAME, ((Enumeration)mReturn).hasMoreElements() ? "non-empty result" : "empty result");
                    return lock;
                }
                if (!traceLogger.isLogging()) return lock;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, ((Enumeration)mReturn).hasMoreElements() ? "non-empty result" : "empty result");
                return lock;
            }
            if (pLTH != null) {
                pLTH.traceSvcReturn(SVC_NAME, DiskMessageHelper.toMsgString(mReturn));
                return lock;
            }
            if (!traceLogger.isLogging()) return lock;
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, DiskMessageHelper.toMsgString(mReturn));
            return lock;
        }
        if (pLTH != null) {
            pLTH.traceSvcReturn(SVC_NAME, mError != null ? mError.toString() : null);
            return lock;
        }
        if (!traceLogger.isLogging()) return lock;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, mError != null ? mError.toString() : null);
        return lock;
    }

    public Enumeration associatorNames(CIMObjectPath pPath, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("associatorNames", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, pLTH);
    }

    public Enumeration associatorNames(CIMObjectPath pObjectName, String pAssocClass, String pResultClass, String pRole, String pResultRole) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("associatorNames", new Class[]{CIMObjectPath.class, String.class, String.class, String.class, String.class}, new Object[]{pObjectName, pAssocClass, pResultClass, pRole, pResultRole}, null);
    }

    public Enumeration associatorNames(CIMObjectPath pObjectName, String pAssocClass, String pResultClass, String pRole, String pResultRole, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("associatorNames", new Class[]{CIMObjectPath.class, String.class, String.class, String.class, String.class}, new Object[]{pObjectName, pAssocClass, pResultClass, pRole, pResultRole}, pLTH);
    }

    public Enumeration associators(CIMObjectPath pObjectName, String pAssocClass, String pResultClass, String pRole, String pResultRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("associators", new Class[]{CIMObjectPath.class, String.class, String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{pObjectName, pAssocClass, pResultClass, pRole, pResultRole, new Boolean(pIncludeQualifiers), new Boolean(pIncludeClassOrigin), pPropertyList}, null);
    }

    public Enumeration associators(CIMObjectPath pObjectName, String pAssocClass, String pResultClass, String pRole, String pResultRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("associators", new Class[]{CIMObjectPath.class, String.class, String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{pObjectName, pAssocClass, pResultClass, pRole, pResultRole, new Boolean(pIncludeQualifiers), new Boolean(pIncludeClassOrigin), pPropertyList}, pLTH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() throws CIMException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "closeConnection", null);
        try {
            mLTH.traceHigh("ObjectID: " + this.getAddress() + " ThreadName: " + Thread.currentThread().getName());
            this.cCIMClnt.close();
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CIMException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "close", null);
        try {
            mLTH.traceHigh("ObjectID: " + this.getAddress() + " ThreadName: " + Thread.currentThread().getName());
            if (this.useCimPool) {
                CIMClientPool.returnClient(this);
            } else {
                this.closeConnection();
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    protected boolean testConnection() {
        try {
            CIMClass mClassInst = this.cCIMClnt.getClass(new CIMObjectPath("CIM_ManagedElement"));
            return true;
        }
        catch (Exception pEx) {
            return false;
        }
    }

    public CIMObjectPath deleteInstance(CIMObjectPath pName, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMObjectPath)this.executeSvcCall("deleteInstance", new Class[]{CIMObjectPath.class}, new Object[]{pName}, pLTH);
    }

    public CIMObjectPath createInstance(CIMObjectPath pName, CIMInstance pInstance, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMObjectPath)this.executeSvcCall("createInstance", new Class[]{CIMObjectPath.class, CIMInstance.class}, new Object[]{pName, pInstance}, pLTH);
    }

    public Enumeration enumClass(CIMObjectPath pPath, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumClass", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, pLTH);
    }

    public Enumeration enumClass(CIMObjectPath pPath, boolean pDeep, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumClass", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep)}, pLTH);
    }

    public Enumeration enumClass(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumClass", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep), new Boolean(pLocalOnly)}, pLTH);
    }

    public Enumeration enumerateClasses(CIMObjectPath pPath, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, pLTH);
    }

    public Enumeration enumerateClasses(CIMObjectPath pPath, boolean pDeep, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep)}, pLTH);
    }

    public Enumeration enumerateClasses(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep), new Boolean(pLocalOnly)}, pLTH);
    }

    public Enumeration enumerateClasses(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, boolean pIncludeQualifiers, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep), new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers)}, pLTH);
    }

    public Enumeration enumerateClasses(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep), new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers), new Boolean(pIncludeClassOrigin)}, null);
    }

    public Enumeration enumerateClasses(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClasses", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep), new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers), new Boolean(pIncludeClassOrigin)}, pLTH);
    }

    public Enumeration enumerateClassNames(CIMObjectPath pPath) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClassNames", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, null);
    }

    public Enumeration enumerateClassNames(CIMObjectPath pPath, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClassNames", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, pLTH);
    }

    public Enumeration enumerateClassNames(CIMObjectPath pPath, boolean pDeep, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateClassNames", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep)}, pLTH);
    }

    public Enumeration enumerateInstanceNames(CIMObjectPath pPath) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstanceNames", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, null);
    }

    public Enumeration enumerateInstanceNames(CIMObjectPath pPath, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstanceNames", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, pLTH);
    }

    public Enumeration enumerateInstances(CIMObjectPath pPath) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath pPath, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, pLTH);
    }

    public Enumeration enumerateInstances(CIMObjectPath pPath, boolean pDeep, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep)}, pLTH);
    }

    public Enumeration enumerateInstances(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep), new Boolean(pLocalOnly)}, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep), new Boolean(pLocalOnly)}, pLTH);
    }

    public Enumeration enumerateInstances(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, boolean pIncludeQualifiers, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep), new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers)}, pLTH);
    }

    public Enumeration enumerateInstances(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep), new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers), new Boolean(pIncludeClassOrigin)}, pLTH);
    }

    public Enumeration enumerateInstances(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumerateInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{pPath, new Boolean(pDeep), new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers), new Boolean(pIncludeClassOrigin), pPropertyList}, pLTH);
    }

    public Enumeration enumInstances(CIMObjectPath pPath, boolean pDeep, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep)}, pLTH);
    }

    public Enumeration enumInstances(CIMObjectPath pPath, boolean pDeep, boolean pLocalOnly, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumInstances", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep), new Boolean(pLocalOnly)}, pLTH);
    }

    public Enumeration enumNameSpace(CIMObjectPath pPath, boolean pDeep, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumNameSpace", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{pPath, new Boolean(pDeep)}, pLTH);
    }

    public Enumeration enumQualifierTypes(CIMObjectPath pPath, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("enumQualifierTypes", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, pLTH);
    }

    public boolean equals(Object pObj) {
        if (this.useCimPool) {
            return this.cCIMClnt.equals(pObj);
        }
        return super.equals(pObj);
    }

    public Enumeration execQuery(CIMObjectPath pPath, String pQuery, String pQueryLanguage, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("execQuery", new Class[]{CIMObjectPath.class, String.class, String.class}, new Object[]{pPath, pQueryLanguage, pQueryLanguage}, pLTH);
    }

    public CIMClass getClass(CIMObjectPath pName, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMClass)this.executeSvcCall("getClass", new Class[]{CIMObjectPath.class}, new Object[]{pName}, pLTH);
    }

    public CIMClass getClass(CIMObjectPath pName, boolean pLocalOnly, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMClass)this.executeSvcCall("getClass", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{pName, new Boolean(pLocalOnly)}, pLTH);
    }

    public CIMClass getClass(CIMObjectPath pName, boolean pLocalOnly, boolean pIncludeQualifiers, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMClass)this.executeSvcCall("getClass", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{pName, new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers)}, pLTH);
    }

    public CIMClass getClass(CIMObjectPath pName, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pincludeClassOrigin, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMClass)this.executeSvcCall("getClass", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{pName, new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers), new Boolean(pincludeClassOrigin)}, pLTH);
    }

    public CIMClass getClass(CIMObjectPath pName, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pincludeClassOrigin, String[] pPropertyList, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMClass)this.executeSvcCall("getClass", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{pName, new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers), new Boolean(pincludeClassOrigin), pPropertyList}, pLTH);
    }

    public CIMInstance getIndicationHandler(CIMListener pListener, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getIndicationHandler", new Class[]{CIMListener.class}, new Object[]{pListener}, pLTH);
    }

    public CIMInstance getIndicationListener(CIMListener pListener, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getIndicationListener", new Class[]{CIMListener.class}, new Object[]{pListener}, pLTH);
    }

    public CIMInstance getInstance(CIMObjectPath pName, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class}, new Object[]{pName}, pLTH);
    }

    public CIMInstance getInstance(CIMObjectPath pName, boolean pLocalOnly) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{pName, new Boolean(pLocalOnly)}, null);
    }

    public CIMInstance getInstance(CIMObjectPath pName, boolean pLocalOnly, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class, Boolean.TYPE}, new Object[]{pName, new Boolean(pLocalOnly)}, pLTH);
    }

    public CIMInstance getInstance(CIMObjectPath pName, boolean pLocalOnly, boolean pIncludeQualifiers, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{pName, new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers)}, pLTH);
    }

    public CIMInstance getInstance(CIMObjectPath pName, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{pName, new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers), new Boolean(pIncludeClassOrigin)}, pLTH);
    }

    public CIMInstance getInstance(CIMObjectPath pName, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMInstance)this.executeSvcCall("getInstance", new Class[]{CIMObjectPath.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{pName, new Boolean(pLocalOnly), new Boolean(pIncludeQualifiers), new Boolean(pIncludeClassOrigin), pPropertyList}, pLTH);
    }

    public Locale getLocale() {
        return this.cCIMClnt.getLocale();
    }

    public CIMNameSpace getNameSpace() {
        return this.cCIMClnt.getNameSpace();
    }

    public CIMValue getProperty(CIMObjectPath pName, String pPropertyList, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMValue)this.executeSvcCall("getProperty", new Class[]{CIMObjectPath.class, String.class}, new Object[]{pName, pPropertyList}, pLTH);
    }

    public CIMQualifierType getQualifierType(CIMObjectPath pPath, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMQualifierType)this.executeSvcCall("getQualifierType", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, pLTH);
    }

    public int hashCode() {
        if (this.useCimPool) {
            return this.cCIMClnt.hashCode();
        }
        return super.hashCode();
    }

    public CIMValue invokeMethod(CIMObjectPath pPath, String pMethodName, Vector pInArgs, Vector pOutArgs, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMValue)this.executeSvcCall("invokeMethod", new Class[]{CIMObjectPath.class, String.class, Vector.class, Vector.class}, new Object[]{pPath, pMethodName, pInArgs, pOutArgs}, pLTH);
    }

    public CIMValue invokeMethod(CIMObjectPath pPath, String pMethodName, CIMArgument[] pInArgs, CIMArgument[] pOutArgs, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (CIMValue)this.executeSvcCall("invokeMethod", new Class[]{CIMObjectPath.class, String.class, CIMArgument[].class, CIMArgument[].class}, new Object[]{pPath, pMethodName, pInArgs, pOutArgs}, pLTH);
    }

    public BatchResult performBatchOperations(BatchHandle pBc, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (BatchResult)this.executeSvcCall("performBatchOperations", new Class[]{BatchHandle.class}, new Object[]{pBc}, pLTH);
    }

    public Enumeration referenceNames(CIMObjectPath pPath) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("referenceNames", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, null);
    }

    public Enumeration referenceNames(CIMObjectPath pPath, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("referenceNames", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, pLTH);
    }

    public Enumeration referenceNames(CIMObjectPath pPath, String pResultClass, String pRole, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("referenceNames", new Class[]{CIMObjectPath.class, String.class, String.class}, new Object[]{pPath, pResultClass, pRole}, pLTH);
    }

    public Enumeration references(CIMObjectPath pPath, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("references", new Class[]{CIMObjectPath.class}, new Object[]{pPath}, pLTH);
    }

    public Enumeration references(CIMObjectPath pPath, String pResultClass, String pRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("references", new Class[]{CIMObjectPath.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{pPath, pResultClass, pRole, new Boolean(pIncludeQualifiers), new Boolean(pIncludeClassOrigin), pPropertyList}, null);
    }

    public Enumeration references(CIMObjectPath pPath, String pResultClass, String pRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        return (Enumeration)this.executeSvcCall("references", new Class[]{CIMObjectPath.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, String[].class}, new Object[]{pPath, pResultClass, pRole, new Boolean(pIncludeQualifiers), new Boolean(pIncludeClassOrigin), pPropertyList}, pLTH);
    }

    public synchronized void setInstance(CIMObjectPath pPath, CIMInstance pInstance, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        this.executeSvcCall("setInstance", new Class[]{CIMObjectPath.class, CIMInstance.class}, new Object[]{pPath, pInstance}, pLTH);
    }

    public synchronized void setInstance(CIMObjectPath pPath, CIMInstance pInstance, boolean pIncludeQualifiers, String[] pPropertyList, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        this.executeSvcCall("setInstance", new Class[]{CIMObjectPath.class, CIMInstance.class, Boolean.TYPE, String[].class}, new Object[]{pPath, pInstance, new Boolean(pIncludeQualifiers), pPropertyList}, pLTH);
    }

    public void removeCIMListener(CIMListener pListener, LogTraceHelper pLTH) throws CIMException, DiskManagerTimeoutException {
        this.executeSvcCall("removeCIMListener", new Class[]{CIMListener.class}, new Object[]{pListener}, pLTH);
    }

    public String toString() {
        return this.getServiceURL();
    }

    public void useHttp11(boolean pArg0) {
        this.cCIMClnt.useHttp11(pArg0);
    }

    public void useMPost(boolean pArg0) {
        this.cCIMClnt.useMPost(pArg0);
    }

    public long getTimeout() {
        return this.cTimeout;
    }

    public void setTimeout(long pTimeout) {
        this.cTimeout = pTimeout;
    }

    public void setTimeout(String pMethodName, long pTimeout) {
        this.cMethodTimeouts.put(pMethodName, new Long(pTimeout));
    }

    private long getCfgTimeout() {
        return DiskManagerConfigSvc.getLongConfigValue("CIMClientWrapper.Timeout", 600000L);
    }

    public String getAddress() {
        return super.toString();
    }

    private final boolean isSynchronisationNeeded() {
        if (stSynchronizationEnabled == null) {
            stSynchronizationEnabled = new Boolean(DiskManagerConfigSvc.getBooleanConfigValue("CIMClientWrapper.ReqSync.Enabled", true));
        }
        if (!stSynchronizationEnabled.booleanValue()) {
            return false;
        }
        return !CIMOMManager.allowsConcurrentAccess(this.getServiceURL());
    }

    private final boolean isSaxParsingNeeded() {
        if (stSaxParsingEnabled == null) {
            stSaxParsingEnabled = new Boolean(DiskManagerConfigSvc.getBooleanConfigValue("CIMClientWrapper.SaxParsing.Enabled", true));
        }
        if (!stSaxParsingEnabled.booleanValue()) {
            return false;
        }
        return CIMOMManager.needsSaxParsing(this.getServiceURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object getLock() {
        Object mCIMOMLock = stCIMOMLocks.get(this.getServiceURL());
        if (mCIMOMLock == null) {
            Map map = stCIMOMLocks;
            synchronized (map) {
                mCIMOMLock = stCIMOMLocks.get(this.getServiceURL());
                if (mCIMOMLock == null) {
                    mCIMOMLock = new Object();
                    stCIMOMLocks.put(this.getServiceURL(), mCIMOMLock);
                }
            }
        }
        return mCIMOMLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getServiceURL() {
        if (this.cServiceURL != null) {
            return this.cServiceURL;
        }
        Object object = this.cLock;
        synchronized (object) {
            if (this.cServiceURL == null) {
                StringBuffer mHostBuf = new StringBuffer();
                mHostBuf.append(this.cCIMClnt.getNameSpace().getScheme()).append("://").append(this.cCIMClnt.getNameSpace().getHost());
                mHostBuf.append(":").append(this.cCIMClnt.getNameSpace().getPort());
                this.cServiceURL = mHostBuf.toString();
            }
        }
        return this.cServiceURL;
    }

    static {
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
    }
}

