/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResElementProbeStatusTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeFrameTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;

public class CIMOMSelectorDbHelper {
    private static final short NOT_DETECTABLE = 0;
    private static final short DETECTABLE = 1;

    public static CIMOM getCimom(int pId) {
        CIMOM result = CIMOMManager.getCIMOMManager().getCIMMOMByDBKey(pId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short getCreationClassNameId(String pCreationClassName) throws SQLException {
        DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        try {
            short s = Normalizer.CreationClassNameGetID(mConnection, pCreationClassName);
            return s;
        }
        finally {
            if (mConnection != null) {
                mConnection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CapabilityData getCapabilityData(int pCapabilityDataId) throws SQLException {
        DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        try {
            CapabilityData mResult = new CapabilityData();
            mResult.setCapabilityDataId(pCapabilityDataId);
            CapabilityData capabilityData = mResult.retrieve(mConnection) ? mResult : null;
            return capabilityData;
        }
        finally {
            if (mConnection != null) {
                mConnection.close();
            }
        }
    }

    public static class TapeFrameWrapper
    extends TapeFrame {
        public void setFieldsFromDbRow(DBConnection pConnection, DBResultSet pResult) throws SQLException {
            this.setFields(pConnection, pResult);
        }
    }

    public static class TapeLibraryWrapper
    extends TapeLibrary {
        public void setFieldsFromDbRow(DBConnection pConnection, DBResultSet pResult) throws SQLException {
            this.setFields(pConnection, pResult);
        }
    }

    public static class StorageSubsystemWrapper
    extends StorageSubsystem {
        public void setFieldsFromDbRow(DBConnection pConnection, DBResultSet pResult) throws SQLException {
            this.setFields(pConnection, pResult);
        }
    }

    public static class Tape {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CIMOMInformation[] getCimomInformation(int pTapeLibraryId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
                mParameters.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(pTapeLibraryId));
                String mQueryString = "SELECT C2N.CIMOM_ID, C2N.NAMESPACE, CKS.CIM_NAMESPACE_ID, CKS.ACTIVE FROM " + TResCimom2namespaceTable.getTablename() + " AS C2N, " + TResCimkeyTapeLibraryTable.getTablename() + " AS CKS WHERE (C2N." + "CIM_NAMESPACE_ID" + "=CKS." + "CIM_NAMESPACE_ID" + " AND CKS." + "TAPE_LIBRARY_ID" + "=(?) AND CKS." + "ACTIVE" + " IS NOT NULL)";
                DBResultSet mDbResult = ComplexQuery.sqlQuery(mConnection, mQueryString, mParameters);
                ArrayList<CIMOMInformation> mResult = new ArrayList<CIMOMInformation>();
                while (mDbResult.next()) {
                    CIMOMInformation bCimomId = new CIMOMInformation(mDbResult.getInt(1), mDbResult.getInt(3), mDbResult.getString(2), mDbResult.getShort(4));
                    mResult.add(bCimomId);
                }
                mDbResult.closeAll();
                CIMOMInformation[] cIMOMInformationArray = mResult.toArray(new CIMOMInformation[mResult.size()]);
                return cIMOMInformationArray;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean degradeCimomPriority(int pNamespaceId, int pTapeLibraryId) throws SQLException {
            Class<Tape> clazz = Tape.class;
            synchronized (Tape.class) {
                short mLowestPriority = Tape.getLowestPriority(pTapeLibraryId);
                if (mLowestPriority == Short.MAX_VALUE) {
                    mLowestPriority = Tape.resetPriorities(pTapeLibraryId);
                }
                mLowestPriority = (short)(mLowestPriority + 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Tape.setCimomPriority(pNamespaceId, pTapeLibraryId, mLowestPriority);
            }
        }

        private static short resetPriorities(int pTapeLibraryId) throws SQLException {
            Object[] mCimomInfos = Tape.getCimomInformation(pTapeLibraryId);
            Arrays.sort(mCimomInfos);
            for (short i = 0; i < mCimomInfos.length; i = (short)((short)(i + 1))) {
                int n = ((CIMOMInformation)mCimomInfos[i]).getNamespaceId();
                Tape.setCimomPriority(n, pTapeLibraryId, i);
            }
            return (short)mCimomInfos.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean setCimomPriority(int pNamespaceId, int pTapeLibraryId, short pNewPriority) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
                mParameters.put(TResCimkeyTapeLibraryTable.getColumnInfo("ACTIVE"), Short.toString(pNewPriority));
                mParameters.put(TResCimkeyTapeLibraryTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(pNamespaceId));
                mParameters.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(pTapeLibraryId));
                String mSqlString = "UPDATE " + TResCimkeyTapeLibraryTable.getTablename() + " SET " + "ACTIVE" + "=(?) WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "TAPE_LIBRARY_ID" + "=(?))";
                int mRc = ComplexQuery.sqlUpdate(mConnection, mSqlString, mParameters);
                if (!mConnection.getAutoCommit()) {
                    mConnection.commit();
                }
                boolean bl = mRc == 1;
                return bl;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static short getLowestPriority(int pTapeLibraryId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
                mParameters.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(pTapeLibraryId));
                String mSqlString = "SELECT COUNT(*), MAX(ACTIVE) FROM " + TResCimkeyTapeLibraryTable.getTablename() + " WHERE (" + "TAPE_LIBRARY_ID" + "=(?) AND " + "ACTIVE" + " IS NOT NULL)";
                DBResultSet mDbResult = ComplexQuery.sqlQuery(mConnection, mSqlString, mParameters);
                short mResult = mDbResult.next() && mDbResult.getInt(1) > 0 ? mDbResult.getShort(2) : (short)0;
                mDbResult.closeAll();
                short s = mResult;
                return s;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CimkeyTapeLibrary getCimNamespaceMapping(int pTapeLibraryId, int pNamespaceId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                CimkeyTapeLibrary mResult = new CimkeyTapeLibrary();
                mResult.setTapeLibraryId(pTapeLibraryId);
                mResult.setCimNamespaceId(pNamespaceId);
                CimkeyTapeLibrary cimkeyTapeLibrary = mResult.retrieve(mConnection) ? mResult : null;
                return cimkeyTapeLibrary;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        public static int getCorrespondingCapabilityDataId(int pNamespaceId, int pTapeLibraryId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
                mParameters.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(pTapeLibraryId));
                mParameters.put(TResCimkeyTapeLibraryTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(pNamespaceId));
                String mQueryString = "SELECT CAPABILITY_DATA_ID FROM " + TResCimkeyTapeLibraryTable.getTablename() + " WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "TAPE_LIBRARY_ID" + "=(?))";
                DBResultSet mDbResult = ComplexQuery.sqlQuery(mConnection, mQueryString, mParameters);
                try {
                    if (mDbResult.next() && mDbResult.getInt(1) != 0) {
                        int n = mDbResult.getInt(1);
                        return n;
                    }
                    throw new IllegalArgumentException("No record existing in " + TResCimkeyTapeLibraryTable.getTablename() + " for this namespace-subsystem combination.");
                }
                finally {
                    mDbResult.closeAll();
                }
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TapeLibrary getTapeLibrary(int pTapeLibraryId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                DBResultSet mDbResult;
                block9: {
                    TapeLibraryWrapper tapeLibraryWrapper;
                    Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
                    mWhereClause.put(TResTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(pTapeLibraryId));
                    mDbResult = DBQueryAssistant.performRetrieve(TResTapeLibraryTable.getTablename(), mConnection, mWhereClause, null);
                    try {
                        if (!mDbResult.next()) break block9;
                        TapeLibraryWrapper wrapper = new TapeLibraryWrapper();
                        wrapper.setFieldsFromDbRow(mConnection, mDbResult);
                        tapeLibraryWrapper = wrapper;
                    }
                    catch (Throwable throwable) {
                        mDbResult.closeAll();
                        throw throwable;
                    }
                    mDbResult.closeAll();
                    return tapeLibraryWrapper;
                }
                TapeLibrary tapeLibrary = null;
                mDbResult.closeAll();
                return tapeLibrary;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TapeFrame getTapeFrame(int pTapeLibraryId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                DBResultSet mDbResult;
                block9: {
                    TapeFrameWrapper tapeFrameWrapper;
                    Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
                    mWhereClause.put(TResTapeFrameTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(pTapeLibraryId));
                    mDbResult = DBQueryAssistant.performRetrieve(TResTapeFrameTable.getTablename(), mConnection, mWhereClause, null);
                    try {
                        if (!mDbResult.next()) break block9;
                        TapeFrameWrapper wrapper = new TapeFrameWrapper();
                        wrapper.setFieldsFromDbRow(mConnection, mDbResult);
                        tapeFrameWrapper = wrapper;
                    }
                    catch (Throwable throwable) {
                        mDbResult.closeAll();
                        throw throwable;
                    }
                    mDbResult.closeAll();
                    return tapeFrameWrapper;
                }
                TapeFrame tapeFrame = null;
                mDbResult.closeAll();
                return tapeFrame;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        public static void setMissing(int pLibraryId) throws SQLException {
            TapeLibrary mLibrary = Tape.getTapeLibrary(pLibraryId);
            if (mLibrary.getDetectable() != 0) {
                Tape.updateDetectable(mLibrary.getName(), mLibrary.getNameFormat(), (short)0);
            }
        }

        public static void setVisible(int pLibraryId) throws SQLException {
            TapeLibrary mLibrary = Tape.getTapeLibrary(pLibraryId);
            if (mLibrary.getDetectable() != 1) {
                Tape.updateDetectable(mLibrary.getName(), mLibrary.getNameFormat(), (short)1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void updateDetectable(String pName, short pNameFormat, short pDetectable) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                TapeLibrary mLibrary = new TapeLibrary();
                mLibrary.setName(pName);
                mLibrary.setNameFormat(pNameFormat);
                mLibrary.setDetectable(pDetectable);
                mLibrary.setChangedTimestamp(new Timestamp(new Date().getTime()));
                mLibrary.update(mConnection);
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }
    }

    public static class Switch {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CIMOMInformation[] getCimomInformation(String pSwitchWwn) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
                mParameters.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), pSwitchWwn);
                String mQueryString = "SELECT C2N.CIMOM_ID, C2N.NAMESPACE, CKS.CIM_NAMESPACE_ID, CKS.ACTIVE FROM " + TResCimom2namespaceTable.getTablename() + " AS C2N, " + TResCimkeySwitchTable.getTablename() + " AS CKS WHERE (C2N." + "CIM_NAMESPACE_ID" + "=CKS." + "CIM_NAMESPACE_ID" + " AND CKS." + "SWITCH_WWN" + "=(?) AND CKS." + "ACTIVE" + " IS NOT NULL)";
                DBResultSet mDbResult = ComplexQuery.sqlQuery(mConnection, mQueryString, mParameters);
                ArrayList<CIMOMInformation> mResult = new ArrayList<CIMOMInformation>();
                while (mDbResult.next()) {
                    CIMOMInformation bCimomId = new CIMOMInformation(mDbResult.getInt(1), mDbResult.getInt(3), mDbResult.getString(2), mDbResult.getShort(4));
                    mResult.add(bCimomId);
                }
                mDbResult.closeAll();
                CIMOMInformation[] cIMOMInformationArray = mResult.toArray(new CIMOMInformation[mResult.size()]);
                return cIMOMInformationArray;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CimkeySwitch getCimNamespaceMapping(String pSwitchWwn, int pNamespaceId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                CimkeySwitch mResult = new CimkeySwitch();
                mResult.setSwitchWwn(pSwitchWwn);
                mResult.setCimNamespaceId(pNamespaceId);
                CimkeySwitch cimkeySwitch = mResult.retrieve(mConnection) ? mResult : null;
                return cimkeySwitch;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean degradeCimomPriority(int pNamespaceId, String pSwitchWwn) throws SQLException {
            Class<Switch> clazz = Switch.class;
            synchronized (Switch.class) {
                short mLowestPriority = Switch.getLowestPriority(pSwitchWwn);
                if (mLowestPriority == Short.MAX_VALUE) {
                    mLowestPriority = Switch.resetPriorities(pSwitchWwn);
                }
                mLowestPriority = (short)(mLowestPriority + 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Switch.setCimomPriority(pNamespaceId, pSwitchWwn, mLowestPriority);
            }
        }

        private static short resetPriorities(String pSwitchWwn) throws SQLException {
            Object[] mCimomInfos = Switch.getCimomInformation(pSwitchWwn);
            Arrays.sort(mCimomInfos);
            for (short i = 0; i < mCimomInfos.length; i = (short)((short)(i + 1))) {
                int n = ((CIMOMInformation)mCimomInfos[i]).getNamespaceId();
                Switch.setCimomPriority(n, pSwitchWwn, i);
            }
            return (short)mCimomInfos.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean setCimomPriority(int pNamespaceId, String pSwitchWwn, short pNewPriority) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
                mParameters.put(TResCimkeySwitchTable.getColumnInfo("ACTIVE"), Short.toString(pNewPriority));
                mParameters.put(TResCimkeySwitchTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(pNamespaceId));
                mParameters.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), pSwitchWwn);
                String mSqlString = "UPDATE " + TResCimkeySwitchTable.getTablename() + " SET " + "ACTIVE" + "=(?) WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "SWITCH_WWN" + "=(?))";
                int mRc = ComplexQuery.sqlUpdate(mConnection, mSqlString, mParameters);
                if (!mConnection.getAutoCommit()) {
                    mConnection.commit();
                }
                boolean bl = mRc == 1;
                return bl;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static short getLowestPriority(String pSwitchWwn) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
                mParameters.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), pSwitchWwn);
                String mSqlString = "SELECT COUNT(*), MAX(ACTIVE) FROM " + TResCimkeySwitchTable.getTablename() + " WHERE (" + "SWITCH_WWN" + "=(?) AND " + "ACTIVE" + " IS NOT NULL)";
                DBResultSet mDbResult = ComplexQuery.sqlQuery(mConnection, mSqlString, mParameters);
                short mResult = mDbResult.next() && mDbResult.getInt(1) > 0 ? mDbResult.getShort(2) : (short)0;
                mDbResult.closeAll();
                short s = mResult;
                return s;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static org.eclipse.aperi.infrastructure.database.objects.Switch getSwitch(String pSwitchWwn) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                org.eclipse.aperi.infrastructure.database.objects.Switch mResult = new org.eclipse.aperi.infrastructure.database.objects.Switch();
                mResult.setSwitchWwn(pSwitchWwn);
                org.eclipse.aperi.infrastructure.database.objects.Switch switch_ = mResult.retrieve(mConnection) ? mResult : null;
                return switch_;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        private static LinkedList getMissingSwitches(DBConnection pConn, String pSwitchWWN) throws SQLException {
            String mSelectString = "SELECT ELEMENT_ID FROM " + TResElementProbeStatusTable.getTablename() + " WHERE " + "PROBE_FOUND" + "!=1 AND " + "ELEMENT_ID" + " IN (SELECT " + "SWITCH_ID" + " FROM " + TResSwitchTable.getTablename() + " , " + TResCimkeySwitchTable.getTablename() + " WHERE " + TResCimkeySwitchTable.getTablename() + "." + "SWITCH_WWN" + "=" + TResSwitchTable.getTablename() + "." + "SWITCH_WWN" + " AND " + TResCimkeySwitchTable.getTablename() + "." + "SWITCH_WWN" + " = (?) " + ")";
            Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
            mParameters.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), pSwitchWWN);
            DBResultSet mDBR = ComplexQuery.sqlQuery(pConn, mSelectString, mParameters);
            LinkedList<String> pListOfIDs = new LinkedList<String>();
            while (mDBR.next()) {
                pListOfIDs.add(mDBR.getString(1));
            }
            mDBR.close();
            return pListOfIDs;
        }

        private static String convertLinkedListToCommaSeparatedString(LinkedList pList) {
            String mCSS = "";
            Iterator bIter = pList.iterator();
            while (bIter.hasNext()) {
                mCSS = mCSS + (String)bIter.next();
                mCSS = mCSS + ",";
            }
            if (mCSS.indexOf(",") >= 0) {
                mCSS = mCSS.substring(0, mCSS.length() - 1);
            }
            return mCSS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setMissing(String pSwitchWWN) throws SQLException {
            LogTraceHelper mLTH = LogTraceHelper.entry(Switch.class, "setMissing", new Object[]{pSwitchWWN});
            HashMap<String, LinkedList> mTouchedEntities = new HashMap<String, LinkedList>();
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                LinkedList listOfSWIDs = Switch.getMissingSwitches(mConnection, pSwitchWWN);
                if (!listOfSWIDs.isEmpty()) {
                    String mSwitchIdsWithComma = Switch.convertLinkedListToCommaSeparatedString(listOfSWIDs);
                    String mSqlStringSw = "UPDATE " + TResSwitchTable.getTablename() + " SET " + "DETECTABLE" + "=0 WHERE " + "SWITCH_ID" + " IN (" + mSwitchIdsWithComma + ")";
                    ComplexQuery.sqlUpdate(mConnection, mSqlStringSw, null);
                    mTouchedEntities.put(TResSwitchTable.getTablename(), listOfSWIDs);
                    if (!mTouchedEntities.isEmpty()) {
                        String pProcessID = "S" + CIMOMManager.getUniqueNumberString();
                        ChangeDetection mChangeDetection = new ChangeDetection(mConnection);
                        mChangeDetection.complete(mConnection, mTouchedEntities, pProcessID);
                        ServiceUtils.getEventMonitorProxy().handleModelUpdate(pProcessID);
                    }
                    if (!mConnection.getAutoCommit()) {
                        mConnection.commit();
                    }
                }
            }
            catch (Exception e) {
                mLTH.traceError("Failed to set Switch Missing for Switch" + pSwitchWWN + ".Rolling back", e);
                mConnection.rollback();
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setVisible(String pSwitchWWN) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                org.eclipse.aperi.infrastructure.database.objects.Switch mSwitch = new org.eclipse.aperi.infrastructure.database.objects.Switch();
                mSwitch.setSwitchWwn(pSwitchWWN);
                mSwitch.setDetectable((short)1);
                mSwitch.update(mConnection);
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }
    }

    public static class Subsystem {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CIMOMInformation[] getCimomInformation(int pSubsystemId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
                mParameters.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(pSubsystemId));
                String mQueryString = "SELECT C2N.CIMOM_ID, C2N.NAMESPACE, CKS.CIM_NAMESPACE_ID, CKS.ACTIVE FROM " + TResCimom2namespaceTable.getTablename() + " AS C2N, " + TResCimkeySubsystemTable.getTablename() + " AS CKS, " + TResRegisteredCimomTable.getTablename() + " AS REGCIM WHERE (C2N." + "CIM_NAMESPACE_ID" + "=CKS." + "CIM_NAMESPACE_ID" + " AND CKS." + "SUBSYSTEM_ID" + "=(?) AND CKS." + "ACTIVE" + " IS NOT NULL" + " AND (" + "C2N." + "CIMOM_ID" + " = REGCIM." + "REG_CIMOM_ID" + " AND REGCIM." + "STATUS" + " != " + CIMOMConnectionStatus.PENDING_DELETION.toID() + "))";
                DBResultSet mDbResult = ComplexQuery.sqlQuery(mConnection, mQueryString, mParameters);
                ArrayList<CIMOMInformation> mResult = new ArrayList<CIMOMInformation>();
                while (mDbResult.next()) {
                    CIMOMInformation bCimomId = new CIMOMInformation(mDbResult.getInt(1), mDbResult.getInt(3), mDbResult.getString(2), mDbResult.getShort(4));
                    mResult.add(bCimomId);
                }
                mDbResult.closeAll();
                CIMOMInformation[] cIMOMInformationArray = mResult.toArray(new CIMOMInformation[mResult.size()]);
                return cIMOMInformationArray;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean degradeCimomPriority(int pNamespaceId, int pSubsystemId) throws SQLException {
            Class<Subsystem> clazz = Subsystem.class;
            synchronized (Subsystem.class) {
                short mLowestPriority = Subsystem.getLowestPriority(pSubsystemId);
                if (mLowestPriority == Short.MAX_VALUE) {
                    mLowestPriority = Subsystem.resetPriorities(pSubsystemId);
                }
                mLowestPriority = (short)(mLowestPriority + 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Subsystem.setCimomPriority(pNamespaceId, pSubsystemId, mLowestPriority);
            }
        }

        private static short resetPriorities(int pSubsystemId) throws SQLException {
            Object[] mCimomInfos = Subsystem.getCimomInformation(pSubsystemId);
            Arrays.sort(mCimomInfos);
            for (short i = 0; i < mCimomInfos.length; i = (short)((short)(i + 1))) {
                int n = ((CIMOMInformation)mCimomInfos[i]).getNamespaceId();
                Subsystem.setCimomPriority(n, pSubsystemId, i);
            }
            return (short)mCimomInfos.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean setCimomPriority(int pNamespaceId, int pSubsystemId, short pNewPriority) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
                mParameters.put(TResCimkeySubsystemTable.getColumnInfo("ACTIVE"), Short.toString(pNewPriority));
                mParameters.put(TResCimkeySubsystemTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(pNamespaceId));
                mParameters.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(pSubsystemId));
                String mSqlString = "UPDATE " + TResCimkeySubsystemTable.getTablename() + " SET " + "ACTIVE" + "=(?) WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "SUBSYSTEM_ID" + "=(?))";
                int mRc = ComplexQuery.sqlUpdate(mConnection, mSqlString, mParameters);
                if (!mConnection.getAutoCommit()) {
                    mConnection.commit();
                }
                boolean bl = mRc == 1;
                return bl;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static short getLowestPriority(int pSubsystemId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
                mParameters.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(pSubsystemId));
                String mSqlString = "SELECT COUNT(*), MAX(ACTIVE) FROM " + TResCimkeySubsystemTable.getTablename() + " WHERE (" + "SUBSYSTEM_ID" + "=(?) AND " + "ACTIVE" + " IS NOT NULL)";
                DBResultSet mDbResult = ComplexQuery.sqlQuery(mConnection, mSqlString, mParameters);
                short mResult = mDbResult.next() && mDbResult.getInt(1) > 0 ? mDbResult.getShort(2) : (short)0;
                mDbResult.closeAll();
                short s = mResult;
                return s;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CimkeySubsystem getCimNamespaceMapping(int pSubsystemId, int pNamespaceId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                CimkeySubsystem mResult = new CimkeySubsystem();
                mResult.setSubsystemId(pSubsystemId);
                mResult.setCimNamespaceId(pNamespaceId);
                CimkeySubsystem cimkeySubsystem = mResult.retrieve(mConnection) ? mResult : null;
                return cimkeySubsystem;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        public static int getCorrespondingCapabilityDataId(int pNamespaceId, int pSubsystemId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
                mParameters.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(pSubsystemId));
                mParameters.put(TResCimkeySubsystemTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(pNamespaceId));
                String mQueryString = "SELECT CAPABILITY_DATA_ID FROM " + TResCimkeySubsystemTable.getTablename() + " WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "SUBSYSTEM_ID" + "=(?))";
                DBResultSet mDbResult = ComplexQuery.sqlQuery(mConnection, mQueryString, mParameters);
                try {
                    if (mDbResult.next() && mDbResult.getInt(1) != 0) {
                        int n = mDbResult.getInt(1);
                        return n;
                    }
                    throw new IllegalArgumentException("No record existing in " + TResCimkeySubsystemTable.getTablename() + " for this namespace-subsystem combination.");
                }
                finally {
                    mDbResult.closeAll();
                }
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static StorageSubsystem getSubsystem(int pSubsystemId) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                DBResultSet mDbResult;
                block9: {
                    StorageSubsystemWrapper storageSubsystemWrapper;
                    Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
                    mWhereClause.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(pSubsystemId));
                    mDbResult = DBQueryAssistant.performRetrieve(TResStorageSubsystemTable.getTablename(), mConnection, mWhereClause, null);
                    try {
                        if (!mDbResult.next()) break block9;
                        StorageSubsystemWrapper wrapper = new StorageSubsystemWrapper();
                        wrapper.setFieldsFromDbRow(mConnection, mDbResult);
                        storageSubsystemWrapper = wrapper;
                    }
                    catch (Throwable throwable) {
                        mDbResult.closeAll();
                        throw throwable;
                    }
                    mDbResult.closeAll();
                    return storageSubsystemWrapper;
                }
                StorageSubsystem storageSubsystem = null;
                mDbResult.closeAll();
                return storageSubsystem;
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }

        public static void setMissing(int pSubsystemId) throws SQLException {
            StorageSubsystem mSubsystem = Subsystem.getSubsystem(pSubsystemId);
            if (mSubsystem.getDetectable() != 0) {
                Subsystem.updateDetectable(mSubsystem.getName(), mSubsystem.getNameFormat(), (short)0);
            }
        }

        public static void setVisible(int pSubsystemId) throws SQLException {
            StorageSubsystem mSubsystem = Subsystem.getSubsystem(pSubsystemId);
            if (mSubsystem.getDetectable() != 1) {
                Subsystem.updateDetectable(mSubsystem.getName(), mSubsystem.getNameFormat(), (short)1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void updateDetectable(String pName, short pNameFormat, short pDetectable) throws SQLException {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                StorageSubsystem mSubsystem = new StorageSubsystem();
                mSubsystem.setName(pName);
                mSubsystem.setNameFormat(pNameFormat);
                mSubsystem.setDetectable(pDetectable);
                mSubsystem.setChangedTimestamp(new Timestamp(new Date().getTime()));
                mSubsystem.update(mConnection);
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }
    }

    public static class CIMOMInformation
    implements Comparable {
        private int cId;
        private String cNamespace;
        private int cNamespaceId;
        private short cPriority;

        public CIMOMInformation(int pId, int pNamespaceId, String pNamespace, short pPriority) {
            this.cId = pId;
            this.cNamespace = pNamespace;
            this.cNamespaceId = pNamespaceId;
            this.cPriority = pPriority;
        }

        public int getId() {
            return this.cId;
        }

        public String getNamespace() {
            return this.cNamespace;
        }

        public int getNamespaceId() {
            return this.cNamespaceId;
        }

        public short getPriority() {
            return this.cPriority;
        }

        public int compareTo(Object pObj) {
            return this.cPriority - ((CIMOMInformation)pObj).cPriority;
        }

        public String toString() {
            return "{CimomInfo id=" + Integer.toString(this.cId) + ",ns=" + this.cNamespace + ",ns_id=" + Integer.toString(this.cNamespaceId) + ",prio=" + Short.toString(this.cPriority) + "}";
        }
    }
}

