/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.log;

import com.ibm.log.Level;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.control.data.JobInfo;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelperFactory;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.Reusable;
import org.eclipse.aperi.disk.resources.DMJobMessages;
import org.eclipse.aperi.sanmgmt.logging.ILogger;

public class LogTraceHelper
implements Reusable {
    private String cJobID = null;
    private long[] cReqID = new long[]{Long.MIN_VALUE, Long.MIN_VALUE};
    private long cExecID = Long.MIN_VALUE;
    private String cCtxtID = null;
    private Request cDiscoverRequest = null;
    private Token cCtrlToken = null;
    private String cClass = null;
    private String cMethodName = null;
    private long cStartTS = -1L;
    private long cEndTS = -1L;
    private boolean cInPool = false;
    private ILogger cJobLogger = null;
    private String cInvokationParms = null;

    protected LogTraceHelper(String pJobID, Object pClass, String pMethod, Request pDiscoverRequest, Token pCtrlToken, long[] pRequestID) {
        this.initializeInstance(pJobID, pClass, pMethod, pDiscoverRequest, pCtrlToken, pRequestID);
    }

    public final void initializeInstance(String pJobID, Object pClass, String pMethod, Request pDiscoverRequest, Token pCtrlToken, long[] pRequestID) {
        if (pJobID != null) {
            this.cJobID = pJobID;
        }
        if (pDiscoverRequest != null) {
            this.cDiscoverRequest = pDiscoverRequest;
            this.cJobID = Integer.toString(this.cDiscoverRequest.getId());
            this.cJobLogger = pDiscoverRequest.getJobLogger();
            if (this.cJobLogger != null) {
                this.cJobLogger.setMessageFile(DMJobMessages.class.getName());
            }
        } else if (pCtrlToken != null) {
            this.cCtrlToken = pCtrlToken;
            this.cJobID = this.cCtrlToken.getJobId();
            JobInfo bJobInfo = (JobInfo)ServiceUtils.activeJobs.get(this.cJobID);
            if (bJobInfo != null) {
                this.cJobLogger = bJobInfo.getJobLogger();
                if (this.cJobLogger != null) {
                    this.cJobLogger.setMessageFile(DMJobMessages.class.getName());
                }
            }
        }
        this.cClass = pClass instanceof String ? (String)pClass : pClass.getClass().getName();
        this.cMethodName = pMethod;
        if (this.cJobID == null) {
            this.cJobID = "" + LogTraceHelperFactory.getInternalRequestID();
        }
        this.cReqID = pRequestID;
        this.cExecID = LogTraceHelperFactory.getInternalExecID();
        this.cStartTS = System.currentTimeMillis();
    }

    public void clearInstance() {
        this.cJobID = null;
        this.cClass = this.cClass + "(pooled)";
        this.cMethodName = this.cMethodName + "(pooled)";
        this.cDiscoverRequest = null;
        this.cCtrlToken = null;
        this.cJobLogger = null;
        this.cStartTS = -1L;
        this.cEndTS = -1L;
        this.cReqID = null;
        this.cExecID = Long.MIN_VALUE;
        this.cCtxtID = null;
    }

    public void releaseInstance() {
    }

    public boolean isInPool() {
        return this.cInPool;
    }

    public void setIsInPool(boolean pInPool) {
        this.cInPool = pInPool;
    }

    public static final LogTraceHelper entry(String pJobID, Object pClass, String pMethod, Object[] pParams) {
        LogTraceHelper mReturn = LogTraceHelperFactory.getLTHelper(pJobID, pClass, pMethod, null, null);
        mReturn.logEntry(pParams);
        return mReturn;
    }

    public static LogTraceHelper entry(Object pClass, String pMethod, Object[] pParams) {
        return LogTraceHelper.entry((String)null, pClass, pMethod, pParams);
    }

    public static final LogTraceHelper entry(Token pCtrlToken, Object pClass, String pMethod, Object[] pParams) {
        if (pCtrlToken == null) {
            return LogTraceHelper.entry(pClass, pMethod, pParams);
        }
        LogTraceHelper mReturn = LogTraceHelperFactory.getLTHelper(null, pClass, pMethod, null, pCtrlToken);
        mReturn.logEntry(pParams);
        return mReturn;
    }

    public static final LogTraceHelper entry(Request pDiscoverRequest, Object pClass, String pMethod, Object[] pParams) {
        LogTraceHelper mReturn = LogTraceHelperFactory.getLTHelper(null, pClass, pMethod, pDiscoverRequest, null);
        mReturn.logEntry(pParams);
        return mReturn;
    }

    private final void logEntry(Object[] pParams) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099995I", new Object[]{this.cClass, this.cMethodName, DiskMessageHelper.toMsgString(pParams), this.getContextInfo()}));
    }

    public void exit(Object pResult) {
        this.cEndTS = System.currentTimeMillis();
        if (LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099996I", new Object[]{this.cClass, this.cMethodName, DiskMessageHelper.toMsgString(pResult), new Long(this.cEndTS - this.cStartTS), this.getContextInfo()}));
        }
        if (!this.isInPool()) {
            LogTraceHelperFactory.returnInstance(this);
        }
    }

    public void logMsg(String pMsgID, Object[] pParams) {
        LogTraceHelperFactory.getDMTrcLogger().text(Level.OFF, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveAPIMessage(pMsgID, pParams) + " @(" + this.getContextInfo() + ")");
        if (this.cJobLogger != null) {
            this.cJobLogger.message(LogTraceHelper.extractLevel(pMsgID), (Object)this.cClass, this.cMethodName, pMsgID, pParams);
        } else {
            this.logDMMsgRecord(pMsgID, pParams);
        }
    }

    public void traceInfo(String pMsg) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.INFO, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099991I", new Object[]{pMsg, this.getContextInfo()}));
    }

    public void traceAlways(String pMsg) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            System.out.println("DiskManagerTrace: " + LogTraceHelperFactory.resolveMessage("HWN099991I", new Object[]{pMsg, this.getContextInfo()}) + " " + this.cClass + " " + this.cMethodName);
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.OFF, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099991I", new Object[]{pMsg, this.getContextInfo()}));
    }

    public void traceHigh(String pMsg) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099991I", new Object[]{pMsg, this.getContextInfo()}));
    }

    public void traceWarning(String pMsg) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.WARN, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099992W", new Object[]{pMsg, this.getContextInfo()}));
    }

    public void traceSvcEntry(String pService, Object[] pParams) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MIN, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099997I", new Object[]{pService, DiskMessageHelper.toMsgString(pParams), this.getContextInfo()}));
    }

    public void traceSvcReturn(String pService, Object pResult) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MIN, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099998I", new Object[]{pService, DiskMessageHelper.toMsgString(pResult), this.getContextInfo()}));
    }

    public void objectCreation(String pClass) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099994I", new Object[]{pClass, this.getContextInfo()}));
    }

    public void traceError(String pMsg, Throwable pException) {
        if (pException != null) {
            LogTraceHelperFactory.getDMTrcLogger().exception(Level.ERROR, this.cClass, this.cMethodName, pException, LogTraceHelperFactory.resolveMessage("HWN099993E", new Object[]{pMsg, this.getContextInfo()}));
        } else {
            LogTraceHelperFactory.getDMTrcLogger().text(Level.ERROR, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099993E", new Object[]{pMsg, this.getContextInfo()}));
        }
    }

    private final void logDMMsgRecord(String pMsgID, Object[] pParams) {
        if (!LogTraceHelperFactory.getDMMsgLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMMsgLogger().message(LogTraceHelper.extractLevel(pMsgID), (Object)this.cClass, this.cMethodName, pMsgID, pParams);
    }

    private static final Level extractLevel(String pMsgID) {
        int MSG_LENGTH = 10;
        if (pMsgID == null || pMsgID.length() != 10) {
            throw new IllegalArgumentException("Not a valid message ID: " + pMsgID);
        }
        char mLevelCode = pMsgID.charAt(9);
        switch (Character.getNumericValue(mLevelCode)) {
            case 14: {
                return Level.ERROR;
            }
            case 32: {
                return Level.WARN;
            }
            case 18: {
                return Level.INFO;
            }
        }
        throw new IllegalArgumentException("Not a valid message ID: " + pMsgID);
    }

    public final boolean isTraceHighEnabled() {
        return LogTraceHelperFactory.getDMTrcLogger().isLoggable(Level.DEBUG_MAX);
    }

    public void traceDMInvokation(Object[] pParams) {
        this.cInvokationParms = DiskMessageHelper.toMsgString(pParams);
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.OFF, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099999I", new Object[]{this.cMethodName, DiskMessageHelper.toMsgString(pParams), this.getContextInfo()}));
    }

    public void traceDMReturn(Object pRetVal) {
        this.logAuditMsg(this.cInvokationParms, pRetVal);
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        LogTraceHelperFactory.getDMTrcLogger().text(Level.OFF, this.cClass, this.cMethodName, LogTraceHelperFactory.resolveMessage("HWN099990I", new Object[]{this.cMethodName, DiskMessageHelper.toMsgString(pRetVal), this.getContextInfo()}));
    }

    private final String getContextInfo() {
        if (this.cCtxtID == null) {
            if (this.cReqID == null) {
                this.cCtxtID = "Invalid usage of LogTraceHelper. exit() called before calling trace function.";
            } else {
                StringBuffer mCtxtInfo = new StringBuffer(50);
                mCtxtInfo.append(this.cExecID).append(';');
                mCtxtInfo.append('[').append(this.cReqID[0]).append(',').append(this.cReqID[1]).append(',').append(this.cReqID[2]).append(']');
                mCtxtInfo.append(';').append(this.cJobID).append(';');
                mCtxtInfo.append(Thread.currentThread().getName());
                this.cCtxtID = mCtxtInfo.toString();
            }
        }
        return this.cCtxtID;
    }

    private final void logAuditMsg(String pParms, Object pResult) {
        if (pResult instanceof AsyncResult) {
            ServiceUtils.recordInAuditLog("DiskManagerService", this.cMethodName, pParms, (AsyncResult)pResult);
        } else {
            ServiceUtils.recordInAuditLog("DiskManagerService", this.cMethodName, pParms, DiskMessageHelper.toMsgString(pResult));
        }
    }

    public void traceARMPoint(String pPointIdentifier) {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        long mExectime = System.currentTimeMillis() - this.cStartTS;
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, "HWN100000I ARM point " + pPointIdentifier + " reached. (" + mExectime + ") @(" + this.getContextInfo() + ")");
    }

    public void traceCallStack() {
        if (!LogTraceHelperFactory.getDMTrcLogger().isLogging()) {
            return;
        }
        Exception mEx = new Exception();
        mEx.fillInStackTrace();
        LogTraceHelperFactory.getDMTrcLogger().text(Level.DEBUG_MAX, this.cClass, this.cMethodName, "HWN100001I CallStack @(" + this.getContextInfo() + ")\n" + DiskMessageHelper.toMsgString(mEx.getStackTrace()));
    }
}

