/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlStorageSubsystem;

public class ExternalKeyConverter {
    public static final String DELIMITER = "+";
    public static final int STORAGE_SUBSYSTEM_KEY_PART_COUNT = 2;
    public static final int STORAGE_SUBSYSTEM_KEY_NAME_FORMAT_POSISTION = 1;
    public static final int STORAGE_EXTEND_KEY_PART_COUNT = 3;
    public static final int STORAGE_POOL_KEY_PART_COUNT = 3;
    public static final int STORAGE_POOL_KEY_SUBSYSTEM_NAME_FORMAT_POSISTION = 2;
    public static final int STORAGE_VOLUME_KEY_PART_COUNT = 4;
    public static final int STORAGE_VOLUME_KEY_VOL_NAME_FORMAT_POSISTION = 1;
    public static final int STORAGE_VOLUME_KEY_SUBSYSTEM_NAME_FORMAT_POSISTION = 3;
    public static final int PORT_KEY_PART_COUNT = 4;

    public static String frameKeyStorageSubsystem(String name, short nameFormat) {
        return new String(ExternalKeyConverter.convertString(name) + DELIMITER + nameFormat);
    }

    public static String frameKeyStoragePool(String instanceID, String name, short nameFormat) {
        return new String(ExternalKeyConverter.convertString(instanceID) + DELIMITER + ExternalKeyConverter.convertString(name) + DELIMITER + nameFormat);
    }

    public static String frameKeyStorageExtent(String deviceID, String name, short nameFormat) {
        return new String(ExternalKeyConverter.convertString(deviceID) + DELIMITER + ExternalKeyConverter.convertString(name) + DELIMITER + nameFormat);
    }

    public static String frameKeyStorageVolume(String volumeName, short volumeNameFormat, String name, short nameFormat) {
        return new String(ExternalKeyConverter.convertString(volumeName) + DELIMITER + volumeNameFormat + DELIMITER + ExternalKeyConverter.convertString(name) + DELIMITER + nameFormat);
    }

    public static String frameKeyCIMOM(String host, int port) {
        return new String(host + DELIMITER + port);
    }

    public static String frameKeyStorageSubsystemFromPool(String key, LogTraceHelper mLTH) throws IDParseException {
        String[] keys = ExternalKeyConverter.obtainStoragePoolKeyParts(key, mLTH);
        String subsystemKey = new String(ExternalKeyConverter.convertString(keys[1]) + DELIMITER + ExternalKeyConverter.convertString(keys[2]));
        return subsystemKey;
    }

    public static String frameKeyStorageSubsystemFromExtent(String key, LogTraceHelper mLTH) throws IDParseException {
        String subsystemKey = null;
        String[] keys = ExternalKeyConverter.obtainStorageExtentKeyParts(key, mLTH);
        subsystemKey = new String(ExternalKeyConverter.convertString(keys[1]) + DELIMITER + ExternalKeyConverter.convertString(keys[2]));
        return subsystemKey;
    }

    public static String frameKeyStorageSubsystemFromVolume(String key, LogTraceHelper mLTH) throws IDParseException {
        String subsystemKey = null;
        String[] keys = ExternalKeyConverter.obtainStorageVolumeKeyParts(key, mLTH);
        subsystemKey = new String(ExternalKeyConverter.convertString(keys[2]) + DELIMITER + ExternalKeyConverter.convertString(keys[3]));
        return subsystemKey;
    }

    public static String getPortKey(Port pInstance) {
        return pInstance.getName();
    }

    public static String[] splitKey(String ID2) {
        String[] mReturn = ID2.split("\\+");
        mReturn = ExternalKeyConverter.checkForSlash(mReturn);
        String mPart1 = null;
        String mPart2 = null;
        for (int mLoop = 0; mLoop < mReturn.length; ++mLoop) {
            mPart1 = mReturn[mLoop].replaceAll("\\\\\\\\", "\\\\");
            mReturn[mLoop] = mPart2 = mPart1.replaceAll("\\\\\\+", "\\+");
        }
        return mReturn;
    }

    private static String[] checkForSlash(String[] pKeys) {
        LinkedList<String> mReturn = new LinkedList<String>();
        String mPart = null;
        if (pKeys.length > 0) {
            boolean mJoin = false;
            for (int mLoop = 0; mLoop < pKeys.length; ++mLoop) {
                mPart = mJoin ? mPart + DELIMITER + pKeys[mLoop] : pKeys[mLoop];
                if (mPart.endsWith("\\")) {
                    int mCount = ExternalKeyConverter.countSlashFromEnd(mPart);
                    if (mCount % 2 == 0) {
                        mReturn.add(mPart);
                        mJoin = false;
                        mPart = null;
                        continue;
                    }
                    mJoin = true;
                    continue;
                }
                mReturn.add(mPart);
                mJoin = false;
                mPart = null;
            }
        }
        if (mPart != null) {
            mReturn.add(mPart + DELIMITER);
        }
        return mReturn.toArray(new String[0]);
    }

    public static String excapeDelimiter(String pString) {
        return pString.replaceAll("\\+", "\\\\+");
    }

    private static int countSlashFromEnd(String pPart) {
        int mReturn = 0;
        for (int mLoop = pPart.length() - 1; mLoop >= 0; --mLoop) {
            if (pPart.charAt(mLoop) == '\\') {
                ++mReturn;
                continue;
            }
            return mReturn;
        }
        return mReturn;
    }

    public static Object getStoragePoolKey(StoragePool pCurrInst, String pSubsystem, LogTraceHelper mLTH) throws IDParseException {
        String[] keys = ExternalKeyConverter.obtainStorageSubsystemKeyParts(pSubsystem, mLTH);
        return ExternalKeyConverter.convertString(pCurrInst.getInstanceId()) + DELIMITER + ExternalKeyConverter.convertString(keys[0]) + DELIMITER + ExternalKeyConverter.convertString(keys[1]);
    }

    public static Object getStoragePoolKey(StoragePool pCurrInst, StorageSubsystem pSubsystem) {
        return ExternalKeyConverter.convertString(pCurrInst.getInstanceId()) + DELIMITER + ExternalKeyConverter.getStorageSubsystemKey(pSubsystem);
    }

    public static Object getStorageVolumeKey(StorageVolume pCurrInst, String pSubsystem, LogTraceHelper mLTH) throws IDParseException {
        String[] keys = ExternalKeyConverter.obtainStorageSubsystemKeyParts(pSubsystem, mLTH);
        return ExternalKeyConverter.convertString(pCurrInst.getName()) + DELIMITER + pCurrInst.getNameFormat() + DELIMITER + ExternalKeyConverter.convertString(keys[0]) + DELIMITER + ExternalKeyConverter.convertString(keys[1]);
    }

    public static Object getStorageSubsystemKey(StorageSubsystem pCurrInst) {
        return ExternalKeyConverter.convertString(pCurrInst.getName()) + DELIMITER + pCurrInst.getNameFormat();
    }

    public static Hashtable getStorageSubsystemWhereClause(String pSubsystemID, LogTraceHelper pLTH) {
        Hashtable<ColumnInfo, String> mReturn = new Hashtable<ColumnInfo, String>();
        String[] keys = ExternalKeyConverter.splitKey(pSubsystemID);
        ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME", pLTH);
        mReturn.put(mInfo, keys[0]);
        mInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME_FORMAT", pLTH);
        mReturn.put(mInfo, keys[1]);
        return mReturn;
    }

    public static Hashtable getVolumeWhereclause(LogTraceHelper pLTH, String pStorageVolumeIDs, DBConnection pConn) throws ServerException {
        DBResultSet mResultSet = null;
        try {
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, "NAME", pLTH);
            String[] keys = ExternalKeyConverter.splitKey(pStorageVolumeIDs);
            if (keys.length != 4) {
                throw new InvalidParameterException(1, new SRMMessage("HWN020003E", new String[]{pStorageVolumeIDs}));
            }
            mWhereClause.put(mInfo, keys[0]);
            mInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, "NAME_FORMAT", pLTH);
            mWhereClause.put(mInfo, keys[1]);
            Hashtable<ColumnInfo, String> mParams = new Hashtable<ColumnInfo, String>();
            mInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME", pLTH);
            mParams.put(mInfo, keys[2]);
            mInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME_FORMAT", pLTH);
            mParams.put(mInfo, keys[3]);
            mResultSet = SqlStorageSubsystem.sqlQuery(pConn, SqlStorageSubsystem.querySubSystemID, mParams);
            while (mResultSet.next()) {
                int mID = mResultSet.getInt("SUBSYSTEM_ID");
                mInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, "SUBSYSTEM_ID", pLTH);
                mWhereClause.put(mInfo, Integer.toString(mID));
            }
            Hashtable<ColumnInfo, String> hashtable = mWhereClause;
            return hashtable;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
        finally {
            if (mResultSet != null) {
                try {
                    mResultSet.getStatement().close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public static Hashtable getPoolWhereclause(LogTraceHelper pLTH, String pPoolIDs, DBConnection pConn) {
        DBResultSet mResultSet = null;
        try {
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(StoragePool.class, "INSTANCE_ID", pLTH);
            String[] keys = ExternalKeyConverter.splitKey(pPoolIDs);
            mWhereClause.put(mInfo, keys[0]);
            mInfo = DiskReportingHelper.getColumnInfo(StoragePool.class, "PRIMORDIAL", pLTH);
            mWhereClause.put(mInfo, "0");
            Hashtable<ColumnInfo, String> mParams = new Hashtable<ColumnInfo, String>();
            mInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME", pLTH);
            mParams.put(mInfo, keys[1]);
            mInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME_FORMAT", pLTH);
            mParams.put(mInfo, keys[2]);
            mResultSet = SqlStorageSubsystem.sqlQuery(pConn, SqlStorageSubsystem.querySubSystemID, mParams);
            while (mResultSet.next()) {
                int mID = mResultSet.getInt("SUBSYSTEM_ID");
                mInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, "SUBSYSTEM_ID", pLTH);
                mWhereClause.put(mInfo, Integer.toString(mID));
            }
            Hashtable<ColumnInfo, String> hashtable = mWhereClause;
            return hashtable;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
        finally {
            if (mResultSet != null) {
                try {
                    mResultSet.getStatement().close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public static String[] obtainStorageSubsystemKeyParts(String storagesubsystemKey, LogTraceHelper mLTH) throws IDParseException {
        String[] mStorageSubsystemKeyParts = null;
        String[] bKeyParts = ExternalKeyConverter.splitKey(storagesubsystemKey);
        if (ExternalKeyConverter.checkValidFormatForLength(bKeyParts, 2, mLTH) && ExternalKeyConverter.checkValidFormatForType(bKeyParts, 1, mLTH)) {
            mStorageSubsystemKeyParts = bKeyParts;
        }
        return mStorageSubsystemKeyParts;
    }

    public static String[] obtainStoragePoolKeyParts(String storagePoolKey, LogTraceHelper mLTH) throws IDParseException {
        String[] mStoragePoolKeyParts = null;
        String[] bKeyParts = ExternalKeyConverter.splitKey(storagePoolKey);
        if (ExternalKeyConverter.checkValidFormatForLength(bKeyParts, 3, mLTH) && ExternalKeyConverter.checkValidFormatForType(bKeyParts, 2, mLTH)) {
            mStoragePoolKeyParts = bKeyParts;
        }
        return mStoragePoolKeyParts;
    }

    public static String[] obtainStorageExtentKeyParts(String storageExtentKey, LogTraceHelper mLTH) throws IDParseException {
        String[] mStorageExtentKeyParts = null;
        String[] bKeyParts = ExternalKeyConverter.splitKey(storageExtentKey);
        if (ExternalKeyConverter.checkValidFormatForLength(bKeyParts, 3, mLTH)) {
            mStorageExtentKeyParts = bKeyParts;
        }
        return mStorageExtentKeyParts;
    }

    public static String[] obtainStorageVolumeKeyParts(String storageVolumeKey, LogTraceHelper mLTH) throws IDParseException {
        String[] mStorageVolumeKeyParts = null;
        String[] bKeyParts = ExternalKeyConverter.splitKey(storageVolumeKey);
        if (ExternalKeyConverter.checkValidFormatForLength(bKeyParts, 4, mLTH) && ExternalKeyConverter.checkValidFormatForType(bKeyParts, 1, mLTH) && ExternalKeyConverter.checkValidFormatForType(bKeyParts, 3, mLTH)) {
            mStorageVolumeKeyParts = bKeyParts;
        }
        return mStorageVolumeKeyParts;
    }

    public static String[] obtainPortKeyParts(String portKey, LogTraceHelper mLTH) throws IDParseException {
        String[] portKeyParts = new String[]{portKey};
        return portKeyParts;
    }

    private static boolean checkValidFormatForLength(String[] keyParts, int length, LogTraceHelper mLTH) throws IDParseException {
        if (keyParts != null && keyParts.length == length) {
            return true;
        }
        throw new IDParseException();
    }

    private static boolean checkValidFormatForType(String[] keyParts, int position, LogTraceHelper mLTH) throws IDParseException {
        boolean mResult = false;
        try {
            short keyPertType = Short.parseShort(keyParts[position]);
            mResult = true;
        }
        catch (Exception ex) {
            mLTH.traceError(ex.getMessage(), ex);
            throw new IDParseException(ex);
        }
        return mResult;
    }

    private static String convertString(String mParam) {
        mParam = mParam.replaceAll("\\\\", "\\\\\\\\");
        mParam = mParam.replaceAll("\\+", "\\\\+");
        return mParam;
    }
}

