/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.ConfigData;

public class ParameterHelper {
    public static Long[] convertToLong(long[] longArray) {
        Long[] longObjects = null;
        try {
            if (longArray != null) {
                longObjects = new Long[longArray.length];
                for (int idx = 0; idx < longArray.length; ++idx) {
                    longObjects[idx] = new Long(longArray[idx]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return longObjects;
    }

    public static int getPortFromServiceUrl(String pServiceUrl) {
        int mPort = -1;
        if (!ParameterHelper.isValidServiceUrl(pServiceUrl)) {
            return mPort;
        }
        int mLastColonIndex = pServiceUrl.lastIndexOf(":");
        String mPortString = pServiceUrl.substring(mLastColonIndex + 1);
        try {
            mPort = Integer.parseInt(mPortString);
        }
        catch (NumberFormatException bNFE) {
            bNFE.printStackTrace();
        }
        return mPort;
    }

    public static String hashtableToString(Hashtable pTable) {
        StringBuffer mBuffer = new StringBuffer("");
        String mKey = null;
        Object mObj = null;
        if (pTable != null && !pTable.isEmpty()) {
            Enumeration mEnum = pTable.keys();
            while (mEnum.hasMoreElements()) {
                mKey = (String)mEnum.nextElement();
                mObj = pTable.get(mKey);
                mBuffer.append(mKey + " :");
                if (mObj instanceof String[]) {
                    mBuffer.append(ParameterHelper.stringArrayToString(mObj));
                    mBuffer.append(" ,");
                    continue;
                }
                if (mObj instanceof String) {
                    mBuffer.append((String)mObj);
                    mBuffer.append(" ,");
                    continue;
                }
                if (mObj instanceof Boolean) {
                    mBuffer.append((Object)mObj);
                    mBuffer.append(" ,");
                    continue;
                }
                mBuffer.append("No supported object");
            }
        }
        return mBuffer.toString();
    }

    public static String intArrayToString(int[] intArray) {
        String mString = "";
        try {
            if (intArray != null && intArray.length != 0) {
                for (int bI = 0; bI < intArray.length; ++bI) {
                    mString = mString + intArray[bI] + ", ";
                }
                mString = mString.substring(0, mString.length() - 2);
            }
        }
        catch (Exception e) {
            mString = "";
        }
        return mString;
    }

    public static String longArrayToString(long[] longArray) {
        String mString = "";
        try {
            if (longArray != null && longArray.length != 0) {
                for (int bI = 0; bI < longArray.length; ++bI) {
                    mString = mString + longArray[bI] + ", ";
                }
                mString = mString.substring(0, mString.length() - 2);
            }
        }
        catch (Exception e) {
            mString = "";
        }
        return mString;
    }

    public static String stringArrayToString(String[] pStringArray) {
        String mString = "";
        try {
            if (pStringArray != null && pStringArray.length != 0) {
                for (int bI = 0; bI < pStringArray.length; ++bI) {
                    mString = mString + pStringArray[bI] + ", ";
                }
                mString = mString.substring(0, mString.length() - 2);
            }
        }
        catch (Exception e) {
            mString = "";
        }
        return mString;
    }

    public boolean isValidIP(String ip) {
        char[] chars = ip.toCharArray();
        char point = '.';
        char minus = '-';
        char underscore = '_';
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetterOrDigit(chars[i]) || chars[i] == point || chars[i] == minus || chars[i] == underscore) continue;
            return false;
        }
        return true;
    }

    public static String getIpFromServiceUrl(String pServiceUrl) {
        if (!ParameterHelper.isValidServiceUrl(pServiceUrl)) {
            return null;
        }
        int mFirstColonIndex = pServiceUrl.indexOf(":");
        int mLastColonIndex = pServiceUrl.lastIndexOf(":");
        String mIP = pServiceUrl.substring(mFirstColonIndex + 3, mLastColonIndex - 1);
        return mIP;
    }

    public static boolean isValidServiceUrl(String pServiceUrl) {
        boolean mIsValid = false;
        if (pServiceUrl.indexOf(":") != pServiceUrl.lastIndexOf(":") && pServiceUrl.startsWith("http") && pServiceUrl.indexOf("//") > 0 && pServiceUrl.lastIndexOf(":") == pServiceUrl.length() - 4) {
            mIsValid = true;
        }
        return mIsValid;
    }

    public static int[] convertTointArray(String pParam) {
        int[] mReturn = null;
        StringTokenizer mToken = new StringTokenizer(pParam, ",");
        mReturn = new int[mToken.countTokens()];
        int mCount = 0;
        while (mToken.hasMoreTokens()) {
            String mValue = mToken.nextToken();
            mReturn[mCount] = Integer.parseInt(mValue);
            ++mCount;
        }
        return mReturn;
    }

    public static String[] convertToStringArray(String pParam) {
        String[] mReturn = null;
        StringTokenizer mToken = new StringTokenizer(pParam, ",");
        mReturn = new String[mToken.countTokens()];
        int mCount = 0;
        while (mToken.hasMoreTokens()) {
            mReturn[mCount++] = mToken.nextToken();
        }
        return mReturn;
    }

    public static final ConfigData readConfigData(DBConnection pConn, String pParameter, LogTraceHelper pLTH) {
        ConfigData mCD = null;
        try {
            if (pConn != null && pParameter != null) {
                mCD = new ConfigData();
                mCD.setAttribute(pParameter);
                boolean mReturn = mCD.retrieve(pConn);
                if (!mReturn) {
                    mCD = null;
                }
            }
        }
        catch (SQLException e) {
            pLTH.traceInfo("No retrieved parameter " + pParameter + " from ConfigData ");
        }
        return mCD;
    }
}

