/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util.thread;

import java.util.ArrayList;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskMgrThread;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadPool;
import org.eclipse.aperi.disk.common.util.thread.ExecGroup;

public final class DiskThreadManager {
    private static DiskThreadManager stSingletonInstance = null;
    private DiskThreadPool cThreads = new DiskThreadPool();

    private DiskThreadManager() {
    }

    public static final DiskThreadManager get() {
        return stSingletonInstance;
    }

    public static Object executeWithTimeLimit(Object pInstance, String pMethod, Object[] pParams, long pTimeout, LogTraceHelper pLTH) throws DiskManagerTimeoutException, DiskManagerExecException {
        return DiskThreadManager.executeWithTimeLimit(pInstance, pMethod, DiskThreadManager.getParamTypes(pParams), pParams, pTimeout, pLTH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeWithTimeLimit(Object pInstance, String pMethod, Class[] pParamTypes, Object[] pParams, long pTimeout, LogTraceHelper pLTH) throws DiskManagerTimeoutException, DiskManagerExecException {
        ExecGroup mExecGroup = DiskThreadManager.getExecutionGroup();
        try {
            Long mExecID = mExecGroup.execute(pInstance, pMethod, pParamTypes, pParams, pLTH);
            mExecGroup.waitForCompletion(pTimeout);
            if (mExecGroup.getExecutionError(mExecID) != null) {
                throw new DiskManagerExecException(mExecGroup.getExecutionError(mExecID));
            }
            Object object = mExecGroup.getExecutionResult(mExecID);
            return object;
        }
        finally {
            mExecGroup.clear();
        }
    }

    public static ExecGroup getExecutionGroup() {
        return new ExecGroup(DiskThreadManager.get());
    }

    protected DiskMgrThread getThread() {
        return this.cThreads.getThread(this);
    }

    protected void returnThread(DiskMgrThread pThread) {
        this.cThreads.returnThread(pThread);
    }

    public static void shutdown() {
        DiskThreadManager.get().cThreads.clear();
    }

    public static Class[] getParamTypes(Object[] pParams) {
        ArrayList mParamTypeList = new ArrayList();
        for (int bParamIndex = 0; bParamIndex < pParams.length; ++bParamIndex) {
            if (pParams[bParamIndex] == null) {
                throw new IllegalArgumentException("Element at index " + bParamIndex + "in parameter array must not be null.");
            }
            mParamTypeList.add(pParams[bParamIndex].getClass());
        }
        return mParamTypeList.toArray(new Class[mParamTypeList.size()]);
    }

    static {
        stSingletonInstance = new DiskThreadManager();
    }
}

