/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util.thread;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerRTException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskMgrThread;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.disk.common.util.thread.ThreadObserver;
import org.eclipse.aperi.interfaces.IController;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class ExecGroup
implements ThreadObserver {
    private static Random stRandom = null;
    private long cID = -1L;
    private Map cTasks = null;
    private Map cSubJobs = null;
    private DiskThreadManager cThreadMgr = null;
    public static final String TRACE_NAME = "aperi.logger.trace.CIMScanner";
    public static ILogger traceLogger;
    public static String className;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecGroup(DiskThreadManager pMgr) {
        Class<ExecGroup> clazz = ExecGroup.class;
        synchronized (ExecGroup.class) {
            this.cID = System.currentTimeMillis() + (long)((int)(Math.random() * 100.0));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.cTasks = new Hashtable();
            this.cSubJobs = new Hashtable();
            this.cThreadMgr = pMgr;
            return;
        }
    }

    public Long execute(Object pInstance, String pMethod, Object[] pParams, LogTraceHelper pLTH) {
        return this.execute(pInstance, pMethod, DiskThreadManager.getParamTypes(pParams), pParams, pLTH);
    }

    public Long executeAsSubJob(Object pInstance, String pMethod, Object[] pParams, LogTraceHelper pLTH, IController pController, int pNumOfJobs) {
        Long pExecID = this.execute(pInstance, pMethod, DiskThreadManager.getParamTypes(pParams), pParams, pLTH);
        int[] mJobArray = new int[pNumOfJobs];
        for (int bJobs = 0; bJobs < pNumOfJobs; ++bJobs) {
            mJobArray[bJobs] = pController.startSubJob(pMethod + pExecID, false);
        }
        this.cSubJobs.put(pExecID, mJobArray);
        return pExecID;
    }

    public AsyncResult getExecutionResultInSubJob(Long pExecID, IController pController, LogTraceHelper pLTH) throws DiskManagerExecException {
        String methodName = "getExecutionResultInSubJob";
        AsyncResult mResult = new AsyncResult(-1, -1);
        AsyncResult mOverAllStatus = null;
        int[] mSubJobArray = (int[])this.cSubJobs.get(pExecID);
        Object mJobResults = null;
        try {
            mJobResults = this.getExecutionResult(pExecID);
        }
        catch (Exception mEx) {
            mOverAllStatus = new AsyncResult(0, 0, new SRMMessage("HWN021503E", null));
            mOverAllStatus.setReturnException(mEx);
            for (int bJobIndex = 0; bJobIndex < mSubJobArray.length; ++bJobIndex) {
                pController.endSubJob(mSubJobArray[bJobIndex], mOverAllStatus.getRc(), mOverAllStatus.getStatus(), mOverAllStatus.getSRMMessage(), mEx, null);
            }
            return mOverAllStatus;
        }
        if (mJobResults instanceof AsyncResult) {
            AsyncResult[] mRealResults = ((AsyncResult)mJobResults).getSubJobResults();
            for (int bJobIndex = 0; bJobIndex < mSubJobArray.length; ++bJobIndex) {
                pController.endSubJob(mSubJobArray[bJobIndex], mRealResults[bJobIndex].getRc(), mRealResults[bJobIndex].getStatus(), mRealResults[bJobIndex].getSRMMessage(), null, mRealResults[bJobIndex].getResults());
            }
            mOverAllStatus = (AsyncResult)mJobResults;
        } else if (mJobResults instanceof AsyncResult[]) {
            AsyncResult[] mRealResults = (AsyncResult[])mJobResults;
            if (mSubJobArray.length != mRealResults.length) {
                if (pLTH != null) {
                    pLTH.traceInfo("Usage of executeAsSubJob and getExecutionResultInSubJob wrong: Number of AsyncResults must correspond to jobs created.");
                    pLTH.traceInfo("If asynchronously started method returns a AsyncResult only (no array), number of jobs must be one.");
                } else if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "Usage of executeAsSubJob and getExecutionResultInSubJob wrong: Number of AsyncResults must correspond to jobs created.");
                    traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "If asynchronously started method returns a AsyncResult only (no array), number of jobs must be one.");
                }
                throw DiskMessageHelper.getServerException("HWN021503E", null, pLTH);
            }
            for (int bJobIndex = 0; bJobIndex < mSubJobArray.length; ++bJobIndex) {
                pController.endSubJob(mSubJobArray[bJobIndex], mRealResults[bJobIndex].getRc(), mRealResults[bJobIndex].getStatus(), mRealResults[bJobIndex].getSRMMessage(), null, mRealResults[bJobIndex].getResults());
            }
            mOverAllStatus = ResultHelper.computeAndSetFinalStatus(mRealResults, methodName);
            mOverAllStatus.setSubJobResults(mRealResults);
        }
        return mOverAllStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long execute(Object pInstance, String pMethod, Class[] pParamTypes, Object[] pParams, LogTraceHelper pLTH) {
        String methodName = "execute";
        Long mReturn = null;
        Class<ExecGroup> clazz = ExecGroup.class;
        synchronized (ExecGroup.class) {
            mReturn = new Long(System.currentTimeMillis() * 100L + (long)stRandom.nextInt(100));
            // ** MonitorExit[var8_8] (shouldn't be in output)
            try {
                DiskMgrThread mThread = this.cThreadMgr.getThread();
                mThread.execute(this, pInstance, pMethod, pParamTypes, pParams);
                this.cTasks.put(mReturn, mThread);
                return mReturn;
            }
            catch (NoSuchMethodException pEx) {
                if (pLTH != null) {
                    pLTH.traceError("ExecGroup.execute - Internal error: NoSuchMethodException", pEx);
                } else if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, className, methodName, "ExecGroup.execute - Internal error: NoSuchMethodException" + pEx);
                }
                throw new DiskManagerRTException(pEx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion(long pTimeout) throws DiskManagerTimeoutException {
        long mStartTS = System.currentTimeMillis();
        while (!this.checkCompletion()) {
            ExecGroup execGroup = this;
            synchronized (execGroup) {
                try {
                    this.wait(pTimeout / 5L);
                }
                catch (InterruptedException pEx) {
                    // empty catch block
                }
                if (pTimeout > 0L && !this.checkCompletion() && System.currentTimeMillis() > mStartTS + pTimeout) {
                    throw new DiskManagerTimeoutException("Execution time exceeded " + pTimeout + " milliseconds");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyExecutionComplete() {
        ExecGroup execGroup = this;
        synchronized (execGroup) {
            this.notifyAll();
        }
    }

    private boolean checkCompletion() {
        for (Map.Entry mCurEntry : this.cTasks.entrySet()) {
            if (((DiskMgrThread)mCurEntry.getValue()).cIsExecutionComplete()) continue;
            return false;
        }
        return true;
    }

    public Object getExecutionResult(Long pExecID) throws DiskManagerExecException {
        Throwable bError = null;
        bError = this.getExecutionError(pExecID);
        if (bError != null) {
            throw new DiskManagerExecException(bError);
        }
        DiskMgrThread mThread = (DiskMgrThread)this.cTasks.get(pExecID);
        if (mThread != null) {
            return mThread.getResult();
        }
        return null;
    }

    public Map getExecutionResults() {
        HashMap<Long, Object> mReturn = new HashMap<Long, Object>();
        for (Long mCurrKey : this.cTasks.keySet()) {
            mReturn.put(mCurrKey, ((DiskMgrThread)this.cTasks.get(mCurrKey)).getResult());
        }
        return mReturn;
    }

    public Map getExecutionErrors() {
        HashMap<Long, Throwable> mReturn = new HashMap<Long, Throwable>();
        for (Long mCurrKey : this.cTasks.keySet()) {
            mReturn.put(mCurrKey, ((DiskMgrThread)this.cTasks.get(mCurrKey)).getThrowable());
        }
        return mReturn;
    }

    public Throwable getExecutionError(Long pExecID) {
        DiskMgrThread mThread = (DiskMgrThread)this.cTasks.get(pExecID);
        if (mThread != null) {
            return mThread.getThrowable();
        }
        return null;
    }

    public synchronized void clear() {
        Iterator mTaskIt = this.cTasks.entrySet().iterator();
        while (mTaskIt.hasNext()) {
            Map.Entry mCurEntry = mTaskIt.next();
            this.cThreadMgr.returnThread((DiskMgrThread)mCurEntry.getValue());
            mTaskIt.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    static {
        stRandom = new Random();
        traceLogger = null;
        className = ExecGroup.class.getName();
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
    }
}

