/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.sblim.wbem.cim.CIMObjectPath;

public class CreateStorageVolumesParameter
extends ConfigurationParameter {
    protected ArrayList storagePools = new ArrayList();
    protected ArrayList storagePoolCIMOPs = new ArrayList();
    protected ArrayList sizes = new ArrayList();
    protected ArrayList volumeNames = new ArrayList();
    protected String cVolumeElementName = "";

    public CreateStorageVolumesParameter(StorageSubsystem pStorageSubsystem, CIMObjectPath pStorageSystemCIMOP) {
        super(pStorageSubsystem, pStorageSystemCIMOP);
    }

    public void addCreateStorageVolumeParameter(StoragePool pStgPool, CIMObjectPath pStoragePoolCIMOP, long pSize, String pVolumeName) {
        boolean isAppend = true;
        int mPoolInsertIdx = 0;
        for (int idx = this.storagePools.size(); idx > 0; --idx) {
            if (pStgPool.getInstanceId().compareTo(((StoragePool)this.storagePools.get(--idx)).getInstanceId()) > 0) continue;
            mPoolInsertIdx = ++idx;
            isAppend = false;
            break;
        }
        if (isAppend) {
            this.storagePools.add(pStgPool);
            this.storagePoolCIMOPs.add(pStoragePoolCIMOP);
            this.sizes.add(new Long(pSize));
            this.volumeNames.add(pVolumeName);
        } else {
            this.storagePools.add(mPoolInsertIdx, pStgPool);
            this.storagePoolCIMOPs.add(mPoolInsertIdx, pStoragePoolCIMOP);
            this.sizes.add(mPoolInsertIdx, new Long(pSize));
            this.volumeNames.add(mPoolInsertIdx, pVolumeName);
        }
    }

    public long[] getSizes() {
        Long[] sizesL = new Long[this.sizes.size()];
        sizesL = this.sizes.toArray(sizesL);
        long[] sizes = new long[sizesL.length];
        for (int idx = 0; idx < sizesL.length; ++idx) {
            sizes[idx] = sizesL[idx];
        }
        return sizes;
    }

    public StoragePool[] getStoragePools() {
        StoragePool[] mSP = new StoragePool[this.storagePools.size()];
        return this.storagePools.toArray(mSP);
    }

    public CIMObjectPath[] getStoragePoolCIMOPs() {
        CIMObjectPath[] mCO = new CIMObjectPath[this.storagePoolCIMOPs.size()];
        return this.storagePoolCIMOPs.toArray(mCO);
    }

    public String[] getVolumeNames() {
        String[] mSTR = new String[this.volumeNames.size()];
        return this.volumeNames.toArray(mSTR);
    }

    public String getVolumeElementName() {
        return this.cVolumeElementName;
    }

    public void setVolumeElementName(String pString) {
        this.cVolumeElementName = pString;
    }

    String prepareToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.prepareToString());
        sb.append("; Storage Volume Names: {");
        if (this.cVolumeNames != null && this.cVolumeNames.length > 0) {
            for (int i = 0; i < this.cVolumeNames.length; ++i) {
                sb.append(this.cVolumeNames[i]);
                if (i >= this.cVolumeNames.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("}");
        sb.append("; Sizes: {");
        sb.append(OutputHelper.listToCS(this.sizes));
        sb.append("}");
        return sb.toString();
    }
}

