/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import javax.swing.JComponent;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.AlertProductManager;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.gui.AlertLogTable;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.AlertLogReq;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertLogDDI
extends DataDisplayInfo
implements GuiRequestor {
    public static String notApplicableText = MessageLog.getMessageNoID("GUI2020L");
    AlertLogReq requestData;
    boolean[] productMask;
    private AlertLogTable table;

    public static String alertsDirectedTo() {
        Object[] args = new Object[]{GuiUtil.getUserName()};
        return MessageLog.getMessageNoID("GUI2041L", args);
    }

    private void finishInitByNameList(NameList obj) {
        boolean all = true;
        short objectType = obj.nlInfo;
        if (objectType == 20) {
            this.requestData.alertID = obj.nlID;
        } else {
            this.requestData.objectType = objectType;
            if (obj.nlID > 0) {
                this.requestData.objectID = obj.nlID;
                all = false;
            }
        }
        this.setDescription(objectType, obj.nlName, all, obj.nlID2);
    }

    public AlertLogDDI(NameList obj) {
        this.commonInit();
        if (obj instanceof AlertNameList) {
            AlertNameList extended = (AlertNameList)obj;
            this.requestData.productCode = extended.nlProductID;
            this.requestData.subProductCode = extended.nlSubProductID;
        }
        this.finishInitByNameList(obj);
    }

    public AlertLogDDI(short productCode, byte subProductCode, boolean[] pProductMask) {
        this.commonInit();
        this.requestData.productCode = productCode;
        this.requestData.subProductCode = subProductCode;
        this.setDescription((short)20, null, true, -1);
        this.productMask = pProductMask;
    }

    public AlertLogDDI(short productCode, byte subProductCode) {
        this(productCode, subProductCode, null);
    }

    public AlertLogDDI(short productCode) {
        this(productCode, -1);
    }

    public AlertLogDDI(NameList obj, short productCode, byte subProductCode, boolean[] pProductMask) {
        this.commonInit();
        this.requestData.productCode = productCode;
        this.requestData.subProductCode = subProductCode;
        this.productMask = pProductMask;
        this.finishInitByNameList(obj);
    }

    public AlertLogDDI(NameList obj, short productCode, byte subProductCode) {
        this(obj, productCode, subProductCode, null);
    }

    public AlertLogDDI(short productCode, boolean pToUserOnly) {
        this(productCode, pToUserOnly, null);
    }

    public AlertLogDDI(short productCode, boolean pToUserOnly, boolean[] pProductMask) {
        short helpIndex;
        this.commonInit();
        this.productMask = pProductMask;
        this.requestData.productCode = productCode;
        short s = helpIndex = productCode > 0 ? productCode : (short)0;
        if (pToUserOnly) {
            this.requestData.displayActive = 1;
            super.setDescription(AlertLogDDI.alertsDirectedTo());
            this.helpID = AlertProductManager.getAlertLogUserHelp(helpIndex);
        } else {
            this.requestData.displayActive = (byte)2;
            super.setDescription(MessageLog.getMessageNoID("GUI2042L"));
            this.helpID = AlertProductManager.getAlertLogActiveHelp(helpIndex);
        }
    }

    private void commonInit() {
        this.displayInScrollPane = false;
        this.requestData = new AlertLogReq();
        this.requestData.productCode = (short)-2;
        this.requestData.objectType = (short)-1;
        this.requestData.objectID = -1;
        this.requestData.alertID = -1;
        this.requestData.subProductCode = (byte)-1;
    }

    private void setDescription(short objectType, String objectName, boolean all, int computerID) {
        String tail;
        Object[] args;
        if (all) {
            args = new Object[]{ResourceTypeManager.getAlertLogLabel(objectType)};
            tail = MessageLog.getMessageNoID("GUI2018L", args);
        } else {
            if (objectType == 3) {
                objectName = GuiUtil.formatFilesystem(GuiUtil.getComputer((int)computerID).gcTSName, objectName);
            }
            String typeString = CreateOrEditDDI.getObjectTypeName(objectType);
            Object[] args2 = new Object[]{typeString, objectName};
            tail = MessageLog.getMessageNoID("GUI0049L", args2);
        }
        args = new Object[]{tail};
        super.setDescription(MessageLog.getMessageNoID("GUI2019L", args));
        if (objectName == null && objectType == 20) {
            short helpIndex = this.requestData.productCode > 0 ? this.requestData.productCode : (short)0;
            this.helpID = AlertProductManager.getAlertLogActiveHelp(helpIndex);
        } else {
            this.helpID = ResourceTypeManager.getAlertLogHelp(objectType);
        }
    }

    public void reDisplay() {
        if (this.panel != null) {
            this.show();
        } else {
            this.submitRequest();
        }
    }

    public void submitRequest() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.server.AlertLogHndlr";
        request.flags = (byte)4;
        request.requestData = this.requestData;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        if (this.table == null) {
            this.table = new AlertLogTable(this);
        }
        ExtAlertLog[][] responseData = (ExtAlertLog[][])response.responseData;
        for (int i = 0; i < responseData.length; ++i) {
            ExtAlertLog[] array = responseData[i];
            for (int j = 0; j < array.length; ++j) {
                ExtAlertLog record = array[j];
                if (record.alComputer != null) continue;
                record.alComputer = record.alComputerID <= 0 ? notApplicableText : GuiUtil.getComputer((int)record.alComputerID).gcTSName;
            }
        }
        this.panel = (JComponent)this.table.getComponent(responseData);
        this.show();
    }

    public void goingAway() {
        if (this.table != null) {
            this.table.nullReferences();
        }
        this.table = null;
    }

    public void panelToBeNulled() {
        this.table = null;
    }

    public static void showLoginAlerts() {
        if (!AlertManager.anyToDisplayAtLogin()) {
            return;
        }
        UserPreferences prefs = guiMain.getUserPrefs();
        boolean toUserOnly = prefs.showLoginAlerts != 2;
        AlertLogDDI self = new AlertLogDDI(-1, toUserOnly);
        ((DataDisplayInfo)self).reDisplay();
    }
}

