/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.eclipse.aperi.TStorm.gui.OSAlertLogTableData;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertLogDetailPanel
extends JPanel
implements ActionListener {
    private static final String[] alertStates = new String[]{"GUI2029L", "GUI2039T", "GUI0060L"};
    private static final String SCRIPT_LOG = "S";
    private static final String JOB_LOG = "J";
    private AlertLog logRecord;
    private GridBagConstraints labelConstraint;
    private GridBagConstraints valueConstraint;

    public void addPair(String label, String value) {
        JLabel jlabel = new JLabel(label);
        jlabel.setFont(BaseTree.boldFont);
        jlabel.setForeground(Color.black);
        this.add((Component)jlabel, this.labelConstraint);
        if (value == null) {
            value = AlertLogDDI.notApplicableText;
        }
        jlabel = new JLabel(value);
        jlabel.setFont(BaseTree.plainFont);
        jlabel.setForeground(Color.black);
        this.add((Component)jlabel, this.valueConstraint);
    }

    public void addIDPair(String msgID, String value) {
        this.addPair(MessageLog.getMessageNoID(msgID), value);
    }

    private String format(long value, int flags) {
        String result;
        if (flags == 1) {
            result = Long.toString(value);
        } else {
            value = flags == 3 ? (value <<= 20) : (value <<= 9);
            result = Util.formatBytes(value);
        }
        return result;
    }

    public AlertLogDetailPanel(ExtAlertLog record) {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 30;
        c.insets.left = 40;
        c.insets.bottom = 18;
        c.anchor = 17;
        String s = MessageLog.getMessageNoID("GUI2035L");
        JLabel label = new JLabel(s);
        label.setFont(BaseTree.boldFont);
        label.setForeground(Color.black);
        this.add((Component)label, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add(Box.createHorizontalStrut(100), c);
        c = null;
        this.labelConstraint = new GridBagConstraints();
        this.labelConstraint.anchor = 17;
        this.labelConstraint.insets.left = 40;
        this.labelConstraint.insets.top = 0;
        this.labelConstraint.insets.right = 24;
        this.valueConstraint = new GridBagConstraints();
        this.valueConstraint.anchor = 17;
        this.valueConstraint.gridwidth = 0;
        this.valueConstraint.insets.top = this.labelConstraint.insets.top;
        this.logRecord = record;
        if (record.alComputerID > 0) {
            this.addIDPair("STG1102L", record.alComputer);
        }
        if (record.alViolatorType == 33) {
            s = CreateOrEditDDI.getObjectTypeName(record.alResourceType);
            if (s != null) {
                this.addPair(s, record.getAlObjectName());
            }
            if ((s = CreateOrEditDDI.getObjectTypeName(record.alViolatorType)) != null) {
                this.addPair(s, Integer.toString(record.alViolatorID));
            }
        } else {
            switch (record.alProductID) {
                case 0: {
                    OSAlertLogTableData.addResourceDescription(record, this);
                }
            }
        }
        s = (s = AlertConditionManager.getConditionMessageId(record.alAlertCondition)) != null ? MessageLog.getMessageNoID(s) : "?";
        this.addIDPair("GUI2023L", s);
        s = Integer.toString(record.alState);
        try {
            s = MessageLog.getMessageNoID(alertStates[record.alState]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        c = new GridBagConstraints();
        c.gridwidth = 0;
        this.add(Box.createVerticalStrut(12), c);
        this.addIDPair("GUI2040L", s);
        DateFormat formatter = DateFormat.getDateTimeInstance();
        Date date = new Date(record.alLastAlertTime);
        s = formatter.format(date);
        if (!AlertConditionManager.isAccumulate(record.alAlertCondition)) {
            this.addIDPair("STG3065L", s);
        } else {
            date = new Date(record.alFirstAlertTime);
            String first = formatter.format(date);
            this.addIDPair("GUI2024L", first);
            this.addIDPair("GUI2025L", s);
            this.addIDPair("GUI2031L", Integer.toString(record.alAlertCount));
        }
        s = AlertConditionManager.getValueTypeLabelId(record.alAlertCondition);
        if (s != null) {
            byte flags = AlertConditionManager.getValueFlags(record.alAlertCondition);
            int scale = flags & 3;
            if (scale == 2 && record.alThresholdType == 1) {
                scale = 1;
            }
            long value = record.alViolatingValue;
            String formatted = this.format(value, scale);
            s = MessageLog.getMessageNoID(s);
            int pooch = this.labelConstraint.insets.top;
            this.labelConstraint.insets.top = 12;
            this.valueConstraint.insets.top = 12;
            this.addPair(s, formatted);
            this.labelConstraint.insets.top = pooch;
            this.valueConstraint.insets.top = pooch;
            if ((flags & 0x10) == 0 && (value = (long)record.alPreviousValue) >= 0L) {
                formatted = this.format(value, scale);
                Object[] args = new Object[]{s};
                s = MessageLog.getMessageNoID("GUI2032L", args);
                this.addPair(s, formatted);
            }
            if ((flags & 4) != 0) {
                value = record.alThresholdValue;
                StringBuffer buf = new StringBuffer(40);
                if ((flags & 8) != 0) {
                    buf.append('<');
                } else {
                    buf.append('>');
                }
                buf.append(' ');
                if (record.alThresholdType >= 3) {
                    buf.append(Util.formatBytes(value <<= 10));
                } else if (record.alThresholdType == 2) {
                    buf.append(Long.toString(value));
                    buf.append('%');
                } else {
                    buf.append(Long.toString(value));
                }
                this.addIDPair("GUI2033L", buf.toString());
            }
            if ((flags & 0x10) != 0) {
                formatted = this.format(record.alPreviousValue, 2);
                this.addIDPair("STG4210L", formatted);
                formatted = this.format(record.alViolatorID, 2);
                this.addIDPair("STG4211L", formatted);
            }
        }
        this.add(Box.createVerticalStrut(12), c);
        this.addIDPair("GUI2027L", record.alCreator);
        this.addIDPair("GUI2028L", record.getAlName());
        this.add(Box.createVerticalStrut(12), c);
        if (record.alScriptComputerID > 0) {
            this.addIDPair("GUI2069L", record.alScriptName);
            GComputer gc = GuiUtil.getComputer(record.alScriptComputerID);
            this.addIDPair("GUI2070L", gc.gcTSName);
            s = MessageLog.getMessageNoID("GUI0268L");
            JButton button = new JButton(s);
            button.setEnabled(!Util.isEmpty(record.alScriptLogFile));
            button.setFont(BaseTree.boldFont);
            button.setActionCommand(SCRIPT_LOG);
            button.addActionListener(this);
            this.add(Box.createVerticalStrut(1), this.labelConstraint);
            this.add((Component)button, this.valueConstraint);
            this.add(Box.createVerticalStrut(12), c);
        }
        if (!Util.isEmpty(record.alJobLogFile)) {
            s = MessageLog.getMessageNoID("GUI0269L");
            JButton button = new JButton(s);
            button.setFont(BaseTree.boldFont);
            button.setActionCommand(JOB_LOG);
            button.addActionListener(this);
            this.add(Box.createVerticalStrut(1), this.labelConstraint);
            this.add((Component)button, this.valueConstraint);
            this.add(Box.createVerticalStrut(12), c);
        }
        c = null;
        this.labelConstraint.gridheight = 0;
        this.labelConstraint.anchor = 18;
        label = new JLabel(MessageLog.getMessageNoID("GUI2034L"));
        label.setFont(BaseTree.boldFont);
        label.setForeground(Color.black);
        this.add((Component)label, this.labelConstraint);
        JTextArea text = new JTextArea();
        text.setEditable(false);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setBackground(this.getBackground());
        text.setText(record.alMessage);
        this.valueConstraint.gridheight = 0;
        this.valueConstraint.fill = 1;
        this.valueConstraint.weighty = 1.0;
        this.add((Component)text, this.valueConstraint);
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd == SCRIPT_LOG) {
            int computerID = this.logRecord.alScriptComputerID;
            String logFile = this.logRecord.alScriptLogFile;
            new LogViewer(computerID, null, logFile);
        } else {
            int computerID = this.logRecord.alComputerID;
            String logFile = this.logRecord.alJobLogFile;
            new LogViewer(computerID, null, logFile);
        }
    }
}

