/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.San.gui.DiskArrayAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.DiskAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.EndpointAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.ExternalAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.FabricAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.OSAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.SwitchAlertLogTableData;
import org.eclipse.aperi.TStorm.gui.TapeLibraryAlertLogTableData;
import org.eclipse.aperi.common.MutableByte;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.constants.metadata.AlertEditorManager;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertLogDetailDDI;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.IntToString;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertLogTable
implements TJCTableMouseInterface,
ActionListener,
GuiRequestor {
    private static DefaultTableCellRenderer stateRenderer = new StateRenderer();
    private static final String CLEAR = "c";
    private static final String DELETE = "d";
    private static final String CLEAR_ALL = "C";
    private static final String DELETE_ALL = "D";
    private static final String REFRESH = "R";
    private static final String VIEW_DETAIL = "V";
    private static final String VIEW_SCRIPT_LOG = "SL";
    private static final String VIEW_JOB_LOG = "JL";
    private static final String EDIT = "E";
    private static final String PRODUCT_CHANGE = "P";
    private static final IntToString[] productSelections = new IntToString[]{new IntToString(0, MessageLog.getMessageNoID("STG4175L")), null, null, new IntToString(3, MessageLog.getMessageNoID("SAG0005L"))};
    private static final int[] productToLicenseKey = new int[]{0, -1, -1, 9};
    private AlertLogDDI DDI;
    private MegaTable table;
    private BaseTableModel tableData;
    private AlertLogTableAdjuster tableAdjuster;
    private JPanel panel;
    private JComponent bottomHalf;
    private JLabel noDataLabel;
    private JButton clearButton;
    private JButton deleteButton;
    private JButton clearAllButton;
    private JButton deleteAllButton;
    private JComboBox viewComboBox;
    private int productID = -1;
    private ExtAlertLog[][] productArray;
    private ExtAlertLog[] array;
    private ExtAlertLog recordsRemaining;
    private boolean requestWasDelete;
    private boolean clearedAll;
    private JPopupMenu menu;
    private JMenuItem viewScriptLogItem;
    private JMenuItem viewJobLogItem;
    private int popupRow;
    private boolean allProducts;
    private IntToString[] installedProductList;
    private boolean isProperAdmin = false;

    private JMenuItem addMenuItem(String labelID, String action) {
        String label = MessageLog.getMessageNoID(labelID);
        JMenuItem result = new JMenuItem(label);
        result.setActionCommand(action);
        result.addActionListener(this);
        this.menu.add(result);
        return result;
    }

    private static boolean productInstalled(boolean[] productMask, int index) {
        boolean result = false;
        if (!productMask[index]) {
            return result;
        }
        int productKey = productToLicenseKey[index];
        switch (productKey) {
            case 0: 
            case 1: {
                result = true;
                break;
            }
            case 9: {
                result = true;
            }
        }
        return result;
    }

    public AlertLogTable(AlertLogDDI pDDI) {
        this.DDI = pDDI;
        this.recordsRemaining = null;
        this.noDataLabel = new JLabel(MessageLog.getMessageNoID("STG0020M"));
        this.noDataLabel.setFont(BaseTree.boldFont);
        this.noDataLabel.setForeground(Color.black);
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 0;
        c.anchor = 17;
        c.insets.left = 17;
        c.insets.top = 10;
        c.insets.bottom = 10;
        if (this.DDI.requestData.productCode == -1) {
            int i;
            boolean[] productMask;
            if (this.DDI.productMask == null) {
                productMask = new boolean[productToLicenseKey.length];
                Arrays.fill(productMask, true);
            } else if (this.DDI.productMask.length >= productToLicenseKey.length) {
                productMask = this.DDI.productMask;
            } else {
                productMask = new boolean[productToLicenseKey.length];
                System.arraycopy(this.DDI.productMask, 0, productMask, 0, this.DDI.productMask.length);
            }
            int productCount = 0;
            for (i = 0; i < productToLicenseKey.length; ++i) {
                if (!AlertLogTable.productInstalled(productMask, i)) continue;
                this.productID = i;
                ++productCount;
            }
            if (productCount > 1) {
                this.productID = -1;
                this.installedProductList = new IntToString[productCount];
                productCount = 0;
                for (i = 0; i < productToLicenseKey.length; ++i) {
                    if (!AlertLogTable.productInstalled(productMask, i)) continue;
                    this.installedProductList[productCount++] = productSelections[i];
                }
                BlackLabel viewLabel = new BlackLabel(MessageLog.getMessageNoID("STG4177L"));
                c.gridheight = 1;
                c.insets.bottom = 5;
                topPanel.add((Component)viewLabel, c);
                this.viewComboBox = new TComboBox(this.installedProductList);
                this.viewComboBox.setActionCommand(PRODUCT_CHANGE);
                c.gridwidth = 0;
                topPanel.add((Component)this.viewComboBox, c);
                c.insets.top = 5;
                c.insets.bottom = 10;
                c.gridwidth = 1;
                topPanel.add(Box.createHorizontalStrut(10), c);
            }
        }
        this.clearButton = new JButton(MessageLog.getMessageNoID("GUI0060L"));
        this.clearButton.setActionCommand(CLEAR);
        this.clearButton.addActionListener(this);
        GuiUtil.setAccessible(this.clearButton, this.clearButton.getText(), this.clearButton.getText());
        topPanel.add((Component)this.clearButton, c);
        this.deleteButton = new JButton(MessageLog.getMessageNoID("GUI0106L"));
        this.deleteButton.setActionCommand(DELETE);
        this.deleteButton.addActionListener(this);
        GuiUtil.setAccessible(this.deleteButton, this.deleteButton.getText(), this.deleteButton.getText());
        c.insets.left = 10;
        topPanel.add((Component)this.deleteButton, c);
        this.clearAllButton = new JButton(MessageLog.getMessageNoID("GUI0061L"));
        this.clearAllButton.setActionCommand(CLEAR_ALL);
        this.clearAllButton.addActionListener(this);
        GuiUtil.setAccessible(this.clearAllButton, this.clearAllButton.getText(), this.clearAllButton.getText());
        topPanel.add((Component)this.clearAllButton, c);
        this.deleteAllButton = new JButton(MessageLog.getMessageNoID("GUI0062L"));
        this.deleteAllButton.setActionCommand(DELETE_ALL);
        this.deleteAllButton.addActionListener(this);
        GuiUtil.setAccessible(this.deleteAllButton, this.deleteAllButton.getText(), this.deleteAllButton.getText());
        topPanel.add((Component)this.deleteAllButton, c);
        JButton refreshButton = new JButton(MessageLog.getMessageNoID("STG0003L"));
        refreshButton.setActionCommand(REFRESH);
        refreshButton.addActionListener(this);
        GuiUtil.setAccessible(refreshButton, refreshButton.getText(), refreshButton.getText());
        c.weightx = 1.0;
        c.gridwidth = 0;
        topPanel.add((Component)refreshButton, c);
        this.panel = new JPanel(new GridBagLayout());
        c.insets.left = 0;
        c.insets.right = 0;
        c.insets.top = 0;
        c.insets.bottom = 0;
        c.gridheight = 1;
        c.fill = 2;
        this.panel.add((Component)topPanel, c);
        this.menu = new JPopupMenu();
        this.addMenuItem("GUI2036L", VIEW_DETAIL);
        this.viewScriptLogItem = this.addMenuItem("GUI0268L", VIEW_SCRIPT_LOG);
        this.viewJobLogItem = this.addMenuItem("GUI0269L", VIEW_JOB_LOG);
        this.bottomHalf = null;
    }

    private void setBottomHalf(JComponent newBottomHalf) {
        if (newBottomHalf == this.bottomHalf) {
            return;
        }
        if (this.bottomHalf != null) {
            this.panel.remove(this.bottomHalf);
        }
        this.bottomHalf = newBottomHalf;
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weighty = 1.0;
        if (this.bottomHalf == this.table) {
            c.weightx = 1.0;
            c.fill = 1;
        }
        c.anchor = 10;
        this.panel.add((Component)this.bottomHalf, c);
        if (this.DDI.panel != null) {
            this.DDI.show();
        }
    }

    private void rebuild(ExtAlertLog[] logArray, boolean sort) {
        JComponent newBottomHalf;
        boolean haveData;
        IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
        Capabilities capabilities = guiMain.getCapabilities();
        this.array = logArray;
        this.productArray[this.productID] = logArray;
        this.isProperAdmin = capabilities.isAnyAdmin();
        boolean bl = haveData = this.array != null && this.array.length > 0;
        if (!haveData) {
            newBottomHalf = this.noDataLabel;
        } else {
            switch (this.DDI.requestData.objectType) {
                case 10: {
                    this.tableAdjuster = new DiskAlertLogTableData(this, this.array);
                    break;
                }
                case 78: {
                    this.tableAdjuster = new DiskArrayAlertLogTableData(this, this.array);
                    break;
                }
                case 121: {
                    this.tableAdjuster = new SwitchAlertLogTableData(this, this.array, this.DDI.requestData);
                    break;
                }
                case 114: {
                    this.tableAdjuster = new FabricAlertLogTableData(this, this.array, this.DDI.requestData);
                    break;
                }
                case 129: {
                    this.tableAdjuster = new EndpointAlertLogTableData(this, this.array, this.DDI.requestData);
                    break;
                }
                case 128: {
                    this.tableAdjuster = new ExternalAlertLogTableData(this, this.array, this.DDI.requestData);
                    break;
                }
                case 134: {
                    this.tableAdjuster = new TapeLibraryAlertLogTableData(this, this.array, this.DDI.requestData);
                    break;
                }
                default: {
                    this.tableAdjuster = new OSAlertLogTableData(this, this.array, this.DDI.requestData);
                }
            }
            this.table = new MegaTable();
            this.tableData = (BaseTableModel)((Object)this.tableAdjuster);
            this.table.setRowIcon(10, true);
            this.table.setBaseTableModel(this.tableData);
            this.table.setMouseListener(this);
            this.table.setCellRenderer(MutableByte.class, stateRenderer);
            this.table.setCellRenderer(Date.class, TableCellRenderers.date);
            newBottomHalf = this.table;
        }
        this.clearButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.clearAllButton.setEnabled(haveData && this.isProperAdmin);
        this.deleteAllButton.setEnabled(haveData && this.isProperAdmin);
        this.setBottomHalf(newBottomHalf);
    }

    public Component getComponent(ExtAlertLog[][] productArray) {
        this.productArray = productArray;
        if (this.productID == -1) {
            this.productID = 0;
            for (int i = 0; i < productArray.length; ++i) {
                if (productArray[i] == null || productArray[i].length <= 0) continue;
                this.productID = i;
                break;
            }
            if (this.viewComboBox != null) {
                this.viewComboBox.setSelectedItem(productSelections[this.productID]);
                this.viewComboBox.addActionListener(this);
            }
        }
        this.rebuild(productArray[this.productID], true);
        return this.panel;
    }

    private void submitRequest(ExtAlertLog records, String subType) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = subType;
        request.flags = (byte)4;
        request.requestData = ExtAlertLog.pack(records);
        GuiClient.doRequest(this, request);
    }

    private void delete(boolean all) {
        this.recordsRemaining = null;
        ExtAlertLog head = null;
        ExtAlertLog tail = null;
        for (int row = 0; row < this.array.length; ++row) {
            boolean willDelete = all || this.table.isRowSelected(row);
            ExtAlertLog record = this.array[this.table.getDataRow(row)].clone(willDelete);
            if (willDelete) {
                record.alnExt = head;
                head = record;
                continue;
            }
            if (tail == null) {
                this.recordsRemaining = record;
            } else {
                tail.alnExt = record;
            }
            tail = record;
        }
        if (head != null) {
            this.clearedAll = all;
            this.requestWasDelete = true;
            this.submitRequest(head, "org.eclipse.aperi.server.handler.server.AlertLogIDHndlr.Delete");
        }
    }

    private void clear(boolean all) {
        ExtAlertLog head = null;
        for (int row = 0; row < this.array.length; ++row) {
            ExtAlertLog record = this.array[this.table.getDataRow(row)];
            if (record.alState != 0 || !all && !this.table.isRowSelected(row)) continue;
            record = record.clone(true);
            record.alnExt = head;
            head = record;
        }
        if (head != null) {
            this.clearedAll = all;
            this.requestWasDelete = false;
            this.submitRequest(head, "org.eclipse.aperi.server.handler.server.AlertLogIDHndlr.Clear");
        }
    }

    private void recordsCleared() {
        for (int row = 0; row < this.array.length; ++row) {
            if (!this.clearedAll && !this.table.isRowSelected(row)) continue;
            ExtAlertLog record = this.array[this.table.getDataRow(row)];
            if (record.alState != 0) continue;
            AlertManager.alertCleared(record);
            record.alState = 1;
        }
    }

    private void invokeEditor() {
        ExtAlertLog record = this.array[this.popupRow];
        short alertEditor = AlertConditionManager.getClassId(record.alAlertCondition);
        if (alertEditor < 0) {
            Object[] args = new Object[]{new Integer(record.alAlertCondition)};
            String s = MessageLog.getMessageNoTS("GUI2038M", args);
            GuiUtil.displayErrorMessage(s);
            return;
        }
        if (alertEditor == 26 && record.alProductID == 3) {
            alertEditor = 20;
        }
        short objType = AlertEditorManager.getResourceType(alertEditor);
        String creatorAndName = record.alCreator + '.' + record.getAlName();
        short resourceType = 0;
        short qualifier = 0;
        CreateOrEditDDI.showEditor(AlertEditorManager.getClass(alertEditor), creatorAndName, record.alAlertID, objType, resourceType, qualifier, null);
    }

    private void viewLog(String cmd) {
        ExtAlertLog record = this.array[this.popupRow];
        if (cmd == VIEW_SCRIPT_LOG) {
            new LogViewer(record.alScriptComputerID, null, record.alScriptLogFile);
        } else {
            new LogViewer(record.alComputerID, null, record.alJobLogFile);
        }
    }

    private void changeProducts() {
        IntToString selection = (IntToString)this.viewComboBox.getSelectedItem();
        this.productID = selection.value;
        this.rebuild(this.productArray[this.productID], true);
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            this.recordsCleared();
            if (this.requestWasDelete) {
                this.rebuild(ExtAlertLog.pack(this.recordsRemaining), false);
            } else {
                if (this.tableData == null) {
                    this.tableData = (BaseTableModel)((Object)this.tableAdjuster);
                }
                this.tableData.fireTableChanged(new TableModelEvent(this.tableData));
                this.clearButton.setEnabled(false);
            }
        }
        this.recordsRemaining = null;
        this.requestWasDelete = false;
        this.clearedAll = false;
        this.table.repaint();
    }

    public boolean select(int viewRow, int viewColumn) {
        return true;
    }

    public void selectionChanged(boolean state) {
        int[] selectedRows = this.table.getSelectedRows();
        this.deleteButton.setEnabled(selectedRows.length > 0 && state && this.isProperAdmin);
        if (!state || !this.isProperAdmin) {
            this.clearButton.setEnabled(false);
        } else {
            boolean foundAny = false;
            int i = 0;
            while (!foundAny && i < selectedRows.length) {
                int dataRow = selectedRows[i++];
                if (this.array[dataRow].alState != 0) continue;
                foundAny = true;
            }
            this.clearButton.setEnabled(foundAny);
        }
    }

    public void doubleClick(int dataRow, int dataColumn) {
        ExtAlertLog record = this.array[dataRow];
        AlertLogDetailDDI newDDI = new AlertLogDetailDDI(record);
        ((DataDisplayInfo)newDDI).reDisplay();
    }

    public void showPopup(int dataRow, int dataColumn, Component c, int x, int y) {
        this.popupRow = dataRow;
        ExtAlertLog record = this.array[this.popupRow];
        boolean scriptRan = record.alScriptComputerID > 0 && !Util.isEmpty(record.alScriptLogFile);
        this.viewScriptLogItem.setEnabled(scriptRan);
        this.viewJobLogItem.setEnabled(!Util.isEmpty(record.alJobLogFile));
        this.menu.show(c, x, y);
        this.menu.requestFocus();
    }

    public void showDefaultChart(int dataRow) {
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd == REFRESH) {
            this.DDI.submitRequest();
        } else if (cmd == DELETE) {
            this.delete(false);
        } else if (cmd == DELETE_ALL) {
            if (GuiUtil.confirmDelete(null)) {
                this.delete(true);
            }
        } else if (cmd == CLEAR) {
            this.clear(false);
        } else if (cmd == CLEAR_ALL) {
            this.clear(true);
        } else if (cmd == VIEW_DETAIL) {
            this.doubleClick(this.popupRow, 0);
        } else if (cmd == VIEW_SCRIPT_LOG) {
            this.viewLog(cmd);
        } else if (cmd == VIEW_JOB_LOG) {
            this.viewLog(cmd);
        } else if (cmd == EDIT) {
            this.invokeEditor();
        } else if (cmd == PRODUCT_CHANGE) {
            this.changeProducts();
        }
    }

    public void nullReferences() {
        this.productArray = null;
        this.array = null;
        this.tableAdjuster = null;
        if (this.table != null) {
            this.table.nullReferences();
        }
        this.tableData = null;
        if (this.panel != null) {
            this.panel.removeAll();
        }
        this.panel = null;
        this.bottomHalf = null;
        this.table = null;
    }

    public static interface AlertLogTableAdjuster {
        public void hideColumns(MegaTable var1);

        public String[] getLabels();

        public int getNumberRows();

        public int getNumberColumns();

        public int[] getRenderers();

        public int[] getHiddenColumns();

        public Object getTableDataItem(int var1, int var2);
    }

    private static class StateRenderer
    extends DefaultTableCellRenderer {
        private static Icon exclam;
        private static Icon checked;
        private static Icon blank;

        private StateRenderer() {
        }

        public void setValue(Object o) {
            Icon icon = blank;
            if (o instanceof MutableByte) {
                MutableByte object = (MutableByte)o;
                switch (object.value) {
                    case 0: {
                        icon = exclam;
                        break;
                    }
                    case 1: {
                        icon = checked;
                    }
                }
            }
            this.setText(null);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(11);
            this.setIcon(icon);
        }

        static {
            URL imageURL = StateRenderer.class.getResource("images/exclam.gif");
            exclam = new ImageIcon(imageURL);
            imageURL = StateRenderer.class.getResource("images/checked.gif");
            checked = new ImageIcon(imageURL);
            blank = IconFactory.getBlankIcon(16);
        }
    }
}

